'use strict';

var utils = require('../../../utils/utils');

var BaseXform = require('../base-xform');

var BlipXform = require('./blip-xform');

var BlipFillXform = (module.exports = function() {
  this.map = {
    'a:blip': new BlipXform(),
  };
});

utils.inherits(BlipFillXform, BaseXform, {
  get tag() {
    return 'xdr:blipFill';
  },

  render: function render(xmlStream, model) {
    xmlStream.openNode(this.tag);
    this.map['a:blip'].render(xmlStream, model); // TODO: options for this + parsing

    xmlStream.openNode('a:stretch');
    xmlStream.leafNode('a:fillRect');
    xmlStream.closeNode();
    xmlStream.closeNode();
  },
  parseOpen: function parseOpen(node) {
    if (this.parser) {
      this.parser.parseOpen(node);
      return true;
    }

    switch (node.name) {
      case this.tag:
        this.reset();
        break;

      default:
        this.parser = this.map[node.name];

        if (this.parser) {
          this.parser.parseOpen(node);
        }

        break;
    }

    return true;
  },
  parseText: function parseText() {},
  parseClose: function parseClose(name) {
    if (this.parser) {
      if (!this.parser.parseClose(name)) {
        this.parser = undefined;
      }

      return true;
    }

    switch (name) {
      case this.tag:
        this.model = this.map['a:blip'].model;
        return false;

      default:
        return true;
    }
  },
});
//# sourceMappingURL=blip-fill-xform.js.map
