'use strict';

var utils = require('../../../utils/utils');

var BaseXform = require('../base-xform');

var PictureXform = (module.exports = function() {});

utils.inherits(PictureXform, BaseXform, {
  get tag() {
    return 'picture';
  },

  render: function render(xmlStream, model) {
    if (model) {
      xmlStream.leafNode(this.tag, {
        'r:id': model.rId,
      });
    }
  },
  parseOpen: function parseOpen(node) {
    switch (node.name) {
      case this.tag:
        this.model = {
          rId: node.attributes['r:id'],
        };
        return true;

      default:
        return false;
    }
  },
  parseText: function parseText() {},
  parseClose: function parseClose() {
    return false;
  },
});
//# sourceMappingURL=picture-xform.js.map
