'use strict';

var _ = require('../../../utils/under-dash');

var utils = require('../../../utils/utils');

var BaseXform = require('../base-xform');

var SheetFormatPropertiesXform = (module.exports = function() {});

utils.inherits(SheetFormatPropertiesXform, BaseXform, {
  get tag() {
    return 'sheetFormatPr';
  },

  render: function render(xmlStream, model) {
    if (model) {
      var attributes = {
        defaultRowHeight: model.defaultRowHeight,
        outlineLevelRow: model.outlineLevelRow,
        outlineLevelCol: model.outlineLevelCol,
        'x14ac:dyDescent': model.dyDescent,
      };

      if (
        _.some(attributes, function(value) {
          return value !== undefined;
        })
      ) {
        xmlStream.leafNode('sheetFormatPr', attributes);
      }
    }
  },
  parseOpen: function parseOpen(node) {
    if (node.name === 'sheetFormatPr') {
      this.model = {
        defaultRowHeight: parseFloat(node.attributes.defaultRowHeight || '0'),
        dyDescent: parseFloat(node.attributes['x14ac:dyDescent'] || '0'),
        outlineLevelRow: parseInt(node.attributes.outlineLevelRow || '0', 10),
        outlineLevelCol: parseInt(node.attributes.outlineLevelCol || '0', 10),
      };
      return true;
    }

    return false;
  },
  parseText: function parseText() {},
  parseClose: function parseClose() {
    return false;
  },
});
//# sourceMappingURL=sheet-format-properties-xform.js.map
