(function(f) {
  if (typeof exports === 'object' && typeof module !== 'undefined') {
    module.exports = f();
  } else if (typeof define === 'function' && define.amd) {
    define([], f);
  } else {
    var g;
    if (typeof window !== 'undefined') {
      g = window;
    } else if (typeof global !== 'undefined') {
      g = global;
    } else if (typeof self !== 'undefined') {
      g = self;
    } else {
      g = this;
    }
    g.ExcelJS = f();
  }
})(function() {
  var define, module, exports;
  return (function() {
    function r(e, n, t) {
      function o(i, f) {
        if (!n[i]) {
          if (!e[i]) {
            var c = 'function' == typeof require && require;
            if (!f && c) return c(i, !0);
            if (u) return u(i, !0);
            var a = new Error("Cannot find module '" + i + "'");
            throw ((a.code = 'MODULE_NOT_FOUND'), a);
          }
          var p = (n[i] = { exports: {} });
          e[i][0].call(
            p.exports,
            function(r) {
              var n = e[i][1][r];
              return o(n || r);
            },
            p,
            p.exports,
            r,
            e,
            n,
            t
          );
        }
        return n[i].exports;
      }
      for (
        var u = 'function' == typeof require && require, i = 0;
        i < t.length;
        i++
      )
        o(t[i]);
      return o;
    }
    return r;
  })()(
    {
      1: [
        function(require, module, exports) {
          'use strict';

          var PromiseLib = require('../utils/promise');

          function setValue(key, value, overwrite) {
            if (overwrite === undefined) {
              // only avoid overwrite if explicitly disabled
              overwrite = true;
            }

            switch (key.toLowerCase()) {
              case 'promise':
                if (!overwrite && PromiseLib.Promise) return;
                PromiseLib.Promise = value;
                break;

              default:
                break;
            }
          }

          module.exports = setValue;
        },
        { '../utils/promise': 18 },
      ],
      2: [
        function(require, module, exports) {
          'use strict';

          function _typeof(obj) {
            if (
              typeof Symbol === 'function' &&
              typeof Symbol.iterator === 'symbol'
            ) {
              _typeof = function _typeof(obj) {
                return typeof obj;
              };
            } else {
              _typeof = function _typeof(obj) {
                return obj &&
                  typeof Symbol === 'function' &&
                  obj.constructor === Symbol &&
                  obj !== Symbol.prototype
                  ? 'symbol'
                  : typeof obj;
              };
            }
            return _typeof(obj);
          }

          var fs = require('fs');

          var csv = require('fast-csv');

          var moment = require('moment');

          var PromiseLib = require('../utils/promise');

          var StreamBuf = require('../utils/stream-buf');

          var utils = require('../utils/utils');

          var CSV = (module.exports = function(workbook) {
            this.workbook = workbook;
            this.worksheet = null;
          });
          /* eslint-disable quote-props */

          var SpecialValues = {
            true: true,
            false: false,
            '#N/A': {
              error: '#N/A',
            },
            '#REF!': {
              error: '#REF!',
            },
            '#NAME?': {
              error: '#NAME?',
            },
            '#DIV/0!': {
              error: '#DIV/0!',
            },
            '#NULL!': {
              error: '#NULL!',
            },
            '#VALUE!': {
              error: '#VALUE!',
            },
            '#NUM!': {
              error: '#NUM!',
            },
          };
          /* eslint-ensable quote-props */

          CSV.prototype = {
            readFile: function readFile(filename, options) {
              var self = this;
              options = options || {};
              var stream;
              return utils.fs
                .exists(filename)
                .then(function(exists) {
                  if (!exists) {
                    throw new Error('File not found: '.concat(filename));
                  }

                  stream = fs.createReadStream(filename);
                  return self.read(stream, options);
                })
                .then(function(worksheet) {
                  stream.close();
                  return worksheet;
                });
            },
            read: function read(stream, options) {
              var _this = this;

              options = options || {};
              return new PromiseLib.Promise(function(resolve, reject) {
                var csvStream = _this
                  .createInputStream(options)
                  .on('worksheet', resolve)
                  .on('error', reject);

                stream.pipe(csvStream);
              });
            },
            createInputStream: function createInputStream(options) {
              options = options || {};
              var worksheet = this.workbook.addWorksheet(options.sheetName);
              var dateFormats = options.dateFormats || [
                moment.ISO_8601,
                'MM-DD-YYYY',
                'YYYY-MM-DD',
              ];

              var map =
                options.map ||
                function(datum) {
                  if (datum === '') {
                    return null;
                  }

                  var datumNumber = Number(datum);

                  if (!Number.isNaN(datumNumber)) {
                    return datumNumber;
                  }

                  var dt = moment(datum, dateFormats, true);

                  if (dt.isValid()) {
                    return new Date(dt.valueOf());
                  }

                  var special = SpecialValues[datum];

                  if (special !== undefined) {
                    return special;
                  }

                  return datum;
                };

              var csvStream = csv(options)
                .on('data', function(data) {
                  worksheet.addRow(data.map(map));
                })
                .on('end', function() {
                  csvStream.emit('worksheet', worksheet);
                });
              return csvStream;
            },
            write: function write(stream, options) {
              var _this2 = this;

              return new PromiseLib.Promise(function(resolve, reject) {
                options = options || {}; // const encoding = options.encoding || 'utf8';
                // const separator = options.separator || ',';
                // const quoteChar = options.quoteChar || '\'';

                var worksheet = _this2.workbook.getWorksheet(
                  options.sheetName || options.sheetId
                );

                var csvStream = csv.createWriteStream(options);
                stream.on('finish', function() {
                  resolve();
                });
                csvStream.on('error', reject);
                csvStream.pipe(stream);
                var _options = options,
                  dateFormat = _options.dateFormat,
                  dateUTC = _options.dateUTC;

                var map =
                  options.map ||
                  function(value) {
                    if (value) {
                      if (value.text || value.hyperlink) {
                        return value.hyperlink || value.text || '';
                      }

                      if (value.formula || value.result) {
                        return value.result || '';
                      }

                      if (value instanceof Date) {
                        if (dateFormat) {
                          return dateUTC
                            ? moment.utc(value).format(dateFormat)
                            : moment(value).format(dateFormat);
                        }

                        return dateUTC
                          ? moment.utc(value).format()
                          : moment(value).format();
                      }

                      if (value.error) {
                        return value.error;
                      }

                      if (_typeof(value) === 'object') {
                        return JSON.stringify(value);
                      }
                    }

                    return value;
                  };

                var includeEmptyRows =
                  options.includeEmptyRows === undefined ||
                  options.includeEmptyRows;
                var lastRow = 1;

                if (worksheet) {
                  worksheet.eachRow(function(row, rowNumber) {
                    if (includeEmptyRows) {
                      while (lastRow++ < rowNumber - 1) {
                        csvStream.write([]);
                      }
                    }

                    var values = row.values;
                    values.shift();
                    csvStream.write(values.map(map));
                    lastRow = rowNumber;
                  });
                }

                csvStream.end();
              });
            },
            writeFile: function writeFile(filename, options) {
              options = options || {};
              var streamOptions = {
                encoding: options.encoding || 'utf8',
              };
              var stream = fs.createWriteStream(filename, streamOptions);
              return this.write(stream, options);
            },
            writeBuffer: function writeBuffer(options) {
              var self = this;
              var stream = new StreamBuf();
              return self.write(stream, options).then(function() {
                return stream.read();
              });
            },
          };
        },
        {
          '../utils/promise': 18,
          '../utils/stream-buf': 20,
          '../utils/utils': 23,
          'fast-csv': 116,
          fs: 105,
          moment: 167,
        },
      ],
      3: [
        function(require, module, exports) {
          'use strict';

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          var colCache = require('../utils/col-cache');

          module.exports =
            /*#__PURE__*/
            (function() {
              function Anchor(worksheet, address) {
                var offset =
                  arguments.length > 2 && arguments[2] !== undefined
                    ? arguments[2]
                    : 0;

                _classCallCheck(this, Anchor);

                if (!address) {
                  this.nativeCol = 0;
                  this.nativeColOff = 0;
                  this.nativeRow = 0;
                  this.nativeRowOff = 0;
                } else if (typeof address === 'string') {
                  var decoded = colCache.decodeAddress(address);
                  this.nativeCol = decoded.col + offset;
                  this.nativeColOff = 0;
                  this.nativeRow = decoded.row + offset;
                  this.nativeRowOff = 0;
                } else if (address.nativeCol) {
                  this.nativeCol = address.nativeCol || 0;
                  this.nativeColOff = address.nativeColOff || 0;
                  this.nativeRow = address.nativeRow || 0;
                  this.nativeRowOff = address.nativeRowOff || 0;
                } else if (address.col) {
                  this.col = address.col + offset;
                  this.row = address.row + offset;
                } else {
                  this.nativeCol = 0;
                  this.nativeColOff = 0;
                  this.nativeRow = 0;
                  this.nativeRowOff = 0;
                }

                this.worksheet = worksheet;
              }

              _createClass(
                Anchor,
                [
                  {
                    key: 'col',
                    get: function get() {
                      return (
                        this.nativeCol +
                        Math.min(this.colWidth - 1, this.nativeColOff) /
                          this.colWidth
                      );
                    },
                    set: function set(v) {
                      this.nativeCol = Math.floor(v);
                      this.nativeColOff = Math.floor(
                        (v - this.nativeCol) * this.colWidth
                      );
                    },
                  },
                  {
                    key: 'row',
                    get: function get() {
                      return (
                        this.nativeRow +
                        Math.min(this.rowHeight - 1, this.nativeRowOff) /
                          this.rowHeight
                      );
                    },
                    set: function set(v) {
                      this.nativeRow = Math.floor(v);
                      this.nativeRowOff = Math.floor(
                        (v - this.nativeRow) * this.rowHeight
                      );
                    },
                  },
                  {
                    key: 'colWidth',
                    get: function get() {
                      return this.worksheet &&
                        this.worksheet.getColumn(this.nativeCol + 1) &&
                        this.worksheet.getColumn(this.nativeCol + 1)
                          .isCustomWidth
                        ? Math.floor(
                            this.worksheet.getColumn(this.nativeCol + 1).width *
                              10000
                          )
                        : 640000;
                    },
                  },
                  {
                    key: 'rowHeight',
                    get: function get() {
                      return this.worksheet &&
                        this.worksheet.getRow(this.nativeRow + 1) &&
                        this.worksheet.getRow(this.nativeRow + 1).height
                        ? Math.floor(
                            this.worksheet.getRow(this.nativeRow + 1).height *
                              10000
                          )
                        : 180000;
                    },
                  },
                  {
                    key: 'model',
                    get: function get() {
                      return {
                        nativeCol: this.nativeCol,
                        nativeColOff: this.nativeColOff,
                        nativeRow: this.nativeRow,
                        nativeRowOff: this.nativeRowOff,
                      };
                    },
                    set: function set(value) {
                      this.nativeCol = value.nativeCol;
                      this.nativeColOff = value.nativeColOff;
                      this.nativeRow = value.nativeRow;
                      this.nativeRowOff = value.nativeRowOff;
                    },
                  },
                ],
                [
                  {
                    key: 'asInstance',
                    value: function asInstance(model) {
                      return model instanceof Anchor || model == null
                        ? model
                        : new Anchor(model);
                    },
                  },
                ]
              );

              return Anchor;
            })();
        },
        { '../utils/col-cache': 17 },
      ],
      4: [
        function(require, module, exports) {
          'use strict';

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          var colCache = require('../utils/col-cache');

          var _ = require('../utils/under-dash');

          var Enums = require('./enums');

          var _require = require('../utils/shared-formula'),
            slideFormula = _require.slideFormula;

          var Note = require('./note'); // Cell requirements
          //  Operate inside a worksheet
          //  Store and retrieve a value with a range of types: text, number, date, hyperlink, reference, formula, etc.
          //  Manage/use and manipulate cell format either as local to cell or inherited from column or row.

          var Cell =
            /*#__PURE__*/
            (function() {
              function Cell(row, column, address) {
                _classCallCheck(this, Cell);

                if (!row || !column) {
                  throw new Error('A Cell needs a Row');
                }

                this._row = row;
                this._column = column;
                colCache.validateAddress(address);
                this._address = address; // TODO: lazy evaluation of this._value

                this._value = Value.create(Cell.Types.Null, this);
                this.style = this._mergeStyle(row.style, column.style, {});
                this._mergeCount = 0;
              }

              _createClass(Cell, [
                {
                  key: 'destroy',
                  // help GC by removing cyclic (and other) references
                  value: function destroy() {
                    delete this.style;
                    delete this._value;
                    delete this._row;
                    delete this._column;
                    delete this._address;
                  }, // =========================================================================
                  // Styles stuff
                },
                {
                  key: '_mergeStyle',
                  value: function _mergeStyle(rowStyle, colStyle, style) {
                    var numFmt =
                      (rowStyle && rowStyle.numFmt) ||
                      (colStyle && colStyle.numFmt);
                    if (numFmt) style.numFmt = numFmt;
                    var font =
                      (rowStyle && rowStyle.font) ||
                      (colStyle && colStyle.font);
                    if (font) style.font = font;
                    var alignment =
                      (rowStyle && rowStyle.alignment) ||
                      (colStyle && colStyle.alignment);
                    if (alignment) style.alignment = alignment;
                    var border =
                      (rowStyle && rowStyle.border) ||
                      (colStyle && colStyle.border);
                    if (border) style.border = border;
                    var fill =
                      (rowStyle && rowStyle.fill) ||
                      (colStyle && colStyle.fill);
                    if (fill) style.fill = fill;
                    return style;
                  }, // =========================================================================
                  // return the address for this cell
                },
                {
                  key: 'toCsvString',
                  value: function toCsvString() {
                    return this._value.toCsvString();
                  }, // =========================================================================
                  // Merge stuff
                },
                {
                  key: 'addMergeRef',
                  value: function addMergeRef() {
                    this._mergeCount++;
                  },
                },
                {
                  key: 'releaseMergeRef',
                  value: function releaseMergeRef() {
                    this._mergeCount--;
                  },
                },
                {
                  key: 'merge',
                  value: function merge(master) {
                    this._value.release();

                    this._value = Value.create(Cell.Types.Merge, this, master);
                    this.style = master.style;
                  },
                },
                {
                  key: 'unmerge',
                  value: function unmerge() {
                    if (this.type === Cell.Types.Merge) {
                      this._value.release();

                      this._value = Value.create(Cell.Types.Null, this);
                      this.style = this._mergeStyle(
                        this._row.style,
                        this._column.style,
                        {}
                      );
                    }
                  },
                },
                {
                  key: 'isMergedTo',
                  value: function isMergedTo(master) {
                    if (this._value.type !== Cell.Types.Merge) return false;
                    return this._value.isMergedTo(master);
                  },
                },
                {
                  key: 'toString',
                  value: function toString() {
                    return this.text;
                  },
                },
                {
                  key: '_upgradeToHyperlink',
                  value: function _upgradeToHyperlink(hyperlink) {
                    // if this cell is a string, turn it into a Hyperlink
                    if (this.type === Cell.Types.String) {
                      this._value = Value.create(Cell.Types.Hyperlink, this, {
                        text: this._value.value,
                        hyperlink: hyperlink,
                      });
                    }
                  }, // =========================================================================
                  // Formula stuff
                },
                {
                  key: 'addName',
                  value: function addName(name) {
                    this.workbook.definedNames.addEx(this.fullAddress, name);
                  },
                },
                {
                  key: 'removeName',
                  value: function removeName(name) {
                    this.workbook.definedNames.removeEx(this.fullAddress, name);
                  },
                },
                {
                  key: 'removeAllNames',
                  value: function removeAllNames() {
                    this.workbook.definedNames.removeAllNames(this.fullAddress);
                  }, // =========================================================================
                  // Data Validation stuff
                },
                {
                  key: 'worksheet',
                  get: function get() {
                    return this._row.worksheet;
                  },
                },
                {
                  key: 'workbook',
                  get: function get() {
                    return this._row.worksheet.workbook;
                  },
                },
                {
                  key: 'numFmt',
                  get: function get() {
                    return this.style.numFmt;
                  },
                  set: function set(value) {
                    this.style.numFmt = value;
                  },
                },
                {
                  key: 'font',
                  get: function get() {
                    return this.style.font;
                  },
                  set: function set(value) {
                    this.style.font = value;
                  },
                },
                {
                  key: 'alignment',
                  get: function get() {
                    return this.style.alignment;
                  },
                  set: function set(value) {
                    this.style.alignment = value;
                  },
                },
                {
                  key: 'border',
                  get: function get() {
                    return this.style.border;
                  },
                  set: function set(value) {
                    this.style.border = value;
                  },
                },
                {
                  key: 'fill',
                  get: function get() {
                    return this.style.fill;
                  },
                  set: function set(value) {
                    this.style.fill = value;
                  },
                },
                {
                  key: 'address',
                  get: function get() {
                    return this._address;
                  },
                },
                {
                  key: 'row',
                  get: function get() {
                    return this._row.number;
                  },
                },
                {
                  key: 'col',
                  get: function get() {
                    return this._column.number;
                  },
                },
                {
                  key: '$col$row',
                  get: function get() {
                    return '$'
                      .concat(this._column.letter, '$')
                      .concat(this.row);
                  }, // =========================================================================
                  // Value stuff
                },
                {
                  key: 'type',
                  get: function get() {
                    return this._value.type;
                  },
                },
                {
                  key: 'effectiveType',
                  get: function get() {
                    return this._value.effectiveType;
                  },
                },
                {
                  key: 'isMerged',
                  get: function get() {
                    return (
                      this._mergeCount > 0 || this.type === Cell.Types.Merge
                    );
                  },
                },
                {
                  key: 'master',
                  get: function get() {
                    if (this.type === Cell.Types.Merge) {
                      return this._value.master;
                    }

                    return this; // an unmerged cell is its own master
                  },
                },
                {
                  key: 'isHyperlink',
                  get: function get() {
                    return this._value.type === Cell.Types.Hyperlink;
                  },
                },
                {
                  key: 'hyperlink',
                  get: function get() {
                    return this._value.hyperlink;
                  }, // return the value
                },
                {
                  key: 'value',
                  get: function get() {
                    return this._value.value;
                  }, // set the value - can be number, string or raw
                  set: function set(v) {
                    // special case - merge cells set their master's value
                    if (this.type === Cell.Types.Merge) {
                      this._value.master.value = v;
                      return;
                    }

                    this._value.release(); // assign value

                    this._value = Value.create(Value.getType(v), this, v);
                  },
                },
                {
                  key: 'note',
                  get: function get() {
                    return this._comment && this._comment.note;
                  },
                  set: function set(note) {
                    this._comment = new Note(note);
                  },
                },
                {
                  key: 'text',
                  get: function get() {
                    return this._value.toString();
                  },
                },
                {
                  key: 'html',
                  get: function get() {
                    return _.escapeHtml(this.text);
                  },
                },
                {
                  key: 'formula',
                  get: function get() {
                    return this._value.formula;
                  },
                },
                {
                  key: 'result',
                  get: function get() {
                    return this._value.result;
                  },
                },
                {
                  key: 'formulaType',
                  get: function get() {
                    return this._value.formulaType;
                  }, // =========================================================================
                  // Name stuff
                },
                {
                  key: 'fullAddress',
                  get: function get() {
                    var worksheet = this._row.worksheet;
                    return {
                      sheetName: worksheet.name,
                      address: this.address,
                      row: this.row,
                      col: this.col,
                    };
                  },
                },
                {
                  key: 'name',
                  get: function get() {
                    return this.names[0];
                  },
                  set: function set(value) {
                    this.names = [value];
                  },
                },
                {
                  key: 'names',
                  get: function get() {
                    return this.workbook.definedNames.getNamesEx(
                      this.fullAddress
                    );
                  },
                  set: function set(value) {
                    var _this = this;

                    var definedNames = this.workbook.definedNames;
                    definedNames.removeAllNames(this.fullAddress);
                    value.forEach(function(name) {
                      definedNames.addEx(_this.fullAddress, name);
                    });
                  },
                },
                {
                  key: '_dataValidations',
                  get: function get() {
                    return this.worksheet.dataValidations;
                  },
                },
                {
                  key: 'dataValidation',
                  get: function get() {
                    return this._dataValidations.find(this.address);
                  },
                  set: function set(value) {
                    this._dataValidations.add(this.address, value);
                  }, // =========================================================================
                  // Model stuff
                },
                {
                  key: 'model',
                  get: function get() {
                    var model = this._value.model;
                    model.style = this.style;

                    if (this._comment) {
                      model.comment = this._comment.model;
                    }

                    return model;
                  },
                  set: function set(value) {
                    this._value.release();

                    this._value = Value.create(value.type, this);
                    this._value.model = value;

                    if (value.comment) {
                      switch (value.comment.type) {
                        case 'note':
                          this._comment = new Note(value.comment.note);
                          break;
                      }
                    }

                    if (value.style) {
                      this.style = value.style;
                    } else {
                      this.style = {};
                    }
                  },
                },
              ]);

              return Cell;
            })();

          Cell.Types = Enums.ValueType; // =============================================================================
          // Internal Value Types

          var NullValue =
            /*#__PURE__*/
            (function() {
              function NullValue(cell) {
                _classCallCheck(this, NullValue);

                this.model = {
                  address: cell.address,
                  type: Cell.Types.Null,
                };
              }

              _createClass(NullValue, [
                {
                  key: 'toCsvString',
                  value: function toCsvString() {
                    return '';
                  },
                },
                {
                  key: 'release',
                  value: function release() {},
                },
                {
                  key: 'toString',
                  value: function toString() {
                    return '';
                  },
                },
                {
                  key: 'value',
                  get: function get() {
                    return null;
                  },
                  set: function set(value) {
                    // nothing to do
                  },
                },
                {
                  key: 'type',
                  get: function get() {
                    return Cell.Types.Null;
                  },
                },
                {
                  key: 'effectiveType',
                  get: function get() {
                    return Cell.Types.Null;
                  },
                },
                {
                  key: 'address',
                  get: function get() {
                    return this.model.address;
                  },
                  set: function set(value) {
                    this.model.address = value;
                  },
                },
              ]);

              return NullValue;
            })();

          var NumberValue =
            /*#__PURE__*/
            (function() {
              function NumberValue(cell, value) {
                _classCallCheck(this, NumberValue);

                this.model = {
                  address: cell.address,
                  type: Cell.Types.Number,
                  value: value,
                };
              }

              _createClass(NumberValue, [
                {
                  key: 'toCsvString',
                  value: function toCsvString() {
                    return this.model.value.toString();
                  },
                },
                {
                  key: 'release',
                  value: function release() {},
                },
                {
                  key: 'toString',
                  value: function toString() {
                    return this.model.value.toString();
                  },
                },
                {
                  key: 'value',
                  get: function get() {
                    return this.model.value;
                  },
                  set: function set(value) {
                    this.model.value = value;
                  },
                },
                {
                  key: 'type',
                  get: function get() {
                    return Cell.Types.Number;
                  },
                },
                {
                  key: 'effectiveType',
                  get: function get() {
                    return Cell.Types.Number;
                  },
                },
                {
                  key: 'address',
                  get: function get() {
                    return this.model.address;
                  },
                  set: function set(value) {
                    this.model.address = value;
                  },
                },
              ]);

              return NumberValue;
            })();

          var StringValue =
            /*#__PURE__*/
            (function() {
              function StringValue(cell, value) {
                _classCallCheck(this, StringValue);

                this.model = {
                  address: cell.address,
                  type: Cell.Types.String,
                  value: value,
                };
              }

              _createClass(StringValue, [
                {
                  key: 'toCsvString',
                  value: function toCsvString() {
                    return '"'.concat(
                      this.model.value.replace(/"/g, '""'),
                      '"'
                    );
                  },
                },
                {
                  key: 'release',
                  value: function release() {},
                },
                {
                  key: 'toString',
                  value: function toString() {
                    return this.model.value;
                  },
                },
                {
                  key: 'value',
                  get: function get() {
                    return this.model.value;
                  },
                  set: function set(value) {
                    this.model.value = value;
                  },
                },
                {
                  key: 'type',
                  get: function get() {
                    return Cell.Types.String;
                  },
                },
                {
                  key: 'effectiveType',
                  get: function get() {
                    return Cell.Types.String;
                  },
                },
                {
                  key: 'address',
                  get: function get() {
                    return this.model.address;
                  },
                  set: function set(value) {
                    this.model.address = value;
                  },
                },
              ]);

              return StringValue;
            })();

          var RichTextValue =
            /*#__PURE__*/
            (function() {
              function RichTextValue(cell, value) {
                _classCallCheck(this, RichTextValue);

                this.model = {
                  address: cell.address,
                  type: Cell.Types.String,
                  value: value,
                };
              }

              _createClass(RichTextValue, [
                {
                  key: 'toString',
                  value: function toString() {
                    return this.model.value.richText
                      .map(function(t) {
                        return t.text;
                      })
                      .join('');
                  },
                },
                {
                  key: 'toCsvString',
                  value: function toCsvString() {
                    return '"'.concat(this.text.replace(/"/g, '""'), '"');
                  },
                },
                {
                  key: 'release',
                  value: function release() {},
                },
                {
                  key: 'value',
                  get: function get() {
                    return this.model.value;
                  },
                  set: function set(value) {
                    this.model.value = value;
                  },
                },
                {
                  key: 'type',
                  get: function get() {
                    return Cell.Types.RichText;
                  },
                },
                {
                  key: 'effectiveType',
                  get: function get() {
                    return Cell.Types.RichText;
                  },
                },
                {
                  key: 'address',
                  get: function get() {
                    return this.model.address;
                  },
                  set: function set(value) {
                    this.model.address = value;
                  },
                },
              ]);

              return RichTextValue;
            })();

          var DateValue =
            /*#__PURE__*/
            (function() {
              function DateValue(cell, value) {
                _classCallCheck(this, DateValue);

                this.model = {
                  address: cell.address,
                  type: Cell.Types.Date,
                  value: value,
                };
              }

              _createClass(DateValue, [
                {
                  key: 'toCsvString',
                  value: function toCsvString() {
                    return this.model.value.toISOString();
                  },
                },
                {
                  key: 'release',
                  value: function release() {},
                },
                {
                  key: 'toString',
                  value: function toString() {
                    return this.model.value.toString();
                  },
                },
                {
                  key: 'value',
                  get: function get() {
                    return this.model.value;
                  },
                  set: function set(value) {
                    this.model.value = value;
                  },
                },
                {
                  key: 'type',
                  get: function get() {
                    return Cell.Types.Date;
                  },
                },
                {
                  key: 'effectiveType',
                  get: function get() {
                    return Cell.Types.Date;
                  },
                },
                {
                  key: 'address',
                  get: function get() {
                    return this.model.address;
                  },
                  set: function set(value) {
                    this.model.address = value;
                  },
                },
              ]);

              return DateValue;
            })();

          var HyperlinkValue =
            /*#__PURE__*/
            (function() {
              function HyperlinkValue(cell, value) {
                _classCallCheck(this, HyperlinkValue);

                this.model = Object.assign(
                  {
                    address: cell.address,
                    type: Cell.Types.Hyperlink,
                    text: value ? value.text : undefined,
                    hyperlink: value ? value.hyperlink : undefined,
                  },
                  value && value.tooltip
                    ? {
                        tooltip: value.tooltip,
                      }
                    : {}
                );
              }

              _createClass(HyperlinkValue, [
                {
                  key: 'toCsvString',
                  value: function toCsvString() {
                    return this.model.hyperlink;
                  },
                },
                {
                  key: 'release',
                  value: function release() {},
                },
                {
                  key: 'toString',
                  value: function toString() {
                    return this.model.text;
                  },
                },
                {
                  key: 'value',
                  get: function get() {
                    return Object.assign(
                      {
                        text: this.model.text,
                        hyperlink: this.model.hyperlink,
                      },
                      this.model.tooltip
                        ? {
                            tooltip: this.model.tooltip,
                          }
                        : {}
                    );
                  },
                  set: function set(value) {
                    this.model = Object.assign(
                      {
                        text: value.text,
                        hyperlink: value.hyperlink,
                      },
                      value && value.tooltip
                        ? {
                            tooltip: value.tooltip,
                          }
                        : {}
                    );
                  },
                },
                {
                  key: 'text',
                  get: function get() {
                    return this.model.text;
                  },
                  set: function set(value) {
                    this.model.text = value;
                  },
                  /*
    get tooltip() {
      return this.model.tooltip;
    }
     set tooltip(value) {
      this.model.tooltip = value;
    } */
                },
                {
                  key: 'hyperlink',
                  get: function get() {
                    return this.model.hyperlink;
                  },
                  set: function set(value) {
                    this.model.hyperlink = value;
                  },
                },
                {
                  key: 'type',
                  get: function get() {
                    return Cell.Types.Hyperlink;
                  },
                },
                {
                  key: 'effectiveType',
                  get: function get() {
                    return Cell.Types.Hyperlink;
                  },
                },
                {
                  key: 'address',
                  get: function get() {
                    return this.model.address;
                  },
                  set: function set(value) {
                    this.model.address = value;
                  },
                },
              ]);

              return HyperlinkValue;
            })();

          var MergeValue =
            /*#__PURE__*/
            (function() {
              function MergeValue(cell, master) {
                _classCallCheck(this, MergeValue);

                this.model = {
                  address: cell.address,
                  type: Cell.Types.Merge,
                  master: master ? master.address : undefined,
                };
                this._master = master;

                if (master) {
                  master.addMergeRef();
                }
              }

              _createClass(MergeValue, [
                {
                  key: 'isMergedTo',
                  value: function isMergedTo(master) {
                    return master === this._master;
                  },
                },
                {
                  key: 'toCsvString',
                  value: function toCsvString() {
                    return '';
                  },
                },
                {
                  key: 'release',
                  value: function release() {
                    this._master.releaseMergeRef();
                  },
                },
                {
                  key: 'toString',
                  value: function toString() {
                    return this.value.toString();
                  },
                },
                {
                  key: 'value',
                  get: function get() {
                    return this._master.value;
                  },
                  set: function set(value) {
                    if (value instanceof Cell) {
                      if (this._master) {
                        this._master.releaseMergeRef();
                      }

                      value.addMergeRef();
                      this._master = value;
                    } else {
                      this._master.value = value;
                    }
                  },
                },
                {
                  key: 'master',
                  get: function get() {
                    return this._master;
                  },
                },
                {
                  key: 'type',
                  get: function get() {
                    return Cell.Types.Merge;
                  },
                },
                {
                  key: 'effectiveType',
                  get: function get() {
                    return this._master.effectiveType;
                  },
                },
                {
                  key: 'address',
                  get: function get() {
                    return this.model.address;
                  },
                  set: function set(value) {
                    this.model.address = value;
                  },
                },
              ]);

              return MergeValue;
            })();

          var FormulaValue =
            /*#__PURE__*/
            (function() {
              function FormulaValue(cell, value) {
                _classCallCheck(this, FormulaValue);

                this.cell = cell;
                this.model = {
                  address: cell.address,
                  type: Cell.Types.Formula,
                  formula: value ? value.formula : undefined,
                  sharedFormula: value ? value.sharedFormula : undefined,
                  result: value ? value.result : undefined,
                };
              }

              _createClass(FormulaValue, [
                {
                  key: 'validate',
                  value: function validate(value) {
                    switch (Value.getType(value)) {
                      case Cell.Types.Null:
                      case Cell.Types.String:
                      case Cell.Types.Number:
                      case Cell.Types.Date:
                        break;

                      case Cell.Types.Hyperlink:
                      case Cell.Types.Formula:
                      default:
                        throw new Error(
                          'Cannot process that type of result value'
                        );
                    }
                  },
                },
                {
                  key: '_getTranslatedFormula',
                  value: function _getTranslatedFormula() {
                    if (!this._translatedFormula && this.model.sharedFormula) {
                      var worksheet = this.cell.worksheet;
                      var master = worksheet.findCell(this.model.sharedFormula);
                      this._translatedFormula =
                        master &&
                        slideFormula(
                          master.formula,
                          master.address,
                          this.model.address
                        );
                    }

                    return this._translatedFormula;
                  },
                },
                {
                  key: 'toCsvString',
                  value: function toCsvString() {
                    return ''.concat(this.model.result || '');
                  },
                },
                {
                  key: 'release',
                  value: function release() {},
                },
                {
                  key: 'toString',
                  value: function toString() {
                    return this.model.result
                      ? this.model.result.toString()
                      : '';
                  },
                },
                {
                  key: 'value',
                  get: function get() {
                    return this.model.formula
                      ? {
                          formula: this.model.formula,
                          result: this.model.result,
                        }
                      : {
                          sharedFormula: this.model.sharedFormula,
                          result: this.model.result,
                        };
                  },
                  set: function set(value) {
                    this.model.formula = value.formula;
                    this.model.sharedFormula = value.sharedFormula;
                    this.model.result = value.result;
                  },
                },
                {
                  key: 'dependencies',
                  get: function get() {
                    // find all the ranges and cells mentioned in the formula
                    var ranges = this.formula.match(
                      /([a-zA-Z0-9]+!)?[A-Z]{1,3}\d{1,4}:[A-Z]{1,3}\d{1,4}/g
                    );
                    var cells = this.formula
                      .replace(
                        /([a-zA-Z0-9]+!)?[A-Z]{1,3}\d{1,4}:[A-Z]{1,3}\d{1,4}/g,
                        ''
                      )
                      .match(/([a-zA-Z0-9]+!)?[A-Z]{1,3}\d{1,4}/g);
                    return {
                      ranges: ranges,
                      cells: cells,
                    };
                  },
                },
                {
                  key: 'formula',
                  get: function get() {
                    return this.model.formula || this._getTranslatedFormula();
                  },
                  set: function set(value) {
                    this.model.formula = value;
                  },
                },
                {
                  key: 'formulaType',
                  get: function get() {
                    if (this.model.formula) {
                      return Enums.FormulaType.Master;
                    }

                    if (this.model.sharedFormula) {
                      return Enums.FormulaType.Shared;
                    }

                    return Enums.FormulaType.None;
                  },
                },
                {
                  key: 'result',
                  get: function get() {
                    return this.model.result;
                  },
                  set: function set(value) {
                    this.model.result = value;
                  },
                },
                {
                  key: 'type',
                  get: function get() {
                    return Cell.Types.Formula;
                  },
                },
                {
                  key: 'effectiveType',
                  get: function get() {
                    var v = this.model.result;

                    if (v === null || v === undefined) {
                      return Enums.ValueType.Null;
                    }

                    if (v instanceof String || typeof v === 'string') {
                      return Enums.ValueType.String;
                    }

                    if (typeof v === 'number') {
                      return Enums.ValueType.Number;
                    }

                    if (v instanceof Date) {
                      return Enums.ValueType.Date;
                    }

                    if (v.text && v.hyperlink) {
                      return Enums.ValueType.Hyperlink;
                    }

                    if (v.formula) {
                      return Enums.ValueType.Formula;
                    }

                    return Enums.ValueType.Null;
                  },
                },
                {
                  key: 'address',
                  get: function get() {
                    return this.model.address;
                  },
                  set: function set(value) {
                    this.model.address = value;
                  },
                },
              ]);

              return FormulaValue;
            })();

          var SharedStringValue =
            /*#__PURE__*/
            (function() {
              function SharedStringValue(cell, value) {
                _classCallCheck(this, SharedStringValue);

                this.model = {
                  address: cell.address,
                  type: Cell.Types.SharedString,
                  value: value,
                };
              }

              _createClass(SharedStringValue, [
                {
                  key: 'toCsvString',
                  value: function toCsvString() {
                    return this.model.value.toString();
                  },
                },
                {
                  key: 'release',
                  value: function release() {},
                },
                {
                  key: 'toString',
                  value: function toString() {
                    return this.model.value.toString();
                  },
                },
                {
                  key: 'value',
                  get: function get() {
                    return this.model.value;
                  },
                  set: function set(value) {
                    this.model.value = value;
                  },
                },
                {
                  key: 'type',
                  get: function get() {
                    return Cell.Types.SharedString;
                  },
                },
                {
                  key: 'effectiveType',
                  get: function get() {
                    return Cell.Types.SharedString;
                  },
                },
                {
                  key: 'address',
                  get: function get() {
                    return this.model.address;
                  },
                  set: function set(value) {
                    this.model.address = value;
                  },
                },
              ]);

              return SharedStringValue;
            })();

          var BooleanValue =
            /*#__PURE__*/
            (function() {
              function BooleanValue(cell, value) {
                _classCallCheck(this, BooleanValue);

                this.model = {
                  address: cell.address,
                  type: Cell.Types.Boolean,
                  value: value,
                };
              }

              _createClass(BooleanValue, [
                {
                  key: 'toCsvString',
                  value: function toCsvString() {
                    return this.model.value ? 1 : 0;
                  },
                },
                {
                  key: 'release',
                  value: function release() {},
                },
                {
                  key: 'toString',
                  value: function toString() {
                    return this.model.value.toString();
                  },
                },
                {
                  key: 'value',
                  get: function get() {
                    return this.model.value;
                  },
                  set: function set(value) {
                    this.model.value = value;
                  },
                },
                {
                  key: 'type',
                  get: function get() {
                    return Cell.Types.Boolean;
                  },
                },
                {
                  key: 'effectiveType',
                  get: function get() {
                    return Cell.Types.Boolean;
                  },
                },
                {
                  key: 'address',
                  get: function get() {
                    return this.model.address;
                  },
                  set: function set(value) {
                    this.model.address = value;
                  },
                },
              ]);

              return BooleanValue;
            })();

          var ErrorValue =
            /*#__PURE__*/
            (function() {
              function ErrorValue(cell, value) {
                _classCallCheck(this, ErrorValue);

                this.model = {
                  address: cell.address,
                  type: Cell.Types.Error,
                  value: value,
                };
              }

              _createClass(ErrorValue, [
                {
                  key: 'toCsvString',
                  value: function toCsvString() {
                    return this.toString();
                  },
                },
                {
                  key: 'release',
                  value: function release() {},
                },
                {
                  key: 'toString',
                  value: function toString() {
                    return this.model.value.error.toString();
                  },
                },
                {
                  key: 'value',
                  get: function get() {
                    return this.model.value;
                  },
                  set: function set(value) {
                    this.model.value = value;
                  },
                },
                {
                  key: 'type',
                  get: function get() {
                    return Cell.Types.Error;
                  },
                },
                {
                  key: 'effectiveType',
                  get: function get() {
                    return Cell.Types.Error;
                  },
                },
                {
                  key: 'address',
                  get: function get() {
                    return this.model.address;
                  },
                  set: function set(value) {
                    this.model.address = value;
                  },
                },
              ]);

              return ErrorValue;
            })();

          var JSONValue =
            /*#__PURE__*/
            (function() {
              function JSONValue(cell, value) {
                _classCallCheck(this, JSONValue);

                this.model = {
                  address: cell.address,
                  type: Cell.Types.String,
                  value: JSON.stringify(value),
                  rawValue: value,
                };
              }

              _createClass(JSONValue, [
                {
                  key: 'toCsvString',
                  value: function toCsvString() {
                    return this.model.value;
                  },
                },
                {
                  key: 'release',
                  value: function release() {},
                },
                {
                  key: 'toString',
                  value: function toString() {
                    return this.model.value;
                  },
                },
                {
                  key: 'value',
                  get: function get() {
                    return this.model.rawValue;
                  },
                  set: function set(value) {
                    this.model.rawValue = value;
                    this.model.value = JSON.stringify(value);
                  },
                },
                {
                  key: 'type',
                  get: function get() {
                    return Cell.Types.String;
                  },
                },
                {
                  key: 'effectiveType',
                  get: function get() {
                    return Cell.Types.String;
                  },
                },
                {
                  key: 'address',
                  get: function get() {
                    return this.model.address;
                  },
                  set: function set(value) {
                    this.model.address = value;
                  },
                },
              ]);

              return JSONValue;
            })(); // Value is a place to hold common static Value type functions

          var Value = {
            getType: function getType(value) {
              if (value === null || value === undefined) {
                return Cell.Types.Null;
              }

              if (value instanceof String || typeof value === 'string') {
                return Cell.Types.String;
              }

              if (typeof value === 'number') {
                return Cell.Types.Number;
              }

              if (typeof value === 'boolean') {
                return Cell.Types.Boolean;
              }

              if (value instanceof Date) {
                return Cell.Types.Date;
              }

              if (value.text && value.hyperlink) {
                return Cell.Types.Hyperlink;
              }

              if (value.formula || value.sharedFormula) {
                return Cell.Types.Formula;
              }

              if (value.richText) {
                return Cell.Types.RichText;
              }

              if (value.sharedString) {
                return Cell.Types.SharedString;
              }

              if (value.error) {
                return Cell.Types.Error;
              }

              return Cell.Types.JSON;
            },
            // map valueType to constructor
            types: [
              {
                t: Cell.Types.Null,
                f: NullValue,
              },
              {
                t: Cell.Types.Number,
                f: NumberValue,
              },
              {
                t: Cell.Types.String,
                f: StringValue,
              },
              {
                t: Cell.Types.Date,
                f: DateValue,
              },
              {
                t: Cell.Types.Hyperlink,
                f: HyperlinkValue,
              },
              {
                t: Cell.Types.Formula,
                f: FormulaValue,
              },
              {
                t: Cell.Types.Merge,
                f: MergeValue,
              },
              {
                t: Cell.Types.JSON,
                f: JSONValue,
              },
              {
                t: Cell.Types.SharedString,
                f: SharedStringValue,
              },
              {
                t: Cell.Types.RichText,
                f: RichTextValue,
              },
              {
                t: Cell.Types.Boolean,
                f: BooleanValue,
              },
              {
                t: Cell.Types.Error,
                f: ErrorValue,
              },
            ].reduce(function(p, t) {
              p[t.t] = t.f;
              return p;
            }, []),
            create: function create(type, cell, value) {
              var T = this.types[type];

              if (!T) {
                throw new Error('Could not create Value of type '.concat(type));
              }

              return new T(cell, value);
            },
          };
          module.exports = Cell;
        },
        {
          '../utils/col-cache': 17,
          '../utils/shared-formula': 19,
          '../utils/under-dash': 22,
          './enums': 8,
          './note': 10,
        },
      ],
      5: [
        function(require, module, exports) {
          'use strict';

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          var _ = require('../utils/under-dash');

          var Enums = require('./enums');

          var colCache = require('../utils/col-cache'); // Column defines the column properties for 1 column.
          // This includes header rows, widths, key, (style), etc.
          // Worksheet will condense the columns as appropriate during serialization

          module.exports =
            /*#__PURE__*/
            (function() {
              function Column(worksheet, number, defn) {
                _classCallCheck(this, Column);

                this._worksheet = worksheet;
                this._number = number;

                if (defn !== false) {
                  // sometimes defn will follow
                  this.defn = defn;
                }
              }

              _createClass(
                Column,
                [
                  {
                    key: 'toString',
                    value: function toString() {
                      return JSON.stringify({
                        key: this.key,
                        width: this.width,
                        headers: this.headers.length ? this.headers : undefined,
                      });
                    },
                  },
                  {
                    key: 'equivalentTo',
                    value: function equivalentTo(other) {
                      return (
                        this.width === other.width &&
                        this.hidden === other.hidden &&
                        this.outlineLevel === other.outlineLevel &&
                        _.isEqual(this.style, other.style)
                      );
                    },
                  },
                  {
                    key: 'eachCell',
                    value: function eachCell(options, iteratee) {
                      var colNumber = this.number;

                      if (!iteratee) {
                        iteratee = options;
                        options = null;
                      }

                      this._worksheet.eachRow(options, function(
                        row,
                        rowNumber
                      ) {
                        iteratee(row.getCell(colNumber), rowNumber);
                      });
                    },
                  },
                  {
                    key: '_applyStyle',
                    // =========================================================================
                    // styles
                    value: function _applyStyle(name, value) {
                      this.style[name] = value;
                      this.eachCell(function(cell) {
                        cell[name] = value;
                      });
                      return value;
                    },
                  },
                  {
                    key: 'number',
                    get: function get() {
                      return this._number;
                    },
                  },
                  {
                    key: 'worksheet',
                    get: function get() {
                      return this._worksheet;
                    },
                  },
                  {
                    key: 'letter',
                    get: function get() {
                      return colCache.n2l(this._number);
                    },
                  },
                  {
                    key: 'isCustomWidth',
                    get: function get() {
                      return this.width !== undefined && this.width !== 8;
                    },
                  },
                  {
                    key: 'defn',
                    get: function get() {
                      return {
                        header: this._header,
                        key: this.key,
                        width: this.width,
                        style: this.style,
                        hidden: this.hidden,
                        outlineLevel: this.outlineLevel,
                      };
                    },
                    set: function set(value) {
                      if (value) {
                        this.key = value.key;
                        this.width = value.width;
                        this.outlineLevel = value.outlineLevel;

                        if (value.style) {
                          this.style = value.style;
                        } else {
                          this.style = {};
                        } // headers must be set after style

                        this.header = value.header;
                        this._hidden = !!value.hidden;
                      } else {
                        delete this._header;
                        delete this._key;
                        delete this.width;
                        this.style = {};
                        this.outlineLevel = 0;
                      }
                    },
                  },
                  {
                    key: 'headers',
                    get: function get() {
                      return this._header && this._header instanceof Array
                        ? this._header
                        : [this._header];
                    },
                  },
                  {
                    key: 'header',
                    get: function get() {
                      return this._header;
                    },
                    set: function set(value) {
                      var _this = this;

                      if (value !== undefined) {
                        this._header = value;
                        this.headers.forEach(function(text, index) {
                          _this._worksheet.getCell(
                            index + 1,
                            _this.number
                          ).value = text;
                        });
                      } else {
                        this._header = undefined;
                      }
                    },
                  },
                  {
                    key: 'key',
                    get: function get() {
                      return this._key;
                    },
                    set: function set(value) {
                      var column =
                        this._key && this._worksheet.getColumnKey(this._key);

                      if (column === this) {
                        this._worksheet.deleteColumnKey(this._key);
                      }

                      this._key = value;

                      if (value) {
                        this._worksheet.setColumnKey(this._key, this);
                      }
                    },
                  },
                  {
                    key: 'hidden',
                    get: function get() {
                      return !!this._hidden;
                    },
                    set: function set(value) {
                      this._hidden = value;
                    },
                  },
                  {
                    key: 'outlineLevel',
                    get: function get() {
                      return this._outlineLevel || 0;
                    },
                    set: function set(value) {
                      this._outlineLevel = value;
                    },
                  },
                  {
                    key: 'collapsed',
                    get: function get() {
                      return !!(
                        this._outlineLevel &&
                        this._outlineLevel >=
                          this._worksheet.properties.outlineLevelCol
                      );
                    },
                  },
                  {
                    key: 'isDefault',
                    get: function get() {
                      if (this.isCustomWidth) {
                        return false;
                      }

                      if (this.hidden) {
                        return false;
                      }

                      if (this.outlineLevel) {
                        return false;
                      }

                      var s = this.style;

                      if (
                        s &&
                        (s.font ||
                          s.numFmt ||
                          s.alignment ||
                          s.border ||
                          s.fill)
                      ) {
                        return false;
                      }

                      return true;
                    },
                  },
                  {
                    key: 'headerCount',
                    get: function get() {
                      return this.headers.length;
                    },
                  },
                  {
                    key: 'values',
                    get: function get() {
                      var v = [];
                      this.eachCell(function(cell, rowNumber) {
                        if (cell && cell.type !== Enums.ValueType.Null) {
                          v[rowNumber] = cell.value;
                        }
                      });
                      return v;
                    },
                    set: function set(v) {
                      var _this2 = this;

                      if (!v) {
                        return;
                      }

                      var colNumber = this.number;
                      var offset = 0;

                      if (v.hasOwnProperty('0')) {
                        // assume contiguous array, start at row 1
                        offset = 1;
                      }

                      v.forEach(function(value, index) {
                        _this2._worksheet.getCell(
                          index + offset,
                          colNumber
                        ).value = value;
                      });
                    },
                  },
                  {
                    key: 'numFmt',
                    get: function get() {
                      return this.style.numFmt;
                    },
                    set: function set(value) {
                      this._applyStyle('numFmt', value);
                    },
                  },
                  {
                    key: 'font',
                    get: function get() {
                      return this.style.font;
                    },
                    set: function set(value) {
                      this._applyStyle('font', value);
                    },
                  },
                  {
                    key: 'alignment',
                    get: function get() {
                      return this.style.alignment;
                    },
                    set: function set(value) {
                      this._applyStyle('alignment', value);
                    },
                  },
                  {
                    key: 'border',
                    get: function get() {
                      return this.style.border;
                    },
                    set: function set(value) {
                      this._applyStyle('border', value);
                    },
                  },
                  {
                    key: 'fill',
                    get: function get() {
                      return this.style.fill;
                    },
                    set: function set(value) {
                      this._applyStyle('fill', value);
                    }, // =============================================================================
                    // static functions
                  },
                ],
                [
                  {
                    key: 'toModel',
                    value: function toModel(columns) {
                      // Convert array of Column into compressed list cols
                      var cols = [];
                      var col = null;

                      if (columns) {
                        columns.forEach(function(column, index) {
                          if (column.isDefault) {
                            if (col) {
                              col = null;
                            }
                          } else if (!col || !column.equivalentTo(col)) {
                            col = {
                              min: index + 1,
                              max: index + 1,
                              width: column.width,
                              style: column.style,
                              isCustomWidth: column.isCustomWidth,
                              hidden: column.hidden,
                              outlineLevel: column.outlineLevel,
                              collapsed: column.collapsed,
                            };
                            cols.push(col);
                          } else {
                            col.max = index + 1;
                          }
                        });
                      }

                      return cols.length ? cols : undefined;
                    },
                  },
                  {
                    key: 'fromModel',
                    value: function fromModel(worksheet, cols) {
                      cols = cols || [];
                      var columns = [];
                      var count = 1;
                      var index = 0;

                      while (index < cols.length) {
                        var col = cols[index++];

                        while (count < col.min) {
                          columns.push(new Column(worksheet, count++));
                        }

                        while (count <= col.max) {
                          columns.push(new Column(worksheet, count++, col));
                        }
                      }

                      return columns.length ? columns : null;
                    },
                  },
                ]
              );

              return Column;
            })();
        },
        { '../utils/col-cache': 17, '../utils/under-dash': 22, './enums': 8 },
      ],
      6: [
        function(require, module, exports) {
          'use strict';

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          module.exports =
            /*#__PURE__*/
            (function() {
              function DataValidations(model) {
                _classCallCheck(this, DataValidations);

                this.model = model || {};
              }

              _createClass(DataValidations, [
                {
                  key: 'add',
                  value: function add(address, validation) {
                    return (this.model[address] = validation);
                  },
                },
                {
                  key: 'find',
                  value: function find(address) {
                    return this.model[address];
                  },
                },
                {
                  key: 'remove',
                  value: function remove(address) {
                    this.model[address] = undefined;
                  },
                },
              ]);

              return DataValidations;
            })();
        },
        {},
      ],
      7: [
        function(require, module, exports) {
          'use strict';

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          var _ = require('../utils/under-dash');

          var colCache = require('../utils/col-cache');

          var CellMatrix = require('../utils/cell-matrix');

          var Range = require('./range');

          var rangeRegexp = /[$](\w+)[$](\d+)(:[$](\w+)[$](\d+))?/;

          module.exports =
            /*#__PURE__*/
            (function() {
              function DefinedNames() {
                _classCallCheck(this, DefinedNames);

                this.matrixMap = {};
              }

              _createClass(DefinedNames, [
                {
                  key: 'getMatrix',
                  value: function getMatrix(name) {
                    var matrix =
                      this.matrixMap[name] ||
                      (this.matrixMap[name] = new CellMatrix());
                    return matrix;
                  }, // add a name to a cell. locStr in the form SheetName!$col$row or SheetName!$c1$r1:$c2:$r2
                },
                {
                  key: 'add',
                  value: function add(locStr, name) {
                    var location = colCache.decodeEx(locStr);
                    this.addEx(location, name);
                  },
                },
                {
                  key: 'addEx',
                  value: function addEx(location, name) {
                    var matrix = this.getMatrix(name);

                    if (location.top) {
                      for (
                        var col = location.left;
                        col <= location.right;
                        col++
                      ) {
                        for (
                          var row = location.top;
                          row <= location.bottom;
                          row++
                        ) {
                          var address = {
                            sheetName: location.sheetName,
                            address: colCache.n2l(col) + row,
                            row: row,
                            col: col,
                          };
                          matrix.addCellEx(address);
                        }
                      }
                    } else {
                      matrix.addCellEx(location);
                    }
                  },
                },
                {
                  key: 'remove',
                  value: function remove(locStr, name) {
                    var location = colCache.decodeEx(locStr);
                    this.removeEx(location, name);
                  },
                },
                {
                  key: 'removeEx',
                  value: function removeEx(location, name) {
                    var matrix = this.getMatrix(name);
                    matrix.removeCellEx(location);
                  },
                },
                {
                  key: 'removeAllNames',
                  value: function removeAllNames(location) {
                    _.each(this.matrixMap, function(matrix) {
                      matrix.removeCellEx(location);
                    });
                  },
                },
                {
                  key: 'forEach',
                  value: function forEach(callback) {
                    _.each(this.matrixMap, function(matrix, name) {
                      matrix.forEach(function(cell) {
                        callback(name, cell);
                      });
                    });
                  }, // get all the names of a cell
                },
                {
                  key: 'getNames',
                  value: function getNames(addressStr) {
                    return this.getNamesEx(colCache.decodeEx(addressStr));
                  },
                },
                {
                  key: 'getNamesEx',
                  value: function getNamesEx(address) {
                    return _.map(this.matrixMap, function(matrix, name) {
                      return matrix.findCellEx(address) && name;
                    }).filter(Boolean);
                  },
                },
                {
                  key: '_explore',
                  value: function _explore(matrix, cell) {
                    cell.mark = false;
                    var sheetName = cell.sheetName;
                    var range = new Range(
                      cell.row,
                      cell.col,
                      cell.row,
                      cell.col,
                      sheetName
                    );
                    var x;
                    var y; // grow vertical - only one col to worry about

                    function vGrow(yy, edge) {
                      var c = matrix.findCellAt(sheetName, yy, cell.col);

                      if (!c || !c.mark) {
                        return false;
                      }

                      range[edge] = yy;
                      c.mark = false;
                      return true;
                    }

                    for (y = cell.row - 1; vGrow(y, 'top'); y--) {}

                    for (y = cell.row + 1; vGrow(y, 'bottom'); y++) {} // grow horizontal - ensure all rows can grow

                    function hGrow(xx, edge) {
                      var cells = [];

                      for (y = range.top; y <= range.bottom; y++) {
                        var c = matrix.findCellAt(sheetName, y, xx);

                        if (c && c.mark) {
                          cells.push(c);
                        } else {
                          return false;
                        }
                      }

                      range[edge] = xx;

                      for (var i = 0; i < cells.length; i++) {
                        cells[i].mark = false;
                      }

                      return true;
                    }

                    for (x = cell.col - 1; hGrow(x, 'left'); x--) {}

                    for (x = cell.col + 1; hGrow(x, 'right'); x++) {}

                    return range;
                  },
                },
                {
                  key: 'getRanges',
                  value: function getRanges(name, matrix) {
                    var _this = this;

                    matrix = matrix || this.matrixMap[name];

                    if (!matrix) {
                      return {
                        name: name,
                        ranges: [],
                      };
                    } // mark and sweep!

                    matrix.forEach(function(cell) {
                      cell.mark = true;
                    });
                    var ranges = matrix
                      .map(function(cell) {
                        return cell.mark && _this._explore(matrix, cell);
                      })
                      .filter(Boolean)
                      .map(function(range) {
                        return range.$shortRange;
                      });
                    return {
                      name: name,
                      ranges: ranges,
                    };
                  },
                },
                {
                  key: 'normaliseMatrix',
                  value: function normaliseMatrix(matrix, sheetName) {
                    // some of the cells might have shifted on specified sheet
                    // need to reassign rows, cols
                    matrix.forEachInSheet(sheetName, function(cell, row, col) {
                      if (cell) {
                        if (cell.row !== row || cell.col !== col) {
                          cell.row = row;
                          cell.col = col;
                          cell.address = colCache.n2l(col) + row;
                        }
                      }
                    });
                  },
                },
                {
                  key: 'spliceRows',
                  value: function spliceRows(
                    sheetName,
                    start,
                    numDelete,
                    numInsert
                  ) {
                    var _this2 = this;

                    _.each(this.matrixMap, function(matrix) {
                      matrix.spliceRows(sheetName, start, numDelete, numInsert);

                      _this2.normaliseMatrix(matrix, sheetName);
                    });
                  },
                },
                {
                  key: 'spliceColumns',
                  value: function spliceColumns(
                    sheetName,
                    start,
                    numDelete,
                    numInsert
                  ) {
                    var _this3 = this;

                    _.each(this.matrixMap, function(matrix) {
                      matrix.spliceColumns(
                        sheetName,
                        start,
                        numDelete,
                        numInsert
                      );

                      _this3.normaliseMatrix(matrix, sheetName);
                    });
                  },
                },
                {
                  key: 'model',
                  get: function get() {
                    var _this4 = this;

                    // To get names per cell - just iterate over all names finding cells if they exist
                    return _.map(this.matrixMap, function(matrix, name) {
                      return _this4.getRanges(name, matrix);
                    }).filter(function(definedName) {
                      return definedName.ranges.length;
                    });
                  },
                  set: function set(value) {
                    // value is [ { name, ranges }, ... ]
                    var matrixMap = (this.matrixMap = {});
                    value.forEach(function(definedName) {
                      var matrix = (matrixMap[
                        definedName.name
                      ] = new CellMatrix());
                      definedName.ranges.forEach(function(rangeStr) {
                        if (rangeRegexp.test(rangeStr.split('!').pop() || '')) {
                          matrix.addCell(rangeStr);
                        }
                      });
                    });
                  },
                },
              ]);

              return DefinedNames;
            })();
        },
        {
          '../utils/cell-matrix': 16,
          '../utils/col-cache': 17,
          '../utils/under-dash': 22,
          './range': 11,
        },
      ],
      8: [
        function(require, module, exports) {
          'use strict';

          module.exports = {
            ValueType: {
              Null: 0,
              Merge: 1,
              Number: 2,
              String: 3,
              Date: 4,
              Hyperlink: 5,
              Formula: 6,
              SharedString: 7,
              RichText: 8,
              Boolean: 9,
              Error: 10,
            },
            FormulaType: {
              None: 0,
              Master: 1,
              Shared: 2,
            },
            RelationshipType: {
              None: 0,
              OfficeDocument: 1,
              Worksheet: 2,
              CalcChain: 3,
              SharedStrings: 4,
              Styles: 5,
              Theme: 6,
              Hyperlink: 7,
            },
            DocumentType: {
              Xlsx: 1,
            },
            ReadingOrder: {
              LeftToRight: 1,
              RightToLeft: 2,
            },
            ErrorValue: {
              NotApplicable: '#N/A',
              Ref: '#REF!',
              Name: '#NAME?',
              DivZero: '#DIV/0!',
              Null: '#NULL!',
              Value: '#VALUE!',
              Num: '#NUM!',
            },
          };
        },
        {},
      ],
      9: [
        function(require, module, exports) {
          'use strict';

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          var colCache = require('../utils/col-cache');

          var Anchor = require('./anchor');

          module.exports =
            /*#__PURE__*/
            (function() {
              function Image(worksheet, model) {
                _classCallCheck(this, Image);

                this.worksheet = worksheet;
                this.model = model;
              }

              _createClass(Image, [
                {
                  key: 'model',
                  get: function get() {
                    switch (this.type) {
                      case 'background':
                        return {
                          type: this.type,
                          imageId: this.imageId,
                        };

                      case 'image':
                        return {
                          type: this.type,
                          imageId: this.imageId,
                          range: {
                            tl: this.range.tl.model,
                            br: this.range.br && this.range.br.model,
                            ext: this.range.ext,
                          },
                        };

                      default:
                        throw new Error('Invalid Image Type');
                    }
                  },
                  set: function set(_ref) {
                    var type = _ref.type,
                      imageId = _ref.imageId,
                      range = _ref.range;
                    this.type = type;
                    this.imageId = imageId;

                    if (type === 'image') {
                      if (typeof range === 'string') {
                        var decoded = colCache.decode(range);
                        this.range = {
                          tl: new Anchor(
                            this.worksheet,
                            {
                              col: decoded.left,
                              row: decoded.top,
                            },
                            -1
                          ),
                          br: new Anchor(
                            this.worksheet,
                            {
                              col: decoded.right,
                              row: decoded.bottom,
                            },
                            0
                          ),
                          editAs: 'oneCell',
                        };
                      } else {
                        this.range = {
                          tl: new Anchor(this.worksheet, range.tl, 0),
                          br:
                            range.br && new Anchor(this.worksheet, range.br, 0),
                          ext: range.ext,
                          editAs: range.editAs,
                        };
                      }
                    }
                  },
                },
              ]);

              return Image;
            })();
        },
        { '../utils/col-cache': 17, './anchor': 3 },
      ],
      10: [
        function(require, module, exports) {
          'use strict';

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          module.exports =
            /*#__PURE__*/
            (function() {
              function Note(note) {
                _classCallCheck(this, Note);

                if (typeof note === 'string') {
                  this.note = {
                    texts: [
                      {
                        text: note,
                      },
                    ],
                  };
                } else {
                  this.note = note;
                }
              }

              _createClass(Note, [
                {
                  key: 'model',
                  get: function get() {
                    return {
                      type: 'note',
                      note: this.note,
                    };
                  },
                  set: function set(value) {
                    this.note = value.note;
                  },
                },
              ]);

              return Note;
            })();
        },
        {},
      ],
      11: [
        function(require, module, exports) {
          'use strict';

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          var colCache = require('./../utils/col-cache'); // used by worksheet to calculate sheet dimensions

          module.exports =
            /*#__PURE__*/
            (function() {
              function Range() {
                _classCallCheck(this, Range);

                this.decode(arguments);
              }

              _createClass(Range, [
                {
                  key: 'setTLBR',
                  value: function setTLBR(t, l, b, r, s) {
                    if (arguments.length < 4) {
                      // setTLBR(tl, br, s)
                      var tl = colCache.decodeAddress(t);
                      var br = colCache.decodeAddress(l);
                      this.model = {
                        top: Math.min(tl.row, br.row),
                        left: Math.min(tl.col, br.col),
                        bottom: Math.max(tl.row, br.row),
                        right: Math.max(tl.col, br.col),
                        sheetName: b,
                      };
                      this.setTLBR(tl.row, tl.col, br.row, br.col, s);
                    } else {
                      // setTLBR(t, l, b, r, s)
                      this.model = {
                        top: Math.min(t, b),
                        left: Math.min(l, r),
                        bottom: Math.max(t, b),
                        right: Math.max(l, r),
                        sheetName: s,
                      };
                    }
                  },
                },
                {
                  key: 'decode',
                  value: function decode(argv) {
                    switch (argv.length) {
                      case 5:
                        // [t,l,b,r,s]
                        this.setTLBR(
                          argv[0],
                          argv[1],
                          argv[2],
                          argv[3],
                          argv[4]
                        );
                        break;

                      case 4:
                        // [t,l,b,r]
                        this.setTLBR(argv[0], argv[1], argv[2], argv[3]);
                        break;

                      case 3:
                        // [tl,br,s]
                        this.setTLBR(argv[0], argv[1], argv[2]);
                        break;

                      case 2:
                        // [tl,br]
                        this.setTLBR(argv[0], argv[1]);
                        break;

                      case 1: {
                        var value = argv[0];

                        if (value instanceof Range) {
                          // copy constructor
                          this.model = {
                            top: value.model.top,
                            left: value.model.left,
                            bottom: value.model.bottom,
                            right: value.model.right,
                            sheetName: value.sheetName,
                          };
                        } else if (value instanceof Array) {
                          // an arguments array
                          this.decode(value);
                        } else if (
                          value.top &&
                          value.left &&
                          value.bottom &&
                          value.right
                        ) {
                          // a model
                          this.model = {
                            top: value.top,
                            left: value.left,
                            bottom: value.bottom,
                            right: value.right,
                            sheetName: value.sheetName,
                          };
                        } else {
                          // [sheetName!]tl:br
                          var tlbr = colCache.decodeEx(value);

                          if (tlbr.top) {
                            this.model = {
                              top: tlbr.top,
                              left: tlbr.left,
                              bottom: tlbr.bottom,
                              right: tlbr.right,
                              sheetName: tlbr.sheetName,
                            };
                          } else {
                            this.model = {
                              top: tlbr.row,
                              left: tlbr.col,
                              bottom: tlbr.row,
                              right: tlbr.col,
                              sheetName: tlbr.sheetName,
                            };
                          }
                        }

                        break;
                      }

                      case 0:
                        this.model = {
                          top: 0,
                          left: 0,
                          bottom: 0,
                          right: 0,
                        };
                        break;

                      default:
                        throw new Error(
                          'Invalid number of arguments to _getDimensions() - '.concat(
                            argv.length
                          )
                        );
                    }
                  },
                },
                {
                  key: 'expand',
                  value: function expand(top, left, bottom, right) {
                    if (!this.model.top || top < this.top) this.top = top;
                    if (!this.model.left || left < this.left) this.left = left;
                    if (!this.model.bottom || bottom > this.bottom)
                      this.bottom = bottom;
                    if (!this.model.right || right > this.right)
                      this.right = right;
                  },
                },
                {
                  key: 'expandRow',
                  value: function expandRow(row) {
                    if (row) {
                      var dimensions = row.dimensions,
                        number = row.number;

                      if (dimensions) {
                        this.expand(
                          number,
                          dimensions.min,
                          number,
                          dimensions.max
                        );
                      }
                    }
                  },
                },
                {
                  key: 'expandToAddress',
                  value: function expandToAddress(addressStr) {
                    var address = colCache.decodeEx(addressStr);
                    this.expand(
                      address.row,
                      address.col,
                      address.row,
                      address.col
                    );
                  },
                },
                {
                  key: 'toString',
                  value: function toString() {
                    return this.range;
                  },
                },
                {
                  key: 'intersects',
                  value: function intersects(other) {
                    if (
                      other.sheetName &&
                      this.sheetName &&
                      other.sheetName !== this.sheetName
                    )
                      return false;
                    if (other.bottom < this.top) return false;
                    if (other.top > this.bottom) return false;
                    if (other.right < this.left) return false;
                    if (other.left > this.right) return false;
                    return true;
                  },
                },
                {
                  key: 'contains',
                  value: function contains(addressStr) {
                    var address = colCache.decodeEx(addressStr);
                    return this.containsEx(address);
                  },
                },
                {
                  key: 'containsEx',
                  value: function containsEx(address) {
                    if (
                      address.sheetName &&
                      this.sheetName &&
                      address.sheetName !== this.sheetName
                    )
                      return false;
                    return (
                      address.row >= this.top &&
                      address.row <= this.bottom &&
                      address.col >= this.left &&
                      address.col <= this.right
                    );
                  },
                },
                {
                  key: 'top',
                  get: function get() {
                    return this.model.top || 1;
                  },
                  set: function set(value) {
                    this.model.top = value;
                  },
                },
                {
                  key: 'left',
                  get: function get() {
                    return this.model.left || 1;
                  },
                  set: function set(value) {
                    this.model.left = value;
                  },
                },
                {
                  key: 'bottom',
                  get: function get() {
                    return this.model.bottom || 1;
                  },
                  set: function set(value) {
                    this.model.bottom = value;
                  },
                },
                {
                  key: 'right',
                  get: function get() {
                    return this.model.right || 1;
                  },
                  set: function set(value) {
                    this.model.right = value;
                  },
                },
                {
                  key: 'sheetName',
                  get: function get() {
                    return this.model.sheetName;
                  },
                  set: function set(value) {
                    this.model.sheetName = value;
                  },
                },
                {
                  key: '_serialisedSheetName',
                  get: function get() {
                    var sheetName = this.model.sheetName;

                    if (sheetName) {
                      if (/^[a-zA-Z0-9]*$/.test(sheetName)) {
                        return ''.concat(sheetName, '!');
                      }

                      return "'".concat(sheetName, "'!");
                    }

                    return '';
                  },
                },
                {
                  key: 'tl',
                  get: function get() {
                    return colCache.n2l(this.left) + this.top;
                  },
                },
                {
                  key: '$t$l',
                  get: function get() {
                    return '$'
                      .concat(colCache.n2l(this.left), '$')
                      .concat(this.top);
                  },
                },
                {
                  key: 'br',
                  get: function get() {
                    return colCache.n2l(this.right) + this.bottom;
                  },
                },
                {
                  key: '$b$r',
                  get: function get() {
                    return '$'
                      .concat(colCache.n2l(this.right), '$')
                      .concat(this.bottom);
                  },
                },
                {
                  key: 'range',
                  get: function get() {
                    return ''
                      .concat(this._serialisedSheetName + this.tl, ':')
                      .concat(this.br);
                  },
                },
                {
                  key: '$range',
                  get: function get() {
                    return ''
                      .concat(this._serialisedSheetName + this.$t$l, ':')
                      .concat(this.$b$r);
                  },
                },
                {
                  key: 'shortRange',
                  get: function get() {
                    return this.count > 1
                      ? this.range
                      : this._serialisedSheetName + this.tl;
                  },
                },
                {
                  key: '$shortRange',
                  get: function get() {
                    return this.count > 1
                      ? this.$range
                      : this._serialisedSheetName + this.$t$l;
                  },
                },
                {
                  key: 'count',
                  get: function get() {
                    return (
                      (1 + this.bottom - this.top) *
                      (1 + this.right - this.left)
                    );
                  },
                },
              ]);

              return Range;
            })();
        },
        { './../utils/col-cache': 17 },
      ],
      12: [
        function(require, module, exports) {
          'use strict';

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          var _ = require('../utils/under-dash');

          var Enums = require('./enums');

          var colCache = require('./../utils/col-cache');

          var Cell = require('./cell');

          module.exports =
            /*#__PURE__*/
            (function() {
              function Row(worksheet, number) {
                _classCallCheck(this, Row);

                this._worksheet = worksheet;
                this._number = number;
                this._cells = [];
                this.style = {};
                this.outlineLevel = 0;
              } // return the row number

              _createClass(Row, [
                {
                  key: 'commit',
                  // Inform Streaming Writer that this row (and all rows before it) are complete
                  // and ready to write. Has no effect on Worksheet document
                  value: function commit() {
                    this._worksheet._commitRow(this); // eslint-disable-line no-underscore-dangle
                  }, // helps GC by breaking cyclic references
                },
                {
                  key: 'destroy',
                  value: function destroy() {
                    delete this._worksheet;
                    delete this._cells;
                    delete this.style;
                  },
                },
                {
                  key: 'findCell',
                  value: function findCell(colNumber) {
                    return this._cells[colNumber - 1];
                  }, // given {address, row, col}, find or create new cell
                },
                {
                  key: 'getCellEx',
                  value: function getCellEx(address) {
                    var cell = this._cells[address.col - 1];

                    if (!cell) {
                      var column = this._worksheet.getColumn(address.col);

                      cell = new Cell(this, column, address.address);
                      this._cells[address.col - 1] = cell;
                    }

                    return cell;
                  }, // get cell by key, letter or column number
                },
                {
                  key: 'getCell',
                  value: function getCell(col) {
                    if (typeof col === 'string') {
                      // is it a key?
                      var column = this._worksheet.getColumnKey(col);

                      if (column) {
                        col = column.number;
                      } else {
                        col = colCache.l2n(col);
                      }
                    }

                    return (
                      this._cells[col - 1] ||
                      this.getCellEx({
                        address: colCache.encodeAddress(this._number, col),
                        row: this._number,
                        col: col,
                      })
                    );
                  }, // remove cell(s) and shift all higher cells down by count
                },
                {
                  key: 'splice',
                  value: function splice(start, count) {
                    var inserts = Array.prototype.slice.call(arguments, 2);
                    var nKeep = start + count;
                    var nExpand = inserts.length - count;
                    var nEnd = this._cells.length;
                    var i;
                    var cSrc;
                    var cDst;

                    if (nExpand < 0) {
                      // remove cells
                      for (i = start + inserts.length; i <= nEnd; i++) {
                        cDst = this._cells[i - 1];
                        cSrc = this._cells[i - nExpand - 1];

                        if (cSrc) {
                          cDst = this.getCell(i);
                          cDst.value = cSrc.value;
                          cDst.style = cSrc.style;
                        } else if (cDst) {
                          cDst.value = null;
                          cDst.style = {};
                        }
                      }
                    } else if (nExpand > 0) {
                      // insert new cells
                      for (i = nEnd; i >= nKeep; i--) {
                        cSrc = this._cells[i - 1];

                        if (cSrc) {
                          cDst = this.getCell(i + nExpand);
                          cDst.value = cSrc.value;
                          cDst.style = cSrc.style;
                        } else {
                          this._cells[i + nExpand - 1] = undefined;
                        }
                      }
                    } // now add the new values

                    for (i = 0; i < inserts.length; i++) {
                      cDst = this.getCell(start + i);
                      cDst.value = inserts[i];
                      cDst.style = {};
                    }
                  }, // Iterate over all non-null cells in this row
                },
                {
                  key: 'eachCell',
                  value: function eachCell(options, iteratee) {
                    if (!iteratee) {
                      iteratee = options;
                      options = null;
                    }

                    if (options && options.includeEmpty) {
                      var n = this._cells.length;

                      for (var i = 1; i <= n; i++) {
                        iteratee(this.getCell(i), i);
                      }
                    } else {
                      this._cells.forEach(function(cell, index) {
                        if (cell && cell.type !== Enums.ValueType.Null) {
                          iteratee(cell, index + 1);
                        }
                      });
                    }
                  }, // ===========================================================================
                  // Page Breaks
                },
                {
                  key: 'addPageBreak',
                  value: function addPageBreak(lft, rght) {
                    var ws = this._worksheet;
                    var left = Math.max(0, lft - 1) || 0;
                    var right = Math.max(0, rght - 1) || 16838;
                    var pb = {
                      id: this._number,
                      max: right,
                      man: 1,
                    };
                    if (left) pb.min = left;
                    ws.rowBreaks.push(pb);
                  }, // return a sparse array of cell values
                },
                {
                  key: '_applyStyle',
                  // =========================================================================
                  // styles
                  value: function _applyStyle(name, value) {
                    this.style[name] = value;

                    this._cells.forEach(function(cell) {
                      if (cell) {
                        cell[name] = value;
                      }
                    });

                    return value;
                  },
                },
                {
                  key: 'number',
                  get: function get() {
                    return this._number;
                  },
                },
                {
                  key: 'worksheet',
                  get: function get() {
                    return this._worksheet;
                  },
                },
                {
                  key: 'values',
                  get: function get() {
                    var values = [];

                    this._cells.forEach(function(cell) {
                      if (cell && cell.type !== Enums.ValueType.Null) {
                        values[cell.col] = cell.value;
                      }
                    });

                    return values;
                  }, // set the values by contiguous or sparse array, or by key'd object literal
                  set: function set(value) {
                    var _this = this;

                    // this operation is not additive - any prior cells are removed
                    this._cells = [];

                    if (!value) {
                      // empty row
                    } else if (value instanceof Array) {
                      var offset = 0;

                      if (value.hasOwnProperty('0')) {
                        // contiguous array - start at column 1
                        offset = 1;
                      }

                      value.forEach(function(item, index) {
                        if (item !== undefined) {
                          _this.getCellEx({
                            address: colCache.encodeAddress(
                              _this._number,
                              index + offset
                            ),
                            row: _this._number,
                            col: index + offset,
                          }).value = item;
                        }
                      });
                    } else {
                      // assume object with column keys
                      this._worksheet.eachColumnKey(function(column, key) {
                        if (value[key] !== undefined) {
                          _this.getCellEx({
                            address: colCache.encodeAddress(
                              _this._number,
                              column.number
                            ),
                            row: _this._number,
                            col: column.number,
                          }).value = value[key];
                        }
                      });
                    }
                  }, // returns true if the row includes at least one cell with a value
                },
                {
                  key: 'hasValues',
                  get: function get() {
                    return _.some(this._cells, function(cell) {
                      return cell && cell.type !== Enums.ValueType.Null;
                    });
                  },
                },
                {
                  key: 'cellCount',
                  get: function get() {
                    return this._cells.length;
                  },
                },
                {
                  key: 'actualCellCount',
                  get: function get() {
                    var count = 0;
                    this.eachCell(function() {
                      count++;
                    });
                    return count;
                  }, // get the min and max column number for the non-null cells in this row or null
                },
                {
                  key: 'dimensions',
                  get: function get() {
                    var min = 0;
                    var max = 0;

                    this._cells.forEach(function(cell) {
                      if (cell && cell.type !== Enums.ValueType.Null) {
                        if (!min || min > cell.col) {
                          min = cell.col;
                        }

                        if (max < cell.col) {
                          max = cell.col;
                        }
                      }
                    });

                    return min > 0
                      ? {
                          min: min,
                          max: max,
                        }
                      : null;
                  },
                },
                {
                  key: 'numFmt',
                  get: function get() {
                    return this.style.numFmt;
                  },
                  set: function set(value) {
                    this._applyStyle('numFmt', value);
                  },
                },
                {
                  key: 'font',
                  get: function get() {
                    return this.style.font;
                  },
                  set: function set(value) {
                    this._applyStyle('font', value);
                  },
                },
                {
                  key: 'alignment',
                  get: function get() {
                    return this.style.alignment;
                  },
                  set: function set(value) {
                    this._applyStyle('alignment', value);
                  },
                },
                {
                  key: 'border',
                  get: function get() {
                    return this.style.border;
                  },
                  set: function set(value) {
                    this._applyStyle('border', value);
                  },
                },
                {
                  key: 'fill',
                  get: function get() {
                    return this.style.fill;
                  },
                  set: function set(value) {
                    this._applyStyle('fill', value);
                  },
                },
                {
                  key: 'hidden',
                  get: function get() {
                    return !!this._hidden;
                  },
                  set: function set(value) {
                    this._hidden = value;
                  },
                },
                {
                  key: 'outlineLevel',
                  get: function get() {
                    return this._outlineLevel || 0;
                  },
                  set: function set(value) {
                    this._outlineLevel = value;
                  },
                },
                {
                  key: 'collapsed',
                  get: function get() {
                    return !!(
                      this._outlineLevel &&
                      this._outlineLevel >=
                        this._worksheet.properties.outlineLevelRow
                    );
                  }, // =========================================================================
                },
                {
                  key: 'model',
                  get: function get() {
                    var cells = [];
                    var min = 0;
                    var max = 0;

                    this._cells.forEach(function(cell) {
                      if (cell) {
                        var cellModel = cell.model;

                        if (cellModel) {
                          if (!min || min > cell.col) {
                            min = cell.col;
                          }

                          if (max < cell.col) {
                            max = cell.col;
                          }

                          cells.push(cellModel);
                        }
                      }
                    });

                    return this.height || cells.length
                      ? {
                          cells: cells,
                          number: this.number,
                          min: min,
                          max: max,
                          height: this.height,
                          style: this.style,
                          hidden: this.hidden,
                          outlineLevel: this.outlineLevel,
                          collapsed: this.collapsed,
                        }
                      : null;
                  },
                  set: function set(value) {
                    var _this2 = this;

                    if (value.number !== this._number) {
                      throw new Error('Invalid row number in model');
                    }

                    this._cells = [];
                    var previousAddress;
                    value.cells.forEach(function(cellModel) {
                      switch (cellModel.type) {
                        case Cell.Types.Merge:
                          // special case - don't add this types
                          break;

                        default: {
                          var address;

                          if (cellModel.address) {
                            address = colCache.decodeAddress(cellModel.address);
                          } else if (previousAddress) {
                            // This is a <c> element without an r attribute
                            // Assume that it's the cell for the next column
                            var _previousAddress = previousAddress,
                              row = _previousAddress.row;
                            var col = previousAddress.col + 1;
                            address = {
                              row: row,
                              col: col,
                              address: colCache.encodeAddress(row, col),
                              $col$row: '$'
                                .concat(colCache.n2l(col), '$')
                                .concat(row),
                            };
                          }

                          previousAddress = address;

                          var cell = _this2.getCellEx(address);

                          cell.model = cellModel;
                          break;
                        }
                      }
                    });

                    if (value.height) {
                      this.height = value.height;
                    } else {
                      delete this.height;
                    }

                    this.hidden = value.hidden;
                    this.outlineLevel = value.outlineLevel || 0;
                    this.style =
                      (value.style &&
                        JSON.parse(JSON.stringify(value.style))) ||
                      {};
                  },
                },
              ]);

              return Row;
            })();
        },
        {
          '../utils/under-dash': 22,
          './../utils/col-cache': 17,
          './cell': 4,
          './enums': 8,
        },
      ],
      13: [
        function(require, module, exports) {
          'use strict';

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          var Worksheet = require('./worksheet');

          var DefinedNames = require('./defined-names');

          var XLSX = require('./../xlsx/xlsx');

          var CSV = require('./../csv/csv'); // Workbook requirements
          //  Load and Save from file and stream
          //  Access/Add/Delete individual worksheets
          //  Manage String table, Hyperlink table, etc.
          //  Manage scaffolding for contained objects to write to/read from

          var Workbook =
            /*#__PURE__*/
            (function() {
              function Workbook() {
                _classCallCheck(this, Workbook);

                this.created = new Date();
                this.modified = this.created;
                this.properties = {};
                this._worksheets = [];
                this.views = [];
                this.media = [];
                this._definedNames = new DefinedNames();
              }

              _createClass(Workbook, [
                {
                  key: 'addWorksheet',
                  value: function addWorksheet(name, options) {
                    var id = this.nextId;
                    name = name || 'sheet'.concat(id); // if options is a color, call it tabColor (and signal deprecated message)

                    if (options) {
                      if (typeof options === 'string') {
                        // eslint-disable-next-line no-console
                        console.trace(
                          'tabColor argument is now deprecated. Please use workbook.addWorksheet(name, {properties: { tabColor: { argb: "rbg value" } }'
                        );
                        options = {
                          properties: {
                            tabColor: {
                              argb: options,
                            },
                          },
                        };
                      } else if (
                        options.argb ||
                        options.theme ||
                        options.indexed
                      ) {
                        // eslint-disable-next-line no-console
                        console.trace(
                          'tabColor argument is now deprecated. Please use workbook.addWorksheet(name, {properties: { tabColor: { ... } }'
                        );
                        options = {
                          properties: {
                            tabColor: options,
                          },
                        };
                      }
                    }

                    var lastOrderNo = this._worksheets.reduce(function(
                      acc,
                      ws
                    ) {
                      return (ws && ws.orderNo) > acc ? ws.orderNo : acc;
                    },
                    0);

                    var worksheetOptions = Object.assign({}, options, {
                      id: id,
                      name: name,
                      orderNo: lastOrderNo + 1,
                      workbook: this,
                    });
                    var worksheet = new Worksheet(worksheetOptions);
                    this._worksheets[id] = worksheet;
                    return worksheet;
                  },
                },
                {
                  key: 'removeWorksheetEx',
                  value: function removeWorksheetEx(worksheet) {
                    delete this._worksheets[worksheet.id];
                  },
                },
                {
                  key: 'removeWorksheet',
                  value: function removeWorksheet(id) {
                    var worksheet = this.getWorksheet(id);

                    if (worksheet) {
                      worksheet.destroy();
                    }
                  },
                },
                {
                  key: 'getWorksheet',
                  value: function getWorksheet(id) {
                    if (id === undefined) {
                      return this._worksheets.find(Boolean);
                    }

                    if (typeof id === 'number') {
                      return this._worksheets[id];
                    }

                    if (typeof id === 'string') {
                      return this._worksheets.find(function(worksheet) {
                        return worksheet && worksheet.name === id;
                      });
                    }

                    return undefined;
                  },
                },
                {
                  key: 'eachSheet',
                  value: function eachSheet(iteratee) {
                    this.worksheets.forEach(function(sheet) {
                      iteratee(sheet, sheet.id);
                    });
                  },
                },
                {
                  key: 'clearThemes',
                  value: function clearThemes() {
                    // Note: themes are not an exposed feature, meddle at your peril!
                    this._themes = undefined;
                  },
                },
                {
                  key: 'addImage',
                  value: function addImage(image) {
                    // TODO:  validation?
                    var id = this.media.length;
                    this.media.push(
                      Object.assign({}, image, {
                        type: 'image',
                      })
                    );
                    return id;
                  },
                },
                {
                  key: 'getImage',
                  value: function getImage(id) {
                    return this.media[id];
                  },
                },
                {
                  key: 'xlsx',
                  get: function get() {
                    if (!this._xlsx) this._xlsx = new XLSX(this);
                    return this._xlsx;
                  },
                },
                {
                  key: 'csv',
                  get: function get() {
                    if (!this._csv) this._csv = new CSV(this);
                    return this._csv;
                  },
                },
                {
                  key: 'nextId',
                  get: function get() {
                    // find the next unique spot to add worksheet
                    for (var i = 1; i < this._worksheets.length; i++) {
                      if (!this._worksheets[i]) {
                        return i;
                      }
                    }

                    return this._worksheets.length || 1;
                  },
                },
                {
                  key: 'worksheets',
                  get: function get() {
                    // return a clone of _worksheets
                    return this._worksheets
                      .slice(1)
                      .sort(function(a, b) {
                        return a.orderNo - b.orderNo;
                      })
                      .filter(Boolean);
                  },
                },
                {
                  key: 'definedNames',
                  get: function get() {
                    return this._definedNames;
                  },
                },
                {
                  key: 'model',
                  get: function get() {
                    return {
                      creator: this.creator || 'Unknown',
                      lastModifiedBy: this.lastModifiedBy || 'Unknown',
                      lastPrinted: this.lastPrinted,
                      created: this.created,
                      modified: this.modified,
                      properties: this.properties,
                      worksheets: this.worksheets.map(function(worksheet) {
                        return worksheet.model;
                      }),
                      sheets: this.worksheets
                        .map(function(ws) {
                          return ws.model;
                        })
                        .filter(Boolean),
                      definedNames: this._definedNames.model,
                      views: this.views,
                      company: this.company,
                      manager: this.manager,
                      title: this.title,
                      subject: this.subject,
                      keywords: this.keywords,
                      category: this.category,
                      description: this.description,
                      language: this.language,
                      revision: this.revision,
                      contentStatus: this.contentStatus,
                      themes: this._themes,
                      media: this.media,
                    };
                  },
                  set: function set(value) {
                    var _this = this;

                    this.creator = value.creator;
                    this.lastModifiedBy = value.lastModifiedBy;
                    this.lastPrinted = value.lastPrinted;
                    this.created = value.created;
                    this.modified = value.modified;
                    this.company = value.company;
                    this.manager = value.manager;
                    this.title = value.title;
                    this.subject = value.subject;
                    this.keywords = value.keywords;
                    this.category = value.category;
                    this.description = value.description;
                    this.language = value.language;
                    this.revision = value.revision;
                    this.contentStatus = value.contentStatus;
                    this.properties = value.properties;
                    this._worksheets = [];
                    value.worksheets.forEach(function(worksheetModel) {
                      var id = worksheetModel.id,
                        name = worksheetModel.name,
                        state = worksheetModel.state;
                      var orderNo =
                        value.sheets &&
                        value.sheets.findIndex(function(ws) {
                          return ws.id === id;
                        });
                      var worksheet = (_this._worksheets[id] = new Worksheet({
                        id: id,
                        name: name,
                        orderNo: orderNo,
                        state: state,
                        workbook: _this,
                      }));
                      worksheet.model = worksheetModel;
                    });
                    this._definedNames.model = value.definedNames;
                    this.views = value.views;
                    this._themes = value.themes;
                    this.media = value.media || [];
                  },
                },
              ]);

              return Workbook;
            })();

          module.exports = Workbook;
        },
        {
          './../csv/csv': 2,
          './../xlsx/xlsx': 99,
          './defined-names': 7,
          './worksheet': 14,
        },
      ],
      14: [
        function(require, module, exports) {
          'use strict';

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          var _ = require('../utils/under-dash');

          var colCache = require('./../utils/col-cache');

          var Range = require('./range');

          var Row = require('./row');

          var Column = require('./column');

          var Enums = require('./enums');

          var Image = require('./image');

          var DataValidations = require('./data-validations'); // Worksheet requirements
          //  Operate as sheet inside workbook or standalone
          //  Load and Save from file and stream
          //  Access/Add/Delete individual cells
          //  Manage column widths and row heights

          var Worksheet =
            /*#__PURE__*/
            (function() {
              function Worksheet(options) {
                _classCallCheck(this, Worksheet);

                options = options || {}; // in a workbook, each sheet will have a number

                this.id = options.id;
                this.orderNo = options.orderNo; // and a name

                this.name = options.name || 'Sheet'.concat(this.id); // add a state

                this.state = options.state || 'visible'; // rows allows access organised by row. Sparse array of arrays indexed by row-1, col
                // Note: _rows is zero based. Must subtract 1 to go from cell.row to index

                this._rows = []; // column definitions

                this._columns = null; // column keys (addRow convenience): key ==> this._collumns index

                this._keys = {}; // keep record of all merges

                this._merges = {}; // record of all row and column pageBreaks

                this.rowBreaks = [];
                this._workbook = options.workbook; // for tabColor, default row height, outline levels, etc

                this.properties = Object.assign(
                  {},
                  {
                    defaultRowHeight: 15,
                    dyDescent: 55,
                    outlineLevelCol: 0,
                    outlineLevelRow: 0,
                  },
                  options.properties
                ); // for all things printing

                this.pageSetup = Object.assign(
                  {},
                  {
                    margins: {
                      left: 0.7,
                      right: 0.7,
                      top: 0.75,
                      bottom: 0.75,
                      header: 0.3,
                      footer: 0.3,
                    },
                    orientation: 'portrait',
                    horizontalDpi: 4294967295,
                    verticalDpi: 4294967295,
                    fitToPage: !!(
                      options.pageSetup &&
                      (options.pageSetup.fitToWidth ||
                        options.pageSetup.fitToHeight) &&
                      !options.pageSetup.scale
                    ),
                    pageOrder: 'downThenOver',
                    blackAndWhite: false,
                    draft: false,
                    cellComments: 'None',
                    errors: 'displayed',
                    scale: 100,
                    fitToWidth: 1,
                    fitToHeight: 1,
                    paperSize: undefined,
                    showRowColHeaders: false,
                    showGridLines: false,
                    firstPageNumber: undefined,
                    horizontalCentered: false,
                    verticalCentered: false,
                    rowBreaks: null,
                    colBreaks: null,
                  },
                  options.pageSetup
                );
                this.dataValidations = new DataValidations(); // for freezepanes, split, zoom, gridlines, etc

                this.views = options.views || [];
                this.autoFilter = options.autoFilter || null; // for images, etc

                this._media = [];
              }

              _createClass(Worksheet, [
                {
                  key: 'destroy',
                  // when you're done with this worksheet, call this to remove from workbook
                  value: function destroy() {
                    this._workbook.removeWorksheetEx(this);
                  }, // Get the bounding range of the cells in this worksheet
                },
                {
                  key: 'getColumnKey',
                  value: function getColumnKey(key) {
                    return this._keys[key];
                  },
                },
                {
                  key: 'setColumnKey',
                  value: function setColumnKey(key, value) {
                    this._keys[key] = value;
                  },
                },
                {
                  key: 'deleteColumnKey',
                  value: function deleteColumnKey(key) {
                    delete this._keys[key];
                  },
                },
                {
                  key: 'eachColumnKey',
                  value: function eachColumnKey(f) {
                    _.each(this._keys, f);
                  }, // get a single column by col number. If it doesn't exist, create it and any gaps before it
                },
                {
                  key: 'getColumn',
                  value: function getColumn(c) {
                    if (typeof c === 'string') {
                      // if it matches a key'd column, return that
                      var col = this._keys[c];
                      if (col) return col; // otherwise, assume letter

                      c = colCache.l2n(c);
                    }

                    if (!this._columns) {
                      this._columns = [];
                    }

                    if (c > this._columns.length) {
                      var n = this._columns.length + 1;

                      while (n <= c) {
                        this._columns.push(new Column(this, n++));
                      }
                    }

                    return this._columns[c - 1];
                  },
                },
                {
                  key: 'spliceColumns',
                  value: function spliceColumns(start, count) {
                    var _this = this;

                    // each member of inserts is a column of data.
                    var inserts = Array.prototype.slice.call(arguments, 2);
                    var rows = this._rows;
                    var nRows = rows.length;

                    if (inserts.length > 0) {
                      var _loop = function _loop(i) {
                        var rowArguments = [start, count]; // eslint-disable-next-line no-loop-func

                        inserts.forEach(function(insert) {
                          rowArguments.push(insert[i] || null);
                        });

                        var row = _this.getRow(i + 1); // eslint-disable-next-line prefer-spread

                        row.splice.apply(row, rowArguments);
                      };

                      // must iterate over all rows whether they exist yet or not
                      for (var i = 0; i < nRows; i++) {
                        _loop(i);
                      }
                    } else {
                      // nothing to insert, so just splice all rows
                      this._rows.forEach(function(r) {
                        if (r) {
                          r.splice(start, count);
                        }
                      });
                    } // splice column definitions

                    var nExpand = inserts.length - count;
                    var nKeep = start + count;
                    var nEnd = this._columns.length;

                    if (nExpand < 0) {
                      for (var i = start + inserts.length; i <= nEnd; i++) {
                        this.getColumn(i).defn = this.getColumn(
                          i - nExpand
                        ).defn;
                      }
                    } else if (nExpand > 0) {
                      for (var _i = nEnd; _i >= nKeep; _i--) {
                        this.getColumn(_i + nExpand).defn = this.getColumn(
                          _i
                        ).defn;
                      }
                    }

                    for (var _i2 = start; _i2 < start + inserts.length; _i2++) {
                      this.getColumn(_i2).defn = null;
                    } // account for defined names

                    this.workbook.definedNames.spliceColumns(
                      this.name,
                      start,
                      count,
                      inserts.length
                    );
                  },
                },
                {
                  key: '_commitRow',
                  // =========================================================================
                  // Rows
                  value: function _commitRow() {
                    // nop - allows streaming reader to fill a document
                  },
                },
                {
                  key: 'findRow',
                  // find a row (if exists) by row number
                  value: function findRow(r) {
                    return this._rows[r - 1];
                  },
                },
                {
                  key: 'getRow',
                  // get a row by row number.
                  value: function getRow(r) {
                    var row = this._rows[r - 1];

                    if (!row) {
                      row = this._rows[r - 1] = new Row(this, r);
                    }

                    return row;
                  },
                },
                {
                  key: 'addRow',
                  value: function addRow(value) {
                    var row = this.getRow(this._nextRow);
                    row.values = value;
                    return row;
                  },
                },
                {
                  key: 'addRows',
                  value: function addRows(value) {
                    var _this2 = this;

                    value.forEach(function(row) {
                      _this2.addRow(row);
                    });
                  },
                },
                {
                  key: 'spliceRows',
                  value: function spliceRows(start, count) {
                    var _this3 = this;

                    // same problem as row.splice, except worse.
                    var inserts = Array.prototype.slice.call(arguments, 2);
                    var nKeep = start + count;
                    var nExpand = inserts.length - count;
                    var nEnd = this._rows.length;
                    var i;
                    var rSrc;

                    if (nExpand < 0) {
                      // remove rows
                      for (i = nKeep; i <= nEnd; i++) {
                        rSrc = this._rows[i - 1];

                        if (rSrc) {
                          (function() {
                            var rDst = _this3.getRow(i + nExpand);

                            rDst.values = rSrc.values;
                            rDst.style = rSrc.style; // eslint-disable-next-line no-loop-func

                            rSrc.eachCell(
                              {
                                includeEmpty: true,
                              },
                              function(cell, colNumber) {
                                rDst.getCell(colNumber).style = cell.style;
                              }
                            );
                            _this3._rows[i - 1] = undefined;
                          })();
                        } else {
                          this._rows[i + nExpand - 1] = undefined;
                        }
                      }
                    } else if (nExpand > 0) {
                      // insert new cells
                      for (i = nEnd; i >= nKeep; i--) {
                        rSrc = this._rows[i - 1];

                        if (rSrc) {
                          (function() {
                            var rDst = _this3.getRow(i + nExpand);

                            rDst.values = rSrc.values;
                            rDst.style = rSrc.style; // eslint-disable-next-line no-loop-func

                            rSrc.eachCell(
                              {
                                includeEmpty: true,
                              },
                              function(cell, colNumber) {
                                rDst.getCell(colNumber).style = cell.style;
                              }
                            );
                          })();
                        } else {
                          this._rows[i + nExpand - 1] = undefined;
                        }
                      }
                    } // now copy over the new values

                    for (i = 0; i < inserts.length; i++) {
                      var rDst = this.getRow(start + i);
                      rDst.style = {};
                      rDst.values = inserts[i];
                    } // account for defined names

                    this.workbook.definedNames.spliceRows(
                      this.name,
                      start,
                      count,
                      inserts.length
                    );
                  }, // iterate over every row in the worksheet, including maybe empty rows
                },
                {
                  key: 'eachRow',
                  value: function eachRow(options, iteratee) {
                    if (!iteratee) {
                      iteratee = options;
                      options = undefined;
                    }

                    if (options && options.includeEmpty) {
                      var n = this._rows.length;

                      for (var i = 1; i <= n; i++) {
                        iteratee(this.getRow(i), i);
                      }
                    } else {
                      this._rows.forEach(function(row) {
                        if (row && row.hasValues) {
                          iteratee(row, row.number);
                        }
                      });
                    }
                  }, // return all rows as sparse array
                },
                {
                  key: 'getSheetValues',
                  value: function getSheetValues() {
                    var rows = [];

                    this._rows.forEach(function(row) {
                      if (row) {
                        rows[row.number] = row.values;
                      }
                    });

                    return rows;
                  }, // =========================================================================
                  // Cells
                  // returns the cell at [r,c] or address given by r. If not found, return undefined
                },
                {
                  key: 'findCell',
                  value: function findCell(r, c) {
                    var address = colCache.getAddress(r, c);
                    var row = this._rows[address.row - 1];
                    return row ? row.findCell(address.col) : undefined;
                  }, // return the cell at [r,c] or address given by r. If not found, create a new one.
                },
                {
                  key: 'getCell',
                  value: function getCell(r, c) {
                    var address = colCache.getAddress(r, c);
                    var row = this.getRow(address.row);
                    return row.getCellEx(address);
                  }, // =========================================================================
                  // Merge
                  // convert the range defined by ['tl:br'], [tl,br] or [t,l,b,r] into a single 'merged' cell
                },
                {
                  key: 'mergeCells',
                  value: function mergeCells() {
                    var dimensions = new Range(
                      Array.prototype.slice.call(arguments, 0)
                    ); // convert arguments into Array
                    // check cells aren't already merged

                    _.each(this._merges, function(merge) {
                      if (merge.intersects(dimensions)) {
                        throw new Error('Cannot merge already merged cells');
                      }
                    }); // apply merge

                    var master = this.getCell(dimensions.top, dimensions.left);

                    for (var i = dimensions.top; i <= dimensions.bottom; i++) {
                      for (
                        var j = dimensions.left;
                        j <= dimensions.right;
                        j++
                      ) {
                        // merge all but the master cell
                        if (i > dimensions.top || j > dimensions.left) {
                          this.getCell(i, j).merge(master);
                        }
                      }
                    } // index merge

                    this._merges[master.address] = dimensions;
                  },
                },
                {
                  key: '_unMergeMaster',
                  value: function _unMergeMaster(master) {
                    // master is always top left of a rectangle
                    var merge = this._merges[master.address];

                    if (merge) {
                      for (var i = merge.top; i <= merge.bottom; i++) {
                        for (var j = merge.left; j <= merge.right; j++) {
                          this.getCell(i, j).unmerge();
                        }
                      }

                      delete this._merges[master.address];
                    }
                  },
                },
                {
                  key: 'unMergeCells',
                  // scan the range defined by ['tl:br'], [tl,br] or [t,l,b,r] and if any cell is part of a merge,
                  // un-merge the group. Note this function can affect multiple merges and merge-blocks are
                  // atomic - either they're all merged or all un-merged.
                  value: function unMergeCells() {
                    var dimensions = new Range(
                      Array.prototype.slice.call(arguments, 0)
                    ); // convert arguments into Array
                    // find any cells in that range and unmerge them

                    for (var i = dimensions.top; i <= dimensions.bottom; i++) {
                      for (
                        var j = dimensions.left;
                        j <= dimensions.right;
                        j++
                      ) {
                        var cell = this.findCell(i, j);

                        if (cell) {
                          if (cell.type === Enums.ValueType.Merge) {
                            // this cell merges to another master
                            this._unMergeMaster(cell.master);
                          } else if (this._merges[cell.address]) {
                            // this cell is a master
                            this._unMergeMaster(cell);
                          }
                        }
                      }
                    }
                  }, // ===========================================================================
                  // Shared Formula
                },
                {
                  key: 'fillFormula',
                  value: function fillFormula(range, formula, results) {
                    // Define formula for top-left cell and share to rest
                    var decoded = colCache.decode(range);
                    var top = decoded.top,
                      left = decoded.left,
                      bottom = decoded.bottom,
                      right = decoded.right;
                    var width = right - left + 1;
                    var masterAddress = colCache.encodeAddress(top, left); // work out result accessor

                    var getResult;

                    if (typeof results === 'function') {
                      getResult = results;
                    } else if (Array.isArray(results)) {
                      if (Array.isArray(results[0])) {
                        getResult = function getResult(row, col) {
                          return results[row - top][col - left];
                        };
                      } else {
                        getResult = function getResult(row, col) {
                          return results[(row - top) * width + (col - left)];
                        };
                      }
                    } else {
                      getResult = function getResult() {
                        return undefined;
                      };
                    }

                    var first = true;

                    for (var r = top; r <= bottom; r++) {
                      for (var c = left; c <= right; c++) {
                        if (first) {
                          this.getCell(r, c).value = {
                            formula: formula,
                            result: getResult(r, c),
                          };
                          first = false;
                        } else {
                          this.getCell(r, c).value = {
                            sharedFormula: masterAddress,
                            result: getResult(r, c),
                          };
                        }
                      }
                    }
                  }, // =========================================================================
                  // Images
                },
                {
                  key: 'addImage',
                  value: function addImage(imageId, range) {
                    var model = {
                      type: 'image',
                      imageId: imageId,
                      range: range,
                    };

                    this._media.push(new Image(this, model));
                  },
                },
                {
                  key: 'getImages',
                  value: function getImages() {
                    return this._media.filter(function(m) {
                      return m.type === 'image';
                    });
                  },
                },
                {
                  key: 'addBackgroundImage',
                  value: function addBackgroundImage(imageId) {
                    var model = {
                      type: 'background',
                      imageId: imageId,
                    };

                    this._media.push(new Image(this, model));
                  },
                },
                {
                  key: 'getBackgroundImageId',
                  value: function getBackgroundImageId() {
                    var image = this._media.find(function(m) {
                      return m.type === 'background';
                    });

                    return image && image.imageId;
                  }, // ===========================================================================
                  // Deprecated
                },
                {
                  key: '_parseRows',
                  value: function _parseRows(model) {
                    var _this4 = this;

                    this._rows = [];
                    model.rows.forEach(function(rowModel) {
                      var row = new Row(_this4, rowModel.number);
                      _this4._rows[row.number - 1] = row;
                      row.model = rowModel;
                    });
                  },
                },
                {
                  key: '_parseMergeCells',
                  value: function _parseMergeCells(model) {
                    var _this5 = this;

                    _.each(model.mergeCells, function(merge) {
                      _this5.mergeCells(merge);
                    });
                  },
                },
                {
                  key: 'workbook',
                  get: function get() {
                    return this._workbook;
                  },
                },
                {
                  key: 'dimensions',
                  get: function get() {
                    var dimensions = new Range();

                    this._rows.forEach(function(row) {
                      if (row) {
                        var rowDims = row.dimensions;

                        if (rowDims) {
                          dimensions.expand(
                            row.number,
                            rowDims.min,
                            row.number,
                            rowDims.max
                          );
                        }
                      }
                    });

                    return dimensions;
                  }, // =========================================================================
                  // Columns
                  // get the current columns array.
                },
                {
                  key: 'columns',
                  get: function get() {
                    return this._columns;
                  }, // set the columns from an array of column definitions.
                  // Note: any headers defined will overwrite existing values.
                  set: function set(value) {
                    var _this6 = this;

                    // calculate max header row count
                    this._headerRowCount = value.reduce(function(pv, cv) {
                      var headerCount =
                        (cv.header && 1) ||
                        (cv.headers && cv.headers.length) ||
                        0;
                      return Math.max(pv, headerCount);
                    }, 0); // construct Column objects

                    var count = 1;
                    var columns = (this._columns = []);
                    value.forEach(function(defn) {
                      var column = new Column(_this6, count++, false);
                      columns.push(column);
                      column.defn = defn;
                    });
                  },
                },
                {
                  key: 'columnCount',
                  get: function get() {
                    var maxCount = 0;
                    this.eachRow(function(row) {
                      maxCount = Math.max(maxCount, row.cellCount);
                    });
                    return maxCount;
                  },
                },
                {
                  key: 'actualColumnCount',
                  get: function get() {
                    // performance nightmare - for each row, counts all the columns used
                    var counts = [];
                    var count = 0;
                    this.eachRow(function(row) {
                      row.eachCell(function(_ref) {
                        var col = _ref.col;

                        if (!counts[col]) {
                          counts[col] = true;
                          count++;
                        }
                      });
                    });
                    return count;
                  },
                },
                {
                  key: '_lastRowNumber',
                  get: function get() {
                    // need to cope with results of splice
                    var rows = this._rows;
                    var n = rows.length;

                    while (n > 0 && rows[n - 1] === undefined) {
                      n--;
                    }

                    return n;
                  },
                },
                {
                  key: '_nextRow',
                  get: function get() {
                    return this._lastRowNumber + 1;
                  },
                },
                {
                  key: 'lastRow',
                  get: function get() {
                    if (this._rows.length) {
                      return this._rows[this._rows.length - 1];
                    }

                    return undefined;
                  },
                },
                {
                  key: 'rowCount',
                  get: function get() {
                    return this._lastRowNumber;
                  },
                },
                {
                  key: 'actualRowCount',
                  get: function get() {
                    // counts actual rows that have actual data
                    var count = 0;
                    this.eachRow(function() {
                      count++;
                    });
                    return count;
                  },
                },
                {
                  key: 'hasMerges',
                  get: function get() {
                    // return true if this._merges has a merge object
                    return _.some(this._merges, Boolean);
                  },
                },
                {
                  key: 'tabColor',
                  get: function get() {
                    // eslint-disable-next-line no-console
                    console.trace(
                      'worksheet.tabColor property is now deprecated. Please use worksheet.properties.tabColor'
                    );
                    return this.properties.tabColor;
                  },
                  set: function set(value) {
                    // eslint-disable-next-line no-console
                    console.trace(
                      'worksheet.tabColor property is now deprecated. Please use worksheet.properties.tabColor'
                    );
                    this.properties.tabColor = value;
                  }, // ===========================================================================
                  // Model
                },
                {
                  key: 'model',
                  get: function get() {
                    var model = {
                      id: this.id,
                      name: this.name,
                      dataValidations: this.dataValidations.model,
                      properties: this.properties,
                      state: this.state,
                      pageSetup: this.pageSetup,
                      rowBreaks: this.rowBreaks,
                      views: this.views,
                      autoFilter: this.autoFilter,
                      media: this._media.map(function(medium) {
                        return medium.model;
                      }),
                    }; // =================================================
                    // columns

                    model.cols = Column.toModel(this.columns); // ==========================================================
                    // Rows

                    var rows = (model.rows = []);
                    var dimensions = (model.dimensions = new Range());

                    this._rows.forEach(function(row) {
                      var rowModel = row && row.model;

                      if (rowModel) {
                        dimensions.expand(
                          rowModel.number,
                          rowModel.min,
                          rowModel.number,
                          rowModel.max
                        );
                        rows.push(rowModel);
                      }
                    }); // ==========================================================
                    // Merges

                    model.merges = [];

                    _.each(this._merges, function(merge) {
                      model.merges.push(merge.range);
                    });

                    return model;
                  },
                  set: function set(value) {
                    var _this7 = this;

                    this.name = value.name;
                    this._columns = Column.fromModel(this, value.cols);

                    this._parseRows(value);

                    this._parseMergeCells(value);

                    this.dataValidations = new DataValidations(
                      value.dataValidations
                    );
                    this.properties = value.properties;
                    this.pageSetup = value.pageSetup;
                    this.views = value.views;
                    this.autoFilter = value.autoFilter;
                    this._media = value.media.map(function(medium) {
                      return new Image(_this7, medium);
                    });
                  },
                },
              ]);

              return Worksheet;
            })();

          module.exports = Worksheet;
        },
        {
          '../utils/under-dash': 22,
          './../utils/col-cache': 17,
          './column': 5,
          './data-validations': 6,
          './enums': 8,
          './image': 9,
          './range': 11,
          './row': 12,
        },
      ],
      15: [
        function(require, module, exports) {
          'use strict';

          // for the benefit of browserify, include browser friendly promise
          var setConfigValue = require('./config/set-value');

          setConfigValue(
            'promise',
            require('promish/dist/promish-node'),
            false
          );
          var ExcelJS = {
            Workbook: require('./doc/workbook'),
          }; // Object.assign mono-fill

          var Enums = require('./doc/enums');

          Object.keys(Enums).forEach(function(key) {
            ExcelJS[key] = Enums[key];
          });
          module.exports = ExcelJS;
        },
        {
          './config/set-value': 1,
          './doc/enums': 8,
          './doc/workbook': 13,
          'promish/dist/promish-node': 189,
        },
      ],
      16: [
        function(require, module, exports) {
          'use strict';

          var _ = require('./under-dash');

          var colCache = require('./col-cache');

          var CellMatrix = function CellMatrix(template) {
            this.template = template;
            this.sheets = {};
          };

          CellMatrix.prototype = {
            addCell: function addCell(addressStr) {
              this.addCellEx(colCache.decodeEx(addressStr));
            },
            getCell: function getCell(addressStr) {
              return this.findCellEx(colCache.decodeEx(addressStr), true);
            },
            findCell: function findCell(addressStr) {
              return this.findCellEx(colCache.decodeEx(addressStr), false);
            },
            findCellAt: function findCellAt(sheetName, rowNumber, colNumber) {
              var sheet = this.sheets[sheetName];
              var row = sheet && sheet[rowNumber];
              return row && row[colNumber];
            },
            addCellEx: function addCellEx(address) {
              if (address.top) {
                for (var row = address.top; row <= address.bottom; row++) {
                  for (var col = address.left; col <= address.right; col++) {
                    this.getCellAt(address.sheetName, row, col);
                  }
                }
              } else {
                this.findCellEx(address, true);
              }
            },
            getCellEx: function getCellEx(address) {
              return this.findCellEx(address, true);
            },
            findCellEx: function findCellEx(address, create) {
              var sheet = this.findSheet(address, create);
              var row = this.findSheetRow(sheet, address, create);
              return this.findRowCell(row, address, create);
            },
            getCellAt: function getCellAt(sheetName, rowNumber, colNumber) {
              var sheet =
                this.sheets[sheetName] || (this.sheets[sheetName] = []);
              var row = sheet[rowNumber] || (sheet[rowNumber] = []);
              var cell =
                row[colNumber] ||
                (row[colNumber] = {
                  sheetName: sheetName,
                  address: colCache.n2l(colNumber) + rowNumber,
                  row: rowNumber,
                  col: colNumber,
                });
              return cell;
            },
            removeCellEx: function removeCellEx(address) {
              var sheet = this.findSheet(address);

              if (!sheet) {
                return;
              }

              var row = this.findSheetRow(sheet, address);

              if (!row) {
                return;
              }

              delete row[address.col];
            },
            forEachInSheet: function forEachInSheet(sheetName, callback) {
              var sheet = this.sheets[sheetName];

              if (sheet) {
                sheet.forEach(function(row, rowNumber) {
                  if (row) {
                    row.forEach(function(cell, colNumber) {
                      if (cell) {
                        callback(cell, rowNumber, colNumber);
                      }
                    });
                  }
                });
              }
            },
            forEach: function forEach(callback) {
              var _this = this;

              _.each(this.sheets, function(sheet, sheetName) {
                _this.forEachInSheet(sheetName, callback);
              });
            },
            map: function map(callback) {
              var results = [];
              this.forEach(function(cell) {
                results.push(callback(cell));
              });
              return results;
            },
            findSheet: function findSheet(address, create) {
              var name = address.sheetName;

              if (this.sheets[name]) {
                return this.sheets[name];
              }

              if (create) {
                return (this.sheets[name] = []);
              }

              return undefined;
            },
            findSheetRow: function findSheetRow(sheet, address, create) {
              var row = address.row;

              if (sheet && sheet[row]) {
                return sheet[row];
              }

              if (create) {
                return (sheet[row] = []);
              }

              return undefined;
            },
            findRowCell: function findRowCell(row, address, create) {
              var col = address.col;

              if (row && row[col]) {
                return row[col];
              }

              if (create) {
                return (row[col] = this.template
                  ? Object.assign(
                      address,
                      JSON.parse(JSON.stringify(this.template))
                    )
                  : address);
              }

              return undefined;
            },
            spliceRows: function spliceRows(
              sheetName,
              start,
              numDelete,
              numInsert
            ) {
              var sheet = this.sheets[sheetName];

              if (sheet) {
                var inserts = [];

                for (var i = 0; i < numInsert; i++) {
                  inserts.push([]);
                }

                sheet.splice.apply(sheet, [start, numDelete].concat(inserts));
              }
            },
            spliceColumns: function spliceColumns(
              sheetName,
              start,
              numDelete,
              numInsert
            ) {
              var sheet = this.sheets[sheetName];

              if (sheet) {
                var inserts = [];

                for (var i = 0; i < numInsert; i++) {
                  inserts.push(null);
                }

                _.each(sheet, function(row) {
                  row.splice.apply(row, [start, numDelete].concat(inserts));
                });
              }
            },
          };
          module.exports = CellMatrix;
        },
        { './col-cache': 17, './under-dash': 22 },
      ],
      17: [
        function(require, module, exports) {
          'use strict'; // =========================================================================
          // Column Letter to Number conversion

          var colCache = {
            _dictionary: [
              'A',
              'B',
              'C',
              'D',
              'E',
              'F',
              'G',
              'H',
              'I',
              'J',
              'K',
              'L',
              'M',
              'N',
              'O',
              'P',
              'Q',
              'R',
              'S',
              'T',
              'U',
              'V',
              'W',
              'X',
              'Y',
              'Z',
            ],
            _l2n: {},
            _n2l: [],
            _level: function _level(n) {
              if (n <= 26) {
                return 1;
              }

              if (n <= 26 * 26) {
                return 2;
              }

              return 3;
            },
            _fill: function _fill(level) {
              var c;
              var v;
              var l1;
              var l2;
              var l3;
              var n = 1;

              if (level >= 1) {
                while (n <= 26) {
                  c = this._dictionary[n - 1];
                  this._n2l[n] = c;
                  this._l2n[c] = n;
                  n++;
                }
              }

              if (level >= 2) {
                while (n <= 26 + 26 * 26) {
                  v = n - (26 + 1);
                  l1 = v % 26;
                  l2 = Math.floor(v / 26);
                  c = this._dictionary[l2] + this._dictionary[l1];
                  this._n2l[n] = c;
                  this._l2n[c] = n;
                  n++;
                }
              }

              if (level >= 3) {
                while (n <= 16384) {
                  v = n - (26 * 26 + 26 + 1);
                  l1 = v % 26;
                  l2 = Math.floor(v / 26) % 26;
                  l3 = Math.floor(v / (26 * 26));
                  c =
                    this._dictionary[l3] +
                    this._dictionary[l2] +
                    this._dictionary[l1];
                  this._n2l[n] = c;
                  this._l2n[c] = n;
                  n++;
                }
              }
            },
            l2n: function l2n(l) {
              if (!this._l2n[l]) {
                this._fill(l.length);
              }

              if (!this._l2n[l]) {
                throw new Error(
                  'Out of bounds. Invalid column letter: '.concat(l)
                );
              }

              return this._l2n[l];
            },
            n2l: function n2l(n) {
              if (n < 1 || n > 16384) {
                throw new Error(
                  ''.concat(
                    n,
                    ' is out of bounds. Excel supports columns from 1 to 16384'
                  )
                );
              }

              if (!this._n2l[n]) {
                this._fill(this._level(n));
              }

              return this._n2l[n];
            },
            // =========================================================================
            // Address processing
            _hash: {},
            // check if value looks like an address
            validateAddress: function validateAddress(value) {
              if (!value.match(/^[A-Z]+\d+$/)) {
                throw new Error('Invalid Address: '.concat(value));
              }

              return true;
            },
            // convert address string into structure
            decodeAddress: function decodeAddress(value) {
              var addr = this._hash[value];

              if (addr) {
                return addr;
              }

              var matchCol = value.match(/[A-Z]+/);
              var col;
              var colNumber;

              if (matchCol) {
                col = matchCol[0];
                colNumber = this.l2n(col);
              }

              var matchRow = value.match(/\d+/);
              var row;
              var rowNumber;

              if (matchRow) {
                row = matchRow[0];
                rowNumber = parseInt(row, 10);
              } // in case $row$col

              value = (col || '') + (row || '');
              var address = {
                address: value,
                col: colNumber,
                row: rowNumber,
                $col$row: '$'.concat(col || '', '$').concat(row || ''),
              }; // mem fix - cache only the tl 100x100 square

              if (colNumber <= 100 && rowNumber <= 100) {
                this._hash[value] = address;
                this._hash[address.$col$row] = address;
              }

              return address;
            },
            // convert r,c into structure (if only 1 arg, assume r is address string)
            getAddress: function getAddress(r, c) {
              if (c) {
                var address = this.n2l(c) + r;
                return this.decodeAddress(address);
              }

              return this.decodeAddress(r);
            },
            // convert [address], [tl:br] into address structures
            decode: function decode(value) {
              var parts = value.split(':');

              if (parts.length === 2) {
                var tl = this.decodeAddress(parts[0]);
                var br = this.decodeAddress(parts[1]);
                var result = {
                  top: Math.min(tl.row, br.row),
                  left: Math.min(tl.col, br.col),
                  bottom: Math.max(tl.row, br.row),
                  right: Math.max(tl.col, br.col),
                }; // reconstruct tl, br and dimensions

                result.tl = this.n2l(result.left) + result.top;
                result.br = this.n2l(result.right) + result.bottom;
                result.dimensions = ''.concat(result.tl, ':').concat(result.br);
                return result;
              }

              return this.decodeAddress(value);
            },
            // convert [sheetName!][$]col[$]row[[$]col[$]row] into address or range structures
            decodeEx: function decodeEx(value) {
              var groups = value.match(
                /(?:(?:(?:'((?:[^']|'')*)')|([^'^ !]*))!)?(.*)/
              );
              var sheetName = groups[1] || groups[2]; // Qouted and unqouted groups

              var reference = groups[3]; // Remaining address

              var parts = reference.split(':');

              if (parts.length > 1) {
                var tl = this.decodeAddress(parts[0]);
                var br = this.decodeAddress(parts[1]);
                var top = Math.min(tl.row, br.row);
                var left = Math.min(tl.col, br.col);
                var bottom = Math.max(tl.row, br.row);
                var right = Math.max(tl.col, br.col);
                tl = this.n2l(left) + top;
                br = this.n2l(right) + bottom;
                return {
                  top: top,
                  left: left,
                  bottom: bottom,
                  right: right,
                  sheetName: sheetName,
                  tl: {
                    address: tl,
                    col: left,
                    row: top,
                    $col$row: '$'.concat(this.n2l(left), '$').concat(top),
                    sheetName: sheetName,
                  },
                  br: {
                    address: br,
                    col: right,
                    row: bottom,
                    $col$row: '$'.concat(this.n2l(right), '$').concat(bottom),
                    sheetName: sheetName,
                  },
                  dimensions: ''.concat(tl, ':').concat(br),
                };
              }

              if (reference.startsWith('#')) {
                return sheetName
                  ? {
                      sheetName: sheetName,
                      error: reference,
                    }
                  : {
                      error: reference,
                    };
              }

              var address = this.decodeAddress(reference);
              return sheetName
                ? Object.assign(
                    {
                      sheetName: sheetName,
                    },
                    address
                  )
                : address;
            },
            // convert row,col into address string
            encodeAddress: function encodeAddress(row, col) {
              return colCache.n2l(col) + row;
            },
            // convert row,col into string address or t,l,b,r into range
            encode: function encode() {
              switch (arguments.length) {
                case 2:
                  return colCache.encodeAddress(arguments[0], arguments[1]);

                case 4:
                  return ''
                    .concat(
                      colCache.encodeAddress(arguments[0], arguments[1]),
                      ':'
                    )
                    .concat(colCache.encodeAddress(arguments[2], arguments[3]));

                default:
                  throw new Error('Can only encode with 2 or 4 arguments');
              }
            },
          };
          module.exports = colCache;
        },
        {},
      ],
      18: [
        function(require, module, exports) {
          'use strict';

          module.exports = {
            Promise: typeof Promise !== 'undefined' ? Promise : null,
          };
        },
        {},
      ],
      19: [
        function(require, module, exports) {
          'use strict';

          var colCache = require('./col-cache'); // const cellRefRegex = /(([a-z_\-0-9]*)!)?[$]?([a-z]+)[$]?([1-9][0-9]*)/i;

          var replacementCandidateRx = /(([a-z_\-0-9]*)!)?([a-z0-9_$]{2,})([(])?/gi;
          var CRrx = /^([$])?([a-z]+)([$])?([1-9][0-9]*)$/i;

          var slideFormula = function slideFormula(formula, fromCell, toCell) {
            var offset = colCache.decode(fromCell);
            var to = colCache.decode(toCell);
            return formula.replace(replacementCandidateRx, function(
              refMatch,
              sheet,
              sheetMaybe,
              addrPart,
              trailingParen
            ) {
              if (trailingParen) {
                return refMatch;
              }

              var match = CRrx.exec(addrPart);

              if (match) {
                var colDollar = match[1];
                var colStr = match[2].toUpperCase();
                var rowDollar = match[3];
                var rowStr = match[4];

                if (
                  colStr.length > 3 ||
                  (colStr.length === 3 && colStr > 'XFD')
                ) {
                  // > XFD is the highest col number in excel 2007 and beyond, so this is a named range
                  return refMatch;
                }

                var col = colCache.l2n(colStr);
                var row = parseInt(rowStr, 10);

                if (!colDollar) {
                  col += to.col - offset.col;
                }

                if (!rowDollar) {
                  row += to.row - offset.row;
                }

                var res =
                  (sheet || '') +
                  (colDollar || '') +
                  colCache.n2l(col) +
                  (rowDollar || '') +
                  row;
                return res;
              }

              return refMatch;
            });
          };

          module.exports = {
            slideFormula: slideFormula,
          };
        },
        { './col-cache': 17 },
      ],
      20: [
        function(require, module, exports) {
          (function(process, Buffer) {
            'use strict';

            var Stream = require('stream');

            var PromiseLib = require('./promise');

            var utils = require('./utils');

            var StringBuf = require('./string-buf'); // =============================================================================
            // data chunks - encapsulating incoming data

            var StringChunk = function StringChunk(data, encoding) {
              this._data = data;
              this._encoding = encoding;
            };

            StringChunk.prototype = {
              get length() {
                return this.toBuffer().length;
              },

              // copy to target buffer
              copy: function copy(target, targetOffset, offset, length) {
                return this.toBuffer().copy(
                  target,
                  targetOffset,
                  offset,
                  length
                );
              },
              toBuffer: function toBuffer() {
                if (!this._buffer) {
                  this._buffer = new Buffer(this._data, this._encoding);
                }

                return this._buffer;
              },
            };

            var StringBufChunk = function StringBufChunk(data) {
              this._data = data;
            };

            StringBufChunk.prototype = {
              get length() {
                return this._data.length;
              },

              // copy to target buffer
              copy: function copy(target, targetOffset, offset, length) {
                // eslint-disable-next-line no-underscore-dangle
                return this._data._buf.copy(
                  target,
                  targetOffset,
                  offset,
                  length
                );
              },
              toBuffer: function toBuffer() {
                return this._data.toBuffer();
              },
            };

            var BufferChunk = function BufferChunk(data) {
              this._data = data;
            };

            BufferChunk.prototype = {
              get length() {
                return this._data.length;
              },

              // copy to target buffer
              copy: function copy(target, targetOffset, offset, length) {
                this._data.copy(target, targetOffset, offset, length);
              },
              toBuffer: function toBuffer() {
                return this._data;
              },
            }; // =============================================================================
            // ReadWriteBuf - a single buffer supporting simple read-write

            var ReadWriteBuf = function ReadWriteBuf(size) {
              this.size = size; // the buffer

              this.buffer = new Buffer(size); // read index

              this.iRead = 0; // write index

              this.iWrite = 0;
            };

            ReadWriteBuf.prototype = {
              toBuffer: function toBuffer() {
                if (this.iRead === 0 && this.iWrite === this.size) {
                  return this.buffer;
                }

                var buf = new Buffer(this.iWrite - this.iRead);
                this.buffer.copy(buf, 0, this.iRead, this.iWrite);
                return buf;
              },

              get length() {
                return this.iWrite - this.iRead;
              },

              get eod() {
                return this.iRead === this.iWrite;
              },

              get full() {
                return this.iWrite === this.size;
              },

              read: function read(size) {
                var buf; // read size bytes from buffer and return buffer

                if (size === 0) {
                  // special case - return null if no data requested
                  return null;
                }

                if (size === undefined || size >= this.length) {
                  // if no size specified or size is at least what we have then return all of the bytes
                  buf = this.toBuffer();
                  this.iRead = this.iWrite;
                  return buf;
                } // otherwise return a chunk

                buf = new Buffer(size);
                this.buffer.copy(buf, 0, this.iRead, size);
                this.iRead += size;
                return buf;
              },
              write: function write(chunk, offset, length) {
                // write as many bytes from data from optional source offset
                // and return number of bytes written
                var size = Math.min(length, this.size - this.iWrite);
                chunk.copy(this.buffer, this.iWrite, offset, offset + size);
                this.iWrite += size;
                return size;
              },
            }; // =============================================================================
            // StreamBuf - a multi-purpose read-write stream
            //  As MemBuf - write as much data as you like. Then call toBuffer() to consolidate
            //  As StreamHub - pipe to multiple writables
            //  As readable stream - feed data into the writable part and have some other code read from it.

            var StreamBuf = (module.exports = function(options) {
              options = options || {};
              this.bufSize = options.bufSize || 1024 * 1024;
              this.buffers = []; // batch mode fills a buffer completely before passing the data on
              // to pipes or 'readable' event listeners

              this.batch = options.batch || false;
              this.corked = false; // where in the current writable buffer we're up to

              this.inPos = 0; // where in the current readable buffer we've read up to

              this.outPos = 0; // consuming pipe streams go here

              this.pipes = []; // controls emit('data')

              this.paused = false;
              this.encoding = null;
            });

            utils.inherits(StreamBuf, Stream.Duplex, {
              toBuffer: function toBuffer() {
                switch (this.buffers.length) {
                  case 0:
                    return null;

                  case 1:
                    return this.buffers[0].toBuffer();

                  default:
                    return Buffer.concat(
                      this.buffers.map(function(rwBuf) {
                        return rwBuf.toBuffer();
                      })
                    );
                }
              },
              // writable
              // event drain - if write returns false (which it won't), indicates when safe to write again.
              // finish - end() has been called
              // pipe(src) - pipe() has been called on readable
              // unpipe(src) - unpipe() has been called on readable
              // error - duh
              _getWritableBuffer: function _getWritableBuffer() {
                if (this.buffers.length) {
                  var last = this.buffers[this.buffers.length - 1];

                  if (!last.full) {
                    return last;
                  }
                }

                var buf = new ReadWriteBuf(this.bufSize);
                this.buffers.push(buf);
                return buf;
              },
              _pipe: function _pipe(chunk) {
                var write = function write(pipe) {
                  return new PromiseLib.Promise(function(resolve) {
                    pipe.write(chunk.toBuffer(), function() {
                      resolve();
                    });
                  });
                };

                var promises = this.pipes.map(write);
                return promises.length
                  ? PromiseLib.Promise.all(promises).then(utils.nop)
                  : PromiseLib.Promise.resolve();
              },
              _writeToBuffers: function _writeToBuffers(chunk) {
                var inPos = 0;
                var inLen = chunk.length;

                while (inPos < inLen) {
                  // find writable buffer
                  var buffer = this._getWritableBuffer(); // write some data

                  inPos += buffer.write(chunk, inPos, inLen - inPos);
                }
              },
              write: function write(data, encoding, callback) {
                if (encoding instanceof Function) {
                  callback = encoding;
                  encoding = 'utf8';
                }

                callback = callback || utils.nop; // encapsulate data into a chunk

                var chunk;

                if (data instanceof StringBuf) {
                  chunk = new StringBufChunk(data);
                } else if (data instanceof Buffer) {
                  chunk = new BufferChunk(data);
                } else {
                  // assume string
                  chunk = new StringChunk(data, encoding);
                } // now, do something with the chunk

                if (this.pipes.length) {
                  if (this.batch) {
                    this._writeToBuffers(chunk);

                    while (!this.corked && this.buffers.length > 1) {
                      this._pipe(this.buffers.shift());
                    }
                  } else if (!this.corked) {
                    this._pipe(chunk).then(callback);
                  } else {
                    this._writeToBuffers(chunk);

                    process.nextTick(callback);
                  }
                } else {
                  if (!this.paused) {
                    this.emit('data', chunk.toBuffer());
                  }

                  this._writeToBuffers(chunk);

                  this.emit('readable');
                }

                return true;
              },
              cork: function cork() {
                this.corked = true;
              },
              _flush: function _flush() /* destination */
              {
                // if we have comsumers...
                if (this.pipes.length) {
                  // and there's stuff not written
                  while (this.buffers.length) {
                    this._pipe(this.buffers.shift());
                  }
                }
              },
              uncork: function uncork() {
                this.corked = false;

                this._flush();
              },
              end: function end(chunk, encoding, callback) {
                var _this = this;

                var writeComplete = function writeComplete(error) {
                  if (error) {
                    callback(error);
                  } else {
                    _this._flush();

                    _this.pipes.forEach(function(pipe) {
                      pipe.end();
                    });

                    _this.emit('finish');
                  }
                };

                if (chunk) {
                  this.write(chunk, encoding, writeComplete);
                } else {
                  writeComplete();
                }
              },
              // readable
              // event readable - some data is now available
              // event data - switch to flowing mode - feeds chunks to handler
              // event end - no more data
              // event close - optional, indicates upstream close
              // event error - duh
              read: function read(size) {
                var buffers; // read min(buffer, size || infinity)

                if (size) {
                  buffers = [];

                  while (size && this.buffers.length && !this.buffers[0].eod) {
                    var first = this.buffers[0];
                    var buffer = first.read(size);
                    size -= buffer.length;
                    buffers.push(buffer);

                    if (first.eod && first.full) {
                      this.buffers.shift();
                    }
                  }

                  return Buffer.concat(buffers);
                }

                buffers = this.buffers
                  .map(function(buf) {
                    return buf.toBuffer();
                  })
                  .filter(Boolean);
                this.buffers = [];
                return Buffer.concat(buffers);
              },
              setEncoding: function setEncoding(encoding) {
                // causes stream.read or stream.on('data) to return strings of encoding instead of Buffer objects
                this.encoding = encoding;
              },
              pause: function pause() {
                this.paused = true;
              },
              resume: function resume() {
                this.paused = false;
              },
              isPaused: function isPaused() {
                return !!this.paused;
              },
              pipe: function pipe(destination) {
                // add destination to pipe list & write current buffer
                this.pipes.push(destination);

                if (!this.paused && this.buffers.length) {
                  this.end();
                }
              },
              unpipe: function unpipe(destination) {
                // remove destination from pipe list
                this.pipes = this.pipes.filter(function(pipe) {
                  return pipe !== destination;
                });
              },
              unshift: function unshift() /* chunk */
              {
                // some numpty has read some data that's not for them and they want to put it back!
                // Might implement this some day
                throw new Error('Not Implemented');
              },
              wrap: function wrap() /* stream */
              {
                // not implemented
                throw new Error('Not Implemented');
              },
            });
          }.call(this, require('_process'), require('buffer').Buffer));
        },
        {
          './promise': 18,
          './string-buf': 21,
          './utils': 23,
          _process: 187,
          buffer: 106,
          stream: 207,
        },
      ],
      21: [
        function(require, module, exports) {
          (function(Buffer) {
            'use strict'; // StringBuf - a way to keep string memory operations to a minimum
            // while building the strings for the xml files

            var StringBuf = (module.exports = function(options) {
              this._buf = new Buffer((options && options.size) || 16384);
              this._encoding = (options && options.encoding) || 'utf8'; // where in the buffer we are at

              this._inPos = 0; // for use by toBuffer()

              this._buffer = undefined;
            });

            StringBuf.prototype = {
              get length() {
                return this._inPos;
              },

              get capacity() {
                return this._buf.length;
              },

              get buffer() {
                return this._buf;
              },

              toBuffer: function toBuffer() {
                // return the current data as a single enclosing buffer
                if (!this._buffer) {
                  this._buffer = new Buffer(this.length);

                  this._buf.copy(this._buffer, 0, 0, this.length);
                }

                return this._buffer;
              },
              reset: function reset(position) {
                position = position || 0;
                this._buffer = undefined;
                this._inPos = position;
              },
              _grow: function _grow(min) {
                var size = this._buf.length * 2;

                while (size < min) {
                  size *= 2;
                }

                var buf = new Buffer(size);

                this._buf.copy(buf, 0);

                this._buf = buf;
              },
              addText: function addText(text) {
                this._buffer = undefined;

                var inPos =
                  this._inPos +
                  this._buf.write(text, this._inPos, this._encoding); // if we've hit (or nearing capacity), grow the buf

                while (inPos >= this._buf.length - 4) {
                  this._grow(this._inPos + text.length); // keep trying to write until we've completely written the text

                  inPos =
                    this._inPos +
                    this._buf.write(text, this._inPos, this._encoding);
                }

                this._inPos = inPos;
              },
              addStringBuf: function addStringBuf(inBuf) {
                if (inBuf.length) {
                  this._buffer = undefined;

                  if (this.length + inBuf.length > this.capacity) {
                    this._grow(this.length + inBuf.length);
                  } // eslint-disable-next-line no-underscore-dangle

                  inBuf._buf.copy(this._buf, this._inPos, 0, inBuf.length);

                  this._inPos += inBuf.length;
                }
              },
            };
          }.call(this, require('buffer').Buffer));
        },
        { buffer: 106 },
      ],
      22: [
        function(require, module, exports) {
          'use strict';

          function _typeof(obj) {
            if (
              typeof Symbol === 'function' &&
              typeof Symbol.iterator === 'symbol'
            ) {
              _typeof = function _typeof(obj) {
                return typeof obj;
              };
            } else {
              _typeof = function _typeof(obj) {
                return obj &&
                  typeof Symbol === 'function' &&
                  obj.constructor === Symbol &&
                  obj !== Symbol.prototype
                  ? 'symbol'
                  : typeof obj;
              };
            }
            return _typeof(obj);
          }

          var _ = {
            each: function each(obj, cb) {
              if (obj) {
                if (Array.isArray(obj)) {
                  obj.forEach(cb);
                } else {
                  Object.keys(obj).forEach(function(key) {
                    cb(obj[key], key);
                  });
                }
              }
            },
            some: function some(obj, cb) {
              if (obj) {
                if (Array.isArray(obj)) {
                  return obj.some(cb);
                }

                return Object.keys(obj).some(function(key) {
                  return cb(obj[key], key);
                });
              }

              return false;
            },
            every: function every(obj, cb) {
              if (obj) {
                if (Array.isArray(obj)) {
                  return obj.every(cb);
                }

                return Object.keys(obj).every(function(key) {
                  return cb(obj[key], key);
                });
              }

              return true;
            },
            map: function map(obj, cb) {
              if (obj) {
                if (Array.isArray(obj)) {
                  return obj.map(cb);
                }

                return Object.keys(obj).map(function(key) {
                  return cb(obj[key], key);
                });
              }

              return [];
            },
            isEqual: function isEqual(a, b) {
              var aType = _typeof(a);

              var bType = _typeof(b);

              var aArray = Array.isArray(a);
              var bArray = Array.isArray(b);

              if (aType !== bType) {
                return false;
              }

              switch (_typeof(a)) {
                case 'object':
                  if (aArray || bArray) {
                    if (aArray && bArray) {
                      return (
                        a.length === b.length &&
                        a.every(function(aValue, index) {
                          var bValue = b[index];
                          return _.isEqual(aValue, bValue);
                        })
                      );
                    }

                    return false;
                  }

                  return _.every(a, function(aValue, key) {
                    var bValue = b[key];
                    return _.isEqual(aValue, bValue);
                  });

                default:
                  return a === b;
              }
            },
            escapeHtml: function escapeHtml(html) {
              return html
                .replace(/&/g, '&amp;')
                .replace(/</g, '&lt;')
                .replace(/>/g, '&gt;')
                .replace(/"/g, '&quot;')
                .replace(/'/g, '&#039;');
            },
          };
          module.exports = _;
        },
        {},
      ],
      23: [
        function(require, module, exports) {
          (function(global, setImmediate) {
            'use strict';

            var fs = require('fs');

            var PromiseLib = require('./promise'); // useful stuff

            var inherits = function inherits(
              cls,
              superCtor,
              statics,
              prototype
            ) {
              // eslint-disable-next-line no-underscore-dangle
              cls.super_ = superCtor;

              if (!prototype) {
                prototype = statics;
                statics = null;
              }

              if (statics) {
                Object.keys(statics).forEach(function(i) {
                  Object.defineProperty(
                    cls,
                    i,
                    Object.getOwnPropertyDescriptor(statics, i)
                  );
                });
              }

              var properties = {
                constructor: {
                  value: cls,
                  enumerable: false,
                  writable: false,
                  configurable: true,
                },
              };

              if (prototype) {
                Object.keys(prototype).forEach(function(i) {
                  properties[i] = Object.getOwnPropertyDescriptor(prototype, i);
                });
              }

              cls.prototype = Object.create(superCtor.prototype, properties);
            };

            var utils = {
              nop: function nop() {},
              promiseImmediate: function promiseImmediate(value) {
                return new PromiseLib.Promise(function(resolve) {
                  if (global.setImmediate) {
                    setImmediate(function() {
                      resolve(value);
                    });
                  } else {
                    // poorman's setImmediate - must wait at least 1ms
                    setTimeout(function() {
                      resolve(value);
                    }, 1);
                  }
                });
              },
              inherits: inherits,
              dateToExcel: function dateToExcel(d, date1904) {
                return (
                  25569 +
                  d.getTime() / (24 * 3600 * 1000) -
                  (date1904 ? 1462 : 0)
                );
              },
              excelToDate: function excelToDate(v, date1904) {
                var millisecondSinceEpoch = Math.round(
                  (v - 25569 + (date1904 ? 1462 : 0)) * 24 * 3600 * 1000
                );
                return new Date(millisecondSinceEpoch);
              },
              parsePath: function parsePath(filepath) {
                var last = filepath.lastIndexOf('/');
                return {
                  path: filepath.substring(0, last),
                  name: filepath.substring(last + 1),
                };
              },
              getRelsPath: function getRelsPath(filepath) {
                var path = utils.parsePath(filepath);
                return ''
                  .concat(path.path, '/_rels/')
                  .concat(path.name, '.rels');
              },
              xmlEncode: function xmlEncode(text) {
                // eslint-disable-next-line no-control-regex
                return text.replace(
                  /[<>&'"\x7F\x00-\x08\x0B-\x0C\x0E-\x1F]/g,
                  function(c) {
                    switch (c) {
                      case '<':
                        return '&lt;';

                      case '>':
                        return '&gt;';

                      case '&':
                        return '&amp;';

                      case "'":
                        return '&apos;';

                      case '"':
                        return '&quot;';

                      default:
                        return '';
                    }
                  }
                );
              },
              xmlDecode: function xmlDecode(text) {
                return text.replace(/&([a-z]*);/, function(c) {
                  switch (c) {
                    case '&lt;':
                      return '<';

                    case '&gt;':
                      return '>';

                    case '&amp;':
                      return '&';

                    case '&apos;':
                      return "'";

                    case '&quot;':
                      return '"';

                    default:
                      return c;
                  }
                });
              },
              validInt: function validInt(value) {
                var i = parseInt(value, 10);
                return !Number.isNaN(i) ? i : 0;
              },
              isDateFmt: function isDateFmt(fmt) {
                if (!fmt) {
                  return false;
                } // must remove all chars inside quotes and []

                fmt = fmt.replace(/\[[^\]]*]/g, '');
                fmt = fmt.replace(/"[^"]*"/g, ''); // then check for date formatting chars

                var result = fmt.match(/[ymdhMsb]+/) !== null;
                return result;
              },
              fs: {
                exists: function exists(path) {
                  return new PromiseLib.Promise(function(resolve) {
                    fs.exists(path, function(exists) {
                      resolve(exists);
                    });
                  });
                },
              },
              toIsoDateString: function toIsoDateString(dt) {
                return dt.toIsoString().subsstr(0, 10);
              },
            };
            module.exports = utils;
          }.call(
            this,
            typeof global !== 'undefined'
              ? global
              : typeof self !== 'undefined'
              ? self
              : typeof window !== 'undefined'
              ? window
              : {},
            require('timers').setImmediate
          ));
        },
        { './promise': 18, fs: 105, timers: 210 },
      ],
      24: [
        function(require, module, exports) {
          'use strict';

          var _ = require('./under-dash');

          var utils = require('./utils'); // constants

          var OPEN_ANGLE = '<';
          var CLOSE_ANGLE = '>';
          var OPEN_ANGLE_SLASH = '</';
          var CLOSE_SLASH_ANGLE = '/>';
          var EQUALS_QUOTE = '="';
          var QUOTE = '"';
          var SPACE = ' ';

          function pushAttribute(xml, name, value) {
            xml.push(SPACE);
            xml.push(name);
            xml.push(EQUALS_QUOTE);
            xml.push(utils.xmlEncode(value.toString()));
            xml.push(QUOTE);
          }

          function pushAttributes(xml, attributes) {
            if (attributes) {
              _.each(attributes, function(value, name) {
                if (value !== undefined) {
                  pushAttribute(xml, name, value);
                }
              });
            }
          }

          var XmlStream = (module.exports = function() {
            this._xml = [];
            this._stack = [];
            this._rollbacks = [];
          });

          XmlStream.StdDocAttributes = {
            version: '1.0',
            encoding: 'UTF-8',
            standalone: 'yes',
          };
          XmlStream.prototype = {
            get tos() {
              return this._stack.length
                ? this._stack[this._stack.length - 1]
                : undefined;
            },

            openXml: function openXml(docAttributes) {
              var xml = this._xml; // <?xml version="1.0" encoding="UTF-8" standalone="yes"?>

              xml.push('<?xml');
              pushAttributes(xml, docAttributes);
              xml.push('?>\n');
            },
            openNode: function openNode(name, attributes) {
              var parent = this.tos;
              var xml = this._xml;

              if (parent && this.open) {
                xml.push(CLOSE_ANGLE);
              }

              this._stack.push(name); // start streaming node

              xml.push(OPEN_ANGLE);
              xml.push(name);
              pushAttributes(xml, attributes);
              this.leaf = true;
              this.open = true;
            },
            addAttribute: function addAttribute(name, value) {
              if (!this.open) {
                throw new Error(
                  'Cannot write attributes to node if it is not open'
                );
              }

              pushAttribute(this._xml, name, value);
            },
            addAttributes: function addAttributes(attrs) {
              if (!this.open) {
                throw new Error(
                  'Cannot write attributes to node if it is not open'
                );
              }

              pushAttributes(this._xml, attrs);
            },
            writeText: function writeText(text) {
              var xml = this._xml;

              if (this.open) {
                xml.push(CLOSE_ANGLE);
                this.open = false;
              }

              this.leaf = false;
              xml.push(utils.xmlEncode(text.toString()));
            },
            writeXml: function writeXml(xml) {
              if (this.open) {
                this._xml.push(CLOSE_ANGLE);

                this.open = false;
              }

              this.leaf = false;

              this._xml.push(xml);
            },
            closeNode: function closeNode() {
              var node = this._stack.pop();

              var xml = this._xml;

              if (this.leaf) {
                xml.push(CLOSE_SLASH_ANGLE);
              } else {
                xml.push(OPEN_ANGLE_SLASH);
                xml.push(node);
                xml.push(CLOSE_ANGLE);
              }

              this.open = false;
              this.leaf = false;
            },
            leafNode: function leafNode(name, attributes, text) {
              this.openNode(name, attributes);

              if (text !== undefined) {
                // zeros need to be written
                this.writeText(text);
              }

              this.closeNode();
            },
            closeAll: function closeAll() {
              while (this._stack.length) {
                this.closeNode();
              }
            },
            addRollback: function addRollback() {
              this._rollbacks.push({
                xml: this._xml.length,
                stack: this._stack.length,
                leaf: this.leaf,
                open: this.open,
              });
            },
            commit: function commit() {
              this._rollbacks.pop();
            },
            rollback: function rollback() {
              var r = this._rollbacks.pop();

              if (this._xml.length > r.xml) {
                this._xml.splice(r.xml, this._xml.length - r.xml);
              }

              if (this._stack.length > r.stack) {
                this._stack.splice(r.stack, this._stack.length - r.stack);
              }

              this.leaf = r.leaf;
              this.open = r.open;
            },

            get xml() {
              this.closeAll();
              return this._xml.join('');
            },
          };
        },
        { './under-dash': 22, './utils': 23 },
      ],
      25: [
        function(require, module, exports) {
          'use strict'; // The purpose of this module is to wrap the js-zip library into a streaming zip library
          // since most of the exceljs code uses streams.
          // One day I might find (or build) a properly streaming browser safe zip lib

          var events = require('events');

          var JSZip = require('jszip');

          var PromiseLib = require('./promise');

          var utils = require('./utils');

          var StreamBuf = require('./stream-buf'); // =============================================================================
          // The ZipReader class
          // Unpacks an incoming zip stream

          var ZipReader = function ZipReader(options) {
            var _this = this;

            this.count = 0;
            this.jsZip = new JSZip();
            this.stream = new StreamBuf();
            this.stream.on('finish', function() {
              _this._process();
            });

            this.getEntryType =
              options.getEntryType ||
              function() {
                return 'string';
              };
          };

          utils.inherits(ZipReader, events.EventEmitter, {
            _finished: function _finished() {
              var _this2 = this;

              if (!--this.count) {
                PromiseLib.Promise.resolve().then(function() {
                  _this2.emit('finished');
                });
              }
            },
            _process: function _process() {
              var _this3 = this;

              var content = this.stream.read();
              this.jsZip
                .loadAsync(content)
                .then(function(zip) {
                  zip.forEach(function(path, entry) {
                    if (!entry.dir) {
                      _this3.count++;
                      entry
                        .async(_this3.getEntryType(path))
                        .then(function(data) {
                          var entryStream = new StreamBuf();
                          entryStream.path = path;
                          entryStream.write(data);

                          entryStream.autodrain = function() {
                            _this3._finished();
                          };

                          entryStream.on('finish', function() {
                            _this3._finished();
                          });

                          _this3.emit('entry', entryStream);
                        })
                        ['catch'](function(error) {
                          _this3.emit('error', error);
                        });
                    }
                  });
                })
                ['catch'](function(error) {
                  _this3.emit('error', error);
                });
            },
            // ==========================================================================
            // Stream.Writable interface
            write: function write(data, encoding, callback) {
              if (this.error) {
                if (callback) {
                  callback(this.error);
                }

                throw this.error;
              } else {
                return this.stream.write(data, encoding, callback);
              }
            },
            cork: function cork() {
              return this.stream.cork();
            },
            uncork: function uncork() {
              return this.stream.uncork();
            },
            end: function end() {
              return this.stream.end();
            },
            destroy: function destroy(error) {
              this.emit('finished');
              this.error = error;
            },
          }); // =============================================================================
          // The ZipWriter class
          // Packs streamed data into an output zip stream

          var ZipWriter = function ZipWriter() {
            this.zip = new JSZip();
            this.stream = new StreamBuf();
          };

          utils.inherits(ZipWriter, events.EventEmitter, {
            append: function append(data, options) {
              if (options.hasOwnProperty('base64') && options.base64) {
                this.zip.file(options.name, data, {
                  base64: true,
                });
              } else {
                this.zip.file(options.name, data);
              }
            },
            finalize: function finalize() {
              var _this4 = this;

              var options = {
                type: 'nodebuffer',
                compression: 'DEFLATE',
              };
              return this.zip.generateAsync(options).then(function(content) {
                _this4.stream.end(content);

                _this4.emit('finish');
              });
            },
            // ==========================================================================
            // Stream.Readable interface
            read: function read(size) {
              return this.stream.read(size);
            },
            setEncoding: function setEncoding(encoding) {
              return this.stream.setEncoding(encoding);
            },
            pause: function pause() {
              return this.stream.pause();
            },
            resume: function resume() {
              return this.stream.resume();
            },
            isPaused: function isPaused() {
              return this.stream.isPaused();
            },
            pipe: function pipe(destination, options) {
              return this.stream.pipe(
                destination,
                options
              );
            },
            unpipe: function unpipe(destination) {
              return this.stream.unpipe(destination);
            },
            unshift: function unshift(chunk) {
              return this.stream.unshift(chunk);
            },
            wrap: function wrap(stream) {
              return this.stream.wrap(stream);
            },
          }); // =============================================================================

          module.exports = {
            ZipReader: ZipReader,
            ZipWriter: ZipWriter,
          };
        },
        {
          './promise': 18,
          './stream-buf': 20,
          './utils': 23,
          events: 112,
          jszip: 140,
        },
      ],
      26: [
        function(require, module, exports) {
          'use strict';

          module.exports = {
            0: {
              f: 'General',
            },
            1: {
              f: '0',
            },
            2: {
              f: '0.00',
            },
            3: {
              f: '#,##0',
            },
            4: {
              f: '#,##0.00',
            },
            9: {
              f: '0%',
            },
            10: {
              f: '0.00%',
            },
            11: {
              f: '0.00E+00',
            },
            12: {
              f: '# ?/?',
            },
            13: {
              f: '# ??/??',
            },
            14: {
              f: 'mm-dd-yy',
            },
            15: {
              f: 'd-mmm-yy',
            },
            16: {
              f: 'd-mmm',
            },
            17: {
              f: 'mmm-yy',
            },
            18: {
              f: 'h:mm AM/PM',
            },
            19: {
              f: 'h:mm:ss AM/PM',
            },
            20: {
              f: 'h:mm',
            },
            21: {
              f: 'h:mm:ss',
            },
            22: {
              f: 'm/d/yy "h":mm',
            },
            27: {
              'zh-tw': '[$-404]e/m/d',
              'zh-cn': 'yyyy"年"m"月"',
              'ja-jp': '[$-411]ge.m.d',
              'ko-kr': 'yyyy"年" mm"月" dd"日"',
            },
            28: {
              'zh-tw': '[$-404]e"年"m"月"d"日"',
              'zh-cn': 'm"月"d"日"',
              'ja-jp': '[$-411]ggge"年"m"月"d"日"',
              'ko-kr': 'mm-dd',
            },
            29: {
              'zh-tw': '[$-404]e"年"m"月"d"日"',
              'zh-cn': 'm"月"d"日"',
              'ja-jp': '[$-411]ggge"年"m"月"d"日"',
              'ko-kr': 'mm-dd',
            },
            30: {
              'zh-tw': 'm/d/yy ',
              'zh-cn': 'm-d-yy',
              'ja-jp': 'm/d/yy',
              'ko-kr': 'mm-dd-yy',
            },
            31: {
              'zh-tw': 'yyyy"年"m"月"d"日"',
              'zh-cn': 'yyyy"年"m"月"d"日"',
              'ja-jp': 'yyyy"年"m"月"d"日"',
              'ko-kr': 'yyyy"년" mm"월" dd"일"',
            },
            32: {
              'zh-tw': 'hh"時"mm"分"',
              'zh-cn': 'h"时"mm"分"',
              'ja-jp': 'h"時"mm"分"',
              'ko-kr': 'h"시" mm"분"',
            },
            33: {
              'zh-tw': 'hh"時"mm"分"ss"秒"',
              'zh-cn': 'h"时"mm"分"ss"秒"',
              'ja-jp': 'h"時"mm"分"ss"秒"',
              'ko-kr': 'h"시" mm"분" ss"초"',
            },
            34: {
              'zh-tw': '上午/下午 hh"時"mm"分"',
              'zh-cn': '上午/下午 h"时"mm"分"',
              'ja-jp': 'yyyy"年"m"月"',
              'ko-kr': 'yyyy-mm-dd',
            },
            35: {
              'zh-tw': '上午/下午 hh"時"mm"分"ss"秒"',
              'zh-cn': '上午/下午 h"时"mm"分"ss"秒"',
              'ja-jp': 'm"月"d"日"',
              'ko-kr': 'yyyy-mm-dd',
            },
            36: {
              'zh-tw': '[$-404]e/m/d',
              'zh-cn': 'yyyy"年"m"月"',
              'ja-jp': '[$-411]ge.m.d',
              'ko-kr': 'yyyy"年" mm"月" dd"日"',
            },
            37: {
              f: '#,##0 ;(#,##0)',
            },
            38: {
              f: '#,##0 ;[Red](#,##0)',
            },
            39: {
              f: '#,##0.00 ;(#,##0.00)',
            },
            40: {
              f: '#,##0.00 ;[Red](#,##0.00)',
            },
            45: {
              f: 'mm:ss',
            },
            46: {
              f: '[h]:mm:ss',
            },
            47: {
              f: 'mmss.0',
            },
            48: {
              f: '##0.0E+0',
            },
            49: {
              f: '@',
            },
            50: {
              'zh-tw': '[$-404]e/m/d',
              'zh-cn': 'yyyy"年"m"月"',
              'ja-jp': '[$-411]ge.m.d',
              'ko-kr': 'yyyy"年" mm"月" dd"日"',
            },
            51: {
              'zh-tw': '[$-404]e"年"m"月"d"日"',
              'zh-cn': 'm"月"d"日"',
              'ja-jp': '[$-411]ggge"年"m"月"d"日"',
              'ko-kr': 'mm-dd',
            },
            52: {
              'zh-tw': '上午/下午 hh"時"mm"分"',
              'zh-cn': 'yyyy"年"m"月"',
              'ja-jp': 'yyyy"年"m"月"',
              'ko-kr': 'yyyy-mm-dd',
            },
            53: {
              'zh-tw': '上午/下午 hh"時"mm"分"ss"秒"',
              'zh-cn': 'm"月"d"日"',
              'ja-jp': 'm"月"d"日"',
              'ko-kr': 'yyyy-mm-dd',
            },
            54: {
              'zh-tw': '[$-404]e"年"m"月"d"日"',
              'zh-cn': 'm"月"d"日"',
              'ja-jp': '[$-411]ggge"年"m"月"d"日"',
              'ko-kr': 'mm-dd',
            },
            55: {
              'zh-tw': '上午/下午 hh"時"mm"分"',
              'zh-cn': '上午/下午 h"时"mm"分"',
              'ja-jp': 'yyyy"年"m"月"',
              'ko-kr': 'yyyy-mm-dd',
            },
            56: {
              'zh-tw': '上午/下午 hh"時"mm"分"ss"秒"',
              'zh-cn': '上午/下午 h"时"mm"分"ss"秒"',
              'ja-jp': 'm"月"d"日"',
              'ko-kr': 'yyyy-mm-dd',
            },
            57: {
              'zh-tw': '[$-404]e/m/d',
              'zh-cn': 'yyyy"年"m"月"',
              'ja-jp': '[$-411]ge.m.d',
              'ko-kr': 'yyyy"年" mm"月" dd"日"',
            },
            58: {
              'zh-tw': '[$-404]e"年"m"月"d"日"',
              'zh-cn': 'm"月"d"日"',
              'ja-jp': '[$-411]ggge"年"m"月"d"日"',
              'ko-kr': 'mm-dd',
            },
            59: {
              'th-th': 't0',
            },
            60: {
              'th-th': 't0.00',
            },
            61: {
              'th-th': 't#,##0',
            },
            62: {
              'th-th': 't#,##0.00',
            },
            67: {
              'th-th': 't0%',
            },
            68: {
              'th-th': 't0.00%',
            },
            69: {
              'th-th': 't# ?/?',
            },
            70: {
              'th-th': 't# ??/??',
            },
            81: {
              'th-th': 'd/m/bb',
            },
          };
        },
        {},
      ],
      27: [
        function(require, module, exports) {
          'use strict';

          module.exports = {
            OfficeDocument:
              'http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument',
            Worksheet:
              'http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet',
            CalcChain:
              'http://schemas.openxmlformats.org/officeDocument/2006/relationships/calcChain',
            SharedStrings:
              'http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings',
            Styles:
              'http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles',
            Theme:
              'http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme',
            Hyperlink:
              'http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink',
            Image:
              'http://schemas.openxmlformats.org/officeDocument/2006/relationships/image',
            CoreProperties:
              'http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties',
            ExtenderProperties:
              'http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties',
            Comments:
              'http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments',
            VmlDrawing:
              'http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing',
          };
        },
        {},
      ],
      28: [
        function(require, module, exports) {
          'use strict';

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          var Sax = require('sax');

          var PromiseLib = require('../../utils/promise');

          var XmlStream = require('../../utils/xml-stream');
          /* 'virtual' methods used as a form of documentation */

          /* eslint-disable class-methods-use-this */
          // Base class for Xforms

          var BaseXform =
            /*#__PURE__*/
            (function() {
              function BaseXform() {
                _classCallCheck(this, BaseXform);
              }

              _createClass(BaseXform, [
                {
                  key: 'prepare',
                  // constructor(/* model, name */) {}
                  // ============================================================
                  // Virtual Interface
                  value: function prepare() /* model, options */
                  {
                    // optional preparation (mutation) of model so it is ready for write
                  },
                },
                {
                  key: 'render',
                  value: function render() /* xmlStream, model */
                  {
                    // convert model to xml
                  },
                },
                {
                  key: 'parseOpen',
                  value: function parseOpen() /* node */
                  {
                    // Sax Open Node event
                  },
                },
                {
                  key: 'parseText',
                  value: function parseText() /* node */
                  {
                    // Sax Text event
                  },
                },
                {
                  key: 'parseClose',
                  value: function parseClose() /* name */
                  {
                    // Sax Close Node event
                  },
                },
                {
                  key: 'reconcile',
                  value: function reconcile() /* model, options */
                  {}, // optional post-parse step (opposite to prepare)
                  // ============================================================
                },
                {
                  key: 'reset',
                  value: function reset() {
                    // to make sure parses don't bleed to next iteration
                    this.model = null; // if we have a map - reset them too

                    if (this.map) {
                      var keys = Object.keys(this.map);

                      for (var i = 0; i < keys.length; i++) {
                        this.map[keys[i]].reset();
                      }
                    }
                  },
                },
                {
                  key: 'mergeModel',
                  value: function mergeModel(obj) {
                    // set obj's props to this.model
                    this.model = Object.assign(this.model || {}, obj);
                  },
                },
                {
                  key: 'parse',
                  value: function parse(parser, stream) {
                    var _this = this;

                    return new PromiseLib.Promise(function(resolve, reject) {
                      var abort = function abort(error) {
                        // Abandon ship! Prevent the parser from consuming any more resources
                        parser.removeAllListeners();
                        parser.on('error', function() {}); // Ignore any parse errors from the chunk being processed

                        stream.unpipe(parser);
                        reject(error);
                      };

                      parser.on('opentag', function(node) {
                        try {
                          _this.parseOpen(node);
                        } catch (error) {
                          abort(error);
                        }
                      });
                      parser.on('text', function(text) {
                        try {
                          _this.parseText(text);
                        } catch (error) {
                          abort(error);
                        }
                      });
                      parser.on('closetag', function(name) {
                        try {
                          if (!_this.parseClose(name)) {
                            resolve(_this.model);
                          }
                        } catch (error) {
                          abort(error);
                        }
                      });
                      parser.on('end', function() {
                        resolve(_this.model);
                      });
                      parser.on('error', function(error) {
                        abort(error);
                      });
                    });
                  },
                },
                {
                  key: 'parseStream',
                  value: function parseStream(stream) {
                    var parser = Sax.createStream(true, {});
                    var promise = this.parse(parser, stream);
                    stream.pipe(parser);
                    return promise;
                  },
                },
                {
                  key: 'toXml',
                  value: function toXml(model) {
                    var xmlStream = new XmlStream();
                    this.render(xmlStream, model);
                    return xmlStream.xml;
                  },
                },
                {
                  key: 'xml',
                  get: function get() {
                    // convenience function to get the xml of this.model
                    // useful for manager types that are built during the prepare phase
                    return this.toXml(this.model);
                  },
                },
              ]);

              return BaseXform;
            })();

          module.exports = BaseXform;
        },
        { '../../utils/promise': 18, '../../utils/xml-stream': 24, sax: 205 },
      ],
      29: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var colCache = require('../../../utils/col-cache');

          var DefinedNamesXform = (module.exports = function() {});

          utils.inherits(DefinedNamesXform, BaseXform, {
            render: function render(xmlStream, model) {
              // <definedNames>
              //   <definedName name="name">name.ranges.join(',')</definedName>
              //   <definedName name="_xlnm.Print_Area" localSheetId="0">name.ranges.join(',')</definedName>
              // </definedNames>
              xmlStream.openNode('definedName', {
                name: model.name,
                localSheetId: model.localSheetId,
              });
              xmlStream.writeText(model.ranges.join(','));
              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              switch (node.name) {
                case 'definedName':
                  this._parsedName = node.attributes.name;
                  this._parsedLocalSheetId = node.attributes.localSheetId;
                  this._parsedText = [];
                  return true;

                default:
                  return false;
              }
            },
            parseText: function parseText(text) {
              this._parsedText.push(text);
            },
            parseClose: function parseClose() {
              this.model = {
                name: this._parsedName,
                ranges: extractRanges(this._parsedText.join('')),
              };

              if (this._parsedLocalSheetId !== undefined) {
                this.model.localSheetId = parseInt(
                  this._parsedLocalSheetId,
                  10
                );
              }

              return false;
            },
          });

          function isValidRange(range) {
            try {
              colCache.decodeEx(range);
              return true;
            } catch (err) {
              return false;
            }
          }

          function extractRanges(parsedText) {
            var ranges = [];
            var quotesOpened = false;
            var last = '';
            parsedText.split(',').forEach(function(item) {
              if (!item) {
                return;
              }

              var quotes = (item.match(/'/g) || []).length;

              if (!quotes) {
                if (quotesOpened) {
                  last += ''.concat(item, ',');
                } else if (isValidRange(item)) {
                  ranges.push(item);
                }

                return;
              }

              var quotesEven = quotes % 2 === 0;

              if (!quotesOpened && quotesEven && isValidRange(item)) {
                ranges.push(item);
              } else if (quotesOpened && !quotesEven) {
                quotesOpened = false;

                if (isValidRange(last + item)) {
                  ranges.push(last + item);
                }

                last = '';
              } else {
                quotesOpened = true;
                last += ''.concat(item, ',');
              }
            });
            return ranges;
          }
        },
        {
          '../../../utils/col-cache': 17,
          '../../../utils/utils': 23,
          '../base-xform': 28,
        },
      ],
      30: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var WorksheetXform = (module.exports = function() {});

          utils.inherits(WorksheetXform, BaseXform, {
            render: function render(xmlStream, model) {
              xmlStream.leafNode('sheet', {
                sheetId: model.id,
                name: model.name,
                state: model.state,
                'r:id': model.rId,
              });
            },
            parseOpen: function parseOpen(node) {
              if (node.name === 'sheet') {
                this.model = {
                  name: utils.xmlDecode(node.attributes.name),
                  id: parseInt(node.attributes.sheetId, 10),
                  state: node.attributes.state,
                  rId: node.attributes['r:id'],
                };
                return true;
              }

              return false;
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      31: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var WorksheetPropertiesXform = (module.exports = function() {});

          utils.inherits(WorksheetPropertiesXform, BaseXform, {
            render: function render(xmlStream, model) {
              xmlStream.leafNode('workbookPr', {
                date1904: model.date1904 ? 1 : undefined,
                defaultThemeVersion: 164011,
                filterPrivacy: 1,
              });
            },
            parseOpen: function parseOpen(node) {
              if (node.name === 'workbookPr') {
                this.model = {
                  date1904: node.attributes.date1904 === '1',
                };
                return true;
              }

              return false;
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      32: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var WorkbookViewXform = (module.exports = function() {});

          utils.inherits(WorkbookViewXform, BaseXform, {
            render: function render(xmlStream, model) {
              var attributes = {
                xWindow: model.x || 0,
                yWindow: model.y || 0,
                windowWidth: model.width || 12000,
                windowHeight: model.height || 24000,
                firstSheet: model.firstSheet,
                activeTab: model.activeTab,
              };

              if (model.visibility && model.visibility !== 'visible') {
                attributes.visibility = model.visibility;
              }

              xmlStream.leafNode('workbookView', attributes);
            },
            parseOpen: function parseOpen(node) {
              if (node.name === 'workbookView') {
                var model = (this.model = {});

                var addS = function addS(name, value, dflt) {
                  var s = value !== undefined ? (model[name] = value) : dflt;

                  if (s !== undefined) {
                    model[name] = s;
                  }
                };

                var addN = function addN(name, value, dflt) {
                  var n =
                    value !== undefined
                      ? (model[name] = parseInt(value, 10))
                      : dflt;

                  if (n !== undefined) {
                    model[name] = n;
                  }
                };

                addN('x', node.attributes.xWindow, 0);
                addN('y', node.attributes.yWindow, 0);
                addN('width', node.attributes.windowWidth, 25000);
                addN('height', node.attributes.windowHeight, 10000);
                addS('visibility', node.attributes.visibility, 'visible');
                addN('activeTab', node.attributes.activeTab, undefined);
                addN('firstSheet', node.attributes.firstSheet, undefined);
                return true;
              }

              return false;
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      33: [
        function(require, module, exports) {
          'use strict';

          var _ = require('../../../utils/under-dash');

          var utils = require('../../../utils/utils');

          var colCache = require('../../../utils/col-cache');

          var XmlStream = require('../../../utils/xml-stream');

          var BaseXform = require('../base-xform');

          var StaticXform = require('../static-xform');

          var ListXform = require('../list-xform');

          var DefinedNameXform = require('./defined-name-xform');

          var SheetXform = require('./sheet-xform');

          var WorkbookViewXform = require('./workbook-view-xform');

          var WorkbookPropertiesXform = require('./workbook-properties-xform');

          var WorkbookXform = (module.exports = function() {
            this.map = {
              fileVersion: WorkbookXform.STATIC_XFORMS.fileVersion,
              workbookPr: new WorkbookPropertiesXform(),
              bookViews: new ListXform({
                tag: 'bookViews',
                count: false,
                childXform: new WorkbookViewXform(),
              }),
              sheets: new ListXform({
                tag: 'sheets',
                count: false,
                childXform: new SheetXform(),
              }),
              definedNames: new ListXform({
                tag: 'definedNames',
                count: false,
                childXform: new DefinedNameXform(),
              }),
              calcPr: WorkbookXform.STATIC_XFORMS.calcPr,
            };
          });

          utils.inherits(
            WorkbookXform,
            BaseXform,
            {
              WORKBOOK_ATTRIBUTES: {
                xmlns:
                  'http://schemas.openxmlformats.org/spreadsheetml/2006/main',
                'xmlns:r':
                  'http://schemas.openxmlformats.org/officeDocument/2006/relationships',
                'xmlns:mc':
                  'http://schemas.openxmlformats.org/markup-compatibility/2006',
                'mc:Ignorable': 'x15',
                'xmlns:x15':
                  'http://schemas.microsoft.com/office/spreadsheetml/2010/11/main',
              },
              STATIC_XFORMS: {
                fileVersion: new StaticXform({
                  tag: 'fileVersion',
                  $: {
                    appName: 'xl',
                    lastEdited: 5,
                    lowestEdited: 5,
                    rupBuild: 9303,
                  },
                }),
                calcPr: new StaticXform({
                  tag: 'calcPr',
                  $: {
                    calcId: 171027,
                  },
                }),
              },
            },
            {
              prepare: function prepare(model) {
                model.sheets = model.worksheets; // collate all the print areas from all of the sheets and add them to the defined names

                var printAreas = [];
                var index = 0; // sheets is sparse array - calc index manually

                model.sheets.forEach(function(sheet) {
                  if (sheet.pageSetup && sheet.pageSetup.printArea) {
                    var definedName = {
                      name: '_xlnm.Print_Area',
                      ranges: [
                        ''
                          .concat(sheet.name, '!')
                          .concat(sheet.pageSetup.printArea),
                      ],
                      localSheetId: index,
                    };
                    printAreas.push(definedName);
                  }

                  if (
                    sheet.pageSetup &&
                    (sheet.pageSetup.printTitlesRow ||
                      sheet.pageSetup.printTitlesColumn)
                  ) {
                    var ranges = [];

                    if (sheet.pageSetup.printTitlesColumn) {
                      var titlesColumns = sheet.pageSetup.printTitlesColumn.split(
                        ':'
                      );
                      ranges.push(
                        "'"
                          .concat(sheet.name, "'!$")
                          .concat(titlesColumns[0], ':$')
                          .concat(titlesColumns[1])
                      );
                    }

                    if (sheet.pageSetup.printTitlesRow) {
                      var titlesRows = sheet.pageSetup.printTitlesRow.split(
                        ':'
                      );
                      ranges.push(
                        "'"
                          .concat(sheet.name, "'!$")
                          .concat(titlesRows[0], ':$')
                          .concat(titlesRows[1])
                      );
                    }

                    var _definedName = {
                      name: '_xlnm.Print_Titles',
                      ranges: ranges,
                      localSheetId: index,
                    };
                    printAreas.push(_definedName);
                  }

                  index++;
                });

                if (printAreas.length) {
                  model.definedNames = model.definedNames.concat(printAreas);
                }

                model.media &&
                  model.media.forEach(function(medium, i) {
                    // assign name
                    medium.name = medium.type + (i + 1);
                  });
              },
              render: function render(xmlStream, model) {
                xmlStream.openXml(XmlStream.StdDocAttributes);
                xmlStream.openNode(
                  'workbook',
                  WorkbookXform.WORKBOOK_ATTRIBUTES
                );
                this.map.fileVersion.render(xmlStream);
                this.map.workbookPr.render(xmlStream, model.properties);
                this.map.bookViews.render(xmlStream, model.views);
                this.map.sheets.render(xmlStream, model.sheets);
                this.map.definedNames.render(xmlStream, model.definedNames);
                this.map.calcPr.render(xmlStream);
                xmlStream.closeNode();
              },
              parseOpen: function parseOpen(node) {
                if (this.parser) {
                  this.parser.parseOpen(node);
                  return true;
                }

                switch (node.name) {
                  case 'workbook':
                    return true;

                  default:
                    this.parser = this.map[node.name];

                    if (this.parser) {
                      this.parser.parseOpen(node);
                    }

                    return true;
                }
              },
              parseText: function parseText(text) {
                if (this.parser) {
                  this.parser.parseText(text);
                }
              },
              parseClose: function parseClose(name) {
                if (this.parser) {
                  if (!this.parser.parseClose(name)) {
                    this.parser = undefined;
                  }

                  return true;
                }

                switch (name) {
                  case 'workbook':
                    this.model = {
                      sheets: this.map.sheets.model,
                      properties: this.map.workbookPr.model || {},
                      views: this.map.bookViews.model,
                    };

                    if (this.map.definedNames.model) {
                      this.model.definedNames = this.map.definedNames.model;
                    }

                    return false;

                  default:
                    // not quite sure how we get here!
                    return true;
                }
              },
              reconcile: function reconcile(model) {
                var rels = (model.workbookRels || []).reduce(function(
                  map,
                  rel
                ) {
                  map[rel.Id] = rel;
                  return map;
                },
                {}); // reconcile sheet ids, rIds and names

                var worksheets = [];
                var worksheet;
                var index = 0;
                (model.sheets || []).forEach(function(sheet) {
                  var rel = rels[sheet.rId];

                  if (!rel) {
                    return;
                  }

                  worksheet = model.worksheetHash['xl/'.concat(rel.Target)]; // If there are "chartsheets" in the file, rel.Target will
                  // come out as chartsheets/sheet1.xml or similar here, and
                  // that won't be in model.worksheetHash.
                  // As we don't have the infrastructure to support chartsheets,
                  // we will ignore them for now:

                  if (worksheet) {
                    worksheet.name = sheet.name;
                    worksheet.id = sheet.id;
                    worksheet.state = sheet.state;
                    worksheets[index++] = worksheet;
                  }
                }); // reconcile print areas

                var definedNames = [];

                _.each(model.definedNames, function(definedName) {
                  if (definedName.name === '_xlnm.Print_Area') {
                    worksheet = worksheets[definedName.localSheetId];

                    if (worksheet) {
                      if (!worksheet.pageSetup) {
                        worksheet.pageSetup = {};
                      }

                      var range = colCache.decodeEx(definedName.ranges[0]);
                      worksheet.pageSetup.printArea = range.dimensions;
                    }
                  } else if (definedName.name === '_xlnm.Print_Titles') {
                    worksheet = worksheets[definedName.localSheetId];

                    if (worksheet) {
                      if (!worksheet.pageSetup) {
                        worksheet.pageSetup = {};
                      }

                      var rangeString = definedName.ranges.join(',');
                      var rowRangeRegex = /\$\d+:\$\d+/;
                      var rowRangeMatches = rangeString.match(rowRangeRegex);

                      if (rowRangeMatches && rowRangeMatches.length) {
                        worksheet.pageSetup.printTitlesRow = rowRangeMatches[0];
                      }

                      var columnRangeRegex = /\$[A-Z]+:\$[A-Z]+/;
                      var columnRangeMatches = rangeString.match(
                        columnRangeRegex
                      );

                      if (columnRangeMatches && columnRangeMatches.length) {
                        worksheet.pageSetup.printTitlesColumn =
                          columnRangeMatches[0];
                      }
                    }
                  } else {
                    definedNames.push(definedName);
                  }
                });

                model.definedNames = definedNames; // used by sheets to build their image models

                model.media.forEach(function(media, i) {
                  media.index = i;
                });
              },
            }
          );
        },
        {
          '../../../utils/col-cache': 17,
          '../../../utils/under-dash': 22,
          '../../../utils/utils': 23,
          '../../../utils/xml-stream': 24,
          '../base-xform': 28,
          '../list-xform': 57,
          '../static-xform': 84,
          './defined-name-xform': 29,
          './sheet-xform': 30,
          './workbook-properties-xform': 31,
          './workbook-view-xform': 32,
        },
      ],
      34: [
        function(require, module, exports) {
          'use strict';

          function _objectSpread(target) {
            for (var i = 1; i < arguments.length; i++) {
              var source = arguments[i] != null ? arguments[i] : {};
              var ownKeys = Object.keys(source);
              if (typeof Object.getOwnPropertySymbols === 'function') {
                ownKeys = ownKeys.concat(
                  Object.getOwnPropertySymbols(source).filter(function(sym) {
                    return Object.getOwnPropertyDescriptor(
                      source,
                      sym
                    ).enumerable;
                  })
                );
              }
              ownKeys.forEach(function(key) {
                _defineProperty(target, key, source[key]);
              });
            }
            return target;
          }

          function _defineProperty(obj, key, value) {
            if (key in obj) {
              Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true,
              });
            } else {
              obj[key] = value;
            }
            return obj;
          }

          var RichTextXform = require('../strings/rich-text-xform');

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');
          /**
  <comment ref="B1" authorId="0">
    <text>
      <r>
        <rPr>
          <b/>
          <sz val="9"/>
          <rFont val="宋体"/>
          <charset val="134"/>
        </rPr>
        <t>51422:</t>
      </r>
      <r>
        <rPr>
          <sz val="9"/>
          <rFont val="宋体"/>
          <charset val="134"/>
        </rPr>
        <t xml:space="preserve">&#10;test</t>
      </r>
    </text>
  </comment>
 */

          var CommentXform = (module.exports = function(model) {
            this.model = model;
          });

          utils.inherits(CommentXform, BaseXform, {
            get tag() {
              return 'r';
            },

            get richTextXform() {
              if (!this._richTextXform) {
                this._richTextXform = new RichTextXform();
              }

              return this._richTextXform;
            },

            render: function render(xmlStream, model) {
              var _this = this;

              model = model || this.model;
              xmlStream.openNode('comment', {
                ref: model.ref,
                authorId: 0,
              });
              xmlStream.openNode('text');

              if (model.note.texts) {
                model.note.texts.forEach(function(text) {
                  _this.richTextXform.render(xmlStream, text);
                });
              }

              xmlStream.closeNode();
              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              switch (node.name) {
                case 'comment':
                  this.model = _objectSpread(
                    {
                      texts: [],
                    },
                    node.attributes
                  );
                  return true;

                case 'r':
                  this.parser = this.richTextXform;
                  this.parser.parseOpen(node);
                  return true;

                default:
                  return false;
              }
            },
            parseText: function parseText(text) {
              if (this.parser) {
                this.parser.parseText(text);
              }
            },
            parseClose: function parseClose(name) {
              switch (name) {
                case 'comment':
                  return false;

                case 'r':
                  this.model.texts.push(this.parser.model);
                  this.parser = undefined;
                  return true;

                default:
                  if (this.parser) {
                    this.parser.parseClose(name);
                  }

                  return true;
              }
            },
          });
        },
        {
          '../../../utils/utils': 23,
          '../base-xform': 28,
          '../strings/rich-text-xform': 86,
        },
      ],
      35: [
        function(require, module, exports) {
          'use strict';

          var XmlStream = require('../../../utils/xml-stream');

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var CommentXform = require('./comment-xform');

          var CommentsXform = (module.exports = function() {
            this.map = {
              comment: new CommentXform(),
            };
          });

          utils.inherits(
            CommentsXform,
            BaseXform,
            {
              COMMENTS_ATTRIBUTES: {
                xmlns:
                  'http://schemas.openxmlformats.org/spreadsheetml/2006/main',
              },
            },
            {
              render: function render(xmlStream, model) {
                var _this = this;

                model = model || this.model;
                xmlStream.openXml(XmlStream.StdDocAttributes);
                xmlStream.openNode(
                  'comments',
                  CommentsXform.COMMENTS_ATTRIBUTES
                ); // authors
                // TODO: support authors properly

                xmlStream.openNode('authors');
                xmlStream.leafNode('author', null, 'Author');
                xmlStream.closeNode(); // comments

                xmlStream.openNode('commentList');
                model.comments.forEach(function(comment) {
                  _this.map.comment.render(xmlStream, comment);
                });
                xmlStream.closeNode();
                xmlStream.closeNode();
              },
              parseOpen: function parseOpen(node) {
                if (this.parser) {
                  this.parser.parseOpen(node);
                  return true;
                }

                switch (node.name) {
                  case 'commentList':
                    this.model = {
                      comments: [],
                    };
                    return true;

                  case 'comment':
                    this.parser = this.map.comment;
                    this.parser.parseOpen(node);
                    return true;

                  default:
                    return false;
                }
              },
              parseText: function parseText(text) {
                if (this.parser) {
                  this.parser.parseText(text);
                }
              },
              parseClose: function parseClose(name) {
                switch (name) {
                  case 'commentList':
                    return false;

                  case 'comment':
                    this.model.comments.push(this.parser.model);
                    this.parser = undefined;
                    return true;

                  default:
                    if (this.parser) {
                      this.parser.parseClose(name);
                    }

                    return true;
                }
              },
            }
          );
        },
        {
          '../../../utils/utils': 23,
          '../../../utils/xml-stream': 24,
          '../base-xform': 28,
          './comment-xform': 34,
        },
      ],
      36: [
        function(require, module, exports) {
          'use strict';

          function _typeof(obj) {
            if (
              typeof Symbol === 'function' &&
              typeof Symbol.iterator === 'symbol'
            ) {
              _typeof = function _typeof(obj) {
                return typeof obj;
              };
            } else {
              _typeof = function _typeof(obj) {
                return obj &&
                  typeof Symbol === 'function' &&
                  obj.constructor === Symbol &&
                  obj !== Symbol.prototype
                  ? 'symbol'
                  : typeof obj;
              };
            }
            return _typeof(obj);
          }

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          function _possibleConstructorReturn(self, call) {
            if (
              call &&
              (_typeof(call) === 'object' || typeof call === 'function')
            ) {
              return call;
            }
            return _assertThisInitialized(self);
          }

          function _assertThisInitialized(self) {
            if (self === void 0) {
              throw new ReferenceError(
                "this hasn't been initialised - super() hasn't been called"
              );
            }
            return self;
          }

          function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf
              ? Object.getPrototypeOf
              : function _getPrototypeOf(o) {
                  return o.__proto__ || Object.getPrototypeOf(o);
                };
            return _getPrototypeOf(o);
          }

          function _inherits(subClass, superClass) {
            if (typeof superClass !== 'function' && superClass !== null) {
              throw new TypeError(
                'Super expression must either be null or a function'
              );
            }
            subClass.prototype = Object.create(
              superClass && superClass.prototype,
              {
                constructor: {
                  value: subClass,
                  writable: true,
                  configurable: true,
                },
              }
            );
            if (superClass) _setPrototypeOf(subClass, superClass);
          }

          function _setPrototypeOf(o, p) {
            _setPrototypeOf =
              Object.setPrototypeOf ||
              function _setPrototypeOf(o, p) {
                o.__proto__ = p;
                return o;
              };
            return _setPrototypeOf(o, p);
          }

          var BaseXform = require('../base-xform'); // render the triangle in the cell for the comment

          var VmlAnchorXform =
            /*#__PURE__*/
            (function(_BaseXform) {
              _inherits(VmlAnchorXform, _BaseXform);

              function VmlAnchorXform() {
                _classCallCheck(this, VmlAnchorXform);

                return _possibleConstructorReturn(
                  this,
                  _getPrototypeOf(VmlAnchorXform).apply(this, arguments)
                );
              }

              _createClass(VmlAnchorXform, [
                {
                  key: 'getAnchorRect',
                  value: function getAnchorRect(anchor) {
                    var l = Math.floor(anchor.left);
                    var lf = Math.floor((anchor.left - l) * 68);
                    var t = Math.floor(anchor.top);
                    var tf = Math.floor((anchor.top - t) * 18);
                    var r = Math.floor(anchor.right);
                    var rf = Math.floor((anchor.right - r) * 68);
                    var b = Math.floor(anchor.bottom);
                    var bf = Math.floor((anchor.bottom - b) * 18);
                    return [l, lf, t, tf, r, rf, b, bf];
                  },
                },
                {
                  key: 'getDefaultRect',
                  value: function getDefaultRect(ref) {
                    var l = ref.col;
                    var lf = 6;
                    var t = Math.max(ref.row - 2, 0);
                    var tf = 14;
                    var r = l + 2;
                    var rf = 2;
                    var b = t + 4;
                    var bf = 16;
                    return [l, lf, t, tf, r, rf, b, bf];
                  },
                },
                {
                  key: 'render',
                  value: function render(xmlStream, model) {
                    var rect = model.anchor
                      ? this.getAnchorRect(model.anchor)
                      : this.getDefaultRect(model.refAddress);
                    xmlStream.leafNode('x:Anchor', null, rect.join(', '));
                  },
                },
                {
                  key: 'tag',
                  get: function get() {
                    return 'x:Anchor';
                  },
                },
              ]);

              return VmlAnchorXform;
            })(BaseXform);

          module.exports = VmlAnchorXform;
        },
        { '../base-xform': 28 },
      ],
      37: [
        function(require, module, exports) {
          'use strict';

          function _typeof(obj) {
            if (
              typeof Symbol === 'function' &&
              typeof Symbol.iterator === 'symbol'
            ) {
              _typeof = function _typeof(obj) {
                return typeof obj;
              };
            } else {
              _typeof = function _typeof(obj) {
                return obj &&
                  typeof Symbol === 'function' &&
                  obj.constructor === Symbol &&
                  obj !== Symbol.prototype
                  ? 'symbol'
                  : typeof obj;
              };
            }
            return _typeof(obj);
          }

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          function _possibleConstructorReturn(self, call) {
            if (
              call &&
              (_typeof(call) === 'object' || typeof call === 'function')
            ) {
              return call;
            }
            return _assertThisInitialized(self);
          }

          function _assertThisInitialized(self) {
            if (self === void 0) {
              throw new ReferenceError(
                "this hasn't been initialised - super() hasn't been called"
              );
            }
            return self;
          }

          function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf
              ? Object.getPrototypeOf
              : function _getPrototypeOf(o) {
                  return o.__proto__ || Object.getPrototypeOf(o);
                };
            return _getPrototypeOf(o);
          }

          function _inherits(subClass, superClass) {
            if (typeof superClass !== 'function' && superClass !== null) {
              throw new TypeError(
                'Super expression must either be null or a function'
              );
            }
            subClass.prototype = Object.create(
              superClass && superClass.prototype,
              {
                constructor: {
                  value: subClass,
                  writable: true,
                  configurable: true,
                },
              }
            );
            if (superClass) _setPrototypeOf(subClass, superClass);
          }

          function _setPrototypeOf(o, p) {
            _setPrototypeOf =
              Object.setPrototypeOf ||
              function _setPrototypeOf(o, p) {
                o.__proto__ = p;
                return o;
              };
            return _setPrototypeOf(o, p);
          }

          var BaseXform = require('../base-xform');

          var VmlAnchorXform = require('./vml-anchor-xform'); // render the triangle in the cell for the comment

          var VmlNoteXform =
            /*#__PURE__*/
            (function(_BaseXform) {
              _inherits(VmlNoteXform, _BaseXform);

              function VmlNoteXform() {
                _classCallCheck(this, VmlNoteXform);

                return _possibleConstructorReturn(
                  this,
                  _getPrototypeOf(VmlNoteXform).apply(this, arguments)
                );
              }

              _createClass(VmlNoteXform, [
                {
                  key: 'render',
                  value: function render(xmlStream, model, index) {
                    xmlStream.openNode(
                      'v:shape',
                      VmlNoteXform.V_SHAPE_ATTRIBUTES(index)
                    );
                    xmlStream.leafNode('v:fill', {
                      color2: 'infoBackground [80]',
                    });
                    xmlStream.leafNode('v:shadow', {
                      color: 'none [81]',
                      obscured: 't',
                    });
                    xmlStream.leafNode('v:path', {
                      'o:connecttype': 'none',
                    });
                    xmlStream.openNode('v:textbox', {
                      style: 'mso-direction-alt:auto',
                    });
                    xmlStream.leafNode('div', {
                      style: 'text-align:left',
                    });
                    xmlStream.closeNode();
                    xmlStream.openNode('x:ClientData', {
                      ObjectType: 'Note',
                    });
                    xmlStream.leafNode('x:MoveWithCells');
                    xmlStream.leafNode('x:SizeWithCells');
                    VmlNoteXform.vmlAnchorXform.render(xmlStream, model);
                    xmlStream.leafNode('x:AutoFill', null, 'False');
                    xmlStream.leafNode('x:Row', null, model.refAddress.row - 1);
                    xmlStream.leafNode(
                      'x:Column',
                      null,
                      model.refAddress.col - 1
                    );
                    xmlStream.closeNode();
                    xmlStream.closeNode();
                  },
                },
                {
                  key: 'tag',
                  get: function get() {
                    return 'v:shape';
                  },
                },
              ]);

              return VmlNoteXform;
            })(BaseXform);

          module.exports = VmlNoteXform;

          VmlNoteXform.V_SHAPE_ATTRIBUTES = function(index) {
            return {
              id: '_x0000_s'.concat(1025 + index),
              type: '#_x0000_t202',
              style:
                'position:absolute; margin-left:105.3pt;margin-top:10.5pt;width:97.8pt;height:59.1pt;z-index:1;visibility:hidden',
              fillcolor: 'infoBackground [80]',
              strokecolor: 'none [81]',
              'o:insetmode': 'auto',
            };
          };

          VmlNoteXform.vmlAnchorXform = new VmlAnchorXform();
        },
        { '../base-xform': 28, './vml-anchor-xform': 36 },
      ],
      38: [
        function(require, module, exports) {
          'use strict';

          function _typeof(obj) {
            if (
              typeof Symbol === 'function' &&
              typeof Symbol.iterator === 'symbol'
            ) {
              _typeof = function _typeof(obj) {
                return typeof obj;
              };
            } else {
              _typeof = function _typeof(obj) {
                return obj &&
                  typeof Symbol === 'function' &&
                  obj.constructor === Symbol &&
                  obj !== Symbol.prototype
                  ? 'symbol'
                  : typeof obj;
              };
            }
            return _typeof(obj);
          }

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          function _possibleConstructorReturn(self, call) {
            if (
              call &&
              (_typeof(call) === 'object' || typeof call === 'function')
            ) {
              return call;
            }
            return _assertThisInitialized(self);
          }

          function _assertThisInitialized(self) {
            if (self === void 0) {
              throw new ReferenceError(
                "this hasn't been initialised - super() hasn't been called"
              );
            }
            return self;
          }

          function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf
              ? Object.getPrototypeOf
              : function _getPrototypeOf(o) {
                  return o.__proto__ || Object.getPrototypeOf(o);
                };
            return _getPrototypeOf(o);
          }

          function _inherits(subClass, superClass) {
            if (typeof superClass !== 'function' && superClass !== null) {
              throw new TypeError(
                'Super expression must either be null or a function'
              );
            }
            subClass.prototype = Object.create(
              superClass && superClass.prototype,
              {
                constructor: {
                  value: subClass,
                  writable: true,
                  configurable: true,
                },
              }
            );
            if (superClass) _setPrototypeOf(subClass, superClass);
          }

          function _setPrototypeOf(o, p) {
            _setPrototypeOf =
              Object.setPrototypeOf ||
              function _setPrototypeOf(o, p) {
                o.__proto__ = p;
                return o;
              };
            return _setPrototypeOf(o, p);
          }

          var XmlStream = require('../../../utils/xml-stream');

          var BaseXform = require('../base-xform');

          var VmlNoteXform = require('./vml-note-xform'); // This class is (currently) single purposed to insert the triangle
          // drawing icons on commented cells

          var VmlNotesXform =
            /*#__PURE__*/
            (function(_BaseXform) {
              _inherits(VmlNotesXform, _BaseXform);

              function VmlNotesXform() {
                _classCallCheck(this, VmlNotesXform);

                return _possibleConstructorReturn(
                  this,
                  _getPrototypeOf(VmlNotesXform).apply(this, arguments)
                );
              }

              _createClass(VmlNotesXform, [
                {
                  key: 'render',
                  value: function render(xmlStream, model) {
                    xmlStream.openXml(XmlStream.StdDocAttributes);
                    xmlStream.openNode(
                      this.tag,
                      VmlNotesXform.DRAWING_ATTRIBUTES
                    );
                    xmlStream.openNode('o:shapelayout', {
                      'v:ext': 'edit',
                    });
                    xmlStream.leafNode('o:idmap', {
                      'v:ext': 'edit',
                      data: 1,
                    });
                    xmlStream.closeNode();
                    xmlStream.openNode('v:shapetype', {
                      id: '_x0000_t202',
                      coordsize: '21600,21600',
                      'o:spt': 202,
                      path: 'm,l,21600r21600,l21600,xe',
                    });
                    xmlStream.leafNode('v:stroke', {
                      joinstyle: 'miter',
                    });
                    xmlStream.leafNode('v:path', {
                      gradientshapeok: 't',
                      'o:connecttype': 'rect',
                    });
                    xmlStream.closeNode();
                    model.comments.forEach(function(item, index) {
                      VmlNotesXform.vmlCommentXform.render(
                        xmlStream,
                        item,
                        index
                      );
                    });
                    xmlStream.closeNode();
                  },
                },
                {
                  key: 'parseOpen',
                  value: function parseOpen(node) {
                    if (this.parser) {
                      this.parser.parseOpen(node);
                      return true;
                    }

                    switch (node.name) {
                      case this.tag:
                        this.reset();
                        this.model = {
                          anchors: [],
                        };
                        break;

                      default:
                        this.parser = this.map[node.name];

                        if (this.parser) {
                          this.parser.parseOpen(node);
                        }

                        break;
                    }

                    return true;
                  },
                },
                {
                  key: 'parseText',
                  value: function parseText(text) {
                    if (this.parser) {
                      this.parser.parseText(text);
                    }
                  },
                },
                {
                  key: 'parseClose',
                  value: function parseClose(name) {
                    if (this.parser) {
                      if (!this.parser.parseClose(name)) {
                        this.model.anchors.push(this.parser.model);
                        this.parser = undefined;
                      }

                      return true;
                    }

                    switch (name) {
                      case this.tag:
                        return false;

                      default:
                        // could be some unrecognised tags
                        return true;
                    }
                  },
                },
                {
                  key: 'reconcile',
                  value: function reconcile(model, options) {
                    var _this = this;

                    model.anchors.forEach(function(anchor) {
                      if (anchor.br) {
                        _this.map['xdr:twoCellAnchor'].reconcile(
                          anchor,
                          options
                        );
                      } else {
                        _this.map['xdr:oneCellAnchor'].reconcile(
                          anchor,
                          options
                        );
                      }
                    });
                  },
                },
                {
                  key: 'tag',
                  get: function get() {
                    return 'xml';
                  },
                },
              ]);

              return VmlNotesXform;
            })(BaseXform);

          VmlNotesXform.DRAWING_ATTRIBUTES = {
            'xmlns:v': 'urn:schemas-microsoft-com:vml',
            'xmlns:o': 'urn:schemas-microsoft-com:office:office',
            'xmlns:x': 'urn:schemas-microsoft-com:office:excel',
          };
          VmlNotesXform.vmlCommentXform = new VmlNoteXform();
          module.exports = VmlNotesXform;
        },
        {
          '../../../utils/xml-stream': 24,
          '../base-xform': 28,
          './vml-note-xform': 37,
        },
      ],
      39: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var AppHeadingPairsXform = (module.exports = function() {});

          utils.inherits(AppHeadingPairsXform, BaseXform, {
            render: function render(xmlStream, model) {
              xmlStream.openNode('HeadingPairs');
              xmlStream.openNode('vt:vector', {
                size: 2,
                baseType: 'variant',
              });
              xmlStream.openNode('vt:variant');
              xmlStream.leafNode('vt:lpstr', undefined, 'Worksheets');
              xmlStream.closeNode();
              xmlStream.openNode('vt:variant');
              xmlStream.leafNode('vt:i4', undefined, model.length);
              xmlStream.closeNode();
              xmlStream.closeNode();
              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              // no parsing
              return node.name === 'HeadingPairs';
            },
            parseText: function parseText() {},
            parseClose: function parseClose(name) {
              return name !== 'HeadingPairs';
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      40: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var AppTitlesOfPartsXform = (module.exports = function() {});

          utils.inherits(AppTitlesOfPartsXform, BaseXform, {
            render: function render(xmlStream, model) {
              xmlStream.openNode('TitlesOfParts');
              xmlStream.openNode('vt:vector', {
                size: model.length,
                baseType: 'lpstr',
              });
              model.forEach(function(sheet) {
                xmlStream.leafNode('vt:lpstr', undefined, sheet.name);
              });
              xmlStream.closeNode();
              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              // no parsing
              return node.name === 'TitlesOfParts';
            },
            parseText: function parseText() {},
            parseClose: function parseClose(name) {
              return name !== 'TitlesOfParts';
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      41: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var XmlStream = require('../../../utils/xml-stream');

          var BaseXform = require('../base-xform');

          var StringXform = require('../simple/string-xform');

          var AppHeadingPairsXform = require('./app-heading-pairs-xform');

          var AppTitleOfPartsXform = require('./app-titles-of-parts-xform');

          var AppXform = (module.exports = function() {
            this.map = {
              Company: new StringXform({
                tag: 'Company',
              }),
              Manager: new StringXform({
                tag: 'Manager',
              }),
              HeadingPairs: new AppHeadingPairsXform(),
              TitleOfParts: new AppTitleOfPartsXform(),
            };
          });

          AppXform.DateFormat = function(dt) {
            return dt.toISOString().replace(/[.]\d{3,6}/, '');
          };

          AppXform.DateAttrs = {
            'xsi:type': 'dcterms:W3CDTF',
          };
          AppXform.PROPERTY_ATTRIBUTES = {
            xmlns:
              'http://schemas.openxmlformats.org/officeDocument/2006/extended-properties',
            'xmlns:vt':
              'http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes',
          };
          utils.inherits(AppXform, BaseXform, {
            render: function render(xmlStream, model) {
              xmlStream.openXml(XmlStream.StdDocAttributes);
              xmlStream.openNode('Properties', AppXform.PROPERTY_ATTRIBUTES);
              xmlStream.leafNode('Application', undefined, 'Microsoft Excel');
              xmlStream.leafNode('DocSecurity', undefined, '0');
              xmlStream.leafNode('ScaleCrop', undefined, 'false');
              this.map.HeadingPairs.render(xmlStream, model.worksheets);
              this.map.TitleOfParts.render(xmlStream, model.worksheets);
              this.map.Company.render(xmlStream, model.company || '');
              this.map.Manager.render(xmlStream, model.manager);
              xmlStream.leafNode('LinksUpToDate', undefined, 'false');
              xmlStream.leafNode('SharedDoc', undefined, 'false');
              xmlStream.leafNode('HyperlinksChanged', undefined, 'false');
              xmlStream.leafNode('AppVersion', undefined, '16.0300');
              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              switch (node.name) {
                case 'Properties':
                  return true;

                default:
                  this.parser = this.map[node.name];

                  if (this.parser) {
                    this.parser.parseOpen(node);
                    return true;
                  } // there's a lot we don't bother to parse

                  return false;
              }
            },
            parseText: function parseText(text) {
              if (this.parser) {
                this.parser.parseText(text);
              }
            },
            parseClose: function parseClose(name) {
              if (this.parser) {
                if (!this.parser.parseClose(name)) {
                  this.parser = undefined;
                }

                return true;
              }

              switch (name) {
                case 'Properties':
                  this.model = {
                    worksheets: this.map.TitleOfParts.model,
                    company: this.map.Company.model,
                    manager: this.map.Manager.model,
                  };
                  return false;

                default:
                  return true;
              }
            },
          });
        },
        {
          '../../../utils/utils': 23,
          '../../../utils/xml-stream': 24,
          '../base-xform': 28,
          '../simple/string-xform': 83,
          './app-heading-pairs-xform': 39,
          './app-titles-of-parts-xform': 40,
        },
      ],
      42: [
        function(require, module, exports) {
          'use strict';

          function _typeof(obj) {
            if (
              typeof Symbol === 'function' &&
              typeof Symbol.iterator === 'symbol'
            ) {
              _typeof = function _typeof(obj) {
                return typeof obj;
              };
            } else {
              _typeof = function _typeof(obj) {
                return obj &&
                  typeof Symbol === 'function' &&
                  obj.constructor === Symbol &&
                  obj !== Symbol.prototype
                  ? 'symbol'
                  : typeof obj;
              };
            }
            return _typeof(obj);
          }

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          function _possibleConstructorReturn(self, call) {
            if (
              call &&
              (_typeof(call) === 'object' || typeof call === 'function')
            ) {
              return call;
            }
            return _assertThisInitialized(self);
          }

          function _assertThisInitialized(self) {
            if (self === void 0) {
              throw new ReferenceError(
                "this hasn't been initialised - super() hasn't been called"
              );
            }
            return self;
          }

          function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf
              ? Object.getPrototypeOf
              : function _getPrototypeOf(o) {
                  return o.__proto__ || Object.getPrototypeOf(o);
                };
            return _getPrototypeOf(o);
          }

          function _inherits(subClass, superClass) {
            if (typeof superClass !== 'function' && superClass !== null) {
              throw new TypeError(
                'Super expression must either be null or a function'
              );
            }
            subClass.prototype = Object.create(
              superClass && superClass.prototype,
              {
                constructor: {
                  value: subClass,
                  writable: true,
                  configurable: true,
                },
              }
            );
            if (superClass) _setPrototypeOf(subClass, superClass);
          }

          function _setPrototypeOf(o, p) {
            _setPrototypeOf =
              Object.setPrototypeOf ||
              function _setPrototypeOf(o, p) {
                o.__proto__ = p;
                return o;
              };
            return _setPrototypeOf(o, p);
          }

          var XmlStream = require('../../../utils/xml-stream');

          var BaseXform = require('../base-xform'); // used for rendering the [Content_Types].xml file
          // not used for parsing

          var ContentTypesXform =
            /*#__PURE__*/
            (function(_BaseXform) {
              _inherits(ContentTypesXform, _BaseXform);

              function ContentTypesXform() {
                _classCallCheck(this, ContentTypesXform);

                return _possibleConstructorReturn(
                  this,
                  _getPrototypeOf(ContentTypesXform).apply(this, arguments)
                );
              }

              _createClass(ContentTypesXform, [
                {
                  key: 'render',
                  value: function render(xmlStream, model) {
                    xmlStream.openXml(XmlStream.StdDocAttributes);
                    xmlStream.openNode(
                      'Types',
                      ContentTypesXform.PROPERTY_ATTRIBUTES
                    );
                    var mediaHash = {};
                    (model.media || []).forEach(function(medium) {
                      if (medium.type === 'image') {
                        var imageType = medium.extension;

                        if (!mediaHash[imageType]) {
                          mediaHash[imageType] = true;
                          xmlStream.leafNode('Default', {
                            Extension: imageType,
                            ContentType: 'image/'.concat(imageType),
                          });
                        }
                      }
                    });
                    xmlStream.leafNode('Default', {
                      Extension: 'rels',
                      ContentType:
                        'application/vnd.openxmlformats-package.relationships+xml',
                    });
                    xmlStream.leafNode('Default', {
                      Extension: 'xml',
                      ContentType: 'application/xml',
                    });
                    xmlStream.leafNode('Override', {
                      PartName: '/xl/workbook.xml',
                      ContentType:
                        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml',
                    });
                    model.worksheets.forEach(function(worksheet) {
                      var name = '/xl/worksheets/sheet'.concat(
                        worksheet.id,
                        '.xml'
                      );
                      xmlStream.leafNode('Override', {
                        PartName: name,
                        ContentType:
                          'application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml',
                      });
                    });
                    xmlStream.leafNode('Override', {
                      PartName: '/xl/theme/theme1.xml',
                      ContentType:
                        'application/vnd.openxmlformats-officedocument.theme+xml',
                    });
                    xmlStream.leafNode('Override', {
                      PartName: '/xl/styles.xml',
                      ContentType:
                        'application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml',
                    });
                    var hasSharedStrings =
                      model.sharedStrings && model.sharedStrings.count;

                    if (hasSharedStrings) {
                      xmlStream.leafNode('Override', {
                        PartName: '/xl/sharedStrings.xml',
                        ContentType:
                          'application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml',
                      });
                    }

                    if (model.drawings) {
                      model.drawings.forEach(function(drawing) {
                        xmlStream.leafNode('Override', {
                          PartName: '/xl/drawings/'.concat(
                            drawing.name,
                            '.xml'
                          ),
                          ContentType:
                            'application/vnd.openxmlformats-officedocument.drawing+xml',
                        });
                      });
                    }

                    if (model.commentRefs) {
                      xmlStream.leafNode('Default', {
                        Extension: 'vml',
                        ContentType:
                          'application/vnd.openxmlformats-officedocument.vmlDrawing',
                      });
                      model.commentRefs.forEach(function(_ref) {
                        var commentName = _ref.commentName;
                        xmlStream.leafNode('Override', {
                          PartName: '/xl/'.concat(commentName, '.xml'),
                          ContentType:
                            'application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml',
                        });
                      });
                    }

                    xmlStream.leafNode('Override', {
                      PartName: '/docProps/core.xml',
                      ContentType:
                        'application/vnd.openxmlformats-package.core-properties+xml',
                    });
                    xmlStream.leafNode('Override', {
                      PartName: '/docProps/app.xml',
                      ContentType:
                        'application/vnd.openxmlformats-officedocument.extended-properties+xml',
                    });
                    xmlStream.closeNode();
                  },
                },
                {
                  key: 'parseOpen',
                  value: function parseOpen() {
                    return false;
                  },
                },
                {
                  key: 'parseText',
                  value: function parseText() {},
                },
                {
                  key: 'parseClose',
                  value: function parseClose() {
                    return false;
                  },
                },
              ]);

              return ContentTypesXform;
            })(BaseXform);

          ContentTypesXform.PROPERTY_ATTRIBUTES = {
            xmlns:
              'http://schemas.openxmlformats.org/package/2006/content-types',
          };
          module.exports = ContentTypesXform;
        },
        { '../../../utils/xml-stream': 24, '../base-xform': 28 },
      ],
      43: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var XmlStream = require('../../../utils/xml-stream');

          var BaseXform = require('../base-xform');

          var DateXform = require('../simple/date-xform');

          var StringXform = require('../simple/string-xform');

          var IntegerXform = require('../simple/integer-xform');

          var CoreXform = function CoreXform() {
            this.map = {
              'dc:creator': new StringXform({
                tag: 'dc:creator',
              }),
              'dc:title': new StringXform({
                tag: 'dc:title',
              }),
              'dc:subject': new StringXform({
                tag: 'dc:subject',
              }),
              'dc:description': new StringXform({
                tag: 'dc:description',
              }),
              'dc:identifier': new StringXform({
                tag: 'dc:identifier',
              }),
              'dc:language': new StringXform({
                tag: 'dc:language',
              }),
              'cp:keywords': new StringXform({
                tag: 'cp:keywords',
              }),
              'cp:category': new StringXform({
                tag: 'cp:category',
              }),
              'cp:lastModifiedBy': new StringXform({
                tag: 'cp:lastModifiedBy',
              }),
              'cp:lastPrinted': new DateXform({
                tag: 'cp:lastPrinted',
                format: CoreXform.DateFormat,
              }),
              'cp:revision': new IntegerXform({
                tag: 'cp:revision',
              }),
              'cp:version': new StringXform({
                tag: 'cp:version',
              }),
              'cp:contentStatus': new StringXform({
                tag: 'cp:contentStatus',
              }),
              'cp:contentType': new StringXform({
                tag: 'cp:contentType',
              }),
              'dcterms:created': new DateXform({
                tag: 'dcterms:created',
                attrs: CoreXform.DateAttrs,
                format: CoreXform.DateFormat,
              }),
              'dcterms:modified': new DateXform({
                tag: 'dcterms:modified',
                attrs: CoreXform.DateAttrs,
                format: CoreXform.DateFormat,
              }),
            };
          };

          CoreXform.DateFormat = function(dt) {
            return dt.toISOString().replace(/[.]\d{3}/, '');
          };

          CoreXform.DateAttrs = {
            'xsi:type': 'dcterms:W3CDTF',
          };
          CoreXform.CORE_PROPERTY_ATTRIBUTES = {
            'xmlns:cp':
              'http://schemas.openxmlformats.org/package/2006/metadata/core-properties',
            'xmlns:dc': 'http://purl.org/dc/elements/1.1/',
            'xmlns:dcterms': 'http://purl.org/dc/terms/',
            'xmlns:dcmitype': 'http://purl.org/dc/dcmitype/',
            'xmlns:xsi': 'http://www.w3.org/2001/XMLSchema-instance',
          };
          utils.inherits(CoreXform, BaseXform, {
            render: function render(xmlStream, model) {
              xmlStream.openXml(XmlStream.StdDocAttributes);
              xmlStream.openNode(
                'cp:coreProperties',
                CoreXform.CORE_PROPERTY_ATTRIBUTES
              );
              this.map['dc:creator'].render(xmlStream, model.creator);
              this.map['dc:title'].render(xmlStream, model.title);
              this.map['dc:subject'].render(xmlStream, model.subject);
              this.map['dc:description'].render(xmlStream, model.description);
              this.map['dc:identifier'].render(xmlStream, model.identifier);
              this.map['dc:language'].render(xmlStream, model.language);
              this.map['cp:keywords'].render(xmlStream, model.keywords);
              this.map['cp:category'].render(xmlStream, model.category);
              this.map['cp:lastModifiedBy'].render(
                xmlStream,
                model.lastModifiedBy
              );
              this.map['cp:lastPrinted'].render(xmlStream, model.lastPrinted);
              this.map['cp:revision'].render(xmlStream, model.revision);
              this.map['cp:version'].render(xmlStream, model.version);
              this.map['cp:contentStatus'].render(
                xmlStream,
                model.contentStatus
              );
              this.map['cp:contentType'].render(xmlStream, model.contentType);
              this.map['dcterms:created'].render(xmlStream, model.created);
              this.map['dcterms:modified'].render(xmlStream, model.modified);
              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              switch (node.name) {
                case 'cp:coreProperties':
                case 'coreProperties':
                  return true;

                default:
                  this.parser = this.map[node.name];

                  if (this.parser) {
                    this.parser.parseOpen(node);
                    return true;
                  }

                  throw new Error(
                    'Unexpected xml node in parseOpen: '.concat(
                      JSON.stringify(node)
                    )
                  );
              }
            },
            parseText: function parseText(text) {
              if (this.parser) {
                this.parser.parseText(text);
              }
            },
            parseClose: function parseClose(name) {
              if (this.parser) {
                if (!this.parser.parseClose(name)) {
                  this.parser = undefined;
                }

                return true;
              }

              switch (name) {
                case 'cp:coreProperties':
                case 'coreProperties':
                  this.model = {
                    creator: this.map['dc:creator'].model,
                    title: this.map['dc:title'].model,
                    subject: this.map['dc:subject'].model,
                    description: this.map['dc:description'].model,
                    identifier: this.map['dc:identifier'].model,
                    language: this.map['dc:language'].model,
                    keywords: this.map['cp:keywords'].model,
                    category: this.map['cp:category'].model,
                    lastModifiedBy: this.map['cp:lastModifiedBy'].model,
                    lastPrinted: this.map['cp:lastPrinted'].model,
                    revision: this.map['cp:revision'].model,
                    contentStatus: this.map['cp:contentStatus'].model,
                    contentType: this.map['cp:contentType'].model,
                    created: this.map['dcterms:created'].model,
                    modified: this.map['dcterms:modified'].model,
                  };
                  return false;

                default:
                  throw new Error(
                    'Unexpected xml node in parseClose: '.concat(name)
                  );
              }
            },
          });
          module.exports = CoreXform;
        },
        {
          '../../../utils/utils': 23,
          '../../../utils/xml-stream': 24,
          '../base-xform': 28,
          '../simple/date-xform': 81,
          '../simple/integer-xform': 82,
          '../simple/string-xform': 83,
        },
      ],
      44: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var RelationshipXform = (module.exports = function() {});

          utils.inherits(RelationshipXform, BaseXform, {
            render: function render(xmlStream, model) {
              xmlStream.leafNode('Relationship', model);
            },
            parseOpen: function parseOpen(node) {
              switch (node.name) {
                case 'Relationship':
                  this.model = node.attributes;
                  return true;

                default:
                  return false;
              }
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      45: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var XmlStream = require('../../../utils/xml-stream');

          var BaseXform = require('../base-xform');

          var RelationshipXform = require('./relationship-xform');

          var RelationshipsXform = (module.exports = function() {
            this.map = {
              Relationship: new RelationshipXform(),
            };
          });

          utils.inherits(
            RelationshipsXform,
            BaseXform,
            {
              RELATIONSHIPS_ATTRIBUTES: {
                xmlns:
                  'http://schemas.openxmlformats.org/package/2006/relationships',
              },
            },
            {
              render: function render(xmlStream, model) {
                model = model || this._values;
                xmlStream.openXml(XmlStream.StdDocAttributes);
                xmlStream.openNode(
                  'Relationships',
                  RelationshipsXform.RELATIONSHIPS_ATTRIBUTES
                );
                var self = this;
                model.forEach(function(relationship) {
                  self.map.Relationship.render(xmlStream, relationship);
                });
                xmlStream.closeNode();
              },
              parseOpen: function parseOpen(node) {
                if (this.parser) {
                  this.parser.parseOpen(node);
                  return true;
                }

                switch (node.name) {
                  case 'Relationships':
                    this.model = [];
                    return true;

                  default:
                    this.parser = this.map[node.name];

                    if (this.parser) {
                      this.parser.parseOpen(node);
                      return true;
                    }

                    throw new Error(
                      'Unexpected xml node in parseOpen: '.concat(
                        JSON.stringify(node)
                      )
                    );
                }
              },
              parseText: function parseText(text) {
                if (this.parser) {
                  this.parser.parseText(text);
                }
              },
              parseClose: function parseClose(name) {
                if (this.parser) {
                  if (!this.parser.parseClose(name)) {
                    this.model.push(this.parser.model);
                    this.parser = undefined;
                  }

                  return true;
                }

                switch (name) {
                  case 'Relationships':
                    return false;

                  default:
                    throw new Error(
                      'Unexpected xml node in parseClose: '.concat(name)
                    );
                }
              },
            }
          );
        },
        {
          '../../../utils/utils': 23,
          '../../../utils/xml-stream': 24,
          '../base-xform': 28,
          './relationship-xform': 44,
        },
      ],
      46: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var BaseCellAnchorXform = function BaseCellAnchorXform() {};

          utils.inherits(BaseCellAnchorXform, BaseXform, {
            parseOpen: function parseOpen(node) {
              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              switch (node.name) {
                case this.tag:
                  this.reset();
                  this.model = {
                    range: {
                      editAs: node.attributes.editAs || 'oneCell',
                    },
                  };
                  break;

                default:
                  this.parser = this.map[node.name];

                  if (this.parser) {
                    this.parser.parseOpen(node);
                  }

                  break;
              }

              return true;
            },
            parseText: function parseText(text) {
              if (this.parser) {
                this.parser.parseText(text);
              }
            },
            reconcilePicture: function reconcilePicture(model, options) {
              if (model && model.rId) {
                var rel = options.rels[model.rId];
                var match = rel.Target.match(/.*\/media\/(.+[.][a-z]{3,4})/);

                if (match) {
                  var name = match[1];
                  var mediaId = options.mediaIndex[name];
                  return options.media[mediaId];
                }
              }

              return undefined;
            },
          });
          module.exports = BaseCellAnchorXform;
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      47: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var BlipXform = require('./blip-xform');

          var BlipFillXform = (module.exports = function() {
            this.map = {
              'a:blip': new BlipXform(),
            };
          });

          utils.inherits(BlipFillXform, BaseXform, {
            get tag() {
              return 'xdr:blipFill';
            },

            render: function render(xmlStream, model) {
              xmlStream.openNode(this.tag);
              this.map['a:blip'].render(xmlStream, model); // TODO: options for this + parsing

              xmlStream.openNode('a:stretch');
              xmlStream.leafNode('a:fillRect');
              xmlStream.closeNode();
              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              switch (node.name) {
                case this.tag:
                  this.reset();
                  break;

                default:
                  this.parser = this.map[node.name];

                  if (this.parser) {
                    this.parser.parseOpen(node);
                  }

                  break;
              }

              return true;
            },
            parseText: function parseText() {},
            parseClose: function parseClose(name) {
              if (this.parser) {
                if (!this.parser.parseClose(name)) {
                  this.parser = undefined;
                }

                return true;
              }

              switch (name) {
                case this.tag:
                  this.model = this.map['a:blip'].model;
                  return false;

                default:
                  return true;
              }
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28, './blip-xform': 48 },
      ],
      48: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var BlipXform = (module.exports = function() {});

          utils.inherits(BlipXform, BaseXform, {
            get tag() {
              return 'a:blip';
            },

            render: function render(xmlStream, model) {
              xmlStream.leafNode(this.tag, {
                'xmlns:r':
                  'http://schemas.openxmlformats.org/officeDocument/2006/relationships',
                'r:embed': model.rId,
                cstate: 'print',
              }); // TODO: handle children (e.g. a:extLst=>a:ext=>a14:useLocalDpi
            },
            parseOpen: function parseOpen(node) {
              switch (node.name) {
                case this.tag:
                  this.model = {
                    rId: node.attributes['r:embed'],
                  };
                  return true;

                default:
                  return true;
              }
            },
            parseText: function parseText() {},
            parseClose: function parseClose(name) {
              switch (name) {
                case this.tag:
                  return false;

                default:
                  // unprocessed internal nodes
                  return true;
              }
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      49: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var IntegerXform = require('../simple/integer-xform');

          var CellPositionXform = (module.exports = function(options) {
            this.tag = options.tag;
            this.map = {
              'xdr:col': new IntegerXform({
                tag: 'xdr:col',
                zero: true,
              }),
              'xdr:colOff': new IntegerXform({
                tag: 'xdr:colOff',
                zero: true,
              }),
              'xdr:row': new IntegerXform({
                tag: 'xdr:row',
                zero: true,
              }),
              'xdr:rowOff': new IntegerXform({
                tag: 'xdr:rowOff',
                zero: true,
              }),
            };
          });

          utils.inherits(CellPositionXform, BaseXform, {
            render: function render(xmlStream, model) {
              xmlStream.openNode(this.tag);
              this.map['xdr:col'].render(xmlStream, model.nativeCol);
              this.map['xdr:colOff'].render(xmlStream, model.nativeColOff);
              this.map['xdr:row'].render(xmlStream, model.nativeRow);
              this.map['xdr:rowOff'].render(xmlStream, model.nativeRowOff);
              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              switch (node.name) {
                case this.tag:
                  this.reset();
                  break;

                default:
                  this.parser = this.map[node.name];

                  if (this.parser) {
                    this.parser.parseOpen(node);
                  }

                  break;
              }

              return true;
            },
            parseText: function parseText(text) {
              if (this.parser) {
                this.parser.parseText(text);
              }
            },
            parseClose: function parseClose(name) {
              if (this.parser) {
                if (!this.parser.parseClose(name)) {
                  this.parser = undefined;
                }

                return true;
              }

              switch (name) {
                case this.tag:
                  this.model = {
                    nativeCol: this.map['xdr:col'].model,
                    nativeColOff: this.map['xdr:colOff'].model,
                    nativeRow: this.map['xdr:row'].model,
                    nativeRowOff: this.map['xdr:rowOff'].model,
                  };
                  return false;

                default:
                  // not quite sure how we get here!
                  return true;
              }
            },
          });
        },
        {
          '../../../utils/utils': 23,
          '../base-xform': 28,
          '../simple/integer-xform': 82,
        },
      ],
      50: [
        function(require, module, exports) {
          'use strict';

          function _typeof(obj) {
            if (
              typeof Symbol === 'function' &&
              typeof Symbol.iterator === 'symbol'
            ) {
              _typeof = function _typeof(obj) {
                return typeof obj;
              };
            } else {
              _typeof = function _typeof(obj) {
                return obj &&
                  typeof Symbol === 'function' &&
                  obj.constructor === Symbol &&
                  obj !== Symbol.prototype
                  ? 'symbol'
                  : typeof obj;
              };
            }
            return _typeof(obj);
          }

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          function _possibleConstructorReturn(self, call) {
            if (
              call &&
              (_typeof(call) === 'object' || typeof call === 'function')
            ) {
              return call;
            }
            return _assertThisInitialized(self);
          }

          function _assertThisInitialized(self) {
            if (self === void 0) {
              throw new ReferenceError(
                "this hasn't been initialised - super() hasn't been called"
              );
            }
            return self;
          }

          function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf
              ? Object.getPrototypeOf
              : function _getPrototypeOf(o) {
                  return o.__proto__ || Object.getPrototypeOf(o);
                };
            return _getPrototypeOf(o);
          }

          function _inherits(subClass, superClass) {
            if (typeof superClass !== 'function' && superClass !== null) {
              throw new TypeError(
                'Super expression must either be null or a function'
              );
            }
            subClass.prototype = Object.create(
              superClass && superClass.prototype,
              {
                constructor: {
                  value: subClass,
                  writable: true,
                  configurable: true,
                },
              }
            );
            if (superClass) _setPrototypeOf(subClass, superClass);
          }

          function _setPrototypeOf(o, p) {
            _setPrototypeOf =
              Object.setPrototypeOf ||
              function _setPrototypeOf(o, p) {
                o.__proto__ = p;
                return o;
              };
            return _setPrototypeOf(o, p);
          }

          var colCache = require('../../../utils/col-cache');

          var XmlStream = require('../../../utils/xml-stream');

          var BaseXform = require('../base-xform');

          var TwoCellAnchorXform = require('./two-cell-anchor-xform');

          var OneCellAnchorXform = require('./one-cell-anchor-xform');

          function getAnchorType(model) {
            var range =
              typeof model.range === 'string'
                ? colCache.decode(model.range)
                : model.range;
            return range.br ? 'xdr:twoCellAnchor' : 'xdr:oneCellAnchor';
          }

          var DrawingXform =
            /*#__PURE__*/
            (function(_BaseXform) {
              _inherits(DrawingXform, _BaseXform);

              function DrawingXform() {
                var _this;

                _classCallCheck(this, DrawingXform);

                _this = _possibleConstructorReturn(
                  this,
                  _getPrototypeOf(DrawingXform).call(this)
                );
                _this.map = {
                  'xdr:twoCellAnchor': new TwoCellAnchorXform(),
                  'xdr:oneCellAnchor': new OneCellAnchorXform(),
                };
                return _this;
              }

              _createClass(DrawingXform, [
                {
                  key: 'prepare',
                  value: function prepare(model) {
                    var _this2 = this;

                    model.anchors.forEach(function(item, index) {
                      item.anchorType = getAnchorType(item);
                      var anchor = _this2.map[item.anchorType];
                      anchor.prepare(item, {
                        index: index,
                      });
                    });
                  },
                },
                {
                  key: 'render',
                  value: function render(xmlStream, model) {
                    var _this3 = this;

                    xmlStream.openXml(XmlStream.StdDocAttributes);
                    xmlStream.openNode(
                      this.tag,
                      DrawingXform.DRAWING_ATTRIBUTES
                    );
                    model.anchors.forEach(function(item) {
                      var anchor = _this3.map[item.anchorType];
                      anchor.render(xmlStream, item);
                    });
                    xmlStream.closeNode();
                  },
                },
                {
                  key: 'parseOpen',
                  value: function parseOpen(node) {
                    if (this.parser) {
                      this.parser.parseOpen(node);
                      return true;
                    }

                    switch (node.name) {
                      case this.tag:
                        this.reset();
                        this.model = {
                          anchors: [],
                        };
                        break;

                      default:
                        this.parser = this.map[node.name];

                        if (this.parser) {
                          this.parser.parseOpen(node);
                        }

                        break;
                    }

                    return true;
                  },
                },
                {
                  key: 'parseText',
                  value: function parseText(text) {
                    if (this.parser) {
                      this.parser.parseText(text);
                    }
                  },
                },
                {
                  key: 'parseClose',
                  value: function parseClose(name) {
                    if (this.parser) {
                      if (!this.parser.parseClose(name)) {
                        this.model.anchors.push(this.parser.model);
                        this.parser = undefined;
                      }

                      return true;
                    }

                    switch (name) {
                      case this.tag:
                        return false;

                      default:
                        // could be some unrecognised tags
                        return true;
                    }
                  },
                },
                {
                  key: 'reconcile',
                  value: function reconcile(model, options) {
                    var _this4 = this;

                    model.anchors.forEach(function(anchor) {
                      if (anchor.br) {
                        _this4.map['xdr:twoCellAnchor'].reconcile(
                          anchor,
                          options
                        );
                      } else {
                        _this4.map['xdr:oneCellAnchor'].reconcile(
                          anchor,
                          options
                        );
                      }
                    });
                  },
                },
                {
                  key: 'tag',
                  get: function get() {
                    return 'xdr:wsDr';
                  },
                },
              ]);

              return DrawingXform;
            })(BaseXform);

          DrawingXform.DRAWING_ATTRIBUTES = {
            'xmlns:xdr':
              'http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing',
            'xmlns:a': 'http://schemas.openxmlformats.org/drawingml/2006/main',
          };
          module.exports = DrawingXform;
        },
        {
          '../../../utils/col-cache': 17,
          '../../../utils/xml-stream': 24,
          '../base-xform': 28,
          './one-cell-anchor-xform': 53,
          './two-cell-anchor-xform': 56,
        },
      ],
      51: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var ExtXform = (module.exports = function(options) {
            this.tag = options.tag;
            this.map = {};
          });
          /** https://en.wikipedia.org/wiki/Office_Open_XML_file_formats#DrawingML */

          var EMU_PER_PIXEL_AT_96_DPI = 9525;
          utils.inherits(ExtXform, BaseXform, {
            render: function render(xmlStream, model) {
              xmlStream.openNode(this.tag);
              var width = Math.floor(model.width * EMU_PER_PIXEL_AT_96_DPI);
              var height = Math.floor(model.height * EMU_PER_PIXEL_AT_96_DPI);
              xmlStream.addAttribute('cx', width);
              xmlStream.addAttribute('cy', height);
              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              if (node.name === this.tag) {
                this.model = {
                  width:
                    parseInt(node.attributes.cx || '0', 10) /
                    EMU_PER_PIXEL_AT_96_DPI,
                  height:
                    parseInt(node.attributes.cy || '0', 10) /
                    EMU_PER_PIXEL_AT_96_DPI,
                };
                return true;
              }

              return false;
            },
            parseText: function parseText() /* text */
            {},
            parseClose: function parseClose() /* name */
            {
              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      52: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var StaticXform = require('../static-xform');

          var NvPicPrXform = (module.exports = function() {});

          utils.inherits(NvPicPrXform, BaseXform, {
            get tag() {
              return 'xdr:nvPicPr';
            },

            render: function render(xmlStream, model) {
              var xform = new StaticXform({
                tag: this.tag,
                c: [
                  {
                    tag: 'xdr:cNvPr',
                    $: {
                      id: model.index,
                      name: 'Picture '.concat(model.index),
                    },
                    c: [
                      {
                        tag: 'a:extLst',
                        c: [
                          {
                            tag: 'a:ext',
                            $: {
                              uri: '{FF2B5EF4-FFF2-40B4-BE49-F238E27FC236}',
                            },
                            c: [
                              {
                                tag: 'a16:creationId',
                                $: {
                                  'xmlns:a16':
                                    'http://schemas.microsoft.com/office/drawing/2014/main',
                                  id: '{00000000-0008-0000-0000-000002000000}',
                                },
                              },
                            ],
                          },
                        ],
                      },
                    ],
                  },
                  {
                    tag: 'xdr:cNvPicPr',
                    c: [
                      {
                        tag: 'a:picLocks',
                        $: {
                          noChangeAspect: '1',
                        },
                      },
                    ],
                  },
                ],
              });
              xform.render(xmlStream);
            },
          });
        },
        {
          '../../../utils/utils': 23,
          '../base-xform': 28,
          '../static-xform': 84,
        },
      ],
      53: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseCellAnchorXform = require('./base-cell-anchor-xform');

          var StaticXform = require('../static-xform');

          var CellPositionXform = require('./cell-position-xform');

          var ExtXform = require('./ext-xform');

          var PicXform = require('./pic-xform');

          var OneCellAnchorXform = function OneCellAnchorXform() {
            this.map = {
              'xdr:from': new CellPositionXform({
                tag: 'xdr:from',
              }),
              'xdr:ext': new ExtXform({
                tag: 'xdr:ext',
              }),
              'xdr:pic': new PicXform(),
              'xdr:clientData': new StaticXform({
                tag: 'xdr:clientData',
              }),
            };
          };

          utils.inherits(OneCellAnchorXform, BaseCellAnchorXform, {
            get tag() {
              return 'xdr:oneCellAnchor';
            },

            prepare: function prepare(model, options) {
              this.map['xdr:pic'].prepare(model.picture, options);
            },
            render: function render(xmlStream, model) {
              xmlStream.openNode(this.tag, {
                editAs: model.range.editAs || 'oneCell',
              });
              this.map['xdr:from'].render(xmlStream, model.range.tl);
              this.map['xdr:ext'].render(xmlStream, model.range.ext);
              this.map['xdr:pic'].render(xmlStream, model.picture);
              this.map['xdr:clientData'].render(xmlStream, {});
              xmlStream.closeNode();
            },
            parseClose: function parseClose(name) {
              if (this.parser) {
                if (!this.parser.parseClose(name)) {
                  this.parser = undefined;
                }

                return true;
              }

              switch (name) {
                case this.tag:
                  this.model.range.tl = this.map['xdr:from'].model;
                  this.model.range.ext = this.map['xdr:ext'].model;
                  this.model.picture = this.map['xdr:pic'].model;
                  return false;

                default:
                  // could be some unrecognised tags
                  return true;
              }
            },
            reconcile: function reconcile(model, options) {
              model.medium = this.reconcilePicture(model.picture, options);
            },
          });
          module.exports = OneCellAnchorXform;
        },
        {
          '../../../utils/utils': 23,
          '../static-xform': 84,
          './base-cell-anchor-xform': 46,
          './cell-position-xform': 49,
          './ext-xform': 51,
          './pic-xform': 54,
        },
      ],
      54: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var StaticXform = require('../static-xform');

          var BlipFillXform = require('./blip-fill-xform');

          var NvPicPrXform = require('./nv-pic-pr-xform');

          var spPrJSON = require('./sp-pr');

          var PicXform = (module.exports = function() {
            this.map = {
              'xdr:nvPicPr': new NvPicPrXform(),
              'xdr:blipFill': new BlipFillXform(),
              'xdr:spPr': new StaticXform(spPrJSON),
            };
          });

          utils.inherits(PicXform, BaseXform, {
            get tag() {
              return 'xdr:pic';
            },

            prepare: function prepare(model, options) {
              model.index = options.index + 1;
            },
            render: function render(xmlStream, model) {
              xmlStream.openNode(this.tag);
              this.map['xdr:nvPicPr'].render(xmlStream, model);
              this.map['xdr:blipFill'].render(xmlStream, model);
              this.map['xdr:spPr'].render(xmlStream, model);
              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              switch (node.name) {
                case this.tag:
                  this.reset();
                  break;

                default:
                  this.parser = this.map[node.name];

                  if (this.parser) {
                    this.parser.parseOpen(node);
                  }

                  break;
              }

              return true;
            },
            parseText: function parseText() {},
            parseClose: function parseClose(name) {
              if (this.parser) {
                if (!this.parser.parseClose(name)) {
                  this.mergeModel(this.parser.model);
                  this.parser = undefined;
                }

                return true;
              }

              switch (name) {
                case this.tag:
                  return false;

                default:
                  // not quite sure how we get here!
                  return true;
              }
            },
          });
        },
        {
          '../../../utils/utils': 23,
          '../base-xform': 28,
          '../static-xform': 84,
          './blip-fill-xform': 47,
          './nv-pic-pr-xform': 52,
          './sp-pr': 55,
        },
      ],
      55: [
        function(require, module, exports) {
          'use strict';

          module.exports = {
            tag: 'xdr:spPr',
            c: [
              {
                tag: 'a:xfrm',
                c: [
                  {
                    tag: 'a:off',
                    $: {
                      x: '0',
                      y: '0',
                    },
                  },
                  {
                    tag: 'a:ext',
                    $: {
                      cx: '0',
                      cy: '0',
                    },
                  },
                ],
              },
              {
                tag: 'a:prstGeom',
                $: {
                  prst: 'rect',
                },
                c: [
                  {
                    tag: 'a:avLst',
                  },
                ],
              },
            ],
          };
        },
        {},
      ],
      56: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseCellAnchorXform = require('./base-cell-anchor-xform');

          var StaticXform = require('../static-xform');

          var CellPositionXform = require('./cell-position-xform');

          var PicXform = require('./pic-xform');

          var TwoCellAnchorXform = function TwoCellAnchorXform() {
            this.map = {
              'xdr:from': new CellPositionXform({
                tag: 'xdr:from',
              }),
              'xdr:to': new CellPositionXform({
                tag: 'xdr:to',
              }),
              'xdr:pic': new PicXform(),
              'xdr:clientData': new StaticXform({
                tag: 'xdr:clientData',
              }),
            };
          };

          utils.inherits(TwoCellAnchorXform, BaseCellAnchorXform, {
            get tag() {
              return 'xdr:twoCellAnchor';
            },

            prepare: function prepare(model, options) {
              this.map['xdr:pic'].prepare(model.picture, options);
            },
            render: function render(xmlStream, model) {
              xmlStream.openNode(this.tag, {
                editAs: model.range.editAs || 'oneCell',
              });
              this.map['xdr:from'].render(xmlStream, model.range.tl);
              this.map['xdr:to'].render(xmlStream, model.range.br);
              this.map['xdr:pic'].render(xmlStream, model.picture);
              this.map['xdr:clientData'].render(xmlStream, {});
              xmlStream.closeNode();
            },
            parseClose: function parseClose(name) {
              if (this.parser) {
                if (!this.parser.parseClose(name)) {
                  this.parser = undefined;
                }

                return true;
              }

              switch (name) {
                case this.tag:
                  this.model.range.tl = this.map['xdr:from'].model;
                  this.model.range.br = this.map['xdr:to'].model;
                  this.model.picture = this.map['xdr:pic'].model;
                  return false;

                default:
                  // could be some unrecognised tags
                  return true;
              }
            },
            reconcile: function reconcile(model, options) {
              model.medium = this.reconcilePicture(model.picture, options);
            },
          });
          module.exports = TwoCellAnchorXform;
        },
        {
          '../../../utils/utils': 23,
          '../static-xform': 84,
          './base-cell-anchor-xform': 46,
          './cell-position-xform': 49,
          './pic-xform': 54,
        },
      ],
      57: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../utils/utils');

          var BaseXform = require('./base-xform');

          var ListXform = (module.exports = function(options) {
            this.tag = options.tag;
            this.count = options.count;
            this.empty = options.empty;
            this.$count = options.$count || 'count';
            this.$ = options.$;
            this.childXform = options.childXform;
            this.maxItems = options.maxItems;
          });

          utils.inherits(ListXform, BaseXform, {
            prepare: function prepare(model, options) {
              var childXform = this.childXform;

              if (model) {
                model.forEach(function(childModel) {
                  childXform.prepare(childModel, options);
                });
              }
            },
            render: function render(xmlStream, model) {
              if (model && model.length) {
                xmlStream.openNode(this.tag, this.$);

                if (this.count) {
                  xmlStream.addAttribute(this.$count, model.length);
                }

                var childXform = this.childXform;
                model.forEach(function(childModel) {
                  childXform.render(xmlStream, childModel);
                });
                xmlStream.closeNode();
              } else if (this.empty) {
                xmlStream.leafNode(this.tag);
              }
            },
            parseOpen: function parseOpen(node) {
              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              switch (node.name) {
                case this.tag:
                  this.model = [];
                  return true;

                default:
                  if (this.childXform.parseOpen(node)) {
                    this.parser = this.childXform;
                    return true;
                  }

                  return false;
              }
            },
            parseText: function parseText(text) {
              if (this.parser) {
                this.parser.parseText(text);
              }
            },
            parseClose: function parseClose(name) {
              if (this.parser) {
                if (!this.parser.parseClose(name)) {
                  this.model.push(this.parser.model);
                  this.parser = undefined;

                  if (this.maxItems && this.model.length > this.maxItems) {
                    throw new Error(
                      'Max '.concat(this.childXform.tag, ' count exceeded')
                    );
                  }
                }

                return true;
              }

              return false;
            },
            reconcile: function reconcile(model, options) {
              if (model) {
                var childXform = this.childXform;
                model.forEach(function(childModel) {
                  childXform.reconcile(childModel, options);
                });
              }
            },
          });
        },
        { '../../utils/utils': 23, './base-xform': 28 },
      ],
      58: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var colCache = require('../../../utils/col-cache');

          var BaseXform = require('../base-xform');

          var AutoFilterXform = (module.exports = function() {});

          utils.inherits(AutoFilterXform, BaseXform, {
            get tag() {
              return 'autoFilter';
            },

            render: function render(xmlStream, model) {
              if (model) {
                if (typeof model === 'string') {
                  // assume range
                  xmlStream.leafNode('autoFilter', {
                    ref: model,
                  });
                } else {
                  var getAddress = function getAddress(addr) {
                    if (typeof addr === 'string') {
                      return addr;
                    }

                    return colCache.getAddress(addr.row, addr.column).address;
                  };

                  var firstAddress = getAddress(model.from);
                  var secondAddress = getAddress(model.to);

                  if (firstAddress && secondAddress) {
                    xmlStream.leafNode('autoFilter', {
                      ref: ''.concat(firstAddress, ':').concat(secondAddress),
                    });
                  }
                }
              }
            },
            parseOpen: function parseOpen(node) {
              if (node.name === 'autoFilter') {
                this.model = node.attributes.ref;
              }
            },
          });
        },
        {
          '../../../utils/col-cache': 17,
          '../../../utils/utils': 23,
          '../base-xform': 28,
        },
      ],
      59: [
        function(require, module, exports) {
          'use strict';

          function _objectSpread(target) {
            for (var i = 1; i < arguments.length; i++) {
              var source = arguments[i] != null ? arguments[i] : {};
              var ownKeys = Object.keys(source);
              if (typeof Object.getOwnPropertySymbols === 'function') {
                ownKeys = ownKeys.concat(
                  Object.getOwnPropertySymbols(source).filter(function(sym) {
                    return Object.getOwnPropertyDescriptor(
                      source,
                      sym
                    ).enumerable;
                  })
                );
              }
              ownKeys.forEach(function(key) {
                _defineProperty(target, key, source[key]);
              });
            }
            return target;
          }

          function _defineProperty(obj, key, value) {
            if (key in obj) {
              Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true,
              });
            } else {
              obj[key] = value;
            }
            return obj;
          }

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var Enums = require('../../../doc/enums');

          var Range = require('../../../doc/range');

          var RichTextXform = require('../strings/rich-text-xform');

          function getValueType(v) {
            if (v === null || v === undefined) {
              return Enums.ValueType.Null;
            }

            if (v instanceof String || typeof v === 'string') {
              return Enums.ValueType.String;
            }

            if (typeof v === 'number') {
              return Enums.ValueType.Number;
            }

            if (typeof v === 'boolean') {
              return Enums.ValueType.Boolean;
            }

            if (v instanceof Date) {
              return Enums.ValueType.Date;
            }

            if (v.text && v.hyperlink) {
              return Enums.ValueType.Hyperlink;
            }

            if (v.formula) {
              return Enums.ValueType.Formula;
            }

            if (v.error) {
              return Enums.ValueType.Error;
            }

            throw new Error('I could not understand type of value');
          }

          function getEffectiveCellType(cell) {
            switch (cell.type) {
              case Enums.ValueType.Formula:
                return getValueType(cell.result);

              default:
                return cell.type;
            }
          }

          var CellXform = (module.exports = function() {
            this.richTextXForm = new RichTextXform();
          });

          utils.inherits(CellXform, BaseXform, {
            get tag() {
              return 'c';
            },

            prepare: function prepare(model, options) {
              var styleId = options.styles.addStyleModel(
                model.style || {},
                getEffectiveCellType(model)
              );

              if (styleId) {
                model.styleId = styleId;
              }

              if (model.comment) {
                options.comments.push(
                  _objectSpread({}, model.comment, {
                    ref: model.address,
                  })
                );
              }

              switch (model.type) {
                case Enums.ValueType.String:
                  if (options.sharedStrings) {
                    model.ssId = options.sharedStrings.add(model.value);
                  }

                  break;

                case Enums.ValueType.Date:
                  if (options.date1904) {
                    model.date1904 = true;
                  }

                  break;

                case Enums.ValueType.Hyperlink:
                  if (options.sharedStrings) {
                    model.ssId = options.sharedStrings.add(model.text);
                  }

                  options.hyperlinks.push(
                    Object.assign(
                      {
                        address: model.address,
                        target: model.hyperlink,
                      },
                      model.tooltip
                        ? {
                            tooltip: model.tooltip,
                          }
                        : {}
                    )
                  );
                  break;

                case Enums.ValueType.Merge:
                  options.merges.add(model);
                  break;

                case Enums.ValueType.Formula:
                  if (options.date1904) {
                    // in case valueType is date
                    model.date1904 = true;
                  }

                  if (model.formula) {
                    options.formulae[model.address] = model;
                  } else if (model.sharedFormula) {
                    var master = options.formulae[model.sharedFormula];

                    if (!master) {
                      throw new Error(
                        'Shared Formula master must exist above and or left of clone'
                      );
                    }

                    if (master.si !== undefined) {
                      model.si = master.si;
                      master.ref.expandToAddress(model.address);
                    } else {
                      model.si = master.si = options.siFormulae++;
                      master.ref = new Range(master.address, model.address);
                    }
                  }

                  break;

                default:
                  break;
              }
            },
            renderFormula: function renderFormula(xmlStream, model) {
              var attrs = null;

              if (model.ref) {
                attrs = {
                  t: 'shared',
                  ref: model.ref.range,
                  si: model.si,
                };
              } else if (model.si !== undefined) {
                attrs = {
                  t: 'shared',
                  si: model.si,
                };
              }

              switch (getValueType(model.result)) {
                case Enums.ValueType.Null:
                  // ?
                  xmlStream.leafNode('f', attrs, model.formula);
                  break;

                case Enums.ValueType.String:
                  // oddly, formula results don't ever use shared strings
                  xmlStream.addAttribute('t', 'str');
                  xmlStream.leafNode('f', attrs, model.formula);
                  xmlStream.leafNode('v', null, model.result);
                  break;

                case Enums.ValueType.Number:
                  xmlStream.leafNode('f', attrs, model.formula);
                  xmlStream.leafNode('v', null, model.result);
                  break;

                case Enums.ValueType.Boolean:
                  xmlStream.addAttribute('t', 'b');
                  xmlStream.leafNode('f', attrs, model.formula);
                  xmlStream.leafNode('v', null, model.result ? 1 : 0);
                  break;

                case Enums.ValueType.Error:
                  xmlStream.addAttribute('t', 'e');
                  xmlStream.leafNode('f', attrs, model.formula);
                  xmlStream.leafNode('v', null, model.result.error);
                  break;

                case Enums.ValueType.Date:
                  xmlStream.leafNode('f', attrs, model.formula);
                  xmlStream.leafNode(
                    'v',
                    null,
                    utils.dateToExcel(model.result, model.date1904)
                  );
                  break;
                // case Enums.ValueType.Hyperlink: // ??
                // case Enums.ValueType.Formula:

                default:
                  throw new Error('I could not understand type of value');
              }
            },
            render: function render(xmlStream, model) {
              if (model.type === Enums.ValueType.Null && !model.styleId) {
                // if null and no style, exit
                return;
              }

              xmlStream.openNode('c');
              xmlStream.addAttribute('r', model.address);

              if (model.styleId) {
                xmlStream.addAttribute('s', model.styleId);
              }

              switch (model.type) {
                case Enums.ValueType.Null:
                  break;

                case Enums.ValueType.Number:
                  xmlStream.leafNode('v', null, model.value);
                  break;

                case Enums.ValueType.Boolean:
                  xmlStream.addAttribute('t', 'b');
                  xmlStream.leafNode('v', null, model.value ? '1' : '0');
                  break;

                case Enums.ValueType.Error:
                  xmlStream.addAttribute('t', 'e');
                  xmlStream.leafNode('v', null, model.value.error);
                  break;

                case Enums.ValueType.String:
                  if (model.ssId !== undefined) {
                    xmlStream.addAttribute('t', 's');
                    xmlStream.leafNode('v', null, model.ssId);
                  } else if (model.value && model.value.richText) {
                    xmlStream.addAttribute('t', 'inlineStr');
                    xmlStream.openNode('is');
                    var self = this;
                    model.value.richText.forEach(function(text) {
                      self.richTextXForm.render(xmlStream, text);
                    });
                    xmlStream.closeNode('is');
                  } else {
                    xmlStream.addAttribute('t', 'str');
                    xmlStream.leafNode('v', null, model.value);
                  }

                  break;

                case Enums.ValueType.Date:
                  xmlStream.leafNode(
                    'v',
                    null,
                    utils.dateToExcel(model.value, model.date1904)
                  );
                  break;

                case Enums.ValueType.Hyperlink:
                  if (model.ssId !== undefined) {
                    xmlStream.addAttribute('t', 's');
                    xmlStream.leafNode('v', null, model.ssId);
                  } else {
                    xmlStream.addAttribute('t', 'str');
                    xmlStream.leafNode('v', null, model.text);
                  }

                  break;

                case Enums.ValueType.Formula:
                  this.renderFormula(xmlStream, model);
                  break;

                case Enums.ValueType.Merge:
                  // nothing to add
                  break;

                default:
                  break;
              }

              xmlStream.closeNode(); // </c>
            },
            parseOpen: function parseOpen(node) {
              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              switch (node.name) {
                case 'c':
                  // const address = colCache.decodeAddress(node.attributes.r);
                  this.model = {
                    address: node.attributes.r,
                  };
                  this.t = node.attributes.t;

                  if (node.attributes.s) {
                    this.model.styleId = parseInt(node.attributes.s, 10);
                  }

                  return true;

                case 'f':
                  this.currentNode = 'f';
                  this.model.si = node.attributes.si;

                  if (node.attributes.t === 'shared') {
                    this.model.sharedFormula = true;
                  }

                  this.model.ref = node.attributes.ref;
                  return true;

                case 'v':
                  this.currentNode = 'v';
                  return true;

                case 't':
                  this.currentNode = 't';
                  return true;

                case 'r':
                  this.parser = this.richTextXForm;
                  this.parser.parseOpen(node);
                  return true;

                default:
                  return false;
              }
            },
            parseText: function parseText(text) {
              if (this.parser) {
                this.parser.parseText(text);
                return;
              }

              switch (this.currentNode) {
                case 'f':
                  this.model.formula = this.model.formula
                    ? this.model.formula + text
                    : text;
                  break;

                case 'v':
                case 't':
                  if (this.model.value && this.model.value.richText) {
                    this.model.value.richText.text = this.model.value.richText
                      .text
                      ? this.model.value.richText.text + text
                      : text;
                  } else {
                    this.model.value = this.model.value
                      ? this.model.value + text
                      : text;
                  }

                  break;

                default:
                  break;
              }
            },
            parseClose: function parseClose(name) {
              switch (name) {
                case 'c': {
                  var model = this.model; // first guess on cell type

                  if (model.formula || model.sharedFormula) {
                    model.type = Enums.ValueType.Formula;

                    if (model.value) {
                      if (this.t === 'str') {
                        model.result = utils.xmlDecode(model.value);
                      } else if (this.t === 'b') {
                        model.result = parseInt(model.value, 10) !== 0;
                      } else if (this.t === 'e') {
                        model.result = {
                          error: model.value,
                        };
                      } else {
                        model.result = parseFloat(model.value);
                      }

                      model.value = undefined;
                    }
                  } else if (model.value !== undefined) {
                    switch (this.t) {
                      case 's':
                        model.type = Enums.ValueType.String;
                        model.value = parseInt(model.value, 10);
                        break;

                      case 'str':
                        model.type = Enums.ValueType.String;
                        model.value = utils.xmlDecode(model.value);
                        break;

                      case 'inlineStr':
                        model.type = Enums.ValueType.String;
                        break;

                      case 'b':
                        model.type = Enums.ValueType.Boolean;
                        model.value = parseInt(model.value, 10) !== 0;
                        break;

                      case 'e':
                        model.type = Enums.ValueType.Error;
                        model.value = {
                          error: model.value,
                        };
                        break;

                      default:
                        model.type = Enums.ValueType.Number;
                        model.value = parseFloat(model.value);
                        break;
                    }
                  } else if (model.styleId) {
                    model.type = Enums.ValueType.Null;
                  } else {
                    model.type = Enums.ValueType.Merge;
                  }

                  return false;
                }

                case 'f':
                case 'v':
                case 'is':
                  this.currentNode = undefined;
                  return true;

                case 't':
                  if (this.parser) {
                    this.parser.parseClose(name);
                    return true;
                  }

                  this.currentNode = undefined;
                  return true;

                case 'r':
                  this.model.value = this.model.value || {};
                  this.model.value.richText = this.model.value.richText || [];
                  this.model.value.richText.push(this.parser.model);
                  this.parser = undefined;
                  this.currentNode = undefined;
                  return true;

                default:
                  if (this.parser) {
                    this.parser.parseClose(name);
                    return true;
                  }

                  return false;
              }
            },
            reconcile: function reconcile(model, options) {
              var style =
                model.styleId &&
                options.styles &&
                options.styles.getStyleModel(model.styleId);

              if (style) {
                model.style = style;
              }

              if (model.styleId !== undefined) {
                model.styleId = undefined;
              }

              switch (model.type) {
                case Enums.ValueType.String:
                  if (typeof model.value === 'number') {
                    if (options.sharedStrings) {
                      model.value = options.sharedStrings.getString(
                        model.value
                      );
                    }
                  }

                  if (model.value.richText) {
                    model.type = Enums.ValueType.RichText;
                  }

                  break;

                case Enums.ValueType.Number:
                  if (style && utils.isDateFmt(style.numFmt)) {
                    model.type = Enums.ValueType.Date;
                    model.value = utils.excelToDate(
                      model.value,
                      options.date1904
                    );
                  }

                  break;

                case Enums.ValueType.Formula:
                  if (
                    model.result !== undefined &&
                    style &&
                    utils.isDateFmt(style.numFmt)
                  ) {
                    model.result = utils.excelToDate(
                      model.result,
                      options.date1904
                    );
                  }

                  if (model.sharedFormula) {
                    if (model.formula) {
                      options.formulae[model.si] = model;
                      delete model.sharedFormula;
                    } else {
                      model.sharedFormula = options.formulae[model.si].address;
                    }

                    delete model.si;
                  }

                  break;

                default:
                  break;
              } // look for hyperlink

              var hyperlink = options.hyperlinkMap[model.address];

              if (hyperlink) {
                if (model.type === Enums.ValueType.Formula) {
                  model.text = model.result;
                  model.result = undefined;
                } else {
                  model.text = model.value;
                  model.value = undefined;
                }

                model.type = Enums.ValueType.Hyperlink;
                model.hyperlink = hyperlink;
              }

              var comment =
                options.commentsMap && options.commentsMap[model.address];

              if (comment) {
                model.comment = comment;
              }
            },
          });
        },
        {
          '../../../doc/enums': 8,
          '../../../doc/range': 11,
          '../../../utils/utils': 23,
          '../base-xform': 28,
          '../strings/rich-text-xform': 86,
        },
      ],
      60: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var ColXform = (module.exports = function() {});

          utils.inherits(ColXform, BaseXform, {
            get tag() {
              return 'col';
            },

            prepare: function prepare(model, options) {
              var styleId = options.styles.addStyleModel(model.style || {});

              if (styleId) {
                model.styleId = styleId;
              }
            },
            render: function render(xmlStream, model) {
              xmlStream.openNode('col');
              xmlStream.addAttribute('min', model.min);
              xmlStream.addAttribute('max', model.max);

              if (model.width) {
                xmlStream.addAttribute('width', model.width);
              }

              if (model.styleId) {
                xmlStream.addAttribute('style', model.styleId);
              }

              if (model.hidden) {
                xmlStream.addAttribute('hidden', '1');
              }

              if (model.bestFit) {
                xmlStream.addAttribute('bestFit', '1');
              }

              if (model.outlineLevel) {
                xmlStream.addAttribute('outlineLevel', model.outlineLevel);
              }

              if (model.collapsed) {
                xmlStream.addAttribute('collapsed', '1');
              }

              xmlStream.addAttribute('customWidth', '1');
              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              if (node.name === 'col') {
                var model = (this.model = {
                  min: parseInt(node.attributes.min || '0', 10),
                  max: parseInt(node.attributes.max || '0', 10),
                  width:
                    node.attributes.width === undefined
                      ? undefined
                      : parseFloat(node.attributes.width || '0'),
                });

                if (node.attributes.style) {
                  model.styleId = parseInt(node.attributes.style, 10);
                }

                if (node.attributes.hidden) {
                  model.hidden = true;
                }

                if (node.attributes.bestFit) {
                  model.bestFit = true;
                }

                if (node.attributes.outlineLevel) {
                  model.outlineLevel = parseInt(
                    node.attributes.outlineLevel,
                    10
                  );
                }

                if (node.attributes.collapsed) {
                  model.collapsed = true;
                }

                return true;
              }

              return false;
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
            reconcile: function reconcile(model, options) {
              // reconcile column styles
              if (model.styleId) {
                model.style = options.styles.getStyleModel(model.styleId);
              }
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      61: [
        function(require, module, exports) {
          'use strict';

          var _ = require('../../../utils/under-dash');

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          function assign(definedName, attributes, name, defaultValue) {
            var value = attributes[name];

            if (value !== undefined) {
              definedName[name] = value;
            } else if (defaultValue !== undefined) {
              definedName[name] = defaultValue;
            }
          }

          function parseBool(value) {
            switch (value) {
              case '1':
              case 'true':
                return true;

              default:
                return false;
            }
          }

          function assignBool(definedName, attributes, name, defaultValue) {
            var value = attributes[name];

            if (value !== undefined) {
              definedName[name] = parseBool(value);
            } else if (defaultValue !== undefined) {
              definedName[name] = defaultValue;
            }
          }

          var DataValidationsXform = (module.exports = function() {});

          utils.inherits(DataValidationsXform, BaseXform, {
            get tag() {
              return 'dataValidations';
            },

            render: function render(xmlStream, model) {
              var count = model && Object.keys(model).length;

              if (count) {
                xmlStream.openNode('dataValidations', {
                  count: count,
                });

                _.each(model, function(value, address) {
                  xmlStream.openNode('dataValidation');

                  if (value.type !== 'any') {
                    xmlStream.addAttribute('type', value.type);

                    if (
                      value.operator &&
                      value.type !== 'list' &&
                      value.operator !== 'between'
                    ) {
                      xmlStream.addAttribute('operator', value.operator);
                    }

                    if (value.allowBlank) {
                      xmlStream.addAttribute('allowBlank', '1');
                    }
                  }

                  if (value.showInputMessage) {
                    xmlStream.addAttribute('showInputMessage', '1');
                  }

                  if (value.promptTitle) {
                    xmlStream.addAttribute('promptTitle', value.promptTitle);
                  }

                  if (value.prompt) {
                    xmlStream.addAttribute('prompt', value.prompt);
                  }

                  if (value.showErrorMessage) {
                    xmlStream.addAttribute('showErrorMessage', '1');
                  }

                  if (value.errorStyle) {
                    xmlStream.addAttribute('errorStyle', value.errorStyle);
                  }

                  if (value.errorTitle) {
                    xmlStream.addAttribute('errorTitle', value.errorTitle);
                  }

                  if (value.error) {
                    xmlStream.addAttribute('error', value.error);
                  }

                  xmlStream.addAttribute('sqref', address);
                  (value.formulae || []).forEach(function(formula, index) {
                    xmlStream.openNode('formula'.concat(index + 1));

                    if (value.type === 'date') {
                      xmlStream.writeText(utils.dateToExcel(formula));
                    } else {
                      xmlStream.writeText(formula);
                    }

                    xmlStream.closeNode();
                  });
                  xmlStream.closeNode();
                });

                xmlStream.closeNode();
              }
            },
            parseOpen: function parseOpen(node) {
              switch (node.name) {
                case 'dataValidations':
                  this.model = {};
                  return true;

                case 'dataValidation':
                  this._address = node.attributes.sqref;
                  var definedName = node.attributes.type
                    ? {
                        type: node.attributes.type,
                        formulae: [],
                      }
                    : {
                        type: 'any',
                      };

                  if (node.attributes.type) {
                    assignBool(definedName, node.attributes, 'allowBlank');
                  }

                  assignBool(definedName, node.attributes, 'showInputMessage');
                  assignBool(definedName, node.attributes, 'showErrorMessage');

                  switch (definedName.type) {
                    case 'any':
                    case 'list':
                    case 'custom':
                      break;

                    default:
                      assign(
                        definedName,
                        node.attributes,
                        'operator',
                        'between'
                      );
                      break;
                  }

                  assign(definedName, node.attributes, 'promptTitle');
                  assign(definedName, node.attributes, 'prompt');
                  assign(definedName, node.attributes, 'errorStyle');
                  assign(definedName, node.attributes, 'errorTitle');
                  assign(definedName, node.attributes, 'error');
                  this._definedName = definedName;
                  return true;

                case 'formula1':
                case 'formula2':
                  this._formula = [];
                  return true;

                default:
                  return false;
              }
            },
            parseText: function parseText(text) {
              this._formula.push(text);
            },
            parseClose: function parseClose(name) {
              switch (name) {
                case 'dataValidations':
                  return false;

                case 'dataValidation':
                  if (
                    !this._definedName.formulae ||
                    !this._definedName.formulae.length
                  ) {
                    delete this._definedName.formulae;
                    delete this._definedName.operator;
                  }

                  this.model[this._address] = this._definedName;
                  return true;

                case 'formula1':
                case 'formula2': {
                  var formula = this._formula.join('');

                  switch (this._definedName.type) {
                    case 'whole':
                    case 'textLength':
                      formula = parseInt(formula, 10);
                      break;

                    case 'decimal':
                      formula = parseFloat(formula);
                      break;

                    case 'date':
                      formula = utils.excelToDate(parseFloat(formula));
                      break;

                    default:
                      break;
                  }

                  this._definedName.formulae.push(formula);

                  return true;
                }

                default:
                  return true;
              }
            },
          });
        },
        {
          '../../../utils/under-dash': 22,
          '../../../utils/utils': 23,
          '../base-xform': 28,
        },
      ],
      62: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var DimensionXform = (module.exports = function() {});

          utils.inherits(DimensionXform, BaseXform, {
            get tag() {
              return 'dimension';
            },

            render: function render(xmlStream, model) {
              if (model) {
                xmlStream.leafNode('dimension', {
                  ref: model,
                });
              }
            },
            parseOpen: function parseOpen(node) {
              if (node.name === 'dimension') {
                this.model = node.attributes.ref;
                return true;
              }

              return false;
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      63: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var DrawingXform = (module.exports = function() {});

          utils.inherits(DrawingXform, BaseXform, {
            get tag() {
              return 'drawing';
            },

            render: function render(xmlStream, model) {
              if (model) {
                xmlStream.leafNode(this.tag, {
                  'r:id': model.rId,
                });
              }
            },
            parseOpen: function parseOpen(node) {
              switch (node.name) {
                case this.tag:
                  this.model = {
                    rId: node.attributes['r:id'],
                  };
                  return true;

                default:
                  return false;
              }
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      64: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var HyperlinkXform = (module.exports = function() {});

          utils.inherits(HyperlinkXform, BaseXform, {
            get tag() {
              return 'hyperlink';
            },

            render: function render(xmlStream, model) {
              xmlStream.leafNode(
                'hyperlink',
                Object.assign(
                  {
                    ref: model.address,
                    'r:id': model.rId,
                  },
                  model.tooltip
                    ? {
                        tooltip: model.tooltip,
                      }
                    : {}
                )
              );
            },
            parseOpen: function parseOpen(node) {
              if (node.name === 'hyperlink') {
                this.model = Object.assign(
                  {
                    address: node.attributes.ref,
                    rId: node.attributes['r:id'],
                  },
                  node.attributes.tooltip
                    ? {
                        tooltip: node.attributes.tooltip,
                      }
                    : {}
                );
                return true;
              }

              return false;
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      65: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var MergeCellXform = (module.exports = function() {});

          utils.inherits(MergeCellXform, BaseXform, {
            get tag() {
              return 'mergeCell';
            },

            render: function render(xmlStream, model) {
              xmlStream.leafNode('mergeCell', {
                ref: model,
              });
            },
            parseOpen: function parseOpen(node) {
              if (node.name === 'mergeCell') {
                this.model = node.attributes.ref;
                return true;
              }

              return false;
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      66: [
        function(require, module, exports) {
          'use strict';

          var _ = require('../../../utils/under-dash');

          var Range = require('../../../doc/range');

          var colCache = require('../../../utils/col-cache');

          var Enums = require('../../../doc/enums');

          var Merges = (module.exports = function() {
            // optional mergeCells is array of ranges (like the xml)
            this.merges = {};
          });

          Merges.prototype = {
            add: function add(merge) {
              // merge is {address, master}
              if (this.merges[merge.master]) {
                this.merges[merge.master].expandToAddress(merge.address);
              } else {
                var range = ''.concat(merge.master, ':').concat(merge.address);
                this.merges[merge.master] = new Range(range);
              }
            },

            get mergeCells() {
              return _.map(this.merges, function(merge) {
                return merge.range;
              });
            },

            reconcile: function reconcile(mergeCells, rows) {
              // reconcile merge list with merge cells
              _.each(mergeCells, function(merge) {
                var dimensions = colCache.decode(merge);

                for (var i = dimensions.top; i <= dimensions.bottom; i++) {
                  var row = rows[i - 1];

                  for (var j = dimensions.left; j <= dimensions.right; j++) {
                    var cell = row.cells[j - 1];

                    if (!cell) {
                      // nulls are not included in document - so if master cell has no value - add a null one here
                      row.cells[j] = {
                        type: Enums.ValueType.Null,
                        address: colCache.encodeAddress(i, j),
                      };
                    } else if (cell.type === Enums.ValueType.Merge) {
                      cell.master = dimensions.tl;
                    }
                  }
                }
              });
            },
            getMasterAddress: function getMasterAddress(address) {
              // if address has been merged, return its master's address. Assumes reconcile has been called
              var range = this.hash[address];
              return range && range.tl;
            },
          };
        },
        {
          '../../../doc/enums': 8,
          '../../../doc/range': 11,
          '../../../utils/col-cache': 17,
          '../../../utils/under-dash': 22,
        },
      ],
      67: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var OutlinePropertiesXform = (module.exports = function() {});

          var isDefined = function isDefined(attr) {
            return typeof attr !== 'undefined';
          };

          utils.inherits(OutlinePropertiesXform, BaseXform, {
            get tag() {
              return 'outlinePr';
            },

            render: function render(xmlStream, model) {
              if (
                model &&
                (isDefined(model.summaryBelow) || isDefined(model.summaryRight))
              ) {
                xmlStream.leafNode(this.tag, {
                  summaryBelow: isDefined(model.summaryBelow)
                    ? Number(model.summaryBelow)
                    : undefined,
                  summaryRight: isDefined(model.summaryRight)
                    ? Number(model.summaryRight)
                    : undefined,
                });
                return true;
              }

              return false;
            },
            parseOpen: function parseOpen(node) {
              if (node.name === this.tag) {
                this.model = {
                  summaryBelow: isDefined(node.attributes.summaryBelow)
                    ? Boolean(Number(node.attributes.summaryBelow))
                    : undefined,
                  summaryRight: isDefined(node.attributes.summaryRight)
                    ? Boolean(Number(node.attributes.summaryRight))
                    : undefined,
                };
                return true;
              }

              return false;
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      68: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var PageBreaksXform = (module.exports = function() {});

          utils.inherits(PageBreaksXform, BaseXform, {
            get tag() {
              return 'brk';
            },

            render: function render(xmlStream, model) {
              xmlStream.leafNode('brk', model);
            },
            parseOpen: function parseOpen(node) {
              if (node.name === 'brk') {
                this.model = node.attributes.ref;
                return true;
              }

              return false;
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      69: [
        function(require, module, exports) {
          'use strict';

          var _ = require('../../../utils/under-dash');

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var PageMarginsXform = (module.exports = function() {});

          utils.inherits(PageMarginsXform, BaseXform, {
            get tag() {
              return 'pageMargins';
            },

            render: function render(xmlStream, model) {
              if (model) {
                var attributes = {
                  left: model.left,
                  right: model.right,
                  top: model.top,
                  bottom: model.bottom,
                  header: model.header,
                  footer: model.footer,
                };

                if (
                  _.some(attributes, function(value) {
                    return value !== undefined;
                  })
                ) {
                  xmlStream.leafNode(this.tag, attributes);
                }
              }
            },
            parseOpen: function parseOpen(node) {
              switch (node.name) {
                case this.tag:
                  this.model = {
                    left: parseFloat(node.attributes.left || 0.7),
                    right: parseFloat(node.attributes.right || 0.7),
                    top: parseFloat(node.attributes.top || 0.75),
                    bottom: parseFloat(node.attributes.bottom || 0.75),
                    header: parseFloat(node.attributes.header || 0.3),
                    footer: parseFloat(node.attributes.footer || 0.3),
                  };
                  return true;

                default:
                  return false;
              }
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        {
          '../../../utils/under-dash': 22,
          '../../../utils/utils': 23,
          '../base-xform': 28,
        },
      ],
      70: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var PageSetupPropertiesXform = (module.exports = function() {});

          utils.inherits(PageSetupPropertiesXform, BaseXform, {
            get tag() {
              return 'pageSetUpPr';
            },

            render: function render(xmlStream, model) {
              if (model && model.fitToPage) {
                xmlStream.leafNode(this.tag, {
                  fitToPage: model.fitToPage ? '1' : undefined,
                });
                return true;
              }

              return false;
            },
            parseOpen: function parseOpen(node) {
              if (node.name === this.tag) {
                this.model = {
                  fitToPage: node.attributes.fitToPage === '1',
                };
                return true;
              }

              return false;
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      71: [
        function(require, module, exports) {
          'use strict';

          var _ = require('../../../utils/under-dash');

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          function booleanToXml(model) {
            return model ? '1' : undefined;
          }

          function pageOrderToXml(model) {
            switch (model) {
              case 'overThenDown':
                return model;

              default:
                return undefined;
            }
          }

          function cellCommentsToXml(model) {
            switch (model) {
              case 'atEnd':
              case 'asDisplyed':
                return model;

              default:
                return undefined;
            }
          }

          function errorsToXml(model) {
            switch (model) {
              case 'dash':
              case 'blank':
              case 'NA':
                return model;

              default:
                return undefined;
            }
          }

          function pageSizeToModel(value) {
            return value !== undefined ? parseInt(value, 10) : undefined;
          }

          var PageSetupXform = (module.exports = function() {});

          utils.inherits(PageSetupXform, BaseXform, {
            get tag() {
              return 'pageSetup';
            },

            render: function render(xmlStream, model) {
              if (model) {
                var attributes = {
                  paperSize: model.paperSize,
                  orientation: model.orientation,
                  horizontalDpi: model.horizontalDpi,
                  verticalDpi: model.verticalDpi,
                  pageOrder: pageOrderToXml(model.pageOrder),
                  blackAndWhite: booleanToXml(model.blackAndWhite),
                  draft: booleanToXml(model.draft),
                  cellComments: cellCommentsToXml(model.cellComments),
                  errors: errorsToXml(model.errors),
                  scale: model.scale,
                  fitToWidth: model.fitToWidth,
                  fitToHeight: model.fitToHeight,
                  firstPageNumber: model.firstPageNumber,
                  useFirstPageNumber: booleanToXml(model.firstPageNumber),
                  usePrinterDefaults: booleanToXml(model.usePrinterDefaults),
                  copies: model.copies,
                };

                if (
                  _.some(attributes, function(value) {
                    return value !== undefined;
                  })
                ) {
                  xmlStream.leafNode(this.tag, attributes);
                }
              }
            },
            parseOpen: function parseOpen(node) {
              switch (node.name) {
                case this.tag:
                  this.model = {
                    paperSize: pageSizeToModel(node.attributes.paperSize),
                    orientation: node.attributes.orientation || 'portrait',
                    horizontalDpi: parseInt(
                      node.attributes.horizontalDpi || '4294967295',
                      10
                    ),
                    verticalDpi: parseInt(
                      node.attributes.verticalDpi || '4294967295',
                      10
                    ),
                    pageOrder: node.attributes.pageOrder || 'downThenOver',
                    blackAndWhite: node.attributes.blackAndWhite === '1',
                    draft: node.attributes.draft === '1',
                    cellComments: node.attributes.cellComments || 'None',
                    errors: node.attributes.errors || 'displayed',
                    scale: parseInt(node.attributes.scale || '100', 10),
                    fitToWidth: parseInt(node.attributes.fitToWidth || '1', 10),
                    fitToHeight: parseInt(
                      node.attributes.fitToHeight || '1',
                      10
                    ),
                    firstPageNumber: parseInt(
                      node.attributes.firstPageNumber || '1',
                      10
                    ),
                    useFirstPageNumber:
                      node.attributes.useFirstPageNumber === '1',
                    usePrinterDefaults:
                      node.attributes.usePrinterDefaults === '1',
                    copies: parseInt(node.attributes.copies || '1', 10),
                  };
                  return true;

                default:
                  return false;
              }
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        {
          '../../../utils/under-dash': 22,
          '../../../utils/utils': 23,
          '../base-xform': 28,
        },
      ],
      72: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var PictureXform = (module.exports = function() {});

          utils.inherits(PictureXform, BaseXform, {
            get tag() {
              return 'picture';
            },

            render: function render(xmlStream, model) {
              if (model) {
                xmlStream.leafNode(this.tag, {
                  'r:id': model.rId,
                });
              }
            },
            parseOpen: function parseOpen(node) {
              switch (node.name) {
                case this.tag:
                  this.model = {
                    rId: node.attributes['r:id'],
                  };
                  return true;

                default:
                  return false;
              }
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      73: [
        function(require, module, exports) {
          'use strict';

          var _ = require('../../../utils/under-dash');

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          function booleanToXml(model) {
            return model ? '1' : undefined;
          }

          var PrintOptionsXform = (module.exports = function() {});

          utils.inherits(PrintOptionsXform, BaseXform, {
            get tag() {
              return 'printOptions';
            },

            render: function render(xmlStream, model) {
              if (model) {
                var attributes = {
                  headings: booleanToXml(model.showRowColHeaders),
                  gridLines: booleanToXml(model.showGridLines),
                  horizontalCentered: booleanToXml(model.horizontalCentered),
                  verticalCentered: booleanToXml(model.verticalCentered),
                };

                if (
                  _.some(attributes, function(value) {
                    return value !== undefined;
                  })
                ) {
                  xmlStream.leafNode(this.tag, attributes);
                }
              }
            },
            parseOpen: function parseOpen(node) {
              switch (node.name) {
                case this.tag:
                  this.model = {
                    showRowColHeaders: node.attributes.headings === '1',
                    showGridLines: node.attributes.gridLines === '1',
                    horizontalCentered:
                      node.attributes.horizontalCentered === '1',
                    verticalCentered: node.attributes.verticalCentered === '1',
                  };
                  return true;

                default:
                  return false;
              }
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        {
          '../../../utils/under-dash': 22,
          '../../../utils/utils': 23,
          '../base-xform': 28,
        },
      ],
      74: [
        function(require, module, exports) {
          'use strict';

          var PageBreaksXform = require('./page-breaks-xform');

          var utils = require('../../../utils/utils');

          var ListXform = require('../list-xform');

          var RowBreaksXform = (module.exports = function() {
            var options = {
              tag: 'rowBreaks',
              count: true,
              childXform: new PageBreaksXform(),
            };
            ListXform.call(this, options);
          });

          utils.inherits(RowBreaksXform, ListXform, {
            // get tag() { return 'rowBreaks'; },
            render: function render(xmlStream, model) {
              if (model && model.length) {
                xmlStream.openNode(this.tag, this.$);

                if (this.count) {
                  xmlStream.addAttribute(this.$count, model.length);
                  xmlStream.addAttribute('manualBreakCount', model.length);
                }

                var childXform = this.childXform;
                model.forEach(function(childModel) {
                  childXform.render(xmlStream, childModel);
                });
                xmlStream.closeNode();
              } else if (this.empty) {
                xmlStream.leafNode(this.tag);
              }
            },
          });
        },
        {
          '../../../utils/utils': 23,
          '../list-xform': 57,
          './page-breaks-xform': 68,
        },
      ],
      75: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var CellXform = require('./cell-xform');

          var RowXform = (module.exports = function(options) {
            this.maxItems = options && options.maxItems;
            this.map = {
              c: new CellXform(),
            };
          }); // <row r="<%=row.number%>"
          //     <% if(row.height) {%> ht="<%=row.height%>" customHeight="1"<% } %>
          //     <% if(row.hidden) {%> hidden="1"<% } %>
          //     <% if(row.min > 0 && row.max > 0 && row.min <= row.max) {%> spans="<%=row.min%>:<%=row.max%>"<% } %>
          //     <% if (row.styleId) { %> s="<%=row.styleId%>" customFormat="1" <% } %>
          //     x14ac:dyDescent="0.25">
          //   <% row.cells.forEach(function(cell){ %>
          //     <%=cell.xml%><% }); %>
          // </row>

          utils.inherits(RowXform, BaseXform, {
            get tag() {
              return 'row';
            },

            prepare: function prepare(model, options) {
              var styleId = options.styles.addStyleModel(model.style);

              if (styleId) {
                model.styleId = styleId;
              }

              var cellXform = this.map.c;
              model.cells.forEach(function(cellModel) {
                cellXform.prepare(cellModel, options);
              });
            },
            render: function render(xmlStream, model, options) {
              xmlStream.openNode('row');
              xmlStream.addAttribute('r', model.number);

              if (model.height) {
                xmlStream.addAttribute('ht', model.height);
                xmlStream.addAttribute('customHeight', '1');
              }

              if (model.hidden) {
                xmlStream.addAttribute('hidden', '1');
              }

              if (model.min > 0 && model.max > 0 && model.min <= model.max) {
                xmlStream.addAttribute(
                  'spans',
                  ''.concat(model.min, ':').concat(model.max)
                );
              }

              if (model.styleId) {
                xmlStream.addAttribute('s', model.styleId);
                xmlStream.addAttribute('customFormat', '1');
              }

              xmlStream.addAttribute('x14ac:dyDescent', '0.25');

              if (model.outlineLevel) {
                xmlStream.addAttribute('outlineLevel', model.outlineLevel);
              }

              if (model.collapsed) {
                xmlStream.addAttribute('collapsed', '1');
              }

              var cellXform = this.map.c;
              model.cells.forEach(function(cellModel) {
                cellXform.render(xmlStream, cellModel, options);
              });
              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              if (node.name === 'row') {
                this.numRowsSeen += 1;
                var spans = node.attributes.spans
                  ? node.attributes.spans.split(':').map(function(span) {
                      return parseInt(span, 10);
                    })
                  : [undefined, undefined];
                var model = (this.model = {
                  number: parseInt(node.attributes.r, 10),
                  min: spans[0],
                  max: spans[1],
                  cells: [],
                });

                if (node.attributes.s) {
                  model.styleId = parseInt(node.attributes.s, 10);
                }

                if (node.attributes.hidden) {
                  model.hidden = true;
                }

                if (node.attributes.bestFit) {
                  model.bestFit = true;
                }

                if (node.attributes.ht) {
                  model.height = parseFloat(node.attributes.ht);
                }

                if (node.attributes.outlineLevel) {
                  model.outlineLevel = parseInt(
                    node.attributes.outlineLevel,
                    10
                  );
                }

                if (node.attributes.collapsed) {
                  model.collapsed = true;
                }

                return true;
              }

              this.parser = this.map[node.name];

              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              return false;
            },
            parseText: function parseText(text) {
              if (this.parser) {
                this.parser.parseText(text);
              }
            },
            parseClose: function parseClose(name) {
              if (this.parser) {
                if (!this.parser.parseClose(name)) {
                  this.model.cells.push(this.parser.model);

                  if (
                    this.maxItems &&
                    this.model.cells.length > this.maxItems
                  ) {
                    throw new Error('Max column count exceeded');
                  }

                  this.parser = undefined;
                }

                return true;
              }

              return false;
            },
            reconcile: function reconcile(model, options) {
              model.style = model.styleId
                ? options.styles.getStyleModel(model.styleId)
                : {};

              if (model.styleId !== undefined) {
                model.styleId = undefined;
              }

              var cellXform = this.map.c;
              model.cells.forEach(function(cellModel) {
                cellXform.reconcile(cellModel, options);
              });
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28, './cell-xform': 59 },
      ],
      76: [
        function(require, module, exports) {
          'use strict';

          var _ = require('../../../utils/under-dash');

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var SheetFormatPropertiesXform = (module.exports = function() {});

          utils.inherits(SheetFormatPropertiesXform, BaseXform, {
            get tag() {
              return 'sheetFormatPr';
            },

            render: function render(xmlStream, model) {
              if (model) {
                var attributes = {
                  defaultRowHeight: model.defaultRowHeight,
                  outlineLevelRow: model.outlineLevelRow,
                  outlineLevelCol: model.outlineLevelCol,
                  'x14ac:dyDescent': model.dyDescent,
                };

                if (
                  _.some(attributes, function(value) {
                    return value !== undefined;
                  })
                ) {
                  xmlStream.leafNode('sheetFormatPr', attributes);
                }
              }
            },
            parseOpen: function parseOpen(node) {
              if (node.name === 'sheetFormatPr') {
                this.model = {
                  defaultRowHeight: parseFloat(
                    node.attributes.defaultRowHeight || '0'
                  ),
                  dyDescent: parseFloat(
                    node.attributes['x14ac:dyDescent'] || '0'
                  ),
                  outlineLevelRow: parseInt(
                    node.attributes.outlineLevelRow || '0',
                    10
                  ),
                  outlineLevelCol: parseInt(
                    node.attributes.outlineLevelCol || '0',
                    10
                  ),
                };
                return true;
              }

              return false;
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        {
          '../../../utils/under-dash': 22,
          '../../../utils/utils': 23,
          '../base-xform': 28,
        },
      ],
      77: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var ColorXform = require('../style/color-xform');

          var PageSetupPropertiesXform = require('./page-setup-properties-xform');

          var OutlinePropertiesXform = require('./outline-properties-xform');

          var SheetPropertiesXform = (module.exports = function() {
            this.map = {
              tabColor: new ColorXform('tabColor'),
              pageSetUpPr: new PageSetupPropertiesXform(),
              outlinePr: new OutlinePropertiesXform(),
            };
          });

          utils.inherits(SheetPropertiesXform, BaseXform, {
            get tag() {
              return 'sheetPr';
            },

            render: function render(xmlStream, model) {
              if (model) {
                xmlStream.addRollback();
                xmlStream.openNode('sheetPr');
                var inner = false;
                inner =
                  this.map.tabColor.render(xmlStream, model.tabColor) || inner;
                inner =
                  this.map.pageSetUpPr.render(xmlStream, model.pageSetup) ||
                  inner;
                inner =
                  this.map.outlinePr.render(
                    xmlStream,
                    model.outlineProperties
                  ) || inner;

                if (inner) {
                  xmlStream.closeNode();
                  xmlStream.commit();
                } else {
                  xmlStream.rollback();
                }
              }
            },
            parseOpen: function parseOpen(node) {
              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              if (node.name === this.tag) {
                this.reset();
                return true;
              }

              if (this.map[node.name]) {
                this.parser = this.map[node.name];
                this.parser.parseOpen(node);
                return true;
              }

              return false;
            },
            parseText: function parseText(text) {
              if (this.parser) {
                this.parser.parseText(text);
                return true;
              }

              return false;
            },
            parseClose: function parseClose(name) {
              if (this.parser) {
                if (!this.parser.parseClose(name)) {
                  this.parser = undefined;
                }

                return true;
              }

              if (
                this.map.tabColor.model ||
                this.map.pageSetUpPr.model ||
                this.map.outlinePr.model
              ) {
                this.model = {};

                if (this.map.tabColor.model) {
                  this.model.tabColor = this.map.tabColor.model;
                }

                if (this.map.pageSetUpPr.model) {
                  this.model.pageSetup = this.map.pageSetUpPr.model;
                }

                if (this.map.outlinePr.model) {
                  this.model.outlineProperties = this.map.outlinePr.model;
                }
              } else {
                this.model = null;
              }

              return false;
            },
          });
        },
        {
          '../../../utils/utils': 23,
          '../base-xform': 28,
          '../style/color-xform': 92,
          './outline-properties-xform': 67,
          './page-setup-properties-xform': 70,
        },
      ],
      78: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var colCache = require('../../../utils/col-cache');

          var BaseXform = require('../base-xform');

          var VIEW_STATES = {
            frozen: 'frozen',
            frozenSplit: 'frozen',
            split: 'split',
          };

          var SheetViewXform = (module.exports = function() {});

          utils.inherits(SheetViewXform, BaseXform, {
            get tag() {
              return 'sheetView';
            },

            prepare: function prepare(model) {
              switch (model.state) {
                case 'frozen':
                case 'split':
                  break;

                default:
                  model.state = 'normal';
                  break;
              }
            },
            render: function render(xmlStream, model) {
              xmlStream.openNode('sheetView', {
                workbookViewId: model.workbookViewId || 0,
              });

              var add = function add(name, value, included) {
                if (included) {
                  xmlStream.addAttribute(name, value);
                }
              };

              add('rightToLeft', '1', model.rightToLeft === true);
              add('tabSelected', '1', model.tabSelected);
              add('showRuler', '0', model.showRuler === false);
              add('showRowColHeaders', '0', model.showRowColHeaders === false);
              add('showGridLines', '0', model.showGridLines === false);
              add('zoomScale', model.zoomScale, model.zoomScale);
              add(
                'zoomScaleNormal',
                model.zoomScaleNormal,
                model.zoomScaleNormal
              );
              add('view', model.style, model.style);
              var topLeftCell;
              var xSplit;
              var ySplit;
              var activePane;

              switch (model.state) {
                case 'frozen':
                  xSplit = model.xSplit || 0;
                  ySplit = model.ySplit || 0;
                  topLeftCell =
                    model.topLeftCell ||
                    colCache.getAddress(ySplit + 1, xSplit + 1).address;
                  activePane =
                    (model.xSplit && model.ySplit && 'bottomRight') ||
                    (model.xSplit && 'topRight') ||
                    'bottomLeft';
                  xmlStream.leafNode('pane', {
                    xSplit: model.xSplit || undefined,
                    ySplit: model.ySplit || undefined,
                    topLeftCell: topLeftCell,
                    activePane: activePane,
                    state: 'frozen',
                  });
                  xmlStream.leafNode('selection', {
                    pane: activePane,
                    activeCell: model.activeCell,
                    sqref: model.activeCell,
                  });
                  break;

                case 'split':
                  if (model.activePane === 'topLeft') {
                    model.activePane = undefined;
                  }

                  xmlStream.leafNode('pane', {
                    xSplit: model.xSplit || undefined,
                    ySplit: model.ySplit || undefined,
                    topLeftCell: model.topLeftCell,
                    activePane: model.activePane,
                  });
                  xmlStream.leafNode('selection', {
                    pane: model.activePane,
                    activeCell: model.activeCell,
                    sqref: model.activeCell,
                  });
                  break;

                case 'normal':
                  if (model.activeCell) {
                    xmlStream.leafNode('selection', {
                      activeCell: model.activeCell,
                      sqref: model.activeCell,
                    });
                  }

                  break;

                default:
                  break;
              }

              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              switch (node.name) {
                case 'sheetView':
                  this.sheetView = {
                    workbookViewId: parseInt(
                      node.attributes.workbookViewId,
                      10
                    ),
                    rightToLeft: node.attributes.rightToLeft === '1',
                    tabSelected: node.attributes.tabSelected === '1',
                    showRuler: !(node.attributes.showRuler === '0'),
                    showRowColHeaders: !(
                      node.attributes.showRowColHeaders === '0'
                    ),
                    showGridLines: !(node.attributes.showGridLines === '0'),
                    zoomScale: parseInt(node.attributes.zoomScale || '100', 10),
                    zoomScaleNormal: parseInt(
                      node.attributes.zoomScaleNormal || '100',
                      10
                    ),
                    style: node.attributes.view,
                  };
                  this.pane = undefined;
                  this.selections = {};
                  return true;

                case 'pane':
                  this.pane = {
                    xSplit: parseInt(node.attributes.xSplit || '0', 10),
                    ySplit: parseInt(node.attributes.ySplit || '0', 10),
                    topLeftCell: node.attributes.topLeftCell,
                    activePane: node.attributes.activePane || 'topLeft',
                    state: node.attributes.state,
                  };
                  return true;

                case 'selection':
                  var name = node.attributes.pane || 'topLeft';
                  this.selections[name] = {
                    pane: name,
                    activeCell: node.attributes.activeCell,
                  };
                  return true;

                default:
                  return false;
              }
            },
            parseText: function parseText() {},
            parseClose: function parseClose(name) {
              var model;
              var selection;

              switch (name) {
                case 'sheetView':
                  if (this.sheetView && this.pane) {
                    model = this.model = {
                      workbookViewId: this.sheetView.workbookViewId,
                      rightToLeft: this.sheetView.rightToLeft,
                      state: VIEW_STATES[this.pane.state] || 'split',
                      // split is default
                      xSplit: this.pane.xSplit,
                      ySplit: this.pane.ySplit,
                      topLeftCell: this.pane.topLeftCell,
                      showRuler: this.sheetView.showRuler,
                      showRowColHeaders: this.sheetView.showRowColHeaders,
                      showGridLines: this.sheetView.showGridLines,
                      zoomScale: this.sheetView.zoomScale,
                      zoomScaleNormal: this.sheetView.zoomScaleNormal,
                    };

                    if (this.model.state === 'split') {
                      model.activePane = this.pane.activePane;
                    }

                    selection = this.selections[this.pane.activePane];

                    if (selection && selection.activeCell) {
                      model.activeCell = selection.activeCell;
                    }

                    if (this.sheetView.style) {
                      model.style = this.sheetView.style;
                    }
                  } else {
                    model = this.model = {
                      workbookViewId: this.sheetView.workbookViewId,
                      rightToLeft: this.sheetView.rightToLeft,
                      state: 'normal',
                      showRuler: this.sheetView.showRuler,
                      showRowColHeaders: this.sheetView.showRowColHeaders,
                      showGridLines: this.sheetView.showGridLines,
                      zoomScale: this.sheetView.zoomScale,
                      zoomScaleNormal: this.sheetView.zoomScaleNormal,
                    };
                    selection = this.selections.topLeft;

                    if (selection && selection.activeCell) {
                      model.activeCell = selection.activeCell;
                    }

                    if (this.sheetView.style) {
                      model.style = this.sheetView.style;
                    }
                  }

                  return false;

                default:
                  return true;
              }
            },
            reconcile: function reconcile() {},
          });
        },
        {
          '../../../utils/col-cache': 17,
          '../../../utils/utils': 23,
          '../base-xform': 28,
        },
      ],
      79: [
        function(require, module, exports) {
          'use strict';

          var _ = require('../../../utils/under-dash');

          var colCache = require('../../../utils/col-cache');

          var utils = require('../../../utils/utils');

          var XmlStream = require('../../../utils/xml-stream');

          var RelType = require('../../rel-type');

          var Merges = require('./merges');

          var BaseXform = require('../base-xform');

          var ListXform = require('../list-xform');

          var RowXform = require('./row-xform');

          var ColXform = require('./col-xform');

          var DimensionXform = require('./dimension-xform');

          var HyperlinkXform = require('./hyperlink-xform');

          var MergeCellXform = require('./merge-cell-xform');

          var DataValidationsXform = require('./data-validations-xform');

          var SheetPropertiesXform = require('./sheet-properties-xform');

          var SheetFormatPropertiesXform = require('./sheet-format-properties-xform');

          var SheetViewXform = require('./sheet-view-xform');

          var PageMarginsXform = require('./page-margins-xform');

          var PageSetupXform = require('./page-setup-xform');

          var PrintOptionsXform = require('./print-options-xform');

          var AutoFilterXform = require('./auto-filter-xform');

          var PictureXform = require('./picture-xform');

          var DrawingXform = require('./drawing-xform');

          var RowBreaksXform = require('./row-breaks-xform');

          var WorkSheetXform = (module.exports = function(options) {
            var maxRows = options && options.maxRows;
            var maxCols = options && options.maxCols;
            this.map = {
              sheetPr: new SheetPropertiesXform(),
              dimension: new DimensionXform(),
              sheetViews: new ListXform({
                tag: 'sheetViews',
                count: false,
                childXform: new SheetViewXform(),
              }),
              sheetFormatPr: new SheetFormatPropertiesXform(),
              cols: new ListXform({
                tag: 'cols',
                count: false,
                childXform: new ColXform(),
              }),
              sheetData: new ListXform({
                tag: 'sheetData',
                count: false,
                empty: true,
                childXform: new RowXform({
                  maxItems: maxCols,
                }),
                maxItems: maxRows,
              }),
              autoFilter: new AutoFilterXform(),
              mergeCells: new ListXform({
                tag: 'mergeCells',
                count: true,
                childXform: new MergeCellXform(),
              }),
              rowBreaks: new RowBreaksXform(),
              hyperlinks: new ListXform({
                tag: 'hyperlinks',
                count: false,
                childXform: new HyperlinkXform(),
              }),
              pageMargins: new PageMarginsXform(),
              dataValidations: new DataValidationsXform(),
              pageSetup: new PageSetupXform(),
              printOptions: new PrintOptionsXform(),
              picture: new PictureXform(),
              drawing: new DrawingXform(),
            };
          });

          utils.inherits(
            WorkSheetXform,
            BaseXform,
            {
              WORKSHEET_ATTRIBUTES: {
                xmlns:
                  'http://schemas.openxmlformats.org/spreadsheetml/2006/main',
                'xmlns:r':
                  'http://schemas.openxmlformats.org/officeDocument/2006/relationships',
                'xmlns:mc':
                  'http://schemas.openxmlformats.org/markup-compatibility/2006',
                'mc:Ignorable': 'x14ac',
                'xmlns:x14ac':
                  'http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac',
              },
            },
            {
              prepare: function prepare(model, options) {
                options.merges = new Merges();
                model.hyperlinks = options.hyperlinks = [];
                model.comments = options.comments = [];
                options.formulae = {};
                options.siFormulae = 0;
                this.map.cols.prepare(model.cols, options);
                this.map.sheetData.prepare(model.rows, options);
                model.mergeCells = options.merges.mergeCells; // prepare relationships

                var rels = (model.rels = []);

                function nextRid(r) {
                  return 'rId'.concat(r.length + 1);
                }

                model.hyperlinks.forEach(function(hyperlink) {
                  var rId = nextRid(rels);
                  hyperlink.rId = rId;
                  rels.push({
                    Id: rId,
                    Type: RelType.Hyperlink,
                    Target: hyperlink.target,
                    TargetMode: 'External',
                  });
                }); // prepare comment relationships

                if (model.comments.length > 0) {
                  var comment = {
                    Id: nextRid(rels),
                    Type: RelType.Comments,
                    Target: '../comments'.concat(model.id, '.xml'),
                  };
                  rels.push(comment);
                  var vmlDrawing = {
                    Id: nextRid(rels),
                    Type: RelType.VmlDrawing,
                    Target: '../drawings/vmlDrawing'.concat(model.id, '.vml'),
                  };
                  rels.push(vmlDrawing);
                  model.comments.forEach(function(item) {
                    item.refAddress = colCache.decodeAddress(item.ref);
                  });
                  options.commentRefs.push({
                    commentName: 'comments'.concat(model.id),
                    vmlDrawing: 'vmlDrawing'.concat(model.id),
                  });
                }

                var drawingRelsHash = [];
                var bookImage;
                model.media.forEach(function(medium) {
                  if (medium.type === 'background') {
                    var rId = nextRid(rels);
                    bookImage = options.media[medium.imageId];
                    rels.push({
                      Id: rId,
                      Type: RelType.Image,
                      Target: '../media/'
                        .concat(bookImage.name, '.')
                        .concat(bookImage.extension),
                    });
                    model.background = {
                      rId: rId,
                    };
                    model.image = options.media[medium.imageId];
                  } else if (medium.type === 'image') {
                    var drawing = model.drawing;
                    bookImage = options.media[medium.imageId];

                    if (!drawing) {
                      drawing = model.drawing = {
                        rId: nextRid(rels),
                        name: 'drawing'.concat(++options.drawingsCount),
                        anchors: [],
                        rels: [],
                      };
                      options.drawings.push(drawing);
                      rels.push({
                        Id: drawing.rId,
                        Type:
                          'http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing',
                        Target: '../drawings/'.concat(drawing.name, '.xml'),
                      });
                    }

                    var rIdImage = drawingRelsHash[medium.imageId];

                    if (!rIdImage) {
                      rIdImage = nextRid(drawing.rels);
                      drawingRelsHash[medium.imageId] = rIdImage;
                      drawing.rels.push({
                        Id: rIdImage,
                        Type:
                          'http://schemas.openxmlformats.org/officeDocument/2006/relationships/image',
                        Target: '../media/'
                          .concat(bookImage.name, '.')
                          .concat(bookImage.extension),
                      });
                    }

                    drawing.anchors.push({
                      picture: {
                        rId: rIdImage,
                      },
                      range: medium.range,
                    });
                  }
                });
              },
              render: function render(xmlStream, model) {
                xmlStream.openXml(XmlStream.StdDocAttributes);
                xmlStream.openNode(
                  'worksheet',
                  WorkSheetXform.WORKSHEET_ATTRIBUTES
                );
                var sheetFormatPropertiesModel = model.properties
                  ? {
                      defaultRowHeight: model.properties.defaultRowHeight,
                      dyDescent: model.properties.dyDescent,
                      outlineLevelCol: model.properties.outlineLevelCol,
                      outlineLevelRow: model.properties.outlineLevelRow,
                    }
                  : undefined;
                var sheetPropertiesModel = {
                  outlineProperties:
                    model.properties && model.properties.outlineProperties,
                  tabColor: model.properties && model.properties.tabColor,
                  pageSetup:
                    model.pageSetup && model.pageSetup.fitToPage
                      ? {
                          fitToPage: model.pageSetup.fitToPage,
                        }
                      : undefined,
                };
                var pageMarginsModel =
                  model.pageSetup && model.pageSetup.margins;
                var printOptionsModel = {
                  showRowColHeaders: model.showRowColHeaders,
                  showGridLines: model.showGridLines,
                  horizontalCentered: model.horizontalCentered,
                  verticalCentered: model.verticalCentered,
                };
                this.map.sheetPr.render(xmlStream, sheetPropertiesModel);
                this.map.dimension.render(xmlStream, model.dimensions);
                this.map.sheetViews.render(xmlStream, model.views);
                this.map.sheetFormatPr.render(
                  xmlStream,
                  sheetFormatPropertiesModel
                );
                this.map.cols.render(xmlStream, model.cols);
                this.map.sheetData.render(xmlStream, model.rows);
                this.map.autoFilter.render(xmlStream, model.autoFilter);
                this.map.mergeCells.render(xmlStream, model.mergeCells);
                this.map.dataValidations.render(
                  xmlStream,
                  model.dataValidations
                ); // For some reason hyperlinks have to be after the data validations

                this.map.hyperlinks.render(xmlStream, model.hyperlinks);
                this.map.pageMargins.render(xmlStream, pageMarginsModel);
                this.map.printOptions.render(xmlStream, printOptionsModel);
                this.map.pageSetup.render(xmlStream, model.pageSetup);
                this.map.rowBreaks.render(xmlStream, model.rowBreaks);
                this.map.drawing.render(xmlStream, model.drawing); // Note: must be after rowBreaks

                this.map.picture.render(xmlStream, model.background); // Note: must be after drawing

                if (model.rels) {
                  // add a <legacyDrawing /> node for each comment
                  model.rels.forEach(function(rel) {
                    if (rel.Type === RelType.VmlDrawing) {
                      xmlStream.leafNode('legacyDrawing', {
                        'r:id': rel.Id,
                      });
                    }
                  });
                }

                xmlStream.closeNode();
              },
              parseOpen: function parseOpen(node) {
                if (this.parser) {
                  this.parser.parseOpen(node);
                  return true;
                }

                if (node.name === 'worksheet') {
                  _.each(this.map, function(xform) {
                    xform.reset();
                  });

                  return true;
                }

                this.parser = this.map[node.name];

                if (this.parser) {
                  this.parser.parseOpen(node);
                }

                return true;
              },
              parseText: function parseText(text) {
                if (this.parser) {
                  this.parser.parseText(text);
                }
              },
              parseClose: function parseClose(name) {
                if (this.parser) {
                  if (!this.parser.parseClose(name)) {
                    this.parser = undefined;
                  }

                  return true;
                }

                switch (name) {
                  case 'worksheet': {
                    var properties = this.map.sheetFormatPr.model;

                    if (
                      this.map.sheetPr.model &&
                      this.map.sheetPr.model.tabColor
                    ) {
                      properties.tabColor = this.map.sheetPr.model.tabColor;
                    }

                    if (
                      this.map.sheetPr.model &&
                      this.map.sheetPr.model.outlineProperties
                    ) {
                      properties.outlineProperties = this.map.sheetPr.model.outlinePropertiesx;
                    }

                    var sheetProperties = {
                      fitToPage:
                        (this.map.sheetPr.model &&
                          this.map.sheetPr.model.pageSetup &&
                          this.map.sheetPr.model.pageSetup.fitToPage) ||
                        false,
                      margins: this.map.pageMargins.model,
                    };
                    var pageSetup = Object.assign(
                      sheetProperties,
                      this.map.pageSetup.model,
                      this.map.printOptions.model
                    );
                    this.model = {
                      dimensions: this.map.dimension.model,
                      cols: this.map.cols.model,
                      rows: this.map.sheetData.model,
                      mergeCells: this.map.mergeCells.model,
                      hyperlinks: this.map.hyperlinks.model,
                      dataValidations: this.map.dataValidations.model,
                      properties: properties,
                      views: this.map.sheetViews.model,
                      pageSetup: pageSetup,
                      background: this.map.picture.model,
                      drawing: this.map.drawing.model,
                    };

                    if (this.map.autoFilter.model) {
                      this.model.autoFilter = this.map.autoFilter.model;
                    }

                    return false;
                  }

                  default:
                    // not quite sure how we get here!
                    return true;
                }
              },
              reconcile: function reconcile(model, options) {
                // options.merges = new Merges();
                // options.merges.reconcile(model.mergeCells, model.rows);
                var rels = (model.relationships || []).reduce(function(h, rel) {
                  h[rel.Id] = rel;

                  if (rel.Type === RelType.Comments) {
                    model.comments = options.comments[rel.Target].comments;
                  }

                  return h;
                }, {});
                options.commentsMap = (model.comments || []).reduce(function(
                  h,
                  comment
                ) {
                  if (comment.ref) {
                    h[comment.ref] = comment;
                  }

                  return h;
                },
                {});
                options.hyperlinkMap = (model.hyperlinks || []).reduce(function(
                  h,
                  hyperlink
                ) {
                  if (hyperlink.rId) {
                    h[hyperlink.address] = rels[hyperlink.rId].Target;
                  }

                  return h;
                },
                {});
                options.formulae = {}; // compact the rows and cells

                model.rows = (model.rows && model.rows.filter(Boolean)) || [];
                model.rows.forEach(function(row) {
                  row.cells = (row.cells && row.cells.filter(Boolean)) || [];
                });
                this.map.cols.reconcile(model.cols, options);
                this.map.sheetData.reconcile(model.rows, options);
                model.media = [];

                if (model.drawing) {
                  var drawingRel = rels[model.drawing.rId];
                  var match = drawingRel.Target.match(
                    /\/drawings\/([a-zA-Z0-9]+)[.][a-zA-Z]{3,4}$/
                  );

                  if (match) {
                    var drawingName = match[1];
                    var drawing = options.drawings[drawingName];
                    drawing.anchors.forEach(function(anchor) {
                      if (anchor.medium) {
                        var image = {
                          type: 'image',
                          imageId: anchor.medium.index,
                          range: anchor.range,
                        };
                        model.media.push(image);
                      }
                    });
                  }
                }

                var backgroundRel =
                  model.background && rels[model.background.rId];

                if (backgroundRel) {
                  var target = backgroundRel.Target.split('/media/')[1];
                  var imageId =
                    options.mediaIndex && options.mediaIndex[target];

                  if (imageId !== undefined) {
                    model.media.push({
                      type: 'background',
                      imageId: imageId,
                    });
                  }
                }

                delete model.relationships;
                delete model.hyperlinks;
                delete model.comments;
              },
            }
          );
        },
        {
          '../../../utils/col-cache': 17,
          '../../../utils/under-dash': 22,
          '../../../utils/utils': 23,
          '../../../utils/xml-stream': 24,
          '../../rel-type': 27,
          '../base-xform': 28,
          '../list-xform': 57,
          './auto-filter-xform': 58,
          './col-xform': 60,
          './data-validations-xform': 61,
          './dimension-xform': 62,
          './drawing-xform': 63,
          './hyperlink-xform': 64,
          './merge-cell-xform': 65,
          './merges': 66,
          './page-margins-xform': 69,
          './page-setup-xform': 71,
          './picture-xform': 72,
          './print-options-xform': 73,
          './row-breaks-xform': 74,
          './row-xform': 75,
          './sheet-format-properties-xform': 76,
          './sheet-properties-xform': 77,
          './sheet-view-xform': 78,
        },
      ],
      80: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var BooleanXform = (module.exports = function(options) {
            this.tag = options.tag;
            this.attr = options.attr;
          });

          utils.inherits(BooleanXform, BaseXform, {
            render: function render(xmlStream, model) {
              if (model) {
                xmlStream.openNode(this.tag);
                xmlStream.closeNode();
              }
            },
            parseOpen: function parseOpen(node) {
              if (node.name === this.tag) {
                this.model = true;
              }
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      81: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var DateXform = (module.exports = function(options) {
            this.tag = options.tag;
            this.attr = options.attr;
            this.attrs = options.attrs;

            this._format =
              options.format ||
              function(dt) {
                try {
                  if (Number.isNaN(dt.getTime())) return '';
                  return dt.toISOString();
                } catch (e) {
                  return '';
                }
              };

            this._parse =
              options.parse ||
              function(str) {
                return new Date(str);
              };
          });

          utils.inherits(DateXform, BaseXform, {
            render: function render(xmlStream, model) {
              if (model) {
                xmlStream.openNode(this.tag);

                if (this.attrs) {
                  xmlStream.addAttributes(this.attrs);
                }

                if (this.attr) {
                  xmlStream.addAttribute(this.attr, this._format(model));
                } else {
                  xmlStream.writeText(this._format(model));
                }

                xmlStream.closeNode();
              }
            },
            parseOpen: function parseOpen(node) {
              if (node.name === this.tag) {
                if (this.attr) {
                  this.model = this._parse(node.attributes[this.attr]);
                } else {
                  this.text = [];
                }
              }
            },
            parseText: function parseText(text) {
              if (!this.attr) {
                this.text.push(text);
              }
            },
            parseClose: function parseClose() {
              if (!this.attr) {
                this.model = this._parse(this.text.join(''));
              }

              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      82: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var IntegerXform = (module.exports = function(options) {
            this.tag = options.tag;
            this.attr = options.attr;
            this.attrs = options.attrs; // option to render zero

            this.zero = options.zero;
          });

          utils.inherits(IntegerXform, BaseXform, {
            render: function render(xmlStream, model) {
              // int is different to float in that zero is not rendered
              if (model || this.zero) {
                xmlStream.openNode(this.tag);

                if (this.attrs) {
                  xmlStream.addAttributes(this.attrs);
                }

                if (this.attr) {
                  xmlStream.addAttribute(this.attr, model);
                } else {
                  xmlStream.writeText(model);
                }

                xmlStream.closeNode();
              }
            },
            parseOpen: function parseOpen(node) {
              if (node.name === this.tag) {
                if (this.attr) {
                  this.model = parseInt(node.attributes[this.attr], 10);
                } else {
                  this.text = [];
                }

                return true;
              }

              return false;
            },
            parseText: function parseText(text) {
              if (!this.attr) {
                this.text.push(text);
              }
            },
            parseClose: function parseClose() {
              if (!this.attr) {
                this.model = parseInt(this.text.join('') || 0, 10);
              }

              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      83: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var StringXform = (module.exports = function(options) {
            this.tag = options.tag;
            this.attr = options.attr;
            this.attrs = options.attrs;
          });

          utils.inherits(StringXform, BaseXform, {
            render: function render(xmlStream, model) {
              if (model !== undefined) {
                xmlStream.openNode(this.tag);

                if (this.attrs) {
                  xmlStream.addAttributes(this.attrs);
                }

                if (this.attr) {
                  xmlStream.addAttribute(this.attr, model);
                } else {
                  xmlStream.writeText(model);
                }

                xmlStream.closeNode();
              }
            },
            parseOpen: function parseOpen(node) {
              if (node.name === this.tag) {
                if (this.attr) {
                  this.model = node.attributes[this.attr];
                } else {
                  this.text = [];
                }
              }
            },
            parseText: function parseText(text) {
              if (!this.attr) {
                this.text.push(text);
              }
            },
            parseClose: function parseClose() {
              if (!this.attr) {
                this.model = this.text.join('');
              }

              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      84: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../utils/utils');

          var BaseXform = require('./base-xform');

          var XmlStream = require('../../utils/xml-stream'); // const model = {
          //   tag: 'name',
          //   $: {attr: 'value'},
          //   c: [
          //     { tag: 'child' }
          //   ],
          //   t: 'some text'
          // };

          function build(xmlStream, model) {
            xmlStream.openNode(model.tag, model.$);

            if (model.c) {
              model.c.forEach(function(child) {
                build(xmlStream, child);
              });
            }

            if (model.t) {
              xmlStream.writeText(model.t);
            }

            xmlStream.closeNode();
          }

          var StaticXform = (module.exports = function(model) {
            // This class is an optimisation for static (unimportant and unchanging) xml
            // It is stateless - apart from its static model and so can be used as a singleton
            // Being stateless - it will only track entry to and exit from it's root xml tag during parsing and nothing else
            // Known issues:
            //    since stateless - parseOpen always returns true. Parent xform must know when to start using this xform
            //    if the root tag is recursive, the parsing will behave unpredictably
            this._model = model;
          });

          utils.inherits(StaticXform, BaseXform, {
            render: function render(xmlStream) {
              if (!this._xml) {
                var stream = new XmlStream();
                build(stream, this._model);
                this._xml = stream.xml;
              }

              xmlStream.writeXml(this._xml);
            },
            parseOpen: function parseOpen() {
              return true;
            },
            parseText: function parseText() {},
            parseClose: function parseClose(name) {
              switch (name) {
                case this._model.tag:
                  return false;

                default:
                  return true;
              }
            },
          });
        },
        {
          '../../utils/utils': 23,
          '../../utils/xml-stream': 24,
          './base-xform': 28,
        },
      ],
      85: [
        function(require, module, exports) {
          'use strict';

          var TextXform = require('./text-xform');

          var RichTextXform = require('./rich-text-xform');

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform'); // <rPh sb="0" eb="1">
          //   <t>(its pronounciation in KATAKANA)</t>
          // </rPh>

          var PhoneticTextXform = (module.exports = function() {
            this.map = {
              r: new RichTextXform(),
              t: new TextXform(),
            };
          });

          utils.inherits(PhoneticTextXform, BaseXform, {
            get tag() {
              return 'rPh';
            },

            render: function render(xmlStream, model) {
              xmlStream.openNode(this.tag, {
                sb: model.sb || 0,
                eb: model.eb || 0,
              });

              if (model && model.hasOwnProperty('richText') && model.richText) {
                var r = this.map.r;
                model.richText.forEach(function(text) {
                  r.render(xmlStream, text);
                });
              } else if (model) {
                this.map.t.render(xmlStream, model.text);
              }

              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              var name = node.name;

              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              if (name === this.tag) {
                this.model = {
                  sb: parseInt(node.attributes.sb, 10),
                  eb: parseInt(node.attributes.eb, 10),
                };
                return true;
              }

              this.parser = this.map[name];

              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              return false;
            },
            parseText: function parseText(text) {
              if (this.parser) {
                this.parser.parseText(text);
              }
            },
            parseClose: function parseClose(name) {
              if (this.parser) {
                if (!this.parser.parseClose(name)) {
                  switch (name) {
                    case 'r': {
                      var rt = this.model.richText;

                      if (!rt) {
                        rt = this.model.richText = [];
                      }

                      rt.push(this.parser.model);
                      break;
                    }

                    case 't':
                      this.model.text = this.parser.model;
                      break;

                    default:
                      break;
                  }

                  this.parser = undefined;
                }

                return true;
              }

              switch (name) {
                case this.tag:
                  return false;

                default:
                  return true;
              }
            },
          });
        },
        {
          '../../../utils/utils': 23,
          '../base-xform': 28,
          './rich-text-xform': 86,
          './text-xform': 89,
        },
      ],
      86: [
        function(require, module, exports) {
          'use strict';

          var TextXform = require('./text-xform');

          var FontXform = require('../style/font-xform');

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform'); // <r>
          //   <rPr>
          //     <sz val="11"/>
          //     <color theme="1" tint="5"/>
          //     <rFont val="Calibri"/>
          //     <family val="2"/>
          //     <scheme val="minor"/>
          //   </rPr>
          //   <t xml:space="preserve"> is </t>
          // </r>

          var RichTextXform = (module.exports = function(model) {
            this.model = model;
          });

          RichTextXform.FONT_OPTIONS = {
            tagName: 'rPr',
            fontNameTag: 'rFont',
          };
          utils.inherits(RichTextXform, BaseXform, {
            get tag() {
              return 'r';
            },

            get textXform() {
              return this._textXform || (this._textXform = new TextXform());
            },

            get fontXform() {
              return (
                this._fontXform ||
                (this._fontXform = new FontXform(RichTextXform.FONT_OPTIONS))
              );
            },

            render: function render(xmlStream, model) {
              model = model || this.model;
              xmlStream.openNode('r');

              if (model.font) {
                this.fontXform.render(xmlStream, model.font);
              }

              this.textXform.render(xmlStream, model.text);
              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              switch (node.name) {
                case 'r':
                  this.model = {};
                  return true;

                case 't':
                  this.parser = this.textXform;
                  this.parser.parseOpen(node);
                  return true;

                case 'rPr':
                  this.parser = this.fontXform;
                  this.parser.parseOpen(node);
                  return true;

                default:
                  return false;
              }
            },
            parseText: function parseText(text) {
              if (this.parser) {
                this.parser.parseText(text);
              }
            },
            parseClose: function parseClose(name) {
              switch (name) {
                case 'r':
                  return false;

                case 't':
                  this.model.text = this.parser.model;
                  this.parser = undefined;
                  return true;

                case 'rPr':
                  this.model.font = this.parser.model;
                  this.parser = undefined;
                  return true;

                default:
                  if (this.parser) {
                    this.parser.parseClose(name);
                  }

                  return true;
              }
            },
          });
        },
        {
          '../../../utils/utils': 23,
          '../base-xform': 28,
          '../style/font-xform': 94,
          './text-xform': 89,
        },
      ],
      87: [
        function(require, module, exports) {
          'use strict';

          var TextXform = require('./text-xform');

          var RichTextXform = require('./rich-text-xform');

          var PhoneticTextXform = require('./phonetic-text-xform');

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform'); // <si>
          //   <r></r><r></r>...
          // </si>
          // <si>
          //   <t></t>
          // </si>

          var SharedStringXform = (module.exports = function(model) {
            this.model = model;
            this.map = {
              r: new RichTextXform(),
              t: new TextXform(),
              rPh: new PhoneticTextXform(),
            };
          });

          utils.inherits(SharedStringXform, BaseXform, {
            get tag() {
              return 'si';
            },

            render: function render(xmlStream, model) {
              xmlStream.openNode(this.tag);

              if (model && model.hasOwnProperty('richText') && model.richText) {
                var r = this.map.r;
                model.richText.forEach(function(text) {
                  r.render(xmlStream, text);
                });
              } else if (model !== undefined && model !== null) {
                this.map.t.render(xmlStream, model);
              }

              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              var name = node.name;

              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              if (name === this.tag) {
                this.model = {};
                return true;
              }

              this.parser = this.map[name];

              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              return false;
            },
            parseText: function parseText(text) {
              if (this.parser) {
                this.parser.parseText(text);
              }
            },
            parseClose: function parseClose(name) {
              if (this.parser) {
                if (!this.parser.parseClose(name)) {
                  switch (name) {
                    case 'r': {
                      var rt = this.model.richText;

                      if (!rt) {
                        rt = this.model.richText = [];
                      }

                      rt.push(this.parser.model);
                      break;
                    }

                    case 't':
                      this.model = this.parser.model;
                      break;

                    default:
                      break;
                  }

                  this.parser = undefined;
                }

                return true;
              }

              switch (name) {
                case this.tag:
                  return false;

                default:
                  return true;
              }
            },
          });
        },
        {
          '../../../utils/utils': 23,
          '../base-xform': 28,
          './phonetic-text-xform': 85,
          './rich-text-xform': 86,
          './text-xform': 89,
        },
      ],
      88: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var XmlStream = require('../../../utils/xml-stream');

          var BaseXform = require('../base-xform');

          var SharedStringXform = require('./shared-string-xform');

          var SharedStringsXform = (module.exports = function(model) {
            this.model = model || {
              values: [],
              count: 0,
            };
            this.hash = {};
            this.rich = {};
          });

          utils.inherits(SharedStringsXform, BaseXform, {
            get sharedStringXform() {
              return (
                this._sharedStringXform ||
                (this._sharedStringXform = new SharedStringXform())
              );
            },

            get values() {
              return this.model.values;
            },

            get uniqueCount() {
              return this.model.values.length;
            },

            get count() {
              return this.model.count;
            },

            getString: function getString(index) {
              return this.model.values[index];
            },
            add: function add(value) {
              return value.richText
                ? this.addRichText(value)
                : this.addText(value);
            },
            addText: function addText(value) {
              var index = this.hash[value];

              if (index === undefined) {
                index = this.hash[value] = this.model.values.length;
                this.model.values.push(value);
              }

              this.model.count++;
              return index;
            },
            addRichText: function addRichText(value) {
              // TODO: add WeakMap here
              var xml = this.sharedStringXform.toXml(value);
              var index = this.rich[xml];

              if (index === undefined) {
                index = this.rich[xml] = this.model.values.length;
                this.model.values.push(value);
              }

              this.model.count++;
              return index;
            },
            // <?xml version="1.0" encoding="UTF-8" standalone="yes"?>
            // <sst xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" count="<%=totalRefs%>" uniqueCount="<%=count%>">
            //   <si><t><%=text%></t></si>
            //   <si><r><rPr></rPr><t></t></r></si>
            // </sst>
            render: function render(xmlStream, model) {
              model = model || this._values;
              xmlStream.openXml(XmlStream.StdDocAttributes);
              xmlStream.openNode('sst', {
                xmlns:
                  'http://schemas.openxmlformats.org/spreadsheetml/2006/main',
                count: model.count,
                uniqueCount: model.values.length,
              });
              var sx = this.sharedStringXform;
              model.values.forEach(function(sharedString) {
                sx.render(xmlStream, sharedString);
              });
              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              switch (node.name) {
                case 'sst':
                  return true;

                case 'si':
                  this.parser = this.sharedStringXform;
                  this.parser.parseOpen(node);
                  return true;

                default:
                  throw new Error(
                    'Unexpected xml node in parseOpen: '.concat(
                      JSON.stringify(node)
                    )
                  );
              }
            },
            parseText: function parseText(text) {
              if (this.parser) {
                this.parser.parseText(text);
              }
            },
            parseClose: function parseClose(name) {
              if (this.parser) {
                if (!this.parser.parseClose(name)) {
                  this.model.values.push(this.parser.model);
                  this.model.count++;
                  this.parser = undefined;
                }

                return true;
              }

              switch (name) {
                case 'sst':
                  return false;

                default:
                  throw new Error(
                    'Unexpected xml node in parseClose: '.concat(name)
                  );
              }
            },
          });
        },
        {
          '../../../utils/utils': 23,
          '../../../utils/xml-stream': 24,
          '../base-xform': 28,
          './shared-string-xform': 87,
        },
      ],
      89: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform'); //   <t xml:space="preserve"> is </t>

          var TextXform = (module.exports = function() {});

          utils.inherits(TextXform, BaseXform, {
            get tag() {
              return 't';
            },

            render: function render(xmlStream, model) {
              xmlStream.openNode('t');

              if (model[0] === ' ' || model[model.length - 1] === ' ') {
                xmlStream.addAttribute('xml:space', 'preserve');
              }

              xmlStream.writeText(model);
              xmlStream.closeNode();
            },

            get model() {
              return this._text
                .join('')
                .replace(/_x([0-9A-F]{4})_/g, function($0, $1) {
                  return String.fromCharCode(parseInt($1, 16));
                });
            },

            parseOpen: function parseOpen(node) {
              switch (node.name) {
                case 't':
                  this._text = [];
                  return true;

                default:
                  return false;
              }
            },
            parseText: function parseText(text) {
              this._text.push(text);
            },
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      90: [
        function(require, module, exports) {
          'use strict';

          var Enums = require('../../../doc/enums');

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var validation = {
            horizontalValues: [
              'left',
              'center',
              'right',
              'fill',
              'centerContinuous',
              'distributed',
              'justify',
            ].reduce(function(p, v) {
              p[v] = true;
              return p;
            }, {}),
            horizontal: function horizontal(value) {
              return this.horizontalValues[value] ? value : undefined;
            },
            verticalValues: [
              'top',
              'middle',
              'bottom',
              'distributed',
              'justify',
            ].reduce(function(p, v) {
              p[v] = true;
              return p;
            }, {}),
            vertical: function vertical(value) {
              if (value === 'middle') return 'center';
              return this.verticalValues[value] ? value : undefined;
            },
            wrapText: function wrapText(value) {
              return value ? true : undefined;
            },
            shrinkToFit: function shrinkToFit(value) {
              return value ? true : undefined;
            },
            textRotation: function textRotation(value) {
              switch (value) {
                case 'vertical':
                  return value;

                default:
                  value = utils.validInt(value);
                  return value >= -90 && value <= 90 ? value : undefined;
              }
            },
            indent: function indent(value) {
              value = utils.validInt(value);
              return Math.max(0, value);
            },
            readingOrder: function readingOrder(value) {
              switch (value) {
                case 'ltr':
                  return Enums.ReadingOrder.LeftToRight;

                case 'rtl':
                  return Enums.ReadingOrder.RightToLeft;

                default:
                  return undefined;
              }
            },
          };
          var textRotationXform = {
            toXml: function toXml(textRotation) {
              textRotation = validation.textRotation(textRotation);

              if (textRotation) {
                if (textRotation === 'vertical') {
                  return 255;
                }

                var tr = Math.round(textRotation);

                if (tr >= 0 && tr <= 90) {
                  return tr;
                }

                if (tr < 0 && tr >= -90) {
                  return 90 - tr;
                }
              }

              return undefined;
            },
            toModel: function toModel(textRotation) {
              var tr = utils.validInt(textRotation);

              if (tr !== undefined) {
                if (tr === 255) {
                  return 'vertical';
                }

                if (tr >= 0 && tr <= 90) {
                  return tr;
                }

                if (tr > 90 && tr <= 180) {
                  return 90 - tr;
                }
              }

              return undefined;
            },
          }; // Alignment encapsulates translation from style.alignment model to/from xlsx

          var AlignmentXform = (module.exports = function() {});

          utils.inherits(AlignmentXform, BaseXform, {
            get tag() {
              return 'alignment';
            },

            render: function render(xmlStream, model) {
              xmlStream.addRollback();
              xmlStream.openNode('alignment');
              var isValid = false;

              function add(name, value) {
                if (value) {
                  xmlStream.addAttribute(name, value);
                  isValid = true;
                }
              }

              add('horizontal', validation.horizontal(model.horizontal));
              add('vertical', validation.vertical(model.vertical));
              add(
                'wrapText',
                validation.wrapText(model.wrapText) ? '1' : false
              );
              add(
                'shrinkToFit',
                validation.shrinkToFit(model.shrinkToFit) ? '1' : false
              );
              add('indent', validation.indent(model.indent));
              add('textRotation', textRotationXform.toXml(model.textRotation));
              add('readingOrder', validation.readingOrder(model.readingOrder));
              xmlStream.closeNode();

              if (isValid) {
                xmlStream.commit();
              } else {
                xmlStream.rollback();
              }
            },
            parseOpen: function parseOpen(node) {
              var model = {};
              var valid = false;

              function add(truthy, name, value) {
                if (truthy) {
                  model[name] = value;
                  valid = true;
                }
              }

              add(
                node.attributes.horizontal,
                'horizontal',
                node.attributes.horizontal
              );
              add(
                node.attributes.vertical,
                'vertical',
                node.attributes.vertical === 'center'
                  ? 'middle'
                  : node.attributes.vertical
              );
              add(
                node.attributes.wrapText,
                'wrapText',
                !!node.attributes.wrapText
              );
              add(
                node.attributes.shrinkToFit,
                'shrinkToFit',
                !!node.attributes.shrinkToFit
              );
              add(
                node.attributes.indent,
                'indent',
                parseInt(node.attributes.indent, 10)
              );
              add(
                node.attributes.textRotation,
                'textRotation',
                textRotationXform.toModel(node.attributes.textRotation)
              );
              add(
                node.attributes.readingOrder,
                'readingOrder',
                node.attributes.readingOrder === '2' ? 'rtl' : 'ltr'
              );
              this.model = valid ? model : null;
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        {
          '../../../doc/enums': 8,
          '../../../utils/utils': 23,
          '../base-xform': 28,
        },
      ],
      91: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var ColorXform = require('./color-xform');

          var EdgeXform = function EdgeXform(name) {
            this.name = name;
            this.map = {
              color: new ColorXform(),
            };
          };

          utils.inherits(EdgeXform, BaseXform, {
            get tag() {
              return this.name;
            },

            render: function render(xmlStream, model, defaultColor) {
              var color =
                (model && model.color) || defaultColor || this.defaultColor;
              xmlStream.openNode(this.name);

              if (model && model.style) {
                xmlStream.addAttribute('style', model.style);

                if (color) {
                  this.map.color.render(xmlStream, color);
                }
              }

              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              switch (node.name) {
                case this.name: {
                  var style = node.attributes.style;

                  if (style) {
                    this.model = {
                      style: style,
                    };
                  } else {
                    this.model = undefined;
                  }

                  return true;
                }

                case 'color':
                  this.parser = this.map.color;
                  this.parser.parseOpen(node);
                  return true;

                default:
                  return false;
              }
            },
            parseText: function parseText(text) {
              if (this.parser) {
                this.parser.parseText(text);
              }
            },
            parseClose: function parseClose(name) {
              if (this.parser) {
                if (!this.parser.parseClose(name)) {
                  this.parser = undefined;
                }

                return true;
              }

              if (name === this.name) {
                if (this.map.color.model) {
                  if (!this.model) {
                    this.model = {};
                  }

                  this.model.color = this.map.color.model;
                }
              }

              return false;
            },
            validStyleValues: [
              'thin',
              'dotted',
              'dashDot',
              'hair',
              'dashDotDot',
              'slantDashDot',
              'mediumDashed',
              'mediumDashDotDot',
              'mediumDashDot',
              'medium',
              'double',
              'thick',
            ].reduce(function(p, v) {
              p[v] = true;
              return p;
            }, {}),
            validStyle: function validStyle(value) {
              return this.validStyleValues[value];
            },
          }); // Border encapsulates translation from border model to/from xlsx

          var BorderXform = (module.exports = function() {
            this.map = {
              top: new EdgeXform('top'),
              left: new EdgeXform('left'),
              bottom: new EdgeXform('bottom'),
              right: new EdgeXform('right'),
              diagonal: new EdgeXform('diagonal'),
            };
          });

          utils.inherits(BorderXform, BaseXform, {
            render: function render(xmlStream, model) {
              var color = model.color;
              xmlStream.openNode('border');

              if (model.diagonal && model.diagonal.style) {
                if (model.diagonal.up) {
                  xmlStream.addAttribute('diagonalUp', '1');
                }

                if (model.diagonal.down) {
                  xmlStream.addAttribute('diagonalDown', '1');
                }
              }

              function add(edgeModel, edgeXform) {
                if (edgeModel && !edgeModel.color && model.color) {
                  // don't mess with incoming models
                  edgeModel = Object.assign({}, edgeModel, {
                    color: model.color,
                  });
                }

                edgeXform.render(xmlStream, edgeModel, color);
              }

              add(model.left, this.map.left);
              add(model.right, this.map.right);
              add(model.top, this.map.top);
              add(model.bottom, this.map.bottom);
              add(model.diagonal, this.map.diagonal);
              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              }

              switch (node.name) {
                case 'border':
                  this.reset();
                  this.diagonalUp = !!node.attributes.diagonalUp;
                  this.diagonalDown = !!node.attributes.diagonalDown;
                  return true;

                default:
                  this.parser = this.map[node.name];

                  if (this.parser) {
                    this.parser.parseOpen(node);
                    return true;
                  }

                  return false;
              }
            },
            parseText: function parseText(text) {
              if (this.parser) {
                this.parser.parseText(text);
              }
            },
            parseClose: function parseClose(name) {
              if (this.parser) {
                if (!this.parser.parseClose(name)) {
                  this.parser = undefined;
                }

                return true;
              }

              if (name === 'border') {
                var model = (this.model = {});

                var add = function add(key, edgeModel, extensions) {
                  if (edgeModel) {
                    if (extensions) {
                      Object.assign(edgeModel, extensions);
                    }

                    model[key] = edgeModel;
                  }
                };

                add('left', this.map.left.model);
                add('right', this.map.right.model);
                add('top', this.map.top.model);
                add('bottom', this.map.bottom.model);
                add('diagonal', this.map.diagonal.model, {
                  up: this.diagonalUp,
                  down: this.diagonalDown,
                });
              }

              return false;
            },
          });
        },
        {
          '../../../utils/utils': 23,
          '../base-xform': 28,
          './color-xform': 92,
        },
      ],
      92: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform'); // Color encapsulates translation from color model to/from xlsx

          var ColorXform = (module.exports = function(name) {
            // this.name controls the xm node name
            this.name = name || 'color';
          });

          utils.inherits(ColorXform, BaseXform, {
            get tag() {
              return this.name;
            },

            render: function render(xmlStream, model) {
              if (model) {
                xmlStream.openNode(this.name);

                if (model.argb) {
                  xmlStream.addAttribute('rgb', model.argb);
                } else if (model.theme !== undefined) {
                  xmlStream.addAttribute('theme', model.theme);

                  if (model.tint !== undefined) {
                    xmlStream.addAttribute('tint', model.tint);
                  }
                } else if (model.indexed !== undefined) {
                  xmlStream.addAttribute('indexed', model.indexed);
                } else {
                  xmlStream.addAttribute('auto', '1');
                }

                xmlStream.closeNode();
                return true;
              }

              return false;
            },
            parseOpen: function parseOpen(node) {
              if (node.name === this.name) {
                if (node.attributes.rgb) {
                  this.model = {
                    argb: node.attributes.rgb,
                  };
                } else if (node.attributes.theme) {
                  this.model = {
                    theme: parseInt(node.attributes.theme, 10),
                  };

                  if (node.attributes.tint) {
                    this.model.tint = parseFloat(node.attributes.tint);
                  }
                } else if (node.attributes.indexed) {
                  this.model = {
                    indexed: parseInt(node.attributes.indexed, 10),
                  };
                } else {
                  this.model = undefined;
                }

                return true;
              }

              return false;
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      93: [
        function(require, module, exports) {
          'use strict';

          function _typeof(obj) {
            if (
              typeof Symbol === 'function' &&
              typeof Symbol.iterator === 'symbol'
            ) {
              _typeof = function _typeof(obj) {
                return typeof obj;
              };
            } else {
              _typeof = function _typeof(obj) {
                return obj &&
                  typeof Symbol === 'function' &&
                  obj.constructor === Symbol &&
                  obj !== Symbol.prototype
                  ? 'symbol'
                  : typeof obj;
              };
            }
            return _typeof(obj);
          }

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          function _possibleConstructorReturn(self, call) {
            if (
              call &&
              (_typeof(call) === 'object' || typeof call === 'function')
            ) {
              return call;
            }
            return _assertThisInitialized(self);
          }

          function _assertThisInitialized(self) {
            if (self === void 0) {
              throw new ReferenceError(
                "this hasn't been initialised - super() hasn't been called"
              );
            }
            return self;
          }

          function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf
              ? Object.getPrototypeOf
              : function _getPrototypeOf(o) {
                  return o.__proto__ || Object.getPrototypeOf(o);
                };
            return _getPrototypeOf(o);
          }

          function _inherits(subClass, superClass) {
            if (typeof superClass !== 'function' && superClass !== null) {
              throw new TypeError(
                'Super expression must either be null or a function'
              );
            }
            subClass.prototype = Object.create(
              superClass && superClass.prototype,
              {
                constructor: {
                  value: subClass,
                  writable: true,
                  configurable: true,
                },
              }
            );
            if (superClass) _setPrototypeOf(subClass, superClass);
          }

          function _setPrototypeOf(o, p) {
            _setPrototypeOf =
              Object.setPrototypeOf ||
              function _setPrototypeOf(o, p) {
                o.__proto__ = p;
                return o;
              };
            return _setPrototypeOf(o, p);
          }

          var BaseXform = require('../base-xform');

          var ColorXform = require('./color-xform');

          var StopXform =
            /*#__PURE__*/
            (function(_BaseXform) {
              _inherits(StopXform, _BaseXform);

              function StopXform() {
                var _this;

                _classCallCheck(this, StopXform);

                _this = _possibleConstructorReturn(
                  this,
                  _getPrototypeOf(StopXform).call(this)
                );
                _this.map = {
                  color: new ColorXform(),
                };
                return _this;
              }

              _createClass(StopXform, [
                {
                  key: 'render',
                  value: function render(xmlStream, model) {
                    xmlStream.openNode('stop');
                    xmlStream.addAttribute('position', model.position);
                    this.map.color.render(xmlStream, model.color);
                    xmlStream.closeNode();
                  },
                },
                {
                  key: 'parseOpen',
                  value: function parseOpen(node) {
                    if (this.parser) {
                      this.parser.parseOpen(node);
                      return true;
                    }

                    switch (node.name) {
                      case 'stop':
                        this.model = {
                          position: parseFloat(node.attributes.position),
                        };
                        return true;

                      case 'color':
                        this.parser = this.map.color;
                        this.parser.parseOpen(node);
                        return true;

                      default:
                        return false;
                    }
                  },
                },
                {
                  key: 'parseText',
                  value: function parseText() {},
                },
                {
                  key: 'parseClose',
                  value: function parseClose(name) {
                    if (this.parser) {
                      if (!this.parser.parseClose(name)) {
                        this.model.color = this.parser.model;
                        this.parser = undefined;
                      }

                      return true;
                    }

                    return false;
                  },
                },
                {
                  key: 'tag',
                  get: function get() {
                    return 'stop';
                  },
                },
              ]);

              return StopXform;
            })(BaseXform);

          var PatternFillXform =
            /*#__PURE__*/
            (function(_BaseXform2) {
              _inherits(PatternFillXform, _BaseXform2);

              function PatternFillXform() {
                var _this2;

                _classCallCheck(this, PatternFillXform);

                _this2 = _possibleConstructorReturn(
                  this,
                  _getPrototypeOf(PatternFillXform).call(this)
                );
                _this2.map = {
                  fgColor: new ColorXform('fgColor'),
                  bgColor: new ColorXform('bgColor'),
                };
                return _this2;
              }

              _createClass(PatternFillXform, [
                {
                  key: 'render',
                  value: function render(xmlStream, model) {
                    xmlStream.openNode('patternFill');
                    xmlStream.addAttribute('patternType', model.pattern);

                    if (model.fgColor) {
                      this.map.fgColor.render(xmlStream, model.fgColor);
                    }

                    if (model.bgColor) {
                      this.map.bgColor.render(xmlStream, model.bgColor);
                    }

                    xmlStream.closeNode();
                  },
                },
                {
                  key: 'parseOpen',
                  value: function parseOpen(node) {
                    if (this.parser) {
                      this.parser.parseOpen(node);
                      return true;
                    }

                    switch (node.name) {
                      case 'patternFill':
                        this.model = {
                          type: 'pattern',
                          pattern: node.attributes.patternType,
                        };
                        return true;

                      default:
                        this.parser = this.map[node.name];

                        if (this.parser) {
                          this.parser.parseOpen(node);
                          return true;
                        }

                        return false;
                    }
                  },
                },
                {
                  key: 'parseText',
                  value: function parseText(text) {
                    if (this.parser) {
                      this.parser.parseText(text);
                    }
                  },
                },
                {
                  key: 'parseClose',
                  value: function parseClose(name) {
                    if (this.parser) {
                      if (!this.parser.parseClose(name)) {
                        if (this.parser.model) {
                          this.model[name] = this.parser.model;
                        }

                        this.parser = undefined;
                      }

                      return true;
                    }

                    return false;
                  },
                },
                {
                  key: 'name',
                  get: function get() {
                    return 'pattern';
                  },
                },
                {
                  key: 'tag',
                  get: function get() {
                    return 'patternFill';
                  },
                },
              ]);

              return PatternFillXform;
            })(BaseXform);

          var GradientFillXform =
            /*#__PURE__*/
            (function(_BaseXform3) {
              _inherits(GradientFillXform, _BaseXform3);

              function GradientFillXform() {
                var _this3;

                _classCallCheck(this, GradientFillXform);

                _this3 = _possibleConstructorReturn(
                  this,
                  _getPrototypeOf(GradientFillXform).call(this)
                );
                _this3.map = {
                  stop: new StopXform(),
                }; // if (model) {
                //   this.gradient = model.gradient;
                //   if (model.center) {
                //     this.center = model.center;
                //   }
                //   if (model.degree !== undefined) {
                //     this.degree = model.degree;
                //   }
                //   this.stops = model.stops.map(function(stop) { return new StopXform(stop); });
                // } else {
                //   this.stops = [];
                // }

                return _this3;
              }

              _createClass(GradientFillXform, [
                {
                  key: 'render',
                  value: function render(xmlStream, model) {
                    xmlStream.openNode('gradientFill');

                    switch (model.gradient) {
                      case 'angle':
                        xmlStream.addAttribute('degree', model.degree);
                        break;

                      case 'path':
                        xmlStream.addAttribute('type', 'path');

                        if (model.center.left) {
                          xmlStream.addAttribute('left', model.center.left);

                          if (model.center.right === undefined) {
                            xmlStream.addAttribute('right', model.center.left);
                          }
                        }

                        if (model.center.right) {
                          xmlStream.addAttribute('right', model.center.right);
                        }

                        if (model.center.top) {
                          xmlStream.addAttribute('top', model.center.top);

                          if (model.center.bottom === undefined) {
                            xmlStream.addAttribute('bottom', model.center.top);
                          }
                        }

                        if (model.center.bottom) {
                          xmlStream.addAttribute('bottom', model.center.bottom);
                        }

                        break;

                      default:
                        break;
                    }

                    var stopXform = this.map.stop;
                    model.stops.forEach(function(stopModel) {
                      stopXform.render(xmlStream, stopModel);
                    });
                    xmlStream.closeNode();
                  },
                },
                {
                  key: 'parseOpen',
                  value: function parseOpen(node) {
                    if (this.parser) {
                      this.parser.parseOpen(node);
                      return true;
                    }

                    switch (node.name) {
                      case 'gradientFill': {
                        var model = (this.model = {
                          stops: [],
                        });

                        if (node.attributes.degree) {
                          model.gradient = 'angle';
                          model.degree = parseInt(node.attributes.degree, 10);
                        } else if (node.attributes.type === 'path') {
                          model.gradient = 'path';
                          model.center = {
                            left: node.attributes.left
                              ? parseFloat(node.attributes.left)
                              : 0,
                            top: node.attributes.top
                              ? parseFloat(node.attributes.top)
                              : 0,
                          };

                          if (node.attributes.right !== node.attributes.left) {
                            model.center.right = node.attributes.right
                              ? parseFloat(node.attributes.right)
                              : 0;
                          }

                          if (node.attributes.bottom !== node.attributes.top) {
                            model.center.bottom = node.attributes.bottom
                              ? parseFloat(node.attributes.bottom)
                              : 0;
                          }
                        }

                        return true;
                      }

                      case 'stop':
                        this.parser = this.map.stop;
                        this.parser.parseOpen(node);
                        return true;

                      default:
                        return false;
                    }
                  },
                },
                {
                  key: 'parseText',
                  value: function parseText(text) {
                    if (this.parser) {
                      this.parser.parseText(text);
                    }
                  },
                },
                {
                  key: 'parseClose',
                  value: function parseClose(name) {
                    if (this.parser) {
                      if (!this.parser.parseClose(name)) {
                        this.model.stops.push(this.parser.model);
                        this.parser = undefined;
                      }

                      return true;
                    }

                    return false;
                  },
                },
                {
                  key: 'name',
                  get: function get() {
                    return 'gradient';
                  },
                },
                {
                  key: 'tag',
                  get: function get() {
                    return 'gradientFill';
                  },
                },
              ]);

              return GradientFillXform;
            })(BaseXform); // Fill encapsulates translation from fill model to/from xlsx

          var FillXform =
            /*#__PURE__*/
            (function(_BaseXform4) {
              _inherits(FillXform, _BaseXform4);

              function FillXform() {
                var _this4;

                _classCallCheck(this, FillXform);

                _this4 = _possibleConstructorReturn(
                  this,
                  _getPrototypeOf(FillXform).call(this)
                );
                _this4.map = {
                  patternFill: new PatternFillXform(),
                  gradientFill: new GradientFillXform(),
                };
                return _this4;
              }

              _createClass(FillXform, [
                {
                  key: 'render',
                  value: function render(xmlStream, model) {
                    xmlStream.addRollback();
                    xmlStream.openNode('fill');

                    switch (model.type) {
                      case 'pattern':
                        this.map.patternFill.render(xmlStream, model);
                        break;

                      case 'gradient':
                        this.map.gradientFill.render(xmlStream, model);
                        break;

                      default:
                        xmlStream.rollback();
                        return;
                    }

                    xmlStream.closeNode();
                    xmlStream.commit();
                  },
                },
                {
                  key: 'parseOpen',
                  value: function parseOpen(node) {
                    if (this.parser) {
                      this.parser.parseOpen(node);
                      return true;
                    }

                    switch (node.name) {
                      case 'fill':
                        this.model = {};
                        return true;

                      default:
                        this.parser = this.map[node.name];

                        if (this.parser) {
                          this.parser.parseOpen(node);
                          return true;
                        }

                        return false;
                    }
                  },
                },
                {
                  key: 'parseText',
                  value: function parseText(text) {
                    if (this.parser) {
                      this.parser.parseText(text);
                    }
                  },
                },
                {
                  key: 'parseClose',
                  value: function parseClose(name) {
                    if (this.parser) {
                      if (!this.parser.parseClose(name)) {
                        this.model = this.parser.model;
                        this.model.type = this.parser.name;
                        this.parser = undefined;
                      }

                      return true;
                    }

                    return false;
                  },
                },
                {
                  key: 'validStyle',
                  value: function validStyle(value) {
                    return FillXform.validPatternValues[value];
                  },
                },
                {
                  key: 'tag',
                  get: function get() {
                    return 'fill';
                  },
                },
              ]);

              return FillXform;
            })(BaseXform);

          FillXform.validPatternValues = [
            'none',
            'solid',
            'darkVertical',
            'darkGray',
            'mediumGray',
            'lightGray',
            'gray125',
            'gray0625',
            'darkHorizontal',
            'darkVertical',
            'darkDown',
            'darkUp',
            'darkGrid',
            'darkTrellis',
            'lightHorizontal',
            'lightVertical',
            'lightDown',
            'lightUp',
            'lightGrid',
            'lightTrellis',
            'lightGrid',
          ].reduce(function(p, v) {
            p[v] = true;
            return p;
          }, {});
          FillXform.StopXform = StopXform;
          FillXform.PatternFillXform = PatternFillXform;
          FillXform.GradientFillXform = GradientFillXform;
          module.exports = FillXform;
        },
        { '../base-xform': 28, './color-xform': 92 },
      ],
      94: [
        function(require, module, exports) {
          'use strict';

          function _typeof(obj) {
            if (
              typeof Symbol === 'function' &&
              typeof Symbol.iterator === 'symbol'
            ) {
              _typeof = function _typeof(obj) {
                return typeof obj;
              };
            } else {
              _typeof = function _typeof(obj) {
                return obj &&
                  typeof Symbol === 'function' &&
                  obj.constructor === Symbol &&
                  obj !== Symbol.prototype
                  ? 'symbol'
                  : typeof obj;
              };
            }
            return _typeof(obj);
          }

          function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
              throw new TypeError('Cannot call a class as a function');
            }
          }

          function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
              var descriptor = props[i];
              descriptor.enumerable = descriptor.enumerable || false;
              descriptor.configurable = true;
              if ('value' in descriptor) descriptor.writable = true;
              Object.defineProperty(target, descriptor.key, descriptor);
            }
          }

          function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps)
              _defineProperties(Constructor.prototype, protoProps);
            if (staticProps) _defineProperties(Constructor, staticProps);
            return Constructor;
          }

          function _possibleConstructorReturn(self, call) {
            if (
              call &&
              (_typeof(call) === 'object' || typeof call === 'function')
            ) {
              return call;
            }
            return _assertThisInitialized(self);
          }

          function _assertThisInitialized(self) {
            if (self === void 0) {
              throw new ReferenceError(
                "this hasn't been initialised - super() hasn't been called"
              );
            }
            return self;
          }

          function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf
              ? Object.getPrototypeOf
              : function _getPrototypeOf(o) {
                  return o.__proto__ || Object.getPrototypeOf(o);
                };
            return _getPrototypeOf(o);
          }

          function _inherits(subClass, superClass) {
            if (typeof superClass !== 'function' && superClass !== null) {
              throw new TypeError(
                'Super expression must either be null or a function'
              );
            }
            subClass.prototype = Object.create(
              superClass && superClass.prototype,
              {
                constructor: {
                  value: subClass,
                  writable: true,
                  configurable: true,
                },
              }
            );
            if (superClass) _setPrototypeOf(subClass, superClass);
          }

          function _setPrototypeOf(o, p) {
            _setPrototypeOf =
              Object.setPrototypeOf ||
              function _setPrototypeOf(o, p) {
                o.__proto__ = p;
                return o;
              };
            return _setPrototypeOf(o, p);
          }

          var ColorXform = require('./color-xform');

          var BooleanXform = require('../simple/boolean-xform');

          var IntegerXform = require('../simple/integer-xform');

          var StringXform = require('../simple/string-xform');

          var UnderlineXform = require('./underline-xform');

          var _ = require('../../../utils/under-dash');

          var BaseXform = require('../base-xform'); // Font encapsulates translation from font model to xlsx

          var FontXform =
            /*#__PURE__*/
            (function(_BaseXform) {
              _inherits(FontXform, _BaseXform);

              function FontXform(options) {
                var _this;

                _classCallCheck(this, FontXform);

                _this = _possibleConstructorReturn(
                  this,
                  _getPrototypeOf(FontXform).call(this)
                );
                _this.options = options || FontXform.OPTIONS;
                _this.map = {
                  b: {
                    prop: 'bold',
                    xform: new BooleanXform({
                      tag: 'b',
                      attr: 'val',
                    }),
                  },
                  i: {
                    prop: 'italic',
                    xform: new BooleanXform({
                      tag: 'i',
                      attr: 'val',
                    }),
                  },
                  u: {
                    prop: 'underline',
                    xform: new UnderlineXform(),
                  },
                  charset: {
                    prop: 'charset',
                    xform: new IntegerXform({
                      tag: 'charset',
                      attr: 'val',
                    }),
                  },
                  color: {
                    prop: 'color',
                    xform: new ColorXform(),
                  },
                  condense: {
                    prop: 'condense',
                    xform: new BooleanXform({
                      tag: 'condense',
                      attr: 'val',
                    }),
                  },
                  extend: {
                    prop: 'extend',
                    xform: new BooleanXform({
                      tag: 'extend',
                      attr: 'val',
                    }),
                  },
                  family: {
                    prop: 'family',
                    xform: new IntegerXform({
                      tag: 'family',
                      attr: 'val',
                    }),
                  },
                  outline: {
                    prop: 'outline',
                    xform: new BooleanXform({
                      tag: 'outline',
                      attr: 'val',
                    }),
                  },
                  vertAlign: {
                    prop: 'vertAlign',
                    xform: new StringXform({
                      tag: 'vertAlign',
                      attr: 'val',
                    }),
                  },
                  scheme: {
                    prop: 'scheme',
                    xform: new StringXform({
                      tag: 'scheme',
                      attr: 'val',
                    }),
                  },
                  shadow: {
                    prop: 'shadow',
                    xform: new BooleanXform({
                      tag: 'shadow',
                      attr: 'val',
                    }),
                  },
                  strike: {
                    prop: 'strike',
                    xform: new BooleanXform({
                      tag: 'strike',
                      attr: 'val',
                    }),
                  },
                  sz: {
                    prop: 'size',
                    xform: new IntegerXform({
                      tag: 'sz',
                      attr: 'val',
                    }),
                  },
                };
                _this.map[_this.options.fontNameTag] = {
                  prop: 'name',
                  xform: new StringXform({
                    tag: _this.options.fontNameTag,
                    attr: 'val',
                  }),
                };
                return _this;
              }

              _createClass(FontXform, [
                {
                  key: 'render',
                  value: function render(xmlStream, model) {
                    var map = this.map;
                    xmlStream.openNode(this.options.tagName);

                    _.each(this.map, function(defn, tag) {
                      map[tag].xform.render(xmlStream, model[defn.prop]);
                    });

                    xmlStream.closeNode();
                  },
                },
                {
                  key: 'parseOpen',
                  value: function parseOpen(node) {
                    if (this.parser) {
                      this.parser.parseOpen(node);
                      return true;
                    }

                    if (this.map[node.name]) {
                      this.parser = this.map[node.name].xform;
                      return this.parser.parseOpen(node);
                    }

                    switch (node.name) {
                      case this.options.tagName:
                        this.model = {};
                        return true;

                      default:
                        return false;
                    }
                  },
                },
                {
                  key: 'parseText',
                  value: function parseText(text) {
                    if (this.parser) {
                      this.parser.parseText(text);
                    }
                  },
                },
                {
                  key: 'parseClose',
                  value: function parseClose(name) {
                    if (this.parser && !this.parser.parseClose(name)) {
                      var item = this.map[name];

                      if (this.parser.model) {
                        this.model[item.prop] = this.parser.model;
                      }

                      this.parser = undefined;
                      return true;
                    }

                    switch (name) {
                      case this.options.tagName:
                        return false;

                      default:
                        return true;
                    }
                  },
                },
                {
                  key: 'tag',
                  get: function get() {
                    return this.options.tagName;
                  },
                },
              ]);

              return FontXform;
            })(BaseXform);

          FontXform.OPTIONS = {
            tagName: 'font',
            fontNameTag: 'name',
          };
          module.exports = FontXform;
        },
        {
          '../../../utils/under-dash': 22,
          '../base-xform': 28,
          '../simple/boolean-xform': 80,
          '../simple/integer-xform': 82,
          '../simple/string-xform': 83,
          './color-xform': 92,
          './underline-xform': 98,
        },
      ],
      95: [
        function(require, module, exports) {
          'use strict';

          var _ = require('../../../utils/under-dash');

          var utils = require('../../../utils/utils');

          var defaultNumFormats = require('../../defaultnumformats');

          var BaseXform = require('../base-xform');

          function hashDefaultFormats() {
            var hash = {};

            _.each(defaultNumFormats, function(dnf, id) {
              if (dnf.f) {
                hash[dnf.f] = parseInt(id, 10);
              } // at some point, add the other cultures here...
            });

            return hash;
          }

          var defaultFmtHash = hashDefaultFormats(); // NumFmt encapsulates translation between number format and xlsx

          var NumFmtXform = (module.exports = function(id, formatCode) {
            this.id = id;
            this.formatCode = formatCode;
          });

          utils.inherits(
            NumFmtXform,
            BaseXform,
            {
              get tag() {
                return 'numFmt';
              },

              getDefaultFmtId: function getDefaultFmtId(formatCode) {
                return defaultFmtHash[formatCode];
              },
              getDefaultFmtCode: function getDefaultFmtCode(numFmtId) {
                return (
                  defaultNumFormats[numFmtId] && defaultNumFormats[numFmtId].f
                );
              },
            },
            {
              render: function render(xmlStream, model) {
                xmlStream.leafNode('numFmt', {
                  numFmtId: model.id,
                  formatCode: model.formatCode,
                });
              },
              parseOpen: function parseOpen(node) {
                switch (node.name) {
                  case 'numFmt':
                    this.model = {
                      id: parseInt(node.attributes.numFmtId, 10),
                      formatCode: node.attributes.formatCode.replace(
                        /[\\](.)/g,
                        '$1'
                      ),
                    };
                    return true;

                  default:
                    return false;
                }
              },
              parseText: function parseText() {},
              parseClose: function parseClose() {
                return false;
              },
            }
          );
        },
        {
          '../../../utils/under-dash': 22,
          '../../../utils/utils': 23,
          '../../defaultnumformats': 26,
          '../base-xform': 28,
        },
      ],
      96: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var AlignmentXform = require('./alignment-xform'); // <xf numFmtId="[numFmtId]" fontId="[fontId]" fillId="[fillId]" borderId="[xf.borderId]" xfId="[xfId]">
          //   Optional <alignment>
          // </xf>
          // Style assists translation from style model to/from xlsx

          var StyleXform = (module.exports = function(options) {
            this.xfId = !!(options && options.xfId);
            this.map = {
              alignment: new AlignmentXform(),
            };
          });

          utils.inherits(StyleXform, BaseXform, {
            get tag() {
              return 'xf';
            },

            render: function render(xmlStream, model) {
              xmlStream.openNode('xf', {
                numFmtId: model.numFmtId || 0,
                fontId: model.fontId || 0,
                fillId: model.fillId || 0,
                borderId: model.borderId || 0,
              });

              if (this.xfId) {
                xmlStream.addAttribute('xfId', model.xfId || 0);
              }

              if (model.numFmtId) {
                xmlStream.addAttribute('applyNumberFormat', '1');
              }

              if (model.fontId) {
                xmlStream.addAttribute('applyFont', '1');
              }

              if (model.fillId) {
                xmlStream.addAttribute('applyFill', '1');
              }

              if (model.borderId) {
                xmlStream.addAttribute('applyBorder', '1');
              }

              if (model.alignment) {
                xmlStream.addAttribute('applyAlignment', '1');
                this.map.alignment.render(xmlStream, model.alignment);
              }

              xmlStream.closeNode();
            },
            parseOpen: function parseOpen(node) {
              if (this.parser) {
                this.parser.parseOpen(node);
                return true;
              } // used during sax parsing of xml to build font object

              switch (node.name) {
                case 'xf':
                  this.model = {
                    numFmtId: parseInt(node.attributes.numFmtId, 10),
                    fontId: parseInt(node.attributes.fontId, 10),
                    fillId: parseInt(node.attributes.fillId, 10),
                    borderId: parseInt(node.attributes.borderId, 10),
                  };

                  if (this.xfId) {
                    this.model.xfId = parseInt(node.attributes.xfId, 10);
                  }

                  return true;

                case 'alignment':
                  this.parser = this.map.alignment;
                  this.parser.parseOpen(node);
                  return true;

                default:
                  return false;
              }
            },
            parseText: function parseText(text) {
              if (this.parser) {
                this.parser.parseText(text);
              }
            },
            parseClose: function parseClose(name) {
              if (this.parser) {
                if (!this.parser.parseClose(name)) {
                  this.model.alignment = this.parser.model;
                  this.parser = undefined;
                }

                return true;
              }

              return name !== 'xf';
            },
          });
        },
        {
          '../../../utils/utils': 23,
          '../base-xform': 28,
          './alignment-xform': 90,
        },
      ],
      97: [
        function(require, module, exports) {
          'use strict';

          var PromiseLib = require('../../../utils/promise');

          var utils = require('../../../utils/utils');

          var Enums = require('../../../doc/enums');

          var XmlStream = require('../../../utils/xml-stream');

          var BaseXform = require('../base-xform');

          var StaticXform = require('../static-xform');

          var ListXform = require('../list-xform');

          var FontXform = require('./font-xform');

          var FillXform = require('./fill-xform');

          var BorderXform = require('./border-xform');

          var NumFmtXform = require('./numfmt-xform');

          var StyleXform = require('./style-xform'); // custom numfmt ids start here

          var NUMFMT_BASE = 164; // =============================================================================
          // StylesXform is used to generate and parse the styles.xml file
          // it manages the collections of fonts, number formats, alignments, etc

          var StylesXform = function StylesXform(initialise) {
            this.map = {
              numFmts: new ListXform({
                tag: 'numFmts',
                count: true,
                childXform: new NumFmtXform(),
              }),
              fonts: new ListXform({
                tag: 'fonts',
                count: true,
                childXform: new FontXform(),
                $: {
                  'x14ac:knownFonts': 1,
                },
              }),
              fills: new ListXform({
                tag: 'fills',
                count: true,
                childXform: new FillXform(),
              }),
              borders: new ListXform({
                tag: 'borders',
                count: true,
                childXform: new BorderXform(),
              }),
              cellStyleXfs: new ListXform({
                tag: 'cellStyleXfs',
                count: true,
                childXform: new StyleXform(),
              }),
              cellXfs: new ListXform({
                tag: 'cellXfs',
                count: true,
                childXform: new StyleXform({
                  xfId: true,
                }),
              }),
              // for style manager
              numFmt: new NumFmtXform(),
              font: new FontXform(),
              fill: new FillXform(),
              border: new BorderXform(),
              style: new StyleXform({
                xfId: true,
              }),
              cellStyles: StylesXform.STATIC_XFORMS.cellStyles,
              dxfs: StylesXform.STATIC_XFORMS.dxfs,
              tableStyles: StylesXform.STATIC_XFORMS.tableStyles,
              extLst: StylesXform.STATIC_XFORMS.extLst,
            };

            if (initialise) {
              // StylesXform also acts as style manager and is used to build up styles-model during worksheet processing
              this.init();
            }
          };

          utils.inherits(
            StylesXform,
            BaseXform,
            {
              STYLESHEET_ATTRIBUTES: {
                xmlns:
                  'http://schemas.openxmlformats.org/spreadsheetml/2006/main',
                'xmlns:mc':
                  'http://schemas.openxmlformats.org/markup-compatibility/2006',
                'mc:Ignorable': 'x14ac x16r2',
                'xmlns:x14ac':
                  'http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac',
                'xmlns:x16r2':
                  'http://schemas.microsoft.com/office/spreadsheetml/2015/02/main',
              },
              STATIC_XFORMS: {
                cellStyles: new StaticXform({
                  tag: 'cellStyles',
                  $: {
                    count: 1,
                  },
                  c: [
                    {
                      tag: 'cellStyle',
                      $: {
                        name: 'Normal',
                        xfId: 0,
                        builtinId: 0,
                      },
                    },
                  ],
                }),
                dxfs: new StaticXform({
                  tag: 'dxfs',
                  $: {
                    count: 0,
                  },
                }),
                tableStyles: new StaticXform({
                  tag: 'tableStyles',
                  $: {
                    count: 0,
                    defaultTableStyle: 'TableStyleMedium2',
                    defaultPivotStyle: 'PivotStyleLight16',
                  },
                }),
                extLst: new StaticXform({
                  tag: 'extLst',
                  c: [
                    {
                      tag: 'ext',
                      $: {
                        uri: '{EB79DEF2-80B8-43e5-95BD-54CBDDF9020C}',
                        'xmlns:x14':
                          'http://schemas.microsoft.com/office/spreadsheetml/2009/9/main',
                      },
                      c: [
                        {
                          tag: 'x14:slicerStyles',
                          $: {
                            defaultSlicerStyle: 'SlicerStyleLight1',
                          },
                        },
                      ],
                    },
                    {
                      tag: 'ext',
                      $: {
                        uri: '{9260A510-F301-46a8-8635-F512D64BE5F5}',
                        'xmlns:x15':
                          'http://schemas.microsoft.com/office/spreadsheetml/2010/11/main',
                      },
                      c: [
                        {
                          tag: 'x15:timelineStyles',
                          $: {
                            defaultTimelineStyle: 'TimeSlicerStyleLight1',
                          },
                        },
                      ],
                    },
                  ],
                }),
              },
            },
            {
              initIndex: function initIndex() {
                this.index = {
                  style: {},
                  numFmt: {},
                  numFmtNextId: 164,
                  // start custom format ids here
                  font: {},
                  border: {},
                  fill: {},
                };
              },
              init: function init() {
                // Prepare for Style Manager role
                this.model = {
                  styles: [],
                  numFmts: [],
                  fonts: [],
                  borders: [],
                  fills: [],
                };
                this.initIndex(); // default (zero) font

                this._addFont({
                  size: 11,
                  color: {
                    theme: 1,
                  },
                  name: 'Calibri',
                  family: 2,
                  scheme: 'minor',
                }); // default (zero) border

                this._addBorder({}); // add default (all zero) style

                this._addStyle({
                  numFmtId: 0,
                  fontId: 0,
                  fillId: 0,
                  borderId: 0,
                  xfId: 0,
                }); // add default fills

                this._addFill({
                  type: 'pattern',
                  pattern: 'none',
                });

                this._addFill({
                  type: 'pattern',
                  pattern: 'gray125',
                });
              },
              render: function render(xmlStream, model) {
                model = model || this.model; //
                //   <fonts count="2" x14ac:knownFonts="1">

                xmlStream.openXml(XmlStream.StdDocAttributes);
                xmlStream.openNode(
                  'styleSheet',
                  StylesXform.STYLESHEET_ATTRIBUTES
                );

                if (this.index) {
                  // model has been built by style manager role (contains xml)
                  if (model.numFmts && model.numFmts.length) {
                    xmlStream.openNode('numFmts', {
                      count: model.numFmts.length,
                    });
                    model.numFmts.forEach(function(numFmtXml) {
                      xmlStream.writeXml(numFmtXml);
                    });
                    xmlStream.closeNode();
                  }

                  xmlStream.openNode('fonts', {
                    count: model.fonts.length,
                  });
                  model.fonts.forEach(function(fontXml) {
                    xmlStream.writeXml(fontXml);
                  });
                  xmlStream.closeNode();
                  xmlStream.openNode('fills', {
                    count: model.fills.length,
                  });
                  model.fills.forEach(function(fillXml) {
                    xmlStream.writeXml(fillXml);
                  });
                  xmlStream.closeNode();
                  xmlStream.openNode('borders', {
                    count: model.borders.length,
                  });
                  model.borders.forEach(function(borderXml) {
                    xmlStream.writeXml(borderXml);
                  });
                  xmlStream.closeNode();
                  this.map.cellStyleXfs.render(xmlStream, [
                    {
                      numFmtId: 0,
                      fontId: 0,
                      fillId: 0,
                      borderId: 0,
                      xfId: 0,
                    },
                  ]);
                  xmlStream.openNode('cellXfs', {
                    count: model.styles.length,
                  });
                  model.styles.forEach(function(styleXml) {
                    xmlStream.writeXml(styleXml);
                  });
                  xmlStream.closeNode();
                } else {
                  // model is plain JSON and needs to be xformed
                  this.map.numFmts.render(xmlStream, model.numFmts);
                  this.map.fonts.render(xmlStream, model.fonts);
                  this.map.fills.render(xmlStream, model.fills);
                  this.map.borders.render(xmlStream, model.borders);
                  this.map.cellStyleXfs.render(xmlStream, [
                    {
                      numFmtId: 0,
                      fontId: 0,
                      fillId: 0,
                      borderId: 0,
                      xfId: 0,
                    },
                  ]);
                  this.map.cellXfs.render(xmlStream, model.styles);
                } // trailing static stuff

                StylesXform.STATIC_XFORMS.cellStyles.render(xmlStream);
                StylesXform.STATIC_XFORMS.dxfs.render(xmlStream);
                StylesXform.STATIC_XFORMS.tableStyles.render(xmlStream);
                StylesXform.STATIC_XFORMS.extLst.render(xmlStream);
                xmlStream.closeNode();
              },
              parseOpen: function parseOpen(node) {
                if (this.parser) {
                  this.parser.parseOpen(node);
                  return true;
                }

                switch (node.name) {
                  case 'styleSheet':
                    this.initIndex();
                    return true;

                  default:
                    this.parser = this.map[node.name];

                    if (this.parser) {
                      this.parser.parseOpen(node);
                    }

                    return true;
                }
              },
              parseText: function parseText(text) {
                if (this.parser) {
                  this.parser.parseText(text);
                }
              },
              parseClose: function parseClose(name) {
                var _this = this;

                if (this.parser) {
                  if (!this.parser.parseClose(name)) {
                    this.parser = undefined;
                  }

                  return true;
                }

                switch (name) {
                  case 'styleSheet': {
                    this.model = {};

                    var add = function add(propName, xform) {
                      if (xform.model && xform.model.length) {
                        _this.model[propName] = xform.model;
                      }
                    };

                    add('numFmts', this.map.numFmts);
                    add('fonts', this.map.fonts);
                    add('fills', this.map.fills);
                    add('borders', this.map.borders);
                    add('styles', this.map.cellXfs); // index numFmts

                    this.index = {
                      model: [],
                      numFmt: [],
                    };

                    if (this.model.numFmts) {
                      var numFmtIndex = this.index.numFmt;
                      this.model.numFmts.forEach(function(numFmt) {
                        numFmtIndex[numFmt.id] = numFmt.formatCode;
                      });
                    }

                    return false;
                  }

                  default:
                    // not quite sure how we get here!
                    return true;
                }
              },
              // add a cell's style model to the collection
              // each style property is processed and cross-referenced, etc.
              // the styleId is returned. Note: cellType is used when numFmt not defined
              addStyleModel: function addStyleModel(model, cellType) {
                if (!model) {
                  return 0;
                } // if we have seen this style object before, assume it has the same styleId

                if (this.weakMap && this.weakMap.has(model)) {
                  return this.weakMap.get(model);
                }

                var style = {};
                cellType = cellType || Enums.ValueType.Number;

                if (model.numFmt) {
                  style.numFmtId = this._addNumFmtStr(model.numFmt);
                } else {
                  switch (cellType) {
                    case Enums.ValueType.Number:
                      style.numFmtId = this._addNumFmtStr('General');
                      break;

                    case Enums.ValueType.Date:
                      style.numFmtId = this._addNumFmtStr('mm-dd-yy');
                      break;

                    default:
                      break;
                  }
                }

                if (model.font) {
                  style.fontId = this._addFont(model.font);
                }

                if (model.border) {
                  style.borderId = this._addBorder(model.border);
                }

                if (model.fill) {
                  style.fillId = this._addFill(model.fill);
                }

                if (model.alignment) {
                  style.alignment = model.alignment;
                }

                var styleId = this._addStyle(style);

                if (this.weakMap) {
                  this.weakMap.set(model, styleId);
                }

                return styleId;
              },
              // given a styleId (i.e. s="n"), get the cell's style model
              // objects are shared where possible.
              getStyleModel: function getStyleModel(id) {
                // if the style doesn't exist return null
                var style = this.model.styles[id];
                if (!style) return null; // have we built this model before?

                var model = this.index.model[id];
                if (model) return model; // build a new model

                model = this.index.model[id] = {}; // -------------------------------------------------------
                // number format

                if (style.numFmtId) {
                  var numFmt =
                    this.index.numFmt[style.numFmtId] ||
                    NumFmtXform.getDefaultFmtCode(style.numFmtId);

                  if (numFmt) {
                    model.numFmt = numFmt;
                  }
                }

                function addStyle(name, group, styleId) {
                  if (styleId) {
                    var part = group[styleId];

                    if (part) {
                      model[name] = part;
                    }
                  }
                }

                addStyle('font', this.model.fonts, style.fontId);
                addStyle('border', this.model.borders, style.borderId);
                addStyle('fill', this.model.fills, style.fillId); // -------------------------------------------------------
                // alignment

                if (style.alignment) {
                  model.alignment = style.alignment;
                }

                return model;
              },
              // =========================================================================
              // Private Interface
              _addStyle: function _addStyle(style) {
                var xml = this.map.style.toXml(style);
                var index = this.index.style[xml];

                if (index === undefined) {
                  index = this.index.style[xml] = this.model.styles.length;
                  this.model.styles.push(xml);
                }

                return index;
              },
              // =========================================================================
              // Number Formats
              _addNumFmtStr: function _addNumFmtStr(formatCode) {
                // check if default format
                var index = NumFmtXform.getDefaultFmtId(formatCode);
                if (index !== undefined) return index; // check if already in

                index = this.index.numFmt[formatCode];
                if (index !== undefined) return index;
                index = this.index.numFmt[formatCode] =
                  NUMFMT_BASE + this.model.numFmts.length;
                var xml = this.map.numFmt.toXml({
                  id: index,
                  formatCode: formatCode,
                });
                this.model.numFmts.push(xml);
                return index;
              },
              // =========================================================================
              // Fonts
              _addFont: function _addFont(font) {
                var xml = this.map.font.toXml(font);
                var index = this.index.font[xml];

                if (index === undefined) {
                  index = this.index.font[xml] = this.model.fonts.length;
                  this.model.fonts.push(xml);
                }

                return index;
              },
              // =========================================================================
              // Borders
              _addBorder: function _addBorder(border) {
                var xml = this.map.border.toXml(border);
                var index = this.index.border[xml];

                if (index === undefined) {
                  index = this.index.border[xml] = this.model.borders.length;
                  this.model.borders.push(xml);
                }

                return index;
              },
              // =========================================================================
              // Fills
              _addFill: function _addFill(fill) {
                var xml = this.map.fill.toXml(fill);
                var index = this.index.fill[xml];

                if (index === undefined) {
                  index = this.index.fill[xml] = this.model.fills.length;
                  this.model.fills.push(xml);
                }

                return index;
              },
            }
          ); // the stylemanager mock acts like StyleManager except that it always returns 0 or {}

          StylesXform.Mock = function() {
            StylesXform.call(this);
            this.model = {
              styles: [
                {
                  numFmtId: 0,
                  fontId: 0,
                  fillId: 0,
                  borderId: 0,
                  xfId: 0,
                },
              ],
              numFmts: [],
              fonts: [
                {
                  size: 11,
                  color: {
                    theme: 1,
                  },
                  name: 'Calibri',
                  family: 2,
                  scheme: 'minor',
                },
              ],
              borders: [{}],
              fills: [
                {
                  type: 'pattern',
                  pattern: 'none',
                },
                {
                  type: 'pattern',
                  pattern: 'gray125',
                },
              ],
            };
          };

          utils.inherits(StylesXform.Mock, StylesXform, {
            // =========================================================================
            // Style Manager Interface
            // override normal behaviour - consume and dispose
            parseStream: function parseStream(stream) {
              stream.autodrain();
              return PromiseLib.Promise.resolve();
            },
            // add a cell's style model to the collection
            // each style property is processed and cross-referenced, etc.
            // the styleId is returned. Note: cellType is used when numFmt not defined
            addStyleModel: function addStyleModel(model, cellType) {
              switch (cellType) {
                case Enums.ValueType.Date:
                  return this.dateStyleId;

                default:
                  return 0;
              }
            },

            get dateStyleId() {
              if (!this._dateStyleId) {
                var dateStyle = {
                  numFmtId: NumFmtXform.getDefaultFmtId('mm-dd-yy'),
                };
                this._dateStyleId = this.model.styles.length;
                this.model.styles.push(dateStyle);
              }

              return this._dateStyleId;
            },

            // given a styleId (i.e. s="n"), get the cell's style model
            // objects are shared where possible.
            getStyleModel: function getStyleModel() /* id */
            {
              return {};
            },
          });
          module.exports = StylesXform;
        },
        {
          '../../../doc/enums': 8,
          '../../../utils/promise': 18,
          '../../../utils/utils': 23,
          '../../../utils/xml-stream': 24,
          '../base-xform': 28,
          '../list-xform': 57,
          '../static-xform': 84,
          './border-xform': 91,
          './fill-xform': 93,
          './font-xform': 94,
          './numfmt-xform': 95,
          './style-xform': 96,
        },
      ],
      98: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../../../utils/utils');

          var BaseXform = require('../base-xform');

          var UnderlineXform = (module.exports = function(model) {
            this.model = model;
          });

          UnderlineXform.Attributes = {
            single: {},
            double: {
              val: 'double',
            },
            singleAccounting: {
              val: 'singleAccounting',
            },
            doubleAccounting: {
              val: 'doubleAccounting',
            },
          };
          utils.inherits(UnderlineXform, BaseXform, {
            get tag() {
              return 'u';
            },

            render: function render(xmlStream, model) {
              model = model || this.model;

              if (model === true) {
                xmlStream.leafNode('u');
              } else {
                var attr = UnderlineXform.Attributes[model];

                if (attr) {
                  xmlStream.leafNode('u', attr);
                }
              }
            },
            parseOpen: function parseOpen(node) {
              if (node.name === 'u') {
                this.model = node.attributes.val || true;
              }
            },
            parseText: function parseText() {},
            parseClose: function parseClose() {
              return false;
            },
          });
        },
        { '../../../utils/utils': 23, '../base-xform': 28 },
      ],
      99: [
        function(require, module, exports) {
          (function(Buffer) {
            'use strict';

            var fs = require('fs');

            var ZipStream = require('../utils/zip-stream');

            var StreamBuf = require('../utils/stream-buf');

            var PromiseLib = require('../utils/promise');

            var utils = require('../utils/utils');

            var XmlStream = require('../utils/xml-stream');

            var StylesXform = require('./xform/style/styles-xform');

            var CoreXform = require('./xform/core/core-xform');

            var SharedStringsXform = require('./xform/strings/shared-strings-xform');

            var RelationshipsXform = require('./xform/core/relationships-xform');

            var ContentTypesXform = require('./xform/core/content-types-xform');

            var AppXform = require('./xform/core/app-xform');

            var WorkbookXform = require('./xform/book/workbook-xform');

            var WorksheetXform = require('./xform/sheet/worksheet-xform');

            var DrawingXform = require('./xform/drawing/drawing-xform');

            var CommentsXform = require('./xform/comment/comments-xform');

            var VmlNotesXform = require('./xform/comment/vml-notes-xform');

            var theme1Xml = require('./xml/theme1.js');

            var XLSX = (module.exports = function(workbook) {
              this.workbook = workbook;
            });

            function fsReadFileAsync(filename, options) {
              return new PromiseLib.Promise(function(resolve, reject) {
                fs.readFile(filename, options, function(error, data) {
                  if (error) {
                    reject(error);
                  } else {
                    resolve(data);
                  }
                });
              });
            }

            XLSX.RelType = require('./rel-type');
            XLSX.prototype = {
              // ===============================================================================
              // Workbook
              // =========================================================================
              // Read
              readFile: function readFile(filename, options) {
                var self = this;
                var stream;
                return utils.fs
                  .exists(filename)
                  .then(function(exists) {
                    if (!exists) {
                      throw new Error('File not found: '.concat(filename));
                    }

                    stream = fs.createReadStream(filename);
                    return self.read(stream, options)['catch'](function(error) {
                      stream.close();
                      throw error;
                    });
                  })
                  .then(function(workbook) {
                    stream.close();
                    return workbook;
                  });
              },
              parseRels: function parseRels(stream) {
                var xform = new RelationshipsXform();
                return xform.parseStream(stream);
              },
              parseWorkbook: function parseWorkbook(stream) {
                var xform = new WorkbookXform();
                return xform.parseStream(stream);
              },
              parseSharedStrings: function parseSharedStrings(stream) {
                var xform = new SharedStringsXform();
                return xform.parseStream(stream);
              },
              reconcile: function reconcile(model, options) {
                var workbookXform = new WorkbookXform();
                var worksheetXform = new WorksheetXform(options);
                var drawingXform = new DrawingXform();
                workbookXform.reconcile(model); // reconcile drawings with their rels

                var drawingOptions = {
                  media: model.media,
                  mediaIndex: model.mediaIndex,
                };
                Object.keys(model.drawings).forEach(function(name) {
                  var drawing = model.drawings[name];
                  var drawingRel = model.drawingRels[name];

                  if (drawingRel) {
                    drawingOptions.rels = drawingRel.reduce(function(o, rel) {
                      o[rel.Id] = rel;
                      return o;
                    }, {});
                    drawingXform.reconcile(drawing, drawingOptions);
                  }
                });
                var sheetOptions = {
                  styles: model.styles,
                  sharedStrings: model.sharedStrings,
                  media: model.media,
                  mediaIndex: model.mediaIndex,
                  date1904: model.properties && model.properties.date1904,
                  drawings: model.drawings,
                  comments: model.comments,
                };
                model.worksheets.forEach(function(worksheet) {
                  worksheet.relationships =
                    model.worksheetRels[worksheet.sheetNo];
                  worksheetXform.reconcile(worksheet, sheetOptions);
                }); // delete unnecessary parts

                delete model.worksheetHash;
                delete model.worksheetRels;
                delete model.globalRels;
                delete model.sharedStrings;
                delete model.workbookRels;
                delete model.sheetDefs;
                delete model.styles;
                delete model.mediaIndex;
                delete model.drawings;
                delete model.drawingRels;
              },
              processWorksheetEntry: function processWorksheetEntry(
                entry,
                model,
                options
              ) {
                var match = entry.path.match(
                  /xl\/worksheets\/sheet(\d+)[.]xml/
                );

                if (match) {
                  var sheetNo = match[1];
                  var xform = new WorksheetXform(options);
                  return xform.parseStream(entry).then(function(worksheet) {
                    worksheet.sheetNo = sheetNo;
                    model.worksheetHash[entry.path] = worksheet;
                    model.worksheets.push(worksheet);
                  });
                }

                return undefined;
              },
              processCommentEntry: function processCommentEntry(entry, model) {
                var match = entry.path.match(/xl\/(comments\d+)[.]xml/);

                if (match) {
                  var name = match[1];
                  var xform = new CommentsXform();
                  return xform.parseStream(entry).then(function(comments) {
                    model.comments['../'.concat(name, '.xml')] = comments;
                  });
                }

                return undefined;
              },
              processWorksheetRelsEntry: function processWorksheetRelsEntry(
                entry,
                model
              ) {
                var match = entry.path.match(
                  /xl\/worksheets\/_rels\/sheet(\d+)[.]xml.rels/
                );

                if (match) {
                  var sheetNo = match[1];
                  var xform = new RelationshipsXform();
                  return xform.parseStream(entry).then(function(relationships) {
                    model.worksheetRels[sheetNo] = relationships;
                  });
                }

                return undefined;
              },
              processMediaEntry: function processMediaEntry(entry, model) {
                var match = entry.path.match(
                  /xl\/media\/([a-zA-Z0-9]+[.][a-zA-Z0-9]{3,4})$/
                );

                if (match) {
                  var filename = match[1];
                  var lastDot = filename.lastIndexOf('.');

                  if (lastDot === -1) {
                    // if we can't determine extension, ignore it
                    return undefined;
                  }

                  var extension = filename.substr(lastDot + 1);
                  var name = filename.substr(0, lastDot);
                  return new PromiseLib.Promise(function(resolve, reject) {
                    var streamBuf = new StreamBuf();
                    streamBuf.on('finish', function() {
                      model.mediaIndex[filename] = model.media.length;
                      model.mediaIndex[name] = model.media.length;
                      var medium = {
                        type: 'image',
                        name: name,
                        extension: extension,
                        buffer: streamBuf.toBuffer(),
                      };
                      model.media.push(medium);
                      resolve();
                    });
                    entry.on('error', function(error) {
                      reject(error);
                    });
                    entry.pipe(streamBuf);
                  });
                }

                return undefined;
              },
              processDrawingEntry: function processDrawingEntry(entry, model) {
                var match = entry.path.match(
                  /xl\/drawings\/([a-zA-Z0-9]+)[.]xml/
                );

                if (match) {
                  var name = match[1];
                  var xform = new DrawingXform();
                  return xform.parseStream(entry).then(function(drawing) {
                    model.drawings[name] = drawing;
                  });
                }

                return undefined;
              },
              processDrawingRelsEntry: function processDrawingRelsEntry(
                entry,
                model
              ) {
                var match = entry.path.match(
                  /xl\/drawings\/_rels\/([a-zA-Z0-9]+)[.]xml[.]rels/
                );

                if (match) {
                  var name = match[1];
                  var xform = new RelationshipsXform();
                  return xform.parseStream(entry).then(function(relationships) {
                    model.drawingRels[name] = relationships;
                  });
                }

                return undefined;
              },
              processThemeEntry: function processThemeEntry(entry, model) {
                var match = entry.path.match(/xl\/theme\/([a-zA-Z0-9]+)[.]xml/);

                if (match) {
                  return new PromiseLib.Promise(function(resolve, reject) {
                    var name = match[1]; // TODO: stream entry into buffer and store the xml in the model.themes[]

                    var stream = new StreamBuf();
                    entry.on('error', reject);
                    stream.on('error', reject);
                    stream.on('finish', function() {
                      model.themes[name] = stream.read().toString();
                      resolve();
                    });
                    entry.pipe(stream);
                  });
                }

                return undefined;
              },
              processIgnoreEntry: function processIgnoreEntry(entry) {
                entry.autodrain();
              },
              createInputStream: function createInputStream(options) {
                var self = this;
                var model = {
                  worksheets: [],
                  worksheetHash: {},
                  worksheetRels: [],
                  themes: {},
                  media: [],
                  mediaIndex: {},
                  drawings: {},
                  drawingRels: {},
                  comments: {},
                }; // we have to be prepared to read the zip entries in whatever order they arrive

                var promises = [];
                var stream = new ZipStream.ZipReader({
                  getEntryType: function getEntryType(path) {
                    return path.match(/xl\/media\//) ? 'nodebuffer' : 'string';
                  },
                });
                stream.on('entry', function(entry) {
                  var promise = null;
                  var entryPath = entry.path;

                  if (entryPath[0] === '/') {
                    entryPath = entryPath.substr(1);
                  }

                  switch (entryPath) {
                    case '_rels/.rels':
                      promise = self
                        .parseRels(entry)
                        .then(function(relationships) {
                          model.globalRels = relationships;
                        });
                      break;

                    case 'xl/workbook.xml':
                      promise = self
                        .parseWorkbook(entry)
                        .then(function(workbook) {
                          model.sheets = workbook.sheets;
                          model.definedNames = workbook.definedNames;
                          model.views = workbook.views;
                          model.properties = workbook.properties;
                        });
                      break;

                    case 'xl/_rels/workbook.xml.rels':
                      promise = self
                        .parseRels(entry)
                        .then(function(relationships) {
                          model.workbookRels = relationships;
                        });
                      break;

                    case 'xl/sharedStrings.xml':
                      model.sharedStrings = new SharedStringsXform();
                      promise = model.sharedStrings.parseStream(entry);
                      break;

                    case 'xl/styles.xml':
                      model.styles = new StylesXform();
                      promise = model.styles.parseStream(entry);
                      break;

                    case 'docProps/app.xml': {
                      var appXform = new AppXform();
                      promise = appXform
                        .parseStream(entry)
                        .then(function(appProperties) {
                          Object.assign(model, {
                            company: appProperties.company,
                            manager: appProperties.manager,
                          });
                        });
                      break;
                    }

                    case 'docProps/core.xml': {
                      var coreXform = new CoreXform();
                      promise = coreXform
                        .parseStream(entry)
                        .then(function(coreProperties) {
                          Object.assign(model, coreProperties);
                        });
                      break;
                    }

                    default:
                      promise =
                        self.processWorksheetEntry(entry, model, options) ||
                        self.processWorksheetRelsEntry(entry, model) ||
                        self.processThemeEntry(entry, model) ||
                        self.processMediaEntry(entry, model) ||
                        self.processDrawingEntry(entry, model) ||
                        self.processCommentEntry(entry, model) ||
                        self.processDrawingRelsEntry(entry, model) ||
                        self.processIgnoreEntry(entry);
                      break;
                  }

                  if (promise) {
                    promise = promise['catch'](function(error) {
                      stream.destroy(error);
                      throw error;
                    });
                    promises.push(promise);
                    promise = null;
                  }
                });
                stream.on('finished', function() {
                  PromiseLib.Promise.all(promises)
                    .then(function() {
                      self.reconcile(model, options); // apply model

                      self.workbook.model = model;
                    })
                    .then(function() {
                      stream.emit('done');
                    })
                    ['catch'](function(error) {
                      stream.emit('error', error);
                    });
                });
                return stream;
              },
              read: function read(stream, options) {
                options = options || {};
                var self = this;
                var zipStream = this.createInputStream(options);
                return new PromiseLib.Promise(function(resolve, reject) {
                  zipStream
                    .on('done', function() {
                      resolve(self.workbook);
                    })
                    .on('error', function(error) {
                      reject(error);
                    });
                  stream.pipe(zipStream);
                });
              },
              load: function load(data, options) {
                var self = this;

                if (options === undefined) {
                  options = {};
                }

                var zipStream = this.createInputStream();
                return new PromiseLib.Promise(function(resolve, reject) {
                  zipStream
                    .on('done', function() {
                      resolve(self.workbook);
                    })
                    .on('error', function(error) {
                      reject(error);
                    });

                  if (options.base64) {
                    var buffer = Buffer.from(data.toString(), 'base64');
                    zipStream.write(buffer);
                  } else {
                    zipStream.write(data);
                  }

                  zipStream.end();
                });
              },
              // =========================================================================
              // Write
              addMedia: function addMedia(zip, model) {
                return PromiseLib.Promise.all(
                  model.media.map(function(medium) {
                    if (medium.type === 'image') {
                      var filename = 'xl/media/'
                        .concat(medium.name, '.')
                        .concat(medium.extension);

                      if (medium.filename) {
                        return fsReadFileAsync(medium.filename).then(function(
                          data
                        ) {
                          zip.append(data, {
                            name: filename,
                          });
                        });
                      }

                      if (medium.buffer) {
                        return new PromiseLib.Promise(function(resolve) {
                          zip.append(medium.buffer, {
                            name: filename,
                          });
                          resolve();
                        });
                      }

                      if (medium.base64) {
                        return new PromiseLib.Promise(function(resolve) {
                          var dataimg64 = medium.base64;
                          var content = dataimg64.substring(
                            dataimg64.indexOf(',') + 1
                          );
                          zip.append(content, {
                            name: filename,
                            base64: true,
                          });
                          resolve();
                        });
                      }
                    }

                    return PromiseLib.Promise.reject(
                      new Error('Unsupported media')
                    );
                  })
                );
              },
              addDrawings: function addDrawings(zip, model) {
                var drawingXform = new DrawingXform();
                var relsXform = new RelationshipsXform();
                var promises = [];
                model.worksheets.forEach(function(worksheet) {
                  var drawing = worksheet.drawing;

                  if (drawing) {
                    promises.push(
                      new PromiseLib.Promise(function(resolve) {
                        drawingXform.prepare(drawing, {});
                        var xml = drawingXform.toXml(drawing);
                        zip.append(xml, {
                          name: 'xl/drawings/'.concat(drawing.name, '.xml'),
                        });
                        xml = relsXform.toXml(drawing.rels);
                        zip.append(xml, {
                          name: 'xl/drawings/_rels/'.concat(
                            drawing.name,
                            '.xml.rels'
                          ),
                        });
                        resolve();
                      })
                    );
                  }
                });
                return PromiseLib.Promise.all(promises);
              },
              addContentTypes: function addContentTypes(zip, model) {
                return new PromiseLib.Promise(function(resolve) {
                  var xform = new ContentTypesXform();
                  var xml = xform.toXml(model);
                  zip.append(xml, {
                    name: '[Content_Types].xml',
                  });
                  resolve();
                });
              },
              addApp: function addApp(zip, model) {
                return new PromiseLib.Promise(function(resolve) {
                  var xform = new AppXform();
                  var xml = xform.toXml(model);
                  zip.append(xml, {
                    name: 'docProps/app.xml',
                  });
                  resolve();
                });
              },
              addCore: function addCore(zip, model) {
                return new PromiseLib.Promise(function(resolve) {
                  var coreXform = new CoreXform();
                  zip.append(coreXform.toXml(model), {
                    name: 'docProps/core.xml',
                  });
                  resolve();
                });
              },
              addThemes: function addThemes(zip, model) {
                return new PromiseLib.Promise(function(resolve) {
                  var themes = model.themes || {
                    theme1: theme1Xml,
                  };
                  Object.keys(themes).forEach(function(name) {
                    var xml = themes[name];
                    var path = 'xl/theme/'.concat(name, '.xml');
                    zip.append(xml, {
                      name: path,
                    });
                  });
                  resolve();
                });
              },
              addOfficeRels: function addOfficeRels(zip) {
                return new PromiseLib.Promise(function(resolve) {
                  var xform = new RelationshipsXform();
                  var xml = xform.toXml([
                    {
                      Id: 'rId1',
                      Type: XLSX.RelType.OfficeDocument,
                      Target: 'xl/workbook.xml',
                    },
                    {
                      Id: 'rId2',
                      Type: XLSX.RelType.CoreProperties,
                      Target: 'docProps/core.xml',
                    },
                    {
                      Id: 'rId3',
                      Type: XLSX.RelType.ExtenderProperties,
                      Target: 'docProps/app.xml',
                    },
                  ]);
                  zip.append(xml, {
                    name: '_rels/.rels',
                  });
                  resolve();
                });
              },
              addWorkbookRels: function addWorkbookRels(zip, model) {
                var count = 1;
                var relationships = [
                  {
                    Id: 'rId'.concat(count++),
                    Type: XLSX.RelType.Styles,
                    Target: 'styles.xml',
                  },
                  {
                    Id: 'rId'.concat(count++),
                    Type: XLSX.RelType.Theme,
                    Target: 'theme/theme1.xml',
                  },
                ];

                if (model.sharedStrings.count) {
                  relationships.push({
                    Id: 'rId'.concat(count++),
                    Type: XLSX.RelType.SharedStrings,
                    Target: 'sharedStrings.xml',
                  });
                }

                model.worksheets.forEach(function(worksheet) {
                  worksheet.rId = 'rId'.concat(count++);
                  relationships.push({
                    Id: worksheet.rId,
                    Type: XLSX.RelType.Worksheet,
                    Target: 'worksheets/sheet'.concat(worksheet.id, '.xml'),
                  });
                });
                return new PromiseLib.Promise(function(resolve) {
                  var xform = new RelationshipsXform();
                  var xml = xform.toXml(relationships);
                  zip.append(xml, {
                    name: 'xl/_rels/workbook.xml.rels',
                  });
                  resolve();
                });
              },
              addSharedStrings: function addSharedStrings(zip, model) {
                if (!model.sharedStrings || !model.sharedStrings.count) {
                  return PromiseLib.Promise.resolve();
                }

                return new PromiseLib.Promise(function(resolve) {
                  zip.append(model.sharedStrings.xml, {
                    name: 'xl/sharedStrings.xml',
                  });
                  resolve();
                });
              },
              addStyles: function addStyles(zip, model) {
                return new PromiseLib.Promise(function(resolve) {
                  var xml = model.styles.xml;

                  if (xml) {
                    zip.append(xml, {
                      name: 'xl/styles.xml',
                    });
                  }

                  resolve();
                });
              },
              addWorkbook: function addWorkbook(zip, model) {
                return new PromiseLib.Promise(function(resolve) {
                  var xform = new WorkbookXform();
                  zip.append(xform.toXml(model), {
                    name: 'xl/workbook.xml',
                  });
                  resolve();
                });
              },
              addWorksheets: function addWorksheets(zip, model) {
                return new PromiseLib.Promise(function(resolve) {
                  // preparation phase
                  var worksheetXform = new WorksheetXform();
                  var relationshipsXform = new RelationshipsXform();
                  var commentsXform = new CommentsXform();
                  var vmlNotesXform = new VmlNotesXform(); // write sheets

                  model.worksheets.forEach(function(worksheet) {
                    var xmlStream = new XmlStream();
                    worksheetXform.render(xmlStream, worksheet);
                    zip.append(xmlStream.xml, {
                      name: 'xl/worksheets/sheet'.concat(worksheet.id, '.xml'),
                    });

                    if (worksheet.rels && worksheet.rels.length) {
                      xmlStream = new XmlStream();
                      relationshipsXform.render(xmlStream, worksheet.rels);
                      zip.append(xmlStream.xml, {
                        name: 'xl/worksheets/_rels/sheet'.concat(
                          worksheet.id,
                          '.xml.rels'
                        ),
                      });
                    }

                    if (worksheet.comments.length > 0) {
                      xmlStream = new XmlStream();
                      commentsXform.render(xmlStream, worksheet);
                      zip.append(xmlStream.xml, {
                        name: 'xl/comments'.concat(worksheet.id, '.xml'),
                      });
                      xmlStream = new XmlStream();
                      vmlNotesXform.render(xmlStream, worksheet);
                      zip.append(xmlStream.xml, {
                        name: 'xl/drawings/vmlDrawing'.concat(
                          worksheet.id,
                          '.vml'
                        ),
                      });
                    }
                  });
                  resolve();
                });
              },
              _finalize: function _finalize(zip) {
                var _this = this;

                return new PromiseLib.Promise(function(resolve, reject) {
                  zip.on('finish', function() {
                    resolve(_this);
                  });
                  zip.on('error', reject);
                  zip.finalize();
                });
              },
              prepareModel: function prepareModel(model, options) {
                // ensure following properties have sane values
                model.creator = model.creator || 'ExcelJS';
                model.lastModifiedBy = model.lastModifiedBy || 'ExcelJS';
                model.created = model.created || new Date();
                model.modified = model.modified || new Date();
                model.useSharedStrings =
                  options.useSharedStrings !== undefined
                    ? options.useSharedStrings
                    : true;
                model.useStyles =
                  options.useStyles !== undefined ? options.useStyles : true; // Manage the shared strings

                model.sharedStrings = new SharedStringsXform(); // add a style manager to handle cell formats, fonts, etc.

                model.styles = model.useStyles
                  ? new StylesXform(true)
                  : new StylesXform.Mock(); // prepare all of the things before the render

                var workbookXform = new WorkbookXform();
                var worksheetXform = new WorksheetXform();
                workbookXform.prepare(model);
                var worksheetOptions = {
                  sharedStrings: model.sharedStrings,
                  styles: model.styles,
                  date1904: model.properties.date1904,
                  drawingsCount: 0,
                  media: model.media,
                };
                worksheetOptions.drawings = model.drawings = [];
                worksheetOptions.commentRefs = model.commentRefs = [];
                model.worksheets.forEach(function(worksheet) {
                  worksheetXform.prepare(worksheet, worksheetOptions);
                }); // TODO: workbook drawing list
              },
              write: function write(stream, options) {
                var _this2 = this;

                options = options || {};
                var model = this.workbook.model;
                var zip = new ZipStream.ZipWriter();
                zip.pipe(stream);
                this.prepareModel(model, options); // render

                return PromiseLib.Promise.resolve()
                  .then(function() {
                    return _this2.addContentTypes(zip, model);
                  })
                  .then(function() {
                    return _this2.addOfficeRels(zip, model);
                  })
                  .then(function() {
                    return _this2.addWorkbookRels(zip, model);
                  })
                  .then(function() {
                    return _this2.addWorksheets(zip, model);
                  })
                  .then(function() {
                    return _this2.addSharedStrings(zip, model);
                  }) // always after worksheets
                  .then(function() {
                    return _this2.addDrawings(zip, model);
                  })
                  .then(function() {
                    var promises = [
                      _this2.addThemes(zip, model),
                      _this2.addStyles(zip, model),
                    ];
                    return PromiseLib.Promise.all(promises);
                  })
                  .then(function() {
                    return _this2.addMedia(zip, model);
                  })
                  .then(function() {
                    var afters = [
                      _this2.addApp(zip, model),
                      _this2.addCore(zip, model),
                    ];
                    return PromiseLib.Promise.all(afters);
                  })
                  .then(function() {
                    return _this2.addWorkbook(zip, model);
                  })
                  .then(function() {
                    return _this2._finalize(zip);
                  });
              },
              writeFile: function writeFile(filename, options) {
                var self = this;
                var stream = fs.createWriteStream(filename);
                return new PromiseLib.Promise(function(resolve, reject) {
                  stream.on('finish', function() {
                    resolve();
                  });
                  stream.on('error', function(error) {
                    reject(error);
                  });
                  self
                    .write(stream, options)
                    .then(function() {
                      stream.end();
                    })
                    ['catch'](function(error) {
                      reject(error);
                    });
                });
              },
              writeBuffer: function writeBuffer(options) {
                var self = this;
                var stream = new StreamBuf();
                return self.write(stream, options).then(function() {
                  return stream.read();
                });
              },
            };
          }.call(this, require('buffer').Buffer));
        },
        {
          '../utils/promise': 18,
          '../utils/stream-buf': 20,
          '../utils/utils': 23,
          '../utils/xml-stream': 24,
          '../utils/zip-stream': 25,
          './rel-type': 27,
          './xform/book/workbook-xform': 33,
          './xform/comment/comments-xform': 35,
          './xform/comment/vml-notes-xform': 38,
          './xform/core/app-xform': 41,
          './xform/core/content-types-xform': 42,
          './xform/core/core-xform': 43,
          './xform/core/relationships-xform': 45,
          './xform/drawing/drawing-xform': 50,
          './xform/sheet/worksheet-xform': 79,
          './xform/strings/shared-strings-xform': 88,
          './xform/style/styles-xform': 97,
          './xml/theme1.js': 100,
          buffer: 106,
          fs: 105,
        },
      ],
      100: [
        function(require, module, exports) {
          'use strict';

          /* eslint-disable */
          module.exports =
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>\n<a:theme xmlns:a="http://schemas.openxmlformats.org/drawingml/2006/main" name="Office Theme"> <a:themeElements> <a:clrScheme name="Office"> <a:dk1> <a:sysClr val="windowText" lastClr="000000"/> </a:dk1> <a:lt1> <a:sysClr val="window" lastClr="FFFFFF"/> </a:lt1> <a:dk2> <a:srgbClr val="1F497D"/> </a:dk2> <a:lt2> <a:srgbClr val="EEECE1"/> </a:lt2> <a:accent1> <a:srgbClr val="4F81BD"/> </a:accent1> <a:accent2> <a:srgbClr val="C0504D"/> </a:accent2> <a:accent3> <a:srgbClr val="9BBB59"/> </a:accent3> <a:accent4> <a:srgbClr val="8064A2"/> </a:accent4> <a:accent5> <a:srgbClr val="4BACC6"/> </a:accent5> <a:accent6> <a:srgbClr val="F79646"/> </a:accent6> <a:hlink> <a:srgbClr val="0000FF"/> </a:hlink> <a:folHlink> <a:srgbClr val="800080"/> </a:folHlink> </a:clrScheme> <a:fontScheme name="Office"> <a:majorFont> <a:latin typeface="Cambria"/> <a:ea typeface=""/> <a:cs typeface=""/> <a:font script="Jpan" typeface="ＭＳ Ｐゴシック"/> <a:font script="Hang" typeface="맑은 고딕"/> <a:font script="Hans" typeface="宋体"/> <a:font script="Hant" typeface="新細明體"/> <a:font script="Arab" typeface="Times New Roman"/> <a:font script="Hebr" typeface="Times New Roman"/> <a:font script="Thai" typeface="Tahoma"/> <a:font script="Ethi" typeface="Nyala"/> <a:font script="Beng" typeface="Vrinda"/> <a:font script="Gujr" typeface="Shruti"/> <a:font script="Khmr" typeface="MoolBoran"/> <a:font script="Knda" typeface="Tunga"/> <a:font script="Guru" typeface="Raavi"/> <a:font script="Cans" typeface="Euphemia"/> <a:font script="Cher" typeface="Plantagenet Cherokee"/> <a:font script="Yiii" typeface="Microsoft Yi Baiti"/> <a:font script="Tibt" typeface="Microsoft Himalaya"/> <a:font script="Thaa" typeface="MV Boli"/> <a:font script="Deva" typeface="Mangal"/> <a:font script="Telu" typeface="Gautami"/> <a:font script="Taml" typeface="Latha"/> <a:font script="Syrc" typeface="Estrangelo Edessa"/> <a:font script="Orya" typeface="Kalinga"/> <a:font script="Mlym" typeface="Kartika"/> <a:font script="Laoo" typeface="DokChampa"/> <a:font script="Sinh" typeface="Iskoola Pota"/> <a:font script="Mong" typeface="Mongolian Baiti"/> <a:font script="Viet" typeface="Times New Roman"/> <a:font script="Uigh" typeface="Microsoft Uighur"/> <a:font script="Geor" typeface="Sylfaen"/> </a:majorFont> <a:minorFont> <a:latin typeface="Calibri"/> <a:ea typeface=""/> <a:cs typeface=""/> <a:font script="Jpan" typeface="ＭＳ Ｐゴシック"/> <a:font script="Hang" typeface="맑은 고딕"/> <a:font script="Hans" typeface="宋体"/> <a:font script="Hant" typeface="新細明體"/> <a:font script="Arab" typeface="Arial"/> <a:font script="Hebr" typeface="Arial"/> <a:font script="Thai" typeface="Tahoma"/> <a:font script="Ethi" typeface="Nyala"/> <a:font script="Beng" typeface="Vrinda"/> <a:font script="Gujr" typeface="Shruti"/> <a:font script="Khmr" typeface="DaunPenh"/> <a:font script="Knda" typeface="Tunga"/> <a:font script="Guru" typeface="Raavi"/> <a:font script="Cans" typeface="Euphemia"/> <a:font script="Cher" typeface="Plantagenet Cherokee"/> <a:font script="Yiii" typeface="Microsoft Yi Baiti"/> <a:font script="Tibt" typeface="Microsoft Himalaya"/> <a:font script="Thaa" typeface="MV Boli"/> <a:font script="Deva" typeface="Mangal"/> <a:font script="Telu" typeface="Gautami"/> <a:font script="Taml" typeface="Latha"/> <a:font script="Syrc" typeface="Estrangelo Edessa"/> <a:font script="Orya" typeface="Kalinga"/> <a:font script="Mlym" typeface="Kartika"/> <a:font script="Laoo" typeface="DokChampa"/> <a:font script="Sinh" typeface="Iskoola Pota"/> <a:font script="Mong" typeface="Mongolian Baiti"/> <a:font script="Viet" typeface="Arial"/> <a:font script="Uigh" typeface="Microsoft Uighur"/> <a:font script="Geor" typeface="Sylfaen"/> </a:minorFont> </a:fontScheme> <a:fmtScheme name="Office"> <a:fillStyleLst> <a:solidFill> <a:schemeClr val="phClr"/> </a:solidFill> <a:gradFill rotWithShape="1"> <a:gsLst> <a:gs pos="0"> <a:schemeClr val="phClr"> <a:tint val="50000"/> <a:satMod val="300000"/> </a:schemeClr> </a:gs> <a:gs pos="35000"> <a:schemeClr val="phClr"> <a:tint val="37000"/> <a:satMod val="300000"/> </a:schemeClr> </a:gs> <a:gs pos="100000"> <a:schemeClr val="phClr"> <a:tint val="15000"/> <a:satMod val="350000"/> </a:schemeClr> </a:gs> </a:gsLst> <a:lin ang="16200000" scaled="1"/> </a:gradFill> <a:gradFill rotWithShape="1"> <a:gsLst> <a:gs pos="0"> <a:schemeClr val="phClr"> <a:tint val="100000"/> <a:shade val="100000"/> <a:satMod val="130000"/> </a:schemeClr> </a:gs> <a:gs pos="100000"> <a:schemeClr val="phClr"> <a:tint val="50000"/> <a:shade val="100000"/> <a:satMod val="350000"/> </a:schemeClr> </a:gs> </a:gsLst> <a:lin ang="16200000" scaled="0"/> </a:gradFill> </a:fillStyleLst> <a:lnStyleLst> <a:ln w="9525" cap="flat" cmpd="sng" algn="ctr"> <a:solidFill> <a:schemeClr val="phClr"> <a:shade val="95000"/> <a:satMod val="105000"/> </a:schemeClr> </a:solidFill> <a:prstDash val="solid"/> </a:ln> <a:ln w="25400" cap="flat" cmpd="sng" algn="ctr"> <a:solidFill> <a:schemeClr val="phClr"/> </a:solidFill> <a:prstDash val="solid"/> </a:ln> <a:ln w="38100" cap="flat" cmpd="sng" algn="ctr"> <a:solidFill> <a:schemeClr val="phClr"/> </a:solidFill> <a:prstDash val="solid"/> </a:ln> </a:lnStyleLst> <a:effectStyleLst> <a:effectStyle> <a:effectLst> <a:outerShdw blurRad="40000" dist="20000" dir="5400000" rotWithShape="0"> <a:srgbClr val="000000"> <a:alpha val="38000"/> </a:srgbClr> </a:outerShdw> </a:effectLst> </a:effectStyle> <a:effectStyle> <a:effectLst> <a:outerShdw blurRad="40000" dist="23000" dir="5400000" rotWithShape="0"> <a:srgbClr val="000000"> <a:alpha val="35000"/> </a:srgbClr> </a:outerShdw> </a:effectLst> </a:effectStyle> <a:effectStyle> <a:effectLst> <a:outerShdw blurRad="40000" dist="23000" dir="5400000" rotWithShape="0"> <a:srgbClr val="000000"> <a:alpha val="35000"/> </a:srgbClr> </a:outerShdw> </a:effectLst> <a:scene3d> <a:camera prst="orthographicFront"> <a:rot lat="0" lon="0" rev="0"/> </a:camera> <a:lightRig rig="threePt" dir="t"> <a:rot lat="0" lon="0" rev="1200000"/> </a:lightRig> </a:scene3d> <a:sp3d> <a:bevelT w="63500" h="25400"/> </a:sp3d> </a:effectStyle> </a:effectStyleLst> <a:bgFillStyleLst> <a:solidFill> <a:schemeClr val="phClr"/> </a:solidFill> <a:gradFill rotWithShape="1"> <a:gsLst> <a:gs pos="0"> <a:schemeClr val="phClr"> <a:tint val="40000"/> <a:satMod val="350000"/> </a:schemeClr> </a:gs> <a:gs pos="40000"> <a:schemeClr val="phClr"> <a:tint val="45000"/> <a:shade val="99000"/> <a:satMod val="350000"/> </a:schemeClr> </a:gs> <a:gs pos="100000"> <a:schemeClr val="phClr"> <a:shade val="20000"/> <a:satMod val="255000"/> </a:schemeClr> </a:gs> </a:gsLst> <a:path path="circle"> <a:fillToRect l="50000" t="-80000" r="50000" b="180000"/> </a:path> </a:gradFill> <a:gradFill rotWithShape="1"> <a:gsLst> <a:gs pos="0"> <a:schemeClr val="phClr"> <a:tint val="80000"/> <a:satMod val="300000"/> </a:schemeClr> </a:gs> <a:gs pos="100000"> <a:schemeClr val="phClr"> <a:shade val="30000"/> <a:satMod val="200000"/> </a:schemeClr> </a:gs> </a:gsLst> <a:path path="circle"> <a:fillToRect l="50000" t="50000" r="50000" b="50000"/> </a:path> </a:gradFill> </a:bgFillStyleLst> </a:fmtScheme> </a:themeElements> <a:objectDefaults> <a:spDef> <a:spPr/> <a:bodyPr/> <a:lstStyle/> <a:style> <a:lnRef idx="1"> <a:schemeClr val="accent1"/> </a:lnRef> <a:fillRef idx="3"> <a:schemeClr val="accent1"/> </a:fillRef> <a:effectRef idx="2"> <a:schemeClr val="accent1"/> </a:effectRef> <a:fontRef idx="minor"> <a:schemeClr val="lt1"/> </a:fontRef> </a:style> </a:spDef> <a:lnDef> <a:spPr/> <a:bodyPr/> <a:lstStyle/> <a:style> <a:lnRef idx="2"> <a:schemeClr val="accent1"/> </a:lnRef> <a:fillRef idx="0"> <a:schemeClr val="accent1"/> </a:fillRef> <a:effectRef idx="1"> <a:schemeClr val="accent1"/> </a:effectRef> <a:fontRef idx="minor"> <a:schemeClr val="tx1"/> </a:fontRef> </a:style> </a:lnDef> </a:objectDefaults> <a:extraClrSchemeLst/> </a:theme>';
        },
        {},
      ],
      101: [
        function(require, module, exports) {
          (function() {
            'use strict';

            function defineArgumentsExtended(extended, is) {
              var pSlice = Array.prototype.slice,
                isArguments = is.isArguments;

              function argsToArray(args, slice) {
                var i = -1,
                  j = 0,
                  l = args.length,
                  ret = [];
                slice = slice || 0;
                i += slice;
                while (++i < l) {
                  ret[j++] = args[i];
                }
                return ret;
              }

              return extended
                .define(isArguments, {
                  toArray: argsToArray,
                })
                .expose({
                  argsToArray: argsToArray,
                });
            }

            if ('undefined' !== typeof exports) {
              if ('undefined' !== typeof module && module.exports) {
                module.exports = defineArgumentsExtended(
                  require('extended'),
                  require('is-extended')
                );
              }
            } else if ('function' === typeof define && define.amd) {
              define(['extended', 'is-extended'], function(extended, is) {
                return defineArgumentsExtended(extended, is);
              });
            } else {
              this.argumentsExtended = defineArgumentsExtended(
                this.extended,
                this.isExtended
              );
            }
          }.call(this));
        },
        { extended: 113, 'is-extended': 129 },
      ],
      102: [
        function(require, module, exports) {
          (function() {
            'use strict';
            /*global define*/

            function defineArray(extended, is, args) {
              var isString = is.isString,
                isArray = Array.isArray || is.isArray,
                isDate = is.isDate,
                floor = Math.floor,
                abs = Math.abs,
                mathMax = Math.max,
                mathMin = Math.min,
                arrayProto = Array.prototype,
                arrayIndexOf = arrayProto.indexOf,
                arrayForEach = arrayProto.forEach,
                arrayMap = arrayProto.map,
                arrayReduce = arrayProto.reduce,
                arrayReduceRight = arrayProto.reduceRight,
                arrayFilter = arrayProto.filter,
                arrayEvery = arrayProto.every,
                arraySome = arrayProto.some,
                argsToArray = args.argsToArray;

              function cross(num, cros) {
                return reduceRight(
                  cros,
                  function(a, b) {
                    if (!isArray(b)) {
                      b = [b];
                    }
                    b.unshift(num);
                    a.unshift(b);
                    return a;
                  },
                  []
                );
              }

              function permute(num, cross, length) {
                var ret = [];
                for (var i = 0; i < cross.length; i++) {
                  ret.push([num].concat(rotate(cross, i)).slice(0, length));
                }
                return ret;
              }

              function intersection(a, b) {
                var ret = [],
                  aOne,
                  i = -1,
                  l;
                l = a.length;
                while (++i < l) {
                  aOne = a[i];
                  if (indexOf(b, aOne) !== -1) {
                    ret.push(aOne);
                  }
                }
                return ret;
              }

              var _sort = (function() {
                var isAll = function(arr, test) {
                  return every(arr, test);
                };

                var defaultCmp = function(a, b) {
                  return a - b;
                };

                var dateSort = function(a, b) {
                  return a.getTime() - b.getTime();
                };

                return function _sort(arr, property) {
                  var ret = [];
                  if (isArray(arr)) {
                    ret = arr.slice();
                    if (property) {
                      if (typeof property === 'function') {
                        ret.sort(property);
                      } else {
                        ret.sort(function(a, b) {
                          var aProp = a[property],
                            bProp = b[property];
                          if (isString(aProp) && isString(bProp)) {
                            return aProp > bProp ? 1 : aProp < bProp ? -1 : 0;
                          } else if (isDate(aProp) && isDate(bProp)) {
                            return aProp.getTime() - bProp.getTime();
                          } else {
                            return aProp - bProp;
                          }
                        });
                      }
                    } else {
                      if (isAll(ret, isString)) {
                        ret.sort();
                      } else if (isAll(ret, isDate)) {
                        ret.sort(dateSort);
                      } else {
                        ret.sort(defaultCmp);
                      }
                    }
                  }
                  return ret;
                };
              })();

              function indexOf(arr, searchElement, from) {
                var index = (from || 0) - 1,
                  length = arr.length;
                while (++index < length) {
                  if (arr[index] === searchElement) {
                    return index;
                  }
                }
                return -1;
              }

              function lastIndexOf(arr, searchElement, from) {
                if (!isArray(arr)) {
                  throw new TypeError();
                }

                var t = Object(arr);
                var len = t.length >>> 0;
                if (len === 0) {
                  return -1;
                }

                var n = len;
                if (arguments.length > 2) {
                  n = Number(arguments[2]);
                  if (n !== n) {
                    n = 0;
                  } else if (n !== 0 && n !== 1 / 0 && n !== -(1 / 0)) {
                    n = (n > 0 || -1) * floor(abs(n));
                  }
                }

                var k = n >= 0 ? mathMin(n, len - 1) : len - abs(n);

                for (; k >= 0; k--) {
                  if (k in t && t[k] === searchElement) {
                    return k;
                  }
                }
                return -1;
              }

              function filter(arr, iterator, scope) {
                if (arr && arrayFilter && arrayFilter === arr.filter) {
                  return arr.filter(iterator, scope);
                }
                if (!isArray(arr) || typeof iterator !== 'function') {
                  throw new TypeError();
                }

                var t = Object(arr);
                var len = t.length >>> 0;
                var res = [];
                for (var i = 0; i < len; i++) {
                  if (i in t) {
                    var val = t[i]; // in case fun mutates this
                    if (iterator.call(scope, val, i, t)) {
                      res.push(val);
                    }
                  }
                }
                return res;
              }

              function forEach(arr, iterator, scope) {
                if (!isArray(arr) || typeof iterator !== 'function') {
                  throw new TypeError();
                }
                if (arr && arrayForEach && arrayForEach === arr.forEach) {
                  arr.forEach(iterator, scope);
                  return arr;
                }
                for (var i = 0, len = arr.length; i < len; ++i) {
                  iterator.call(scope || arr, arr[i], i, arr);
                }

                return arr;
              }

              function every(arr, iterator, scope) {
                if (arr && arrayEvery && arrayEvery === arr.every) {
                  return arr.every(iterator, scope);
                }
                if (!isArray(arr) || typeof iterator !== 'function') {
                  throw new TypeError();
                }
                var t = Object(arr);
                var len = t.length >>> 0;
                for (var i = 0; i < len; i++) {
                  if (i in t && !iterator.call(scope, t[i], i, t)) {
                    return false;
                  }
                }
                return true;
              }

              function some(arr, iterator, scope) {
                if (arr && arraySome && arraySome === arr.some) {
                  return arr.some(iterator, scope);
                }
                if (!isArray(arr) || typeof iterator !== 'function') {
                  throw new TypeError();
                }
                var t = Object(arr);
                var len = t.length >>> 0;
                for (var i = 0; i < len; i++) {
                  if (i in t && iterator.call(scope, t[i], i, t)) {
                    return true;
                  }
                }
                return false;
              }

              function map(arr, iterator, scope) {
                if (arr && arrayMap && arrayMap === arr.map) {
                  return arr.map(iterator, scope);
                }
                if (!isArray(arr) || typeof iterator !== 'function') {
                  throw new TypeError();
                }

                var t = Object(arr);
                var len = t.length >>> 0;
                var res = [];
                for (var i = 0; i < len; i++) {
                  if (i in t) {
                    res.push(iterator.call(scope, t[i], i, t));
                  }
                }
                return res;
              }

              function reduce(arr, accumulator, curr) {
                var initial = arguments.length > 2;
                if (arr && arrayReduce && arrayReduce === arr.reduce) {
                  return initial
                    ? arr.reduce(accumulator, curr)
                    : arr.reduce(accumulator);
                }
                if (!isArray(arr) || typeof accumulator !== 'function') {
                  throw new TypeError();
                }
                var i = 0,
                  l = arr.length >> 0;
                if (arguments.length < 3) {
                  if (l === 0) {
                    throw new TypeError(
                      'Array length is 0 and no second argument'
                    );
                  }
                  curr = arr[0];
                  i = 1; // start accumulating at the second element
                } else {
                  curr = arguments[2];
                }
                while (i < l) {
                  if (i in arr) {
                    curr = accumulator.call(undefined, curr, arr[i], i, arr);
                  }
                  ++i;
                }
                return curr;
              }

              function reduceRight(arr, accumulator, curr) {
                var initial = arguments.length > 2;
                if (
                  arr &&
                  arrayReduceRight &&
                  arrayReduceRight === arr.reduceRight
                ) {
                  return initial
                    ? arr.reduceRight(accumulator, curr)
                    : arr.reduceRight(accumulator);
                }
                if (!isArray(arr) || typeof accumulator !== 'function') {
                  throw new TypeError();
                }

                var t = Object(arr);
                var len = t.length >>> 0;

                // no value to return if no initial value, empty array
                if (len === 0 && arguments.length === 2) {
                  throw new TypeError();
                }

                var k = len - 1;
                if (arguments.length >= 3) {
                  curr = arguments[2];
                } else {
                  do {
                    if (k in arr) {
                      curr = arr[k--];
                      break;
                    }
                  } while (true);
                }
                while (k >= 0) {
                  if (k in t) {
                    curr = accumulator.call(undefined, curr, t[k], k, t);
                  }
                  k--;
                }
                return curr;
              }

              function toArray(o) {
                var ret = [];
                if (o !== null) {
                  var args = argsToArray(arguments);
                  if (args.length === 1) {
                    if (isArray(o)) {
                      ret = o;
                    } else if (is.isHash(o)) {
                      for (var i in o) {
                        if (o.hasOwnProperty(i)) {
                          ret.push([i, o[i]]);
                        }
                      }
                    } else {
                      ret.push(o);
                    }
                  } else {
                    forEach(args, function(a) {
                      ret = ret.concat(toArray(a));
                    });
                  }
                }
                return ret;
              }

              function sum(array) {
                array = array || [];
                if (array.length) {
                  return reduce(array, function(a, b) {
                    return a + b;
                  });
                } else {
                  return 0;
                }
              }

              function avg(arr) {
                arr = arr || [];
                if (arr.length) {
                  var total = sum(arr);
                  if (is.isNumber(total)) {
                    return total / arr.length;
                  } else {
                    throw new Error('Cannot average an array of non numbers.');
                  }
                } else {
                  return 0;
                }
              }

              function sort(arr, cmp) {
                return _sort(arr, cmp);
              }

              function min(arr, cmp) {
                return _sort(arr, cmp)[0];
              }

              function max(arr, cmp) {
                return _sort(arr, cmp)[arr.length - 1];
              }

              function difference(arr1) {
                var ret = arr1,
                  args = flatten(argsToArray(arguments, 1));
                if (isArray(arr1)) {
                  ret = filter(arr1, function(a) {
                    return indexOf(args, a) === -1;
                  });
                }
                return ret;
              }

              function removeDuplicates(arr) {
                var ret = [],
                  i = -1,
                  l,
                  retLength = 0;
                if (arr) {
                  l = arr.length;
                  while (++i < l) {
                    var item = arr[i];
                    if (indexOf(ret, item) === -1) {
                      ret[retLength++] = item;
                    }
                  }
                }
                return ret;
              }

              function unique(arr) {
                return removeDuplicates(arr);
              }

              function rotate(arr, numberOfTimes) {
                var ret = arr.slice();
                if (typeof numberOfTimes !== 'number') {
                  numberOfTimes = 1;
                }
                if (numberOfTimes && isArray(arr)) {
                  if (numberOfTimes > 0) {
                    ret.push(ret.shift());
                    numberOfTimes--;
                  } else {
                    ret.unshift(ret.pop());
                    numberOfTimes++;
                  }
                  return rotate(ret, numberOfTimes);
                } else {
                  return ret;
                }
              }

              function permutations(arr, length) {
                var ret = [];
                if (isArray(arr)) {
                  var copy = arr.slice(0);
                  if (typeof length !== 'number') {
                    length = arr.length;
                  }
                  if (!length) {
                    ret = [[]];
                  } else if (length <= arr.length) {
                    ret = reduce(
                      arr,
                      function(a, b, i) {
                        var ret;
                        if (length > 1) {
                          ret = permute(b, rotate(copy, i).slice(1), length);
                        } else {
                          ret = [[b]];
                        }
                        return a.concat(ret);
                      },
                      []
                    );
                  }
                }
                return ret;
              }

              function zip() {
                var ret = [];
                var arrs = argsToArray(arguments);
                if (arrs.length > 1) {
                  var arr1 = arrs.shift();
                  if (isArray(arr1)) {
                    ret = reduce(
                      arr1,
                      function(a, b, i) {
                        var curr = [b];
                        for (var j = 0; j < arrs.length; j++) {
                          var currArr = arrs[j];
                          if (isArray(currArr) && !is.isUndefined(currArr[i])) {
                            curr.push(currArr[i]);
                          } else {
                            curr.push(null);
                          }
                        }
                        a.push(curr);
                        return a;
                      },
                      []
                    );
                  }
                }
                return ret;
              }

              function transpose(arr) {
                var ret = [];
                if (isArray(arr) && arr.length) {
                  var last;
                  forEach(arr, function(a) {
                    if (isArray(a) && (!last || a.length === last.length)) {
                      forEach(a, function(b, i) {
                        if (!ret[i]) {
                          ret[i] = [];
                        }
                        ret[i].push(b);
                      });
                      last = a;
                    }
                  });
                }
                return ret;
              }

              function valuesAt(arr, indexes) {
                var ret = [];
                indexes = argsToArray(arguments);
                arr = indexes.shift();
                if (isArray(arr) && indexes.length) {
                  for (var i = 0, l = indexes.length; i < l; i++) {
                    ret.push(arr[indexes[i]] || null);
                  }
                }
                return ret;
              }

              function union() {
                var ret = [];
                var arrs = argsToArray(arguments);
                if (arrs.length > 1) {
                  for (var i = 0, l = arrs.length; i < l; i++) {
                    ret = ret.concat(arrs[i]);
                  }
                  ret = removeDuplicates(ret);
                }
                return ret;
              }

              function intersect() {
                var collect = [],
                  sets,
                  i = -1,
                  l;
                if (arguments.length > 1) {
                  //assume we are intersections all the lists in the array
                  sets = argsToArray(arguments);
                } else {
                  sets = arguments[0];
                }
                if (isArray(sets)) {
                  collect = sets[0];
                  i = 0;
                  l = sets.length;
                  while (++i < l) {
                    collect = intersection(collect, sets[i]);
                  }
                }
                return removeDuplicates(collect);
              }

              function powerSet(arr) {
                var ret = [];
                if (isArray(arr) && arr.length) {
                  ret = reduce(
                    arr,
                    function(a, b) {
                      var ret = map(a, function(c) {
                        return c.concat(b);
                      });
                      return a.concat(ret);
                    },
                    [[]]
                  );
                }
                return ret;
              }

              function cartesian(a, b) {
                var ret = [];
                if (isArray(a) && isArray(b) && a.length && b.length) {
                  ret = cross(a[0], b).concat(cartesian(a.slice(1), b));
                }
                return ret;
              }

              function compact(arr) {
                var ret = [];
                if (isArray(arr) && arr.length) {
                  ret = filter(arr, function(item) {
                    return !is.isUndefinedOrNull(item);
                  });
                }
                return ret;
              }

              function multiply(arr, times) {
                times = is.isNumber(times) ? times : 1;
                if (!times) {
                  //make sure times is greater than zero if it is zero then dont multiply it
                  times = 1;
                }
                arr = toArray(arr || []);
                var ret = [],
                  i = 0;
                while (++i <= times) {
                  ret = ret.concat(arr);
                }
                return ret;
              }

              function flatten(arr) {
                var set;
                var args = argsToArray(arguments);
                if (args.length > 1) {
                  //assume we are intersections all the lists in the array
                  set = args;
                } else {
                  set = toArray(arr);
                }
                return reduce(
                  set,
                  function(a, b) {
                    return a.concat(b);
                  },
                  []
                );
              }

              function pluck(arr, prop) {
                prop = prop.split('.');
                var result = arr.slice(0);
                forEach(prop, function(prop) {
                  var exec = prop.match(/(\w+)\(\)$/);
                  result = map(result, function(item) {
                    return exec ? item[exec[1]]() : item[prop];
                  });
                });
                return result;
              }

              function invoke(arr, func, args) {
                args = argsToArray(arguments, 2);
                return map(arr, function(item) {
                  var exec = isString(func) ? item[func] : func;
                  return exec.apply(item, args);
                });
              }

              var array = {
                toArray: toArray,
                sum: sum,
                avg: avg,
                sort: sort,
                min: min,
                max: max,
                difference: difference,
                removeDuplicates: removeDuplicates,
                unique: unique,
                rotate: rotate,
                permutations: permutations,
                zip: zip,
                transpose: transpose,
                valuesAt: valuesAt,
                union: union,
                intersect: intersect,
                powerSet: powerSet,
                cartesian: cartesian,
                compact: compact,
                multiply: multiply,
                flatten: flatten,
                pluck: pluck,
                invoke: invoke,
                forEach: forEach,
                map: map,
                filter: filter,
                reduce: reduce,
                reduceRight: reduceRight,
                some: some,
                every: every,
                indexOf: indexOf,
                lastIndexOf: lastIndexOf,
              };

              return extended.define(isArray, array).expose(array);
            }

            if ('undefined' !== typeof exports) {
              if ('undefined' !== typeof module && module.exports) {
                module.exports = defineArray(
                  require('extended'),
                  require('is-extended'),
                  require('arguments-extended')
                );
              }
            } else if ('function' === typeof define && define.amd) {
              define([
                'extended',
                'is-extended',
                'arguments-extended',
              ], function(extended, is, args) {
                return defineArray(extended, is, args);
              });
            } else {
              this.arrayExtended = defineArray(
                this.extended,
                this.isExtended,
                this.argumentsExtended
              );
            }
          }.call(this));
        },
        { 'arguments-extended': 101, extended: 113, 'is-extended': 129 },
      ],
      103: [
        function(require, module, exports) {
          'use strict';

          exports.byteLength = byteLength;
          exports.toByteArray = toByteArray;
          exports.fromByteArray = fromByteArray;

          var lookup = [];
          var revLookup = [];
          var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;

          var code =
            'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
          for (var i = 0, len = code.length; i < len; ++i) {
            lookup[i] = code[i];
            revLookup[code.charCodeAt(i)] = i;
          }

          // Support decoding URL-safe base64 strings, as Node.js does.
          // See: https://en.wikipedia.org/wiki/Base64#URL_applications
          revLookup['-'.charCodeAt(0)] = 62;
          revLookup['_'.charCodeAt(0)] = 63;

          function getLens(b64) {
            var len = b64.length;

            if (len % 4 > 0) {
              throw new Error('Invalid string. Length must be a multiple of 4');
            }

            // Trim off extra bytes after placeholder bytes are found
            // See: https://github.com/beatgammit/base64-js/issues/42
            var validLen = b64.indexOf('=');
            if (validLen === -1) validLen = len;

            var placeHoldersLen = validLen === len ? 0 : 4 - (validLen % 4);

            return [validLen, placeHoldersLen];
          }

          // base64 is 4/3 + up to two characters of the original data
          function byteLength(b64) {
            var lens = getLens(b64);
            var validLen = lens[0];
            var placeHoldersLen = lens[1];
            return ((validLen + placeHoldersLen) * 3) / 4 - placeHoldersLen;
          }

          function _byteLength(b64, validLen, placeHoldersLen) {
            return ((validLen + placeHoldersLen) * 3) / 4 - placeHoldersLen;
          }

          function toByteArray(b64) {
            var tmp;
            var lens = getLens(b64);
            var validLen = lens[0];
            var placeHoldersLen = lens[1];

            var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen));

            var curByte = 0;

            // if there are placeholders, only get up to the last complete 4 chars
            var len = placeHoldersLen > 0 ? validLen - 4 : validLen;

            for (var i = 0; i < len; i += 4) {
              tmp =
                (revLookup[b64.charCodeAt(i)] << 18) |
                (revLookup[b64.charCodeAt(i + 1)] << 12) |
                (revLookup[b64.charCodeAt(i + 2)] << 6) |
                revLookup[b64.charCodeAt(i + 3)];
              arr[curByte++] = (tmp >> 16) & 0xff;
              arr[curByte++] = (tmp >> 8) & 0xff;
              arr[curByte++] = tmp & 0xff;
            }

            if (placeHoldersLen === 2) {
              tmp =
                (revLookup[b64.charCodeAt(i)] << 2) |
                (revLookup[b64.charCodeAt(i + 1)] >> 4);
              arr[curByte++] = tmp & 0xff;
            }

            if (placeHoldersLen === 1) {
              tmp =
                (revLookup[b64.charCodeAt(i)] << 10) |
                (revLookup[b64.charCodeAt(i + 1)] << 4) |
                (revLookup[b64.charCodeAt(i + 2)] >> 2);
              arr[curByte++] = (tmp >> 8) & 0xff;
              arr[curByte++] = tmp & 0xff;
            }

            return arr;
          }

          function tripletToBase64(num) {
            return (
              lookup[(num >> 18) & 0x3f] +
              lookup[(num >> 12) & 0x3f] +
              lookup[(num >> 6) & 0x3f] +
              lookup[num & 0x3f]
            );
          }

          function encodeChunk(uint8, start, end) {
            var tmp;
            var output = [];
            for (var i = start; i < end; i += 3) {
              tmp =
                ((uint8[i] << 16) & 0xff0000) +
                ((uint8[i + 1] << 8) & 0xff00) +
                (uint8[i + 2] & 0xff);
              output.push(tripletToBase64(tmp));
            }
            return output.join('');
          }

          function fromByteArray(uint8) {
            var tmp;
            var len = uint8.length;
            var extraBytes = len % 3; // if we have 1 byte left, pad 2 bytes
            var parts = [];
            var maxChunkLength = 16383; // must be multiple of 3

            // go through the array every three bytes, we'll deal with trailing stuff later
            for (
              var i = 0, len2 = len - extraBytes;
              i < len2;
              i += maxChunkLength
            ) {
              parts.push(
                encodeChunk(
                  uint8,
                  i,
                  i + maxChunkLength > len2 ? len2 : i + maxChunkLength
                )
              );
            }

            // pad the end with zeros, but make sure to not forget the extra bytes
            if (extraBytes === 1) {
              tmp = uint8[len - 1];
              parts.push(lookup[tmp >> 2] + lookup[(tmp << 4) & 0x3f] + '==');
            } else if (extraBytes === 2) {
              tmp = (uint8[len - 2] << 8) + uint8[len - 1];
              parts.push(
                lookup[tmp >> 10] +
                  lookup[(tmp >> 4) & 0x3f] +
                  lookup[(tmp << 2) & 0x3f] +
                  '='
              );
            }

            return parts.join('');
          }
        },
        {},
      ],
      104: [function(require, module, exports) {}, {}],
      105: [
        function(require, module, exports) {
          arguments[4][104][0].apply(exports, arguments);
        },
        { dup: 104 },
      ],
      106: [
        function(require, module, exports) {
          (function(Buffer) {
            /*!
             * The buffer module from node.js, for the browser.
             *
             * @author   Feross Aboukhadijeh <https://feross.org>
             * @license  MIT
             */
            /* eslint-disable no-proto */

            'use strict';

            var base64 = require('base64-js');
            var ieee754 = require('ieee754');

            exports.Buffer = Buffer;
            exports.SlowBuffer = SlowBuffer;
            exports.INSPECT_MAX_BYTES = 50;

            var K_MAX_LENGTH = 0x7fffffff;
            exports.kMaxLength = K_MAX_LENGTH;

            /**
             * If `Buffer.TYPED_ARRAY_SUPPORT`:
             *   === true    Use Uint8Array implementation (fastest)
             *   === false   Print warning and recommend using `buffer` v4.x which has an Object
             *               implementation (most compatible, even IE6)
             *
             * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
             * Opera 11.6+, iOS 4.2+.
             *
             * We report that the browser does not support typed arrays if the are not subclassable
             * using __proto__. Firefox 4-29 lacks support for adding new properties to `Uint8Array`
             * (See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438). IE 10 lacks support
             * for __proto__ and has a buggy typed array implementation.
             */
            Buffer.TYPED_ARRAY_SUPPORT = typedArraySupport();

            if (
              !Buffer.TYPED_ARRAY_SUPPORT &&
              typeof console !== 'undefined' &&
              typeof console.error === 'function'
            ) {
              console.error(
                'This browser lacks typed array (Uint8Array) support which is required by ' +
                  '`buffer` v5.x. Use `buffer` v4.x if you require old browser support.'
              );
            }

            function typedArraySupport() {
              // Can typed array instances can be augmented?
              try {
                var arr = new Uint8Array(1);
                arr.__proto__ = {
                  __proto__: Uint8Array.prototype,
                  foo: function() {
                    return 42;
                  },
                };
                return arr.foo() === 42;
              } catch (e) {
                return false;
              }
            }

            Object.defineProperty(Buffer.prototype, 'parent', {
              enumerable: true,
              get: function() {
                if (!Buffer.isBuffer(this)) return undefined;
                return this.buffer;
              },
            });

            Object.defineProperty(Buffer.prototype, 'offset', {
              enumerable: true,
              get: function() {
                if (!Buffer.isBuffer(this)) return undefined;
                return this.byteOffset;
              },
            });

            function createBuffer(length) {
              if (length > K_MAX_LENGTH) {
                throw new RangeError(
                  'The value "' + length + '" is invalid for option "size"'
                );
              }
              // Return an augmented `Uint8Array` instance
              var buf = new Uint8Array(length);
              buf.__proto__ = Buffer.prototype;
              return buf;
            }

            /**
             * The Buffer constructor returns instances of `Uint8Array` that have their
             * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
             * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
             * and the `Uint8Array` methods. Square bracket notation works as expected -- it
             * returns a single octet.
             *
             * The `Uint8Array` prototype remains unmodified.
             */

            function Buffer(arg, encodingOrOffset, length) {
              // Common case.
              if (typeof arg === 'number') {
                if (typeof encodingOrOffset === 'string') {
                  throw new TypeError(
                    'The "string" argument must be of type string. Received type number'
                  );
                }
                return allocUnsafe(arg);
              }
              return from(arg, encodingOrOffset, length);
            }

            // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
            if (
              typeof Symbol !== 'undefined' &&
              Symbol.species != null &&
              Buffer[Symbol.species] === Buffer
            ) {
              Object.defineProperty(Buffer, Symbol.species, {
                value: null,
                configurable: true,
                enumerable: false,
                writable: false,
              });
            }

            Buffer.poolSize = 8192; // not used by this implementation

            function from(value, encodingOrOffset, length) {
              if (typeof value === 'string') {
                return fromString(value, encodingOrOffset);
              }

              if (ArrayBuffer.isView(value)) {
                return fromArrayLike(value);
              }

              if (value == null) {
                throw TypeError(
                  'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
                    'or Array-like Object. Received type ' +
                    typeof value
                );
              }

              if (
                isInstance(value, ArrayBuffer) ||
                (value && isInstance(value.buffer, ArrayBuffer))
              ) {
                return fromArrayBuffer(value, encodingOrOffset, length);
              }

              if (typeof value === 'number') {
                throw new TypeError(
                  'The "value" argument must not be of type number. Received type number'
                );
              }

              var valueOf = value.valueOf && value.valueOf();
              if (valueOf != null && valueOf !== value) {
                return Buffer.from(valueOf, encodingOrOffset, length);
              }

              var b = fromObject(value);
              if (b) return b;

              if (
                typeof Symbol !== 'undefined' &&
                Symbol.toPrimitive != null &&
                typeof value[Symbol.toPrimitive] === 'function'
              ) {
                return Buffer.from(
                  value[Symbol.toPrimitive]('string'),
                  encodingOrOffset,
                  length
                );
              }

              throw new TypeError(
                'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
                  'or Array-like Object. Received type ' +
                  typeof value
              );
            }

            /**
             * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
             * if value is a number.
             * Buffer.from(str[, encoding])
             * Buffer.from(array)
             * Buffer.from(buffer)
             * Buffer.from(arrayBuffer[, byteOffset[, length]])
             **/
            Buffer.from = function(value, encodingOrOffset, length) {
              return from(value, encodingOrOffset, length);
            };

            // Note: Change prototype *after* Buffer.from is defined to workaround Chrome bug:
            // https://github.com/feross/buffer/pull/148
            Buffer.prototype.__proto__ = Uint8Array.prototype;
            Buffer.__proto__ = Uint8Array;

            function assertSize(size) {
              if (typeof size !== 'number') {
                throw new TypeError('"size" argument must be of type number');
              } else if (size < 0) {
                throw new RangeError(
                  'The value "' + size + '" is invalid for option "size"'
                );
              }
            }

            function alloc(size, fill, encoding) {
              assertSize(size);
              if (size <= 0) {
                return createBuffer(size);
              }
              if (fill !== undefined) {
                // Only pay attention to encoding if it's a string. This
                // prevents accidentally sending in a number that would
                // be interpretted as a start offset.
                return typeof encoding === 'string'
                  ? createBuffer(size).fill(fill, encoding)
                  : createBuffer(size).fill(fill);
              }
              return createBuffer(size);
            }

            /**
             * Creates a new filled Buffer instance.
             * alloc(size[, fill[, encoding]])
             **/
            Buffer.alloc = function(size, fill, encoding) {
              return alloc(size, fill, encoding);
            };

            function allocUnsafe(size) {
              assertSize(size);
              return createBuffer(size < 0 ? 0 : checked(size) | 0);
            }

            /**
             * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
             * */
            Buffer.allocUnsafe = function(size) {
              return allocUnsafe(size);
            };
            /**
             * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
             */
            Buffer.allocUnsafeSlow = function(size) {
              return allocUnsafe(size);
            };

            function fromString(string, encoding) {
              if (typeof encoding !== 'string' || encoding === '') {
                encoding = 'utf8';
              }

              if (!Buffer.isEncoding(encoding)) {
                throw new TypeError('Unknown encoding: ' + encoding);
              }

              var length = byteLength(string, encoding) | 0;
              var buf = createBuffer(length);

              var actual = buf.write(string, encoding);

              if (actual !== length) {
                // Writing a hex string, for example, that contains invalid characters will
                // cause everything after the first invalid character to be ignored. (e.g.
                // 'abxxcd' will be treated as 'ab')
                buf = buf.slice(0, actual);
              }

              return buf;
            }

            function fromArrayLike(array) {
              var length = array.length < 0 ? 0 : checked(array.length) | 0;
              var buf = createBuffer(length);
              for (var i = 0; i < length; i += 1) {
                buf[i] = array[i] & 255;
              }
              return buf;
            }

            function fromArrayBuffer(array, byteOffset, length) {
              if (byteOffset < 0 || array.byteLength < byteOffset) {
                throw new RangeError('"offset" is outside of buffer bounds');
              }

              if (array.byteLength < byteOffset + (length || 0)) {
                throw new RangeError('"length" is outside of buffer bounds');
              }

              var buf;
              if (byteOffset === undefined && length === undefined) {
                buf = new Uint8Array(array);
              } else if (length === undefined) {
                buf = new Uint8Array(array, byteOffset);
              } else {
                buf = new Uint8Array(array, byteOffset, length);
              }

              // Return an augmented `Uint8Array` instance
              buf.__proto__ = Buffer.prototype;
              return buf;
            }

            function fromObject(obj) {
              if (Buffer.isBuffer(obj)) {
                var len = checked(obj.length) | 0;
                var buf = createBuffer(len);

                if (buf.length === 0) {
                  return buf;
                }

                obj.copy(buf, 0, 0, len);
                return buf;
              }

              if (obj.length !== undefined) {
                if (typeof obj.length !== 'number' || numberIsNaN(obj.length)) {
                  return createBuffer(0);
                }
                return fromArrayLike(obj);
              }

              if (obj.type === 'Buffer' && Array.isArray(obj.data)) {
                return fromArrayLike(obj.data);
              }
            }

            function checked(length) {
              // Note: cannot use `length < K_MAX_LENGTH` here because that fails when
              // length is NaN (which is otherwise coerced to zero.)
              if (length >= K_MAX_LENGTH) {
                throw new RangeError(
                  'Attempt to allocate Buffer larger than maximum ' +
                    'size: 0x' +
                    K_MAX_LENGTH.toString(16) +
                    ' bytes'
                );
              }
              return length | 0;
            }

            function SlowBuffer(length) {
              if (+length != length) {
                // eslint-disable-line eqeqeq
                length = 0;
              }
              return Buffer.alloc(+length);
            }

            Buffer.isBuffer = function isBuffer(b) {
              return (
                b != null && b._isBuffer === true && b !== Buffer.prototype
              ); // so Buffer.isBuffer(Buffer.prototype) will be false
            };

            Buffer.compare = function compare(a, b) {
              if (isInstance(a, Uint8Array))
                a = Buffer.from(a, a.offset, a.byteLength);
              if (isInstance(b, Uint8Array))
                b = Buffer.from(b, b.offset, b.byteLength);
              if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
                throw new TypeError(
                  'The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array'
                );
              }

              if (a === b) return 0;

              var x = a.length;
              var y = b.length;

              for (var i = 0, len = Math.min(x, y); i < len; ++i) {
                if (a[i] !== b[i]) {
                  x = a[i];
                  y = b[i];
                  break;
                }
              }

              if (x < y) return -1;
              if (y < x) return 1;
              return 0;
            };

            Buffer.isEncoding = function isEncoding(encoding) {
              switch (String(encoding).toLowerCase()) {
                case 'hex':
                case 'utf8':
                case 'utf-8':
                case 'ascii':
                case 'latin1':
                case 'binary':
                case 'base64':
                case 'ucs2':
                case 'ucs-2':
                case 'utf16le':
                case 'utf-16le':
                  return true;
                default:
                  return false;
              }
            };

            Buffer.concat = function concat(list, length) {
              if (!Array.isArray(list)) {
                throw new TypeError(
                  '"list" argument must be an Array of Buffers'
                );
              }

              if (list.length === 0) {
                return Buffer.alloc(0);
              }

              var i;
              if (length === undefined) {
                length = 0;
                for (i = 0; i < list.length; ++i) {
                  length += list[i].length;
                }
              }

              var buffer = Buffer.allocUnsafe(length);
              var pos = 0;
              for (i = 0; i < list.length; ++i) {
                var buf = list[i];
                if (isInstance(buf, Uint8Array)) {
                  buf = Buffer.from(buf);
                }
                if (!Buffer.isBuffer(buf)) {
                  throw new TypeError(
                    '"list" argument must be an Array of Buffers'
                  );
                }
                buf.copy(buffer, pos);
                pos += buf.length;
              }
              return buffer;
            };

            function byteLength(string, encoding) {
              if (Buffer.isBuffer(string)) {
                return string.length;
              }
              if (
                ArrayBuffer.isView(string) ||
                isInstance(string, ArrayBuffer)
              ) {
                return string.byteLength;
              }
              if (typeof string !== 'string') {
                throw new TypeError(
                  'The "string" argument must be one of type string, Buffer, or ArrayBuffer. ' +
                    'Received type ' +
                    typeof string
                );
              }

              var len = string.length;
              var mustMatch = arguments.length > 2 && arguments[2] === true;
              if (!mustMatch && len === 0) return 0;

              // Use a for loop to avoid recursion
              var loweredCase = false;
              for (;;) {
                switch (encoding) {
                  case 'ascii':
                  case 'latin1':
                  case 'binary':
                    return len;
                  case 'utf8':
                  case 'utf-8':
                    return utf8ToBytes(string).length;
                  case 'ucs2':
                  case 'ucs-2':
                  case 'utf16le':
                  case 'utf-16le':
                    return len * 2;
                  case 'hex':
                    return len >>> 1;
                  case 'base64':
                    return base64ToBytes(string).length;
                  default:
                    if (loweredCase) {
                      return mustMatch ? -1 : utf8ToBytes(string).length; // assume utf8
                    }
                    encoding = ('' + encoding).toLowerCase();
                    loweredCase = true;
                }
              }
            }
            Buffer.byteLength = byteLength;

            function slowToString(encoding, start, end) {
              var loweredCase = false;

              // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
              // property of a typed array.

              // This behaves neither like String nor Uint8Array in that we set start/end
              // to their upper/lower bounds if the value passed is out of range.
              // undefined is handled specially as per ECMA-262 6th Edition,
              // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
              if (start === undefined || start < 0) {
                start = 0;
              }
              // Return early if start > this.length. Done here to prevent potential uint32
              // coercion fail below.
              if (start > this.length) {
                return '';
              }

              if (end === undefined || end > this.length) {
                end = this.length;
              }

              if (end <= 0) {
                return '';
              }

              // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
              end >>>= 0;
              start >>>= 0;

              if (end <= start) {
                return '';
              }

              if (!encoding) encoding = 'utf8';

              while (true) {
                switch (encoding) {
                  case 'hex':
                    return hexSlice(this, start, end);

                  case 'utf8':
                  case 'utf-8':
                    return utf8Slice(this, start, end);

                  case 'ascii':
                    return asciiSlice(this, start, end);

                  case 'latin1':
                  case 'binary':
                    return latin1Slice(this, start, end);

                  case 'base64':
                    return base64Slice(this, start, end);

                  case 'ucs2':
                  case 'ucs-2':
                  case 'utf16le':
                  case 'utf-16le':
                    return utf16leSlice(this, start, end);

                  default:
                    if (loweredCase)
                      throw new TypeError('Unknown encoding: ' + encoding);
                    encoding = (encoding + '').toLowerCase();
                    loweredCase = true;
                }
              }
            }

            // This property is used by `Buffer.isBuffer` (and the `is-buffer` npm package)
            // to detect a Buffer instance. It's not possible to use `instanceof Buffer`
            // reliably in a browserify context because there could be multiple different
            // copies of the 'buffer' package in use. This method works even for Buffer
            // instances that were created from another copy of the `buffer` package.
            // See: https://github.com/feross/buffer/issues/154
            Buffer.prototype._isBuffer = true;

            function swap(b, n, m) {
              var i = b[n];
              b[n] = b[m];
              b[m] = i;
            }

            Buffer.prototype.swap16 = function swap16() {
              var len = this.length;
              if (len % 2 !== 0) {
                throw new RangeError(
                  'Buffer size must be a multiple of 16-bits'
                );
              }
              for (var i = 0; i < len; i += 2) {
                swap(this, i, i + 1);
              }
              return this;
            };

            Buffer.prototype.swap32 = function swap32() {
              var len = this.length;
              if (len % 4 !== 0) {
                throw new RangeError(
                  'Buffer size must be a multiple of 32-bits'
                );
              }
              for (var i = 0; i < len; i += 4) {
                swap(this, i, i + 3);
                swap(this, i + 1, i + 2);
              }
              return this;
            };

            Buffer.prototype.swap64 = function swap64() {
              var len = this.length;
              if (len % 8 !== 0) {
                throw new RangeError(
                  'Buffer size must be a multiple of 64-bits'
                );
              }
              for (var i = 0; i < len; i += 8) {
                swap(this, i, i + 7);
                swap(this, i + 1, i + 6);
                swap(this, i + 2, i + 5);
                swap(this, i + 3, i + 4);
              }
              return this;
            };

            Buffer.prototype.toString = function toString() {
              var length = this.length;
              if (length === 0) return '';
              if (arguments.length === 0) return utf8Slice(this, 0, length);
              return slowToString.apply(this, arguments);
            };

            Buffer.prototype.toLocaleString = Buffer.prototype.toString;

            Buffer.prototype.equals = function equals(b) {
              if (!Buffer.isBuffer(b))
                throw new TypeError('Argument must be a Buffer');
              if (this === b) return true;
              return Buffer.compare(this, b) === 0;
            };

            Buffer.prototype.inspect = function inspect() {
              var str = '';
              var max = exports.INSPECT_MAX_BYTES;
              str = this.toString('hex', 0, max)
                .replace(/(.{2})/g, '$1 ')
                .trim();
              if (this.length > max) str += ' ... ';
              return '<Buffer ' + str + '>';
            };

            Buffer.prototype.compare = function compare(
              target,
              start,
              end,
              thisStart,
              thisEnd
            ) {
              if (isInstance(target, Uint8Array)) {
                target = Buffer.from(target, target.offset, target.byteLength);
              }
              if (!Buffer.isBuffer(target)) {
                throw new TypeError(
                  'The "target" argument must be one of type Buffer or Uint8Array. ' +
                    'Received type ' +
                    typeof target
                );
              }

              if (start === undefined) {
                start = 0;
              }
              if (end === undefined) {
                end = target ? target.length : 0;
              }
              if (thisStart === undefined) {
                thisStart = 0;
              }
              if (thisEnd === undefined) {
                thisEnd = this.length;
              }

              if (
                start < 0 ||
                end > target.length ||
                thisStart < 0 ||
                thisEnd > this.length
              ) {
                throw new RangeError('out of range index');
              }

              if (thisStart >= thisEnd && start >= end) {
                return 0;
              }
              if (thisStart >= thisEnd) {
                return -1;
              }
              if (start >= end) {
                return 1;
              }

              start >>>= 0;
              end >>>= 0;
              thisStart >>>= 0;
              thisEnd >>>= 0;

              if (this === target) return 0;

              var x = thisEnd - thisStart;
              var y = end - start;
              var len = Math.min(x, y);

              var thisCopy = this.slice(thisStart, thisEnd);
              var targetCopy = target.slice(start, end);

              for (var i = 0; i < len; ++i) {
                if (thisCopy[i] !== targetCopy[i]) {
                  x = thisCopy[i];
                  y = targetCopy[i];
                  break;
                }
              }

              if (x < y) return -1;
              if (y < x) return 1;
              return 0;
            };

            // Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
            // OR the last index of `val` in `buffer` at offset <= `byteOffset`.
            //
            // Arguments:
            // - buffer - a Buffer to search
            // - val - a string, Buffer, or number
            // - byteOffset - an index into `buffer`; will be clamped to an int32
            // - encoding - an optional encoding, relevant is val is a string
            // - dir - true for indexOf, false for lastIndexOf
            function bidirectionalIndexOf(
              buffer,
              val,
              byteOffset,
              encoding,
              dir
            ) {
              // Empty buffer means no match
              if (buffer.length === 0) return -1;

              // Normalize byteOffset
              if (typeof byteOffset === 'string') {
                encoding = byteOffset;
                byteOffset = 0;
              } else if (byteOffset > 0x7fffffff) {
                byteOffset = 0x7fffffff;
              } else if (byteOffset < -0x80000000) {
                byteOffset = -0x80000000;
              }
              byteOffset = +byteOffset; // Coerce to Number.
              if (numberIsNaN(byteOffset)) {
                // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
                byteOffset = dir ? 0 : buffer.length - 1;
              }

              // Normalize byteOffset: negative offsets start from the end of the buffer
              if (byteOffset < 0) byteOffset = buffer.length + byteOffset;
              if (byteOffset >= buffer.length) {
                if (dir) return -1;
                else byteOffset = buffer.length - 1;
              } else if (byteOffset < 0) {
                if (dir) byteOffset = 0;
                else return -1;
              }

              // Normalize val
              if (typeof val === 'string') {
                val = Buffer.from(val, encoding);
              }

              // Finally, search either indexOf (if dir is true) or lastIndexOf
              if (Buffer.isBuffer(val)) {
                // Special case: looking for empty string/buffer always fails
                if (val.length === 0) {
                  return -1;
                }
                return arrayIndexOf(buffer, val, byteOffset, encoding, dir);
              } else if (typeof val === 'number') {
                val = val & 0xff; // Search for a byte value [0-255]
                if (typeof Uint8Array.prototype.indexOf === 'function') {
                  if (dir) {
                    return Uint8Array.prototype.indexOf.call(
                      buffer,
                      val,
                      byteOffset
                    );
                  } else {
                    return Uint8Array.prototype.lastIndexOf.call(
                      buffer,
                      val,
                      byteOffset
                    );
                  }
                }
                return arrayIndexOf(buffer, [val], byteOffset, encoding, dir);
              }

              throw new TypeError('val must be string, number or Buffer');
            }

            function arrayIndexOf(arr, val, byteOffset, encoding, dir) {
              var indexSize = 1;
              var arrLength = arr.length;
              var valLength = val.length;

              if (encoding !== undefined) {
                encoding = String(encoding).toLowerCase();
                if (
                  encoding === 'ucs2' ||
                  encoding === 'ucs-2' ||
                  encoding === 'utf16le' ||
                  encoding === 'utf-16le'
                ) {
                  if (arr.length < 2 || val.length < 2) {
                    return -1;
                  }
                  indexSize = 2;
                  arrLength /= 2;
                  valLength /= 2;
                  byteOffset /= 2;
                }
              }

              function read(buf, i) {
                if (indexSize === 1) {
                  return buf[i];
                } else {
                  return buf.readUInt16BE(i * indexSize);
                }
              }

              var i;
              if (dir) {
                var foundIndex = -1;
                for (i = byteOffset; i < arrLength; i++) {
                  if (
                    read(arr, i) ===
                    read(val, foundIndex === -1 ? 0 : i - foundIndex)
                  ) {
                    if (foundIndex === -1) foundIndex = i;
                    if (i - foundIndex + 1 === valLength)
                      return foundIndex * indexSize;
                  } else {
                    if (foundIndex !== -1) i -= i - foundIndex;
                    foundIndex = -1;
                  }
                }
              } else {
                if (byteOffset + valLength > arrLength)
                  byteOffset = arrLength - valLength;
                for (i = byteOffset; i >= 0; i--) {
                  var found = true;
                  for (var j = 0; j < valLength; j++) {
                    if (read(arr, i + j) !== read(val, j)) {
                      found = false;
                      break;
                    }
                  }
                  if (found) return i;
                }
              }

              return -1;
            }

            Buffer.prototype.includes = function includes(
              val,
              byteOffset,
              encoding
            ) {
              return this.indexOf(val, byteOffset, encoding) !== -1;
            };

            Buffer.prototype.indexOf = function indexOf(
              val,
              byteOffset,
              encoding
            ) {
              return bidirectionalIndexOf(
                this,
                val,
                byteOffset,
                encoding,
                true
              );
            };

            Buffer.prototype.lastIndexOf = function lastIndexOf(
              val,
              byteOffset,
              encoding
            ) {
              return bidirectionalIndexOf(
                this,
                val,
                byteOffset,
                encoding,
                false
              );
            };

            function hexWrite(buf, string, offset, length) {
              offset = Number(offset) || 0;
              var remaining = buf.length - offset;
              if (!length) {
                length = remaining;
              } else {
                length = Number(length);
                if (length > remaining) {
                  length = remaining;
                }
              }

              var strLen = string.length;

              if (length > strLen / 2) {
                length = strLen / 2;
              }
              for (var i = 0; i < length; ++i) {
                var parsed = parseInt(string.substr(i * 2, 2), 16);
                if (numberIsNaN(parsed)) return i;
                buf[offset + i] = parsed;
              }
              return i;
            }

            function utf8Write(buf, string, offset, length) {
              return blitBuffer(
                utf8ToBytes(string, buf.length - offset),
                buf,
                offset,
                length
              );
            }

            function asciiWrite(buf, string, offset, length) {
              return blitBuffer(asciiToBytes(string), buf, offset, length);
            }

            function latin1Write(buf, string, offset, length) {
              return asciiWrite(buf, string, offset, length);
            }

            function base64Write(buf, string, offset, length) {
              return blitBuffer(base64ToBytes(string), buf, offset, length);
            }

            function ucs2Write(buf, string, offset, length) {
              return blitBuffer(
                utf16leToBytes(string, buf.length - offset),
                buf,
                offset,
                length
              );
            }

            Buffer.prototype.write = function write(
              string,
              offset,
              length,
              encoding
            ) {
              // Buffer#write(string)
              if (offset === undefined) {
                encoding = 'utf8';
                length = this.length;
                offset = 0;
                // Buffer#write(string, encoding)
              } else if (length === undefined && typeof offset === 'string') {
                encoding = offset;
                length = this.length;
                offset = 0;
                // Buffer#write(string, offset[, length][, encoding])
              } else if (isFinite(offset)) {
                offset = offset >>> 0;
                if (isFinite(length)) {
                  length = length >>> 0;
                  if (encoding === undefined) encoding = 'utf8';
                } else {
                  encoding = length;
                  length = undefined;
                }
              } else {
                throw new Error(
                  'Buffer.write(string, encoding, offset[, length]) is no longer supported'
                );
              }

              var remaining = this.length - offset;
              if (length === undefined || length > remaining)
                length = remaining;

              if (
                (string.length > 0 && (length < 0 || offset < 0)) ||
                offset > this.length
              ) {
                throw new RangeError('Attempt to write outside buffer bounds');
              }

              if (!encoding) encoding = 'utf8';

              var loweredCase = false;
              for (;;) {
                switch (encoding) {
                  case 'hex':
                    return hexWrite(this, string, offset, length);

                  case 'utf8':
                  case 'utf-8':
                    return utf8Write(this, string, offset, length);

                  case 'ascii':
                    return asciiWrite(this, string, offset, length);

                  case 'latin1':
                  case 'binary':
                    return latin1Write(this, string, offset, length);

                  case 'base64':
                    // Warning: maxLength not taken into account in base64Write
                    return base64Write(this, string, offset, length);

                  case 'ucs2':
                  case 'ucs-2':
                  case 'utf16le':
                  case 'utf-16le':
                    return ucs2Write(this, string, offset, length);

                  default:
                    if (loweredCase)
                      throw new TypeError('Unknown encoding: ' + encoding);
                    encoding = ('' + encoding).toLowerCase();
                    loweredCase = true;
                }
              }
            };

            Buffer.prototype.toJSON = function toJSON() {
              return {
                type: 'Buffer',
                data: Array.prototype.slice.call(this._arr || this, 0),
              };
            };

            function base64Slice(buf, start, end) {
              if (start === 0 && end === buf.length) {
                return base64.fromByteArray(buf);
              } else {
                return base64.fromByteArray(buf.slice(start, end));
              }
            }

            function utf8Slice(buf, start, end) {
              end = Math.min(buf.length, end);
              var res = [];

              var i = start;
              while (i < end) {
                var firstByte = buf[i];
                var codePoint = null;
                var bytesPerSequence =
                  firstByte > 0xef
                    ? 4
                    : firstByte > 0xdf
                    ? 3
                    : firstByte > 0xbf
                    ? 2
                    : 1;

                if (i + bytesPerSequence <= end) {
                  var secondByte, thirdByte, fourthByte, tempCodePoint;

                  switch (bytesPerSequence) {
                    case 1:
                      if (firstByte < 0x80) {
                        codePoint = firstByte;
                      }
                      break;
                    case 2:
                      secondByte = buf[i + 1];
                      if ((secondByte & 0xc0) === 0x80) {
                        tempCodePoint =
                          ((firstByte & 0x1f) << 0x6) | (secondByte & 0x3f);
                        if (tempCodePoint > 0x7f) {
                          codePoint = tempCodePoint;
                        }
                      }
                      break;
                    case 3:
                      secondByte = buf[i + 1];
                      thirdByte = buf[i + 2];
                      if (
                        (secondByte & 0xc0) === 0x80 &&
                        (thirdByte & 0xc0) === 0x80
                      ) {
                        tempCodePoint =
                          ((firstByte & 0xf) << 0xc) |
                          ((secondByte & 0x3f) << 0x6) |
                          (thirdByte & 0x3f);
                        if (
                          tempCodePoint > 0x7ff &&
                          (tempCodePoint < 0xd800 || tempCodePoint > 0xdfff)
                        ) {
                          codePoint = tempCodePoint;
                        }
                      }
                      break;
                    case 4:
                      secondByte = buf[i + 1];
                      thirdByte = buf[i + 2];
                      fourthByte = buf[i + 3];
                      if (
                        (secondByte & 0xc0) === 0x80 &&
                        (thirdByte & 0xc0) === 0x80 &&
                        (fourthByte & 0xc0) === 0x80
                      ) {
                        tempCodePoint =
                          ((firstByte & 0xf) << 0x12) |
                          ((secondByte & 0x3f) << 0xc) |
                          ((thirdByte & 0x3f) << 0x6) |
                          (fourthByte & 0x3f);
                        if (
                          tempCodePoint > 0xffff &&
                          tempCodePoint < 0x110000
                        ) {
                          codePoint = tempCodePoint;
                        }
                      }
                  }
                }

                if (codePoint === null) {
                  // we did not generate a valid codePoint so insert a
                  // replacement char (U+FFFD) and advance only 1 byte
                  codePoint = 0xfffd;
                  bytesPerSequence = 1;
                } else if (codePoint > 0xffff) {
                  // encode to utf16 (surrogate pair dance)
                  codePoint -= 0x10000;
                  res.push(((codePoint >>> 10) & 0x3ff) | 0xd800);
                  codePoint = 0xdc00 | (codePoint & 0x3ff);
                }

                res.push(codePoint);
                i += bytesPerSequence;
              }

              return decodeCodePointsArray(res);
            }

            // Based on http://stackoverflow.com/a/22747272/680742, the browser with
            // the lowest limit is Chrome, with 0x10000 args.
            // We go 1 magnitude less, for safety
            var MAX_ARGUMENTS_LENGTH = 0x1000;

            function decodeCodePointsArray(codePoints) {
              var len = codePoints.length;
              if (len <= MAX_ARGUMENTS_LENGTH) {
                return String.fromCharCode.apply(String, codePoints); // avoid extra slice()
              }

              // Decode in chunks to avoid "call stack size exceeded".
              var res = '';
              var i = 0;
              while (i < len) {
                res += String.fromCharCode.apply(
                  String,
                  codePoints.slice(i, (i += MAX_ARGUMENTS_LENGTH))
                );
              }
              return res;
            }

            function asciiSlice(buf, start, end) {
              var ret = '';
              end = Math.min(buf.length, end);

              for (var i = start; i < end; ++i) {
                ret += String.fromCharCode(buf[i] & 0x7f);
              }
              return ret;
            }

            function latin1Slice(buf, start, end) {
              var ret = '';
              end = Math.min(buf.length, end);

              for (var i = start; i < end; ++i) {
                ret += String.fromCharCode(buf[i]);
              }
              return ret;
            }

            function hexSlice(buf, start, end) {
              var len = buf.length;

              if (!start || start < 0) start = 0;
              if (!end || end < 0 || end > len) end = len;

              var out = '';
              for (var i = start; i < end; ++i) {
                out += toHex(buf[i]);
              }
              return out;
            }

            function utf16leSlice(buf, start, end) {
              var bytes = buf.slice(start, end);
              var res = '';
              for (var i = 0; i < bytes.length; i += 2) {
                res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256);
              }
              return res;
            }

            Buffer.prototype.slice = function slice(start, end) {
              var len = this.length;
              start = ~~start;
              end = end === undefined ? len : ~~end;

              if (start < 0) {
                start += len;
                if (start < 0) start = 0;
              } else if (start > len) {
                start = len;
              }

              if (end < 0) {
                end += len;
                if (end < 0) end = 0;
              } else if (end > len) {
                end = len;
              }

              if (end < start) end = start;

              var newBuf = this.subarray(start, end);
              // Return an augmented `Uint8Array` instance
              newBuf.__proto__ = Buffer.prototype;
              return newBuf;
            };

            /*
             * Need to make sure that buffer isn't trying to write out of bounds.
             */
            function checkOffset(offset, ext, length) {
              if (offset % 1 !== 0 || offset < 0)
                throw new RangeError('offset is not uint');
              if (offset + ext > length)
                throw new RangeError('Trying to access beyond buffer length');
            }

            Buffer.prototype.readUIntLE = function readUIntLE(
              offset,
              byteLength,
              noAssert
            ) {
              offset = offset >>> 0;
              byteLength = byteLength >>> 0;
              if (!noAssert) checkOffset(offset, byteLength, this.length);

              var val = this[offset];
              var mul = 1;
              var i = 0;
              while (++i < byteLength && (mul *= 0x100)) {
                val += this[offset + i] * mul;
              }

              return val;
            };

            Buffer.prototype.readUIntBE = function readUIntBE(
              offset,
              byteLength,
              noAssert
            ) {
              offset = offset >>> 0;
              byteLength = byteLength >>> 0;
              if (!noAssert) {
                checkOffset(offset, byteLength, this.length);
              }

              var val = this[offset + --byteLength];
              var mul = 1;
              while (byteLength > 0 && (mul *= 0x100)) {
                val += this[offset + --byteLength] * mul;
              }

              return val;
            };

            Buffer.prototype.readUInt8 = function readUInt8(offset, noAssert) {
              offset = offset >>> 0;
              if (!noAssert) checkOffset(offset, 1, this.length);
              return this[offset];
            };

            Buffer.prototype.readUInt16LE = function readUInt16LE(
              offset,
              noAssert
            ) {
              offset = offset >>> 0;
              if (!noAssert) checkOffset(offset, 2, this.length);
              return this[offset] | (this[offset + 1] << 8);
            };

            Buffer.prototype.readUInt16BE = function readUInt16BE(
              offset,
              noAssert
            ) {
              offset = offset >>> 0;
              if (!noAssert) checkOffset(offset, 2, this.length);
              return (this[offset] << 8) | this[offset + 1];
            };

            Buffer.prototype.readUInt32LE = function readUInt32LE(
              offset,
              noAssert
            ) {
              offset = offset >>> 0;
              if (!noAssert) checkOffset(offset, 4, this.length);

              return (
                (this[offset] |
                  (this[offset + 1] << 8) |
                  (this[offset + 2] << 16)) +
                this[offset + 3] * 0x1000000
              );
            };

            Buffer.prototype.readUInt32BE = function readUInt32BE(
              offset,
              noAssert
            ) {
              offset = offset >>> 0;
              if (!noAssert) checkOffset(offset, 4, this.length);

              return (
                this[offset] * 0x1000000 +
                ((this[offset + 1] << 16) |
                  (this[offset + 2] << 8) |
                  this[offset + 3])
              );
            };

            Buffer.prototype.readIntLE = function readIntLE(
              offset,
              byteLength,
              noAssert
            ) {
              offset = offset >>> 0;
              byteLength = byteLength >>> 0;
              if (!noAssert) checkOffset(offset, byteLength, this.length);

              var val = this[offset];
              var mul = 1;
              var i = 0;
              while (++i < byteLength && (mul *= 0x100)) {
                val += this[offset + i] * mul;
              }
              mul *= 0x80;

              if (val >= mul) val -= Math.pow(2, 8 * byteLength);

              return val;
            };

            Buffer.prototype.readIntBE = function readIntBE(
              offset,
              byteLength,
              noAssert
            ) {
              offset = offset >>> 0;
              byteLength = byteLength >>> 0;
              if (!noAssert) checkOffset(offset, byteLength, this.length);

              var i = byteLength;
              var mul = 1;
              var val = this[offset + --i];
              while (i > 0 && (mul *= 0x100)) {
                val += this[offset + --i] * mul;
              }
              mul *= 0x80;

              if (val >= mul) val -= Math.pow(2, 8 * byteLength);

              return val;
            };

            Buffer.prototype.readInt8 = function readInt8(offset, noAssert) {
              offset = offset >>> 0;
              if (!noAssert) checkOffset(offset, 1, this.length);
              if (!(this[offset] & 0x80)) return this[offset];
              return (0xff - this[offset] + 1) * -1;
            };

            Buffer.prototype.readInt16LE = function readInt16LE(
              offset,
              noAssert
            ) {
              offset = offset >>> 0;
              if (!noAssert) checkOffset(offset, 2, this.length);
              var val = this[offset] | (this[offset + 1] << 8);
              return val & 0x8000 ? val | 0xffff0000 : val;
            };

            Buffer.prototype.readInt16BE = function readInt16BE(
              offset,
              noAssert
            ) {
              offset = offset >>> 0;
              if (!noAssert) checkOffset(offset, 2, this.length);
              var val = this[offset + 1] | (this[offset] << 8);
              return val & 0x8000 ? val | 0xffff0000 : val;
            };

            Buffer.prototype.readInt32LE = function readInt32LE(
              offset,
              noAssert
            ) {
              offset = offset >>> 0;
              if (!noAssert) checkOffset(offset, 4, this.length);

              return (
                this[offset] |
                (this[offset + 1] << 8) |
                (this[offset + 2] << 16) |
                (this[offset + 3] << 24)
              );
            };

            Buffer.prototype.readInt32BE = function readInt32BE(
              offset,
              noAssert
            ) {
              offset = offset >>> 0;
              if (!noAssert) checkOffset(offset, 4, this.length);

              return (
                (this[offset] << 24) |
                (this[offset + 1] << 16) |
                (this[offset + 2] << 8) |
                this[offset + 3]
              );
            };

            Buffer.prototype.readFloatLE = function readFloatLE(
              offset,
              noAssert
            ) {
              offset = offset >>> 0;
              if (!noAssert) checkOffset(offset, 4, this.length);
              return ieee754.read(this, offset, true, 23, 4);
            };

            Buffer.prototype.readFloatBE = function readFloatBE(
              offset,
              noAssert
            ) {
              offset = offset >>> 0;
              if (!noAssert) checkOffset(offset, 4, this.length);
              return ieee754.read(this, offset, false, 23, 4);
            };

            Buffer.prototype.readDoubleLE = function readDoubleLE(
              offset,
              noAssert
            ) {
              offset = offset >>> 0;
              if (!noAssert) checkOffset(offset, 8, this.length);
              return ieee754.read(this, offset, true, 52, 8);
            };

            Buffer.prototype.readDoubleBE = function readDoubleBE(
              offset,
              noAssert
            ) {
              offset = offset >>> 0;
              if (!noAssert) checkOffset(offset, 8, this.length);
              return ieee754.read(this, offset, false, 52, 8);
            };

            function checkInt(buf, value, offset, ext, max, min) {
              if (!Buffer.isBuffer(buf))
                throw new TypeError(
                  '"buffer" argument must be a Buffer instance'
                );
              if (value > max || value < min)
                throw new RangeError('"value" argument is out of bounds');
              if (offset + ext > buf.length)
                throw new RangeError('Index out of range');
            }

            Buffer.prototype.writeUIntLE = function writeUIntLE(
              value,
              offset,
              byteLength,
              noAssert
            ) {
              value = +value;
              offset = offset >>> 0;
              byteLength = byteLength >>> 0;
              if (!noAssert) {
                var maxBytes = Math.pow(2, 8 * byteLength) - 1;
                checkInt(this, value, offset, byteLength, maxBytes, 0);
              }

              var mul = 1;
              var i = 0;
              this[offset] = value & 0xff;
              while (++i < byteLength && (mul *= 0x100)) {
                this[offset + i] = (value / mul) & 0xff;
              }

              return offset + byteLength;
            };

            Buffer.prototype.writeUIntBE = function writeUIntBE(
              value,
              offset,
              byteLength,
              noAssert
            ) {
              value = +value;
              offset = offset >>> 0;
              byteLength = byteLength >>> 0;
              if (!noAssert) {
                var maxBytes = Math.pow(2, 8 * byteLength) - 1;
                checkInt(this, value, offset, byteLength, maxBytes, 0);
              }

              var i = byteLength - 1;
              var mul = 1;
              this[offset + i] = value & 0xff;
              while (--i >= 0 && (mul *= 0x100)) {
                this[offset + i] = (value / mul) & 0xff;
              }

              return offset + byteLength;
            };

            Buffer.prototype.writeUInt8 = function writeUInt8(
              value,
              offset,
              noAssert
            ) {
              value = +value;
              offset = offset >>> 0;
              if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0);
              this[offset] = value & 0xff;
              return offset + 1;
            };

            Buffer.prototype.writeUInt16LE = function writeUInt16LE(
              value,
              offset,
              noAssert
            ) {
              value = +value;
              offset = offset >>> 0;
              if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
              this[offset] = value & 0xff;
              this[offset + 1] = value >>> 8;
              return offset + 2;
            };

            Buffer.prototype.writeUInt16BE = function writeUInt16BE(
              value,
              offset,
              noAssert
            ) {
              value = +value;
              offset = offset >>> 0;
              if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
              this[offset] = value >>> 8;
              this[offset + 1] = value & 0xff;
              return offset + 2;
            };

            Buffer.prototype.writeUInt32LE = function writeUInt32LE(
              value,
              offset,
              noAssert
            ) {
              value = +value;
              offset = offset >>> 0;
              if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
              this[offset + 3] = value >>> 24;
              this[offset + 2] = value >>> 16;
              this[offset + 1] = value >>> 8;
              this[offset] = value & 0xff;
              return offset + 4;
            };

            Buffer.prototype.writeUInt32BE = function writeUInt32BE(
              value,
              offset,
              noAssert
            ) {
              value = +value;
              offset = offset >>> 0;
              if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
              this[offset] = value >>> 24;
              this[offset + 1] = value >>> 16;
              this[offset + 2] = value >>> 8;
              this[offset + 3] = value & 0xff;
              return offset + 4;
            };

            Buffer.prototype.writeIntLE = function writeIntLE(
              value,
              offset,
              byteLength,
              noAssert
            ) {
              value = +value;
              offset = offset >>> 0;
              if (!noAssert) {
                var limit = Math.pow(2, 8 * byteLength - 1);

                checkInt(this, value, offset, byteLength, limit - 1, -limit);
              }

              var i = 0;
              var mul = 1;
              var sub = 0;
              this[offset] = value & 0xff;
              while (++i < byteLength && (mul *= 0x100)) {
                if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
                  sub = 1;
                }
                this[offset + i] = (((value / mul) >> 0) - sub) & 0xff;
              }

              return offset + byteLength;
            };

            Buffer.prototype.writeIntBE = function writeIntBE(
              value,
              offset,
              byteLength,
              noAssert
            ) {
              value = +value;
              offset = offset >>> 0;
              if (!noAssert) {
                var limit = Math.pow(2, 8 * byteLength - 1);

                checkInt(this, value, offset, byteLength, limit - 1, -limit);
              }

              var i = byteLength - 1;
              var mul = 1;
              var sub = 0;
              this[offset + i] = value & 0xff;
              while (--i >= 0 && (mul *= 0x100)) {
                if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
                  sub = 1;
                }
                this[offset + i] = (((value / mul) >> 0) - sub) & 0xff;
              }

              return offset + byteLength;
            };

            Buffer.prototype.writeInt8 = function writeInt8(
              value,
              offset,
              noAssert
            ) {
              value = +value;
              offset = offset >>> 0;
              if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80);
              if (value < 0) value = 0xff + value + 1;
              this[offset] = value & 0xff;
              return offset + 1;
            };

            Buffer.prototype.writeInt16LE = function writeInt16LE(
              value,
              offset,
              noAssert
            ) {
              value = +value;
              offset = offset >>> 0;
              if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
              this[offset] = value & 0xff;
              this[offset + 1] = value >>> 8;
              return offset + 2;
            };

            Buffer.prototype.writeInt16BE = function writeInt16BE(
              value,
              offset,
              noAssert
            ) {
              value = +value;
              offset = offset >>> 0;
              if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
              this[offset] = value >>> 8;
              this[offset + 1] = value & 0xff;
              return offset + 2;
            };

            Buffer.prototype.writeInt32LE = function writeInt32LE(
              value,
              offset,
              noAssert
            ) {
              value = +value;
              offset = offset >>> 0;
              if (!noAssert)
                checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
              this[offset] = value & 0xff;
              this[offset + 1] = value >>> 8;
              this[offset + 2] = value >>> 16;
              this[offset + 3] = value >>> 24;
              return offset + 4;
            };

            Buffer.prototype.writeInt32BE = function writeInt32BE(
              value,
              offset,
              noAssert
            ) {
              value = +value;
              offset = offset >>> 0;
              if (!noAssert)
                checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
              if (value < 0) value = 0xffffffff + value + 1;
              this[offset] = value >>> 24;
              this[offset + 1] = value >>> 16;
              this[offset + 2] = value >>> 8;
              this[offset + 3] = value & 0xff;
              return offset + 4;
            };

            function checkIEEE754(buf, value, offset, ext, max, min) {
              if (offset + ext > buf.length)
                throw new RangeError('Index out of range');
              if (offset < 0) throw new RangeError('Index out of range');
            }

            function writeFloat(buf, value, offset, littleEndian, noAssert) {
              value = +value;
              offset = offset >>> 0;
              if (!noAssert) {
                checkIEEE754(
                  buf,
                  value,
                  offset,
                  4,
                  3.4028234663852886e38,
                  -3.4028234663852886e38
                );
              }
              ieee754.write(buf, value, offset, littleEndian, 23, 4);
              return offset + 4;
            }

            Buffer.prototype.writeFloatLE = function writeFloatLE(
              value,
              offset,
              noAssert
            ) {
              return writeFloat(this, value, offset, true, noAssert);
            };

            Buffer.prototype.writeFloatBE = function writeFloatBE(
              value,
              offset,
              noAssert
            ) {
              return writeFloat(this, value, offset, false, noAssert);
            };

            function writeDouble(buf, value, offset, littleEndian, noAssert) {
              value = +value;
              offset = offset >>> 0;
              if (!noAssert) {
                checkIEEE754(
                  buf,
                  value,
                  offset,
                  8,
                  1.7976931348623157e308,
                  -1.7976931348623157e308
                );
              }
              ieee754.write(buf, value, offset, littleEndian, 52, 8);
              return offset + 8;
            }

            Buffer.prototype.writeDoubleLE = function writeDoubleLE(
              value,
              offset,
              noAssert
            ) {
              return writeDouble(this, value, offset, true, noAssert);
            };

            Buffer.prototype.writeDoubleBE = function writeDoubleBE(
              value,
              offset,
              noAssert
            ) {
              return writeDouble(this, value, offset, false, noAssert);
            };

            // copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
            Buffer.prototype.copy = function copy(
              target,
              targetStart,
              start,
              end
            ) {
              if (!Buffer.isBuffer(target))
                throw new TypeError('argument should be a Buffer');
              if (!start) start = 0;
              if (!end && end !== 0) end = this.length;
              if (targetStart >= target.length) targetStart = target.length;
              if (!targetStart) targetStart = 0;
              if (end > 0 && end < start) end = start;

              // Copy 0 bytes; we're done
              if (end === start) return 0;
              if (target.length === 0 || this.length === 0) return 0;

              // Fatal error conditions
              if (targetStart < 0) {
                throw new RangeError('targetStart out of bounds');
              }
              if (start < 0 || start >= this.length)
                throw new RangeError('Index out of range');
              if (end < 0) throw new RangeError('sourceEnd out of bounds');

              // Are we oob?
              if (end > this.length) end = this.length;
              if (target.length - targetStart < end - start) {
                end = target.length - targetStart + start;
              }

              var len = end - start;

              if (
                this === target &&
                typeof Uint8Array.prototype.copyWithin === 'function'
              ) {
                // Use built-in when available, missing from IE11
                this.copyWithin(targetStart, start, end);
              } else if (
                this === target &&
                start < targetStart &&
                targetStart < end
              ) {
                // descending copy from end
                for (var i = len - 1; i >= 0; --i) {
                  target[i + targetStart] = this[i + start];
                }
              } else {
                Uint8Array.prototype.set.call(
                  target,
                  this.subarray(start, end),
                  targetStart
                );
              }

              return len;
            };

            // Usage:
            //    buffer.fill(number[, offset[, end]])
            //    buffer.fill(buffer[, offset[, end]])
            //    buffer.fill(string[, offset[, end]][, encoding])
            Buffer.prototype.fill = function fill(val, start, end, encoding) {
              // Handle string cases:
              if (typeof val === 'string') {
                if (typeof start === 'string') {
                  encoding = start;
                  start = 0;
                  end = this.length;
                } else if (typeof end === 'string') {
                  encoding = end;
                  end = this.length;
                }
                if (encoding !== undefined && typeof encoding !== 'string') {
                  throw new TypeError('encoding must be a string');
                }
                if (
                  typeof encoding === 'string' &&
                  !Buffer.isEncoding(encoding)
                ) {
                  throw new TypeError('Unknown encoding: ' + encoding);
                }
                if (val.length === 1) {
                  var code = val.charCodeAt(0);
                  if (
                    (encoding === 'utf8' && code < 128) ||
                    encoding === 'latin1'
                  ) {
                    // Fast path: If `val` fits into a single byte, use that numeric value.
                    val = code;
                  }
                }
              } else if (typeof val === 'number') {
                val = val & 255;
              }

              // Invalid ranges are not set to a default, so can range check early.
              if (start < 0 || this.length < start || this.length < end) {
                throw new RangeError('Out of range index');
              }

              if (end <= start) {
                return this;
              }

              start = start >>> 0;
              end = end === undefined ? this.length : end >>> 0;

              if (!val) val = 0;

              var i;
              if (typeof val === 'number') {
                for (i = start; i < end; ++i) {
                  this[i] = val;
                }
              } else {
                var bytes = Buffer.isBuffer(val)
                  ? val
                  : Buffer.from(val, encoding);
                var len = bytes.length;
                if (len === 0) {
                  throw new TypeError(
                    'The value "' + val + '" is invalid for argument "value"'
                  );
                }
                for (i = 0; i < end - start; ++i) {
                  this[i + start] = bytes[i % len];
                }
              }

              return this;
            };

            // HELPER FUNCTIONS
            // ================

            var INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g;

            function base64clean(str) {
              // Node takes equal signs as end of the Base64 encoding
              str = str.split('=')[0];
              // Node strips out invalid characters like \n and \t from the string, base64-js does not
              str = str.trim().replace(INVALID_BASE64_RE, '');
              // Node converts strings with length < 2 to ''
              if (str.length < 2) return '';
              // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
              while (str.length % 4 !== 0) {
                str = str + '=';
              }
              return str;
            }

            function toHex(n) {
              if (n < 16) return '0' + n.toString(16);
              return n.toString(16);
            }

            function utf8ToBytes(string, units) {
              units = units || Infinity;
              var codePoint;
              var length = string.length;
              var leadSurrogate = null;
              var bytes = [];

              for (var i = 0; i < length; ++i) {
                codePoint = string.charCodeAt(i);

                // is surrogate component
                if (codePoint > 0xd7ff && codePoint < 0xe000) {
                  // last char was a lead
                  if (!leadSurrogate) {
                    // no lead yet
                    if (codePoint > 0xdbff) {
                      // unexpected trail
                      if ((units -= 3) > -1) bytes.push(0xef, 0xbf, 0xbd);
                      continue;
                    } else if (i + 1 === length) {
                      // unpaired lead
                      if ((units -= 3) > -1) bytes.push(0xef, 0xbf, 0xbd);
                      continue;
                    }

                    // valid lead
                    leadSurrogate = codePoint;

                    continue;
                  }

                  // 2 leads in a row
                  if (codePoint < 0xdc00) {
                    if ((units -= 3) > -1) bytes.push(0xef, 0xbf, 0xbd);
                    leadSurrogate = codePoint;
                    continue;
                  }

                  // valid surrogate pair
                  codePoint =
                    (((leadSurrogate - 0xd800) << 10) | (codePoint - 0xdc00)) +
                    0x10000;
                } else if (leadSurrogate) {
                  // valid bmp char, but last char was a lead
                  if ((units -= 3) > -1) bytes.push(0xef, 0xbf, 0xbd);
                }

                leadSurrogate = null;

                // encode utf8
                if (codePoint < 0x80) {
                  if ((units -= 1) < 0) break;
                  bytes.push(codePoint);
                } else if (codePoint < 0x800) {
                  if ((units -= 2) < 0) break;
                  bytes.push(
                    (codePoint >> 0x6) | 0xc0,
                    (codePoint & 0x3f) | 0x80
                  );
                } else if (codePoint < 0x10000) {
                  if ((units -= 3) < 0) break;
                  bytes.push(
                    (codePoint >> 0xc) | 0xe0,
                    ((codePoint >> 0x6) & 0x3f) | 0x80,
                    (codePoint & 0x3f) | 0x80
                  );
                } else if (codePoint < 0x110000) {
                  if ((units -= 4) < 0) break;
                  bytes.push(
                    (codePoint >> 0x12) | 0xf0,
                    ((codePoint >> 0xc) & 0x3f) | 0x80,
                    ((codePoint >> 0x6) & 0x3f) | 0x80,
                    (codePoint & 0x3f) | 0x80
                  );
                } else {
                  throw new Error('Invalid code point');
                }
              }

              return bytes;
            }

            function asciiToBytes(str) {
              var byteArray = [];
              for (var i = 0; i < str.length; ++i) {
                // Node's code seems to be doing this and not & 0x7F..
                byteArray.push(str.charCodeAt(i) & 0xff);
              }
              return byteArray;
            }

            function utf16leToBytes(str, units) {
              var c, hi, lo;
              var byteArray = [];
              for (var i = 0; i < str.length; ++i) {
                if ((units -= 2) < 0) break;

                c = str.charCodeAt(i);
                hi = c >> 8;
                lo = c % 256;
                byteArray.push(lo);
                byteArray.push(hi);
              }

              return byteArray;
            }

            function base64ToBytes(str) {
              return base64.toByteArray(base64clean(str));
            }

            function blitBuffer(src, dst, offset, length) {
              for (var i = 0; i < length; ++i) {
                if (i + offset >= dst.length || i >= src.length) break;
                dst[i + offset] = src[i];
              }
              return i;
            }

            // ArrayBuffer or Uint8Array objects from other contexts (i.e. iframes) do not pass
            // the `instanceof` check but they should be treated as of that type.
            // See: https://github.com/feross/buffer/issues/166
            function isInstance(obj, type) {
              return (
                obj instanceof type ||
                (obj != null &&
                  obj.constructor != null &&
                  obj.constructor.name != null &&
                  obj.constructor.name === type.name)
              );
            }
            function numberIsNaN(obj) {
              // For IE11 support
              return obj !== obj; // eslint-disable-line no-self-compare
            }
          }.call(this, require('buffer').Buffer));
        },
        { 'base64-js': 103, buffer: 106, ieee754: 125 },
      ],
      107: [
        function(require, module, exports) {
          (function(Buffer) {
            // Copyright Joyent, Inc. and other Node contributors.
            //
            // Permission is hereby granted, free of charge, to any person obtaining a
            // copy of this software and associated documentation files (the
            // "Software"), to deal in the Software without restriction, including
            // without limitation the rights to use, copy, modify, merge, publish,
            // distribute, sublicense, and/or sell copies of the Software, and to permit
            // persons to whom the Software is furnished to do so, subject to the
            // following conditions:
            //
            // The above copyright notice and this permission notice shall be included
            // in all copies or substantial portions of the Software.
            //
            // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
            // OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
            // MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
            // NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
            // DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
            // OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
            // USE OR OTHER DEALINGS IN THE SOFTWARE.

            // NOTE: These type checking functions intentionally don't use `instanceof`
            // because it is fragile and can be easily faked with `Object.create()`.

            function isArray(arg) {
              if (Array.isArray) {
                return Array.isArray(arg);
              }
              return objectToString(arg) === '[object Array]';
            }
            exports.isArray = isArray;

            function isBoolean(arg) {
              return typeof arg === 'boolean';
            }
            exports.isBoolean = isBoolean;

            function isNull(arg) {
              return arg === null;
            }
            exports.isNull = isNull;

            function isNullOrUndefined(arg) {
              return arg == null;
            }
            exports.isNullOrUndefined = isNullOrUndefined;

            function isNumber(arg) {
              return typeof arg === 'number';
            }
            exports.isNumber = isNumber;

            function isString(arg) {
              return typeof arg === 'string';
            }
            exports.isString = isString;

            function isSymbol(arg) {
              return typeof arg === 'symbol';
            }
            exports.isSymbol = isSymbol;

            function isUndefined(arg) {
              return arg === void 0;
            }
            exports.isUndefined = isUndefined;

            function isRegExp(re) {
              return objectToString(re) === '[object RegExp]';
            }
            exports.isRegExp = isRegExp;

            function isObject(arg) {
              return typeof arg === 'object' && arg !== null;
            }
            exports.isObject = isObject;

            function isDate(d) {
              return objectToString(d) === '[object Date]';
            }
            exports.isDate = isDate;

            function isError(e) {
              return (
                objectToString(e) === '[object Error]' || e instanceof Error
              );
            }
            exports.isError = isError;

            function isFunction(arg) {
              return typeof arg === 'function';
            }
            exports.isFunction = isFunction;

            function isPrimitive(arg) {
              return (
                arg === null ||
                typeof arg === 'boolean' ||
                typeof arg === 'number' ||
                typeof arg === 'string' ||
                typeof arg === 'symbol' || // ES6 symbol
                typeof arg === 'undefined'
              );
            }
            exports.isPrimitive = isPrimitive;

            exports.isBuffer = Buffer.isBuffer;

            function objectToString(o) {
              return Object.prototype.toString.call(o);
            }
          }.call(this, { isBuffer: require('../../is-buffer/index.js') }));
        },
        { '../../is-buffer/index.js': 128 },
      ],
      108: [
        function(require, module, exports) {
          (function() {
            'use strict';

            function defineDate(extended, is, array) {
              function _pad(string, length, ch, end) {
                string = '' + string; //check for numbers
                ch = ch || ' ';
                var strLen = string.length;
                while (strLen < length) {
                  if (end) {
                    string += ch;
                  } else {
                    string = ch + string;
                  }
                  strLen++;
                }
                return string;
              }

              function _truncate(string, length, end) {
                var ret = string;
                if (is.isString(ret)) {
                  if (string.length > length) {
                    if (end) {
                      var l = string.length;
                      ret = string.substring(l - length, l);
                    } else {
                      ret = string.substring(0, length);
                    }
                  }
                } else {
                  ret = _truncate('' + ret, length);
                }
                return ret;
              }

              function every(arr, iterator, scope) {
                if (!is.isArray(arr) || typeof iterator !== 'function') {
                  throw new TypeError();
                }
                var t = Object(arr);
                var len = t.length >>> 0;
                for (var i = 0; i < len; i++) {
                  if (i in t && !iterator.call(scope, t[i], i, t)) {
                    return false;
                  }
                }
                return true;
              }

              var transforms = (function() {
                  var floor = Math.floor,
                    round = Math.round;

                  var addMap = {
                    day: function addDay(date, amount) {
                      return [amount, 'Date', false];
                    },
                    weekday: function addWeekday(date, amount) {
                      // Divide the increment time span into weekspans plus leftover days
                      // e.g., 8 days is one 5-day weekspan / and two leftover days
                      // Can't have zero leftover days, so numbers divisible by 5 get
                      // a days value of 5, and the remaining days make up the number of weeks
                      var days,
                        weeks,
                        mod = amount % 5,
                        strt = date.getDay(),
                        adj = 0;
                      if (!mod) {
                        days = amount > 0 ? 5 : -5;
                        weeks =
                          amount > 0 ? (amount - 5) / 5 : (amount + 5) / 5;
                      } else {
                        days = mod;
                        weeks = parseInt(amount / 5, 10);
                      }
                      if (strt === 6 && amount > 0) {
                        adj = 1;
                      } else if (strt === 0 && amount < 0) {
                        // Orig date is Sun / negative increment
                        // Jump back over Sat
                        adj = -1;
                      }
                      // Get weekday val for the new date
                      var trgt = strt + days;
                      // New date is on Sat or Sun
                      if (trgt === 0 || trgt === 6) {
                        adj = amount > 0 ? 2 : -2;
                      }
                      // Increment by number of weeks plus leftover days plus
                      // weekend adjustments
                      return [7 * weeks + days + adj, 'Date', false];
                    },
                    year: function addYear(date, amount) {
                      return [amount, 'FullYear', true];
                    },
                    week: function addWeek(date, amount) {
                      return [amount * 7, 'Date', false];
                    },
                    quarter: function addYear(date, amount) {
                      return [amount * 3, 'Month', true];
                    },
                    month: function addYear(date, amount) {
                      return [amount, 'Month', true];
                    },
                  };

                  function addTransform(interval, date, amount) {
                    interval = interval.replace(/s$/, '');
                    if (addMap.hasOwnProperty(interval)) {
                      return addMap[interval](date, amount);
                    }
                    return [
                      amount,
                      'UTC' +
                        interval.charAt(0).toUpperCase() +
                        interval.substring(1) +
                        's',
                      false,
                    ];
                  }

                  var differenceMap = {
                    quarter: function quarterDifference(date1, date2, utc) {
                      var yearDiff = date2.getFullYear() - date1.getFullYear();
                      var m1 = date1[utc ? 'getUTCMonth' : 'getMonth']();
                      var m2 = date2[utc ? 'getUTCMonth' : 'getMonth']();
                      // Figure out which quarter the months are in
                      var q1 = floor(m1 / 3) + 1;
                      var q2 = floor(m2 / 3) + 1;
                      // Add quarters for any year difference between the dates
                      q2 += yearDiff * 4;
                      return q2 - q1;
                    },

                    weekday: function weekdayDifference(date1, date2, utc) {
                      var days = differenceTransform('day', date1, date2, utc),
                        weeks;
                      var mod = days % 7;
                      // Even number of weeks
                      if (mod === 0) {
                        days =
                          differenceTransform('week', date1, date2, utc) * 5;
                      } else {
                        // Weeks plus spare change (< 7 days)
                        var adj = 0,
                          aDay = date1[utc ? 'getUTCDay' : 'getDay'](),
                          bDay = date2[utc ? 'getUTCDay' : 'getDay']();
                        weeks = parseInt(days / 7, 10);
                        // Mark the date advanced by the number of
                        // round weeks (may be zero)
                        var dtMark = new Date(+date1);
                        dtMark.setDate(
                          dtMark[utc ? 'getUTCDate' : 'getDate']() + weeks * 7
                        );
                        var dayMark = dtMark[utc ? 'getUTCDay' : 'getDay']();

                        // Spare change days -- 6 or less
                        if (days > 0) {
                          if (aDay === 6 || bDay === 6) {
                            adj = -1;
                          } else if (aDay === 0) {
                            adj = 0;
                          } else if (bDay === 0 || dayMark + mod > 5) {
                            adj = -2;
                          }
                        } else if (days < 0) {
                          if (aDay === 6) {
                            adj = 0;
                          } else if (aDay === 0 || bDay === 0) {
                            adj = 1;
                          } else if (bDay === 6 || dayMark + mod < 0) {
                            adj = 2;
                          }
                        }
                        days += adj;
                        days -= weeks * 2;
                      }
                      return days;
                    },
                    year: function(date1, date2) {
                      return date2.getFullYear() - date1.getFullYear();
                    },
                    month: function(date1, date2, utc) {
                      var m1 = date1[utc ? 'getUTCMonth' : 'getMonth']();
                      var m2 = date2[utc ? 'getUTCMonth' : 'getMonth']();
                      return (
                        m2 -
                        m1 +
                        (date2.getFullYear() - date1.getFullYear()) * 12
                      );
                    },
                    week: function(date1, date2, utc) {
                      return round(
                        differenceTransform('day', date1, date2, utc) / 7
                      );
                    },
                    day: function(date1, date2) {
                      return (
                        1.1574074074074074e-8 *
                        (date2.getTime() - date1.getTime())
                      );
                    },
                    hour: function(date1, date2) {
                      return (
                        2.7777777777777776e-7 *
                        (date2.getTime() - date1.getTime())
                      );
                    },
                    minute: function(date1, date2) {
                      return (
                        0.000016666666666666667 *
                        (date2.getTime() - date1.getTime())
                      );
                    },
                    second: function(date1, date2) {
                      return 0.001 * (date2.getTime() - date1.getTime());
                    },
                    millisecond: function(date1, date2) {
                      return date2.getTime() - date1.getTime();
                    },
                  };

                  function differenceTransform(interval, date1, date2, utc) {
                    interval = interval.replace(/s$/, '');
                    return round(differenceMap[interval](date1, date2, utc));
                  }

                  return {
                    addTransform: addTransform,
                    differenceTransform: differenceTransform,
                  };
                })(),
                addTransform = transforms.addTransform,
                differenceTransform = transforms.differenceTransform;

              /**
               * @ignore
               * Based on DOJO Date Implementation
               *
               * Dojo is available under *either* the terms of the modified BSD license *or* the
               * Academic Free License version 2.1. As a recipient of Dojo, you may choose which
               * license to receive this code under (except as noted in per-module LICENSE
               * files). Some modules may not be the copyright of the Dojo Foundation. These
               * modules contain explicit declarations of copyright in both the LICENSE files in
               * the directories in which they reside and in the code itself. No external
               * contributions are allowed under licenses which are fundamentally incompatible
               * with the AFL or BSD licenses that Dojo is distributed under.
               *
               */

              var floor = Math.floor,
                round = Math.round,
                min = Math.min,
                pow = Math.pow,
                ceil = Math.ceil,
                abs = Math.abs;
              var monthNames = [
                'January',
                'February',
                'March',
                'April',
                'May',
                'June',
                'July',
                'August',
                'September',
                'October',
                'November',
                'December',
              ];
              var monthAbbr = [
                'Jan.',
                'Feb.',
                'Mar.',
                'Apr.',
                'May.',
                'Jun.',
                'Jul.',
                'Aug.',
                'Sep.',
                'Oct.',
                'Nov.',
                'Dec.',
              ];
              var dayNames = [
                'Sunday',
                'Monday',
                'Tuesday',
                'Wednesday',
                'Thursday',
                'Friday',
                'Saturday',
              ];
              var dayAbbr = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
              var eraNames = ['Before Christ', 'Anno Domini'];
              var eraAbbr = ['BC', 'AD'];

              function getDayOfYear(/*Date*/ dateObject, utc) {
                // summary: gets the day of the year as represented by dateObject
                return (
                  date.difference(
                    new Date(
                      dateObject.getFullYear(),
                      0,
                      1,
                      dateObject.getHours()
                    ),
                    dateObject,
                    null,
                    utc
                  ) + 1
                ); // Number
              }

              function getWeekOfYear(
                /*Date*/ dateObject,
                /*Number*/ firstDayOfWeek,
                utc
              ) {
                firstDayOfWeek = firstDayOfWeek || 0;
                var fullYear = dateObject[
                  utc ? 'getUTCFullYear' : 'getFullYear'
                ]();
                var firstDayOfYear = new Date(fullYear, 0, 1).getDay(),
                  adj = (firstDayOfYear - firstDayOfWeek + 7) % 7,
                  week = floor((getDayOfYear(dateObject) + adj - 1) / 7);

                // if year starts on the specified day, start counting weeks at 1
                if (firstDayOfYear === firstDayOfWeek) {
                  week++;
                }

                return week; // Number
              }

              function getTimezoneName(/*Date*/ dateObject) {
                var str = dateObject.toString();
                var tz = '';
                var pos = str.indexOf('(');
                if (pos > -1) {
                  tz = str.substring(++pos, str.indexOf(')'));
                }
                return tz; // String
              }

              function buildDateEXP(pattern, tokens) {
                return pattern
                  .replace(/([a-z])\1*/gi, function(match) {
                    // Build a simple regexp.  Avoid captures, which would ruin the tokens list
                    var s,
                      c = match.charAt(0),
                      l = match.length,
                      p2 = '0?',
                      p3 = '0{0,2}';
                    if (c === 'y') {
                      s = '\\d{2,4}';
                    } else if (c === 'M') {
                      s = l > 2 ? '\\S+?' : '1[0-2]|' + p2 + '[1-9]';
                    } else if (c === 'D') {
                      s =
                        '[12][0-9][0-9]|3[0-5][0-9]|36[0-6]|' +
                        p3 +
                        '[1-9][0-9]|' +
                        p2 +
                        '[1-9]';
                    } else if (c === 'd') {
                      s = '3[01]|[12]\\d|' + p2 + '[1-9]';
                    } else if (c === 'w') {
                      s = '[1-4][0-9]|5[0-3]|' + p2 + '[1-9]';
                    } else if (c === 'E') {
                      s = '\\S+';
                    } else if (c === 'h') {
                      s = '1[0-2]|' + p2 + '[1-9]';
                    } else if (c === 'K') {
                      s = '1[01]|' + p2 + '\\d';
                    } else if (c === 'H') {
                      s = '1\\d|2[0-3]|' + p2 + '\\d';
                    } else if (c === 'k') {
                      s = '1\\d|2[0-4]|' + p2 + '[1-9]';
                    } else if (c === 'm' || c === 's') {
                      s = '[0-5]\\d';
                    } else if (c === 'S') {
                      s = '\\d{' + l + '}';
                    } else if (c === 'a') {
                      var am = 'AM',
                        pm = 'PM';
                      s = am + '|' + pm;
                      if (am !== am.toLowerCase()) {
                        s += '|' + am.toLowerCase();
                      }
                      if (pm !== pm.toLowerCase()) {
                        s += '|' + pm.toLowerCase();
                      }
                      s = s.replace(/\./g, '\\.');
                    } else if (
                      c === 'v' ||
                      c === 'z' ||
                      c === 'Z' ||
                      c === 'G' ||
                      c === 'q' ||
                      c === 'Q'
                    ) {
                      s = '.*';
                    } else {
                      s = c === ' ' ? '\\s*' : c + '*';
                    }
                    if (tokens) {
                      tokens.push(match);
                    }

                    return '(' + s + ')'; // add capture
                  })
                  .replace(/[\xa0 ]/g, '[\\s\\xa0]'); // normalize whitespace.  Need explicit handling of \xa0 for IE.
              }

              /**
               * @namespace Utilities for Dates
               */
              var date = {
                /**@lends date*/

                /**
                 * Returns the number of days in the month of a date
                 *
                 * @example
                 *
                 *  dateExtender.getDaysInMonth(new Date(2006, 1, 1)); //28
                 *  dateExtender.getDaysInMonth(new Date(2004, 1, 1)); //29
                 *  dateExtender.getDaysInMonth(new Date(2006, 2, 1)); //31
                 *  dateExtender.getDaysInMonth(new Date(2006, 3, 1)); //30
                 *  dateExtender.getDaysInMonth(new Date(2006, 4, 1)); //31
                 *  dateExtender.getDaysInMonth(new Date(2006, 5, 1)); //30
                 *  dateExtender.getDaysInMonth(new Date(2006, 6, 1)); //31
                 * @param {Date} dateObject the date containing the month
                 * @return {Number} the number of days in the month
                 */
                getDaysInMonth: function(/*Date*/ dateObject) {
                  //	summary:
                  //		Returns the number of days in the month used by dateObject
                  var month = dateObject.getMonth();
                  var days = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
                  if (month === 1 && date.isLeapYear(dateObject)) {
                    return 29;
                  } // Number
                  return days[month]; // Number
                },

                /**
                 * Determines if a date is a leap year
                 *
                 * @example
                 *
                 *  dateExtender.isLeapYear(new Date(1600, 0, 1)); //true
                 *  dateExtender.isLeapYear(new Date(2004, 0, 1)); //true
                 *  dateExtender.isLeapYear(new Date(2000, 0, 1)); //true
                 *  dateExtender.isLeapYear(new Date(2006, 0, 1)); //false
                 *  dateExtender.isLeapYear(new Date(1900, 0, 1)); //false
                 *  dateExtender.isLeapYear(new Date(1800, 0, 1)); //false
                 *  dateExtender.isLeapYear(new Date(1700, 0, 1)); //false
                 *
                 * @param {Date} dateObject
                 * @returns {Boolean} true if it is a leap year false otherwise
                 */
                isLeapYear: function(/*Date*/ dateObject, utc) {
                  var year = dateObject[
                    utc ? 'getUTCFullYear' : 'getFullYear'
                  ]();
                  return (
                    year % 400 === 0 || (year % 4 === 0 && year % 100 !== 0)
                  );
                },

                /**
                 * Determines if a date is on a weekend
                 *
                 * @example
                 *
                 * var thursday = new Date(2006, 8, 21);
                 * var saturday = new Date(2006, 8, 23);
                 * var sunday = new Date(2006, 8, 24);
                 * var monday = new Date(2006, 8, 25);
                 * dateExtender.isWeekend(thursday)); //false
                 * dateExtender.isWeekend(saturday); //true
                 * dateExtender.isWeekend(sunday); //true
                 * dateExtender.isWeekend(monday)); //false
                 *
                 * @param {Date} dateObject the date to test
                 *
                 * @returns {Boolean} true if the date is a weekend
                 */
                isWeekend: function(/*Date?*/ dateObject, utc) {
                  // summary:
                  //	Determines if the date falls on a weekend, according to local custom.
                  var day = (dateObject || new Date())[
                    utc ? 'getUTCDay' : 'getDay'
                  ]();
                  return day === 0 || day === 6;
                },

                /**
                 * Get the timezone of a date
                 *
                 * @example
                 *  //just setting the strLocal to simulate the toString() of a date
                 *  dt.str = 'Sun Sep 17 2006 22:25:51 GMT-0500 (CDT)';
                 *  //just setting the strLocal to simulate the locale
                 *  dt.strLocale = 'Sun 17 Sep 2006 10:25:51 PM CDT';
                 *  dateExtender.getTimezoneName(dt); //'CDT'
                 *  dt.str = 'Sun Sep 17 2006 22:57:18 GMT-0500 (CDT)';
                 *  dt.strLocale = 'Sun Sep 17 22:57:18 2006';
                 *  dateExtender.getTimezoneName(dt); //'CDT'
                 * @param dateObject the date to get the timezone from
                 *
                 * @returns {String} the timezone of the date
                 */
                getTimezoneName: getTimezoneName,

                /**
                 * Compares two dates
                 *
                 * @example
                 *
                 * var d1 = new Date();
                 * d1.setHours(0);
                 * dateExtender.compare(d1, d1); // 0
                 *
                 *  var d1 = new Date();
                 *  d1.setHours(0);
                 *  var d2 = new Date();
                 *  d2.setFullYear(2005);
                 *  d2.setHours(12);
                 *  dateExtender.compare(d1, d2, "date"); // 1
                 *  dateExtender.compare(d1, d2, "datetime"); // 1
                 *
                 *  var d1 = new Date();
                 *  d1.setHours(0);
                 *  var d2 = new Date();
                 *  d2.setFullYear(2005);
                 *  d2.setHours(12);
                 *  dateExtender.compare(d2, d1, "date"); // -1
                 *  dateExtender.compare(d1, d2, "time"); //-1
                 *
                 * @param {Date|String} date1 the date to comapare
                 * @param {Date|String} [date2=new Date()] the date to compare date1 againse
                 * @param {"date"|"time"|"datetime"} portion compares the portion specified
                 *
                 * @returns -1 if date1 is < date2 0 if date1 === date2  1 if date1 > date2
                 */
                compare: function(
                  /*Date*/ date1,
                  /*Date*/ date2,
                  /*String*/ portion
                ) {
                  date1 = new Date(+date1);
                  date2 = new Date(+(date2 || new Date()));

                  if (portion === 'date') {
                    // Ignore times and compare dates.
                    date1.setHours(0, 0, 0, 0);
                    date2.setHours(0, 0, 0, 0);
                  } else if (portion === 'time') {
                    // Ignore dates and compare times.
                    date1.setFullYear(0, 0, 0);
                    date2.setFullYear(0, 0, 0);
                  }
                  return date1 > date2 ? 1 : date1 < date2 ? -1 : 0;
                },

                /**
                 * Adds a specified interval and amount to a date
                 *
                 * @example
                 *  var dtA = new Date(2005, 11, 27);
                 *  dateExtender.add(dtA, "year", 1); //new Date(2006, 11, 27);
                 *  dateExtender.add(dtA, "years", 1); //new Date(2006, 11, 27);
                 *
                 *  dtA = new Date(2000, 0, 1);
                 *  dateExtender.add(dtA, "quarter", 1); //new Date(2000, 3, 1);
                 *  dateExtender.add(dtA, "quarters", 1); //new Date(2000, 3, 1);
                 *
                 *  dtA = new Date(2000, 0, 1);
                 *  dateExtender.add(dtA, "month", 1); //new Date(2000, 1, 1);
                 *  dateExtender.add(dtA, "months", 1); //new Date(2000, 1, 1);
                 *
                 *  dtA = new Date(2000, 0, 31);
                 *  dateExtender.add(dtA, "month", 1); //new Date(2000, 1, 29);
                 *  dateExtender.add(dtA, "months", 1); //new Date(2000, 1, 29);
                 *
                 *  dtA = new Date(2000, 0, 1);
                 *  dateExtender.add(dtA, "week", 1); //new Date(2000, 0, 8);
                 *  dateExtender.add(dtA, "weeks", 1); //new Date(2000, 0, 8);
                 *
                 *  dtA = new Date(2000, 0, 1);
                 *  dateExtender.add(dtA, "day", 1); //new Date(2000, 0, 2);
                 *
                 *  dtA = new Date(2000, 0, 1);
                 *  dateExtender.add(dtA, "weekday", 1); //new Date(2000, 0, 3);
                 *
                 *  dtA = new Date(2000, 0, 1, 11);
                 *  dateExtender.add(dtA, "hour", 1); //new Date(2000, 0, 1, 12);
                 *
                 *  dtA = new Date(2000, 11, 31, 23, 59);
                 *  dateExtender.add(dtA, "minute", 1); //new Date(2001, 0, 1, 0, 0);
                 *
                 *  dtA = new Date(2000, 11, 31, 23, 59, 59);
                 *  dateExtender.add(dtA, "second", 1); //new Date(2001, 0, 1, 0, 0, 0);
                 *
                 *  dtA = new Date(2000, 11, 31, 23, 59, 59, 999);
                 *  dateExtender.add(dtA, "millisecond", 1); //new Date(2001, 0, 1, 0, 0, 0, 0);
                 *
                 * @param {Date} date
                 * @param {String} interval the interval to add
                 *  <ul>
                 *      <li>day | days</li>
                 *      <li>weekday | weekdays</li>
                 *      <li>year | years</li>
                 *      <li>week | weeks</li>
                 *      <li>quarter | quarters</li>
                 *      <li>months | months</li>
                 *      <li>hour | hours</li>
                 *      <li>minute | minutes</li>
                 *      <li>second | seconds</li>
                 *      <li>millisecond | milliseconds</li>
                 *  </ul>
                 * @param {Number} [amount=0] the amount to add
                 */
                add: function(
                  /*Date*/ date,
                  /*String*/ interval,
                  /*int*/ amount
                ) {
                  var res = addTransform(interval, date, amount || 0);
                  amount = res[0];
                  var property = res[1];
                  var sum = new Date(+date);
                  var fixOvershoot = res[2];
                  if (property) {
                    sum['set' + property](sum['get' + property]() + amount);
                  }

                  if (fixOvershoot && sum.getDate() < date.getDate()) {
                    sum.setDate(0);
                  }

                  return sum; // Date
                },

                /**
                 * Finds the difference between two dates based on the specified interval
                 *
                 * @example
                 *
                 * var dtA, dtB;
                 *
                 * dtA = new Date(2005, 11, 27);
                 * dtB = new Date(2006, 11, 27);
                 * dateExtender.difference(dtA, dtB, "year"); //1
                 *
                 * dtA = new Date(2000, 1, 29);
                 * dtB = new Date(2001, 2, 1);
                 * dateExtender.difference(dtA, dtB, "quarter"); //4
                 * dateExtender.difference(dtA, dtB, "month"); //13
                 *
                 * dtA = new Date(2000, 1, 1);
                 * dtB = new Date(2000, 1, 8);
                 * dateExtender.difference(dtA, dtB, "week"); //1
                 *
                 * dtA = new Date(2000, 1, 29);
                 * dtB = new Date(2000, 2, 1);
                 * dateExtender.difference(dtA, dtB, "day"); //1
                 *
                 * dtA = new Date(2006, 7, 3);
                 * dtB = new Date(2006, 7, 11);
                 * dateExtender.difference(dtA, dtB, "weekday"); //6
                 *
                 * dtA = new Date(2000, 11, 31, 23);
                 * dtB = new Date(2001, 0, 1, 0);
                 * dateExtender.difference(dtA, dtB, "hour"); //1
                 *
                 * dtA = new Date(2000, 11, 31, 23, 59);
                 * dtB = new Date(2001, 0, 1, 0, 0);
                 * dateExtender.difference(dtA, dtB, "minute"); //1
                 *
                 * dtA = new Date(2000, 11, 31, 23, 59, 59);
                 * dtB = new Date(2001, 0, 1, 0, 0, 0);
                 * dateExtender.difference(dtA, dtB, "second"); //1
                 *
                 * dtA = new Date(2000, 11, 31, 23, 59, 59, 999);
                 * dtB = new Date(2001, 0, 1, 0, 0, 0, 0);
                 * dateExtender.difference(dtA, dtB, "millisecond"); //1
                 *
                 *
                 * @param {Date} date1
                 * @param {Date} [date2 = new Date()]
                 * @param {String} [interval = "day"] the intercal to find the difference of.
                 *   <ul>
                 *      <li>day | days</li>
                 *      <li>weekday | weekdays</li>
                 *      <li>year | years</li>
                 *      <li>week | weeks</li>
                 *      <li>quarter | quarters</li>
                 *      <li>months | months</li>
                 *      <li>hour | hours</li>
                 *      <li>minute | minutes</li>
                 *      <li>second | seconds</li>
                 *      <li>millisecond | milliseconds</li>
                 *  </ul>
                 */
                difference: function(
                  /*Date*/ date1,
                  /*Date?*/ date2,
                  /*String*/ interval,
                  utc
                ) {
                  date2 = date2 || new Date();
                  interval = interval || 'day';
                  return differenceTransform(interval, date1, date2, utc);
                },

                /**
                 * Formats a date to the specidifed format string
                 *
                 * @example
                 *
                 * var date = new Date(2006, 7, 11, 0, 55, 12, 345);
                 * dateExtender.format(date, "EEEE, MMMM dd, yyyy"); //"Friday, August 11, 2006"
                 * dateExtender.format(date, "M/dd/yy"); //"8/11/06"
                 * dateExtender.format(date, "E"); //"6"
                 * dateExtender.format(date, "h:m a"); //"12:55 AM"
                 * dateExtender.format(date, 'h:m:s'); //"12:55:12"
                 * dateExtender.format(date, 'h:m:s.SS'); //"12:55:12.35"
                 * dateExtender.format(date, 'k:m:s.SS'); //"24:55:12.35"
                 * dateExtender.format(date, 'H:m:s.SS'); //"0:55:12.35"
                 * dateExtender.format(date, "ddMMyyyy"); //"11082006"
                 *
                 * @param date the date to format
                 * @param {String} format the format of the date composed of the following options
                 * <ul>
                 *                  <li> G    Era designator    Text    AD</li>
                 *                  <li> y    Year    Year    1996; 96</li>
                 *                  <li> M    Month in year    Month    July; Jul; 07</li>
                 *                  <li> w    Week in year    Number    27</li>
                 *                  <li> W    Week in month    Number    2</li>
                 *                  <li> D    Day in year    Number    189</li>
                 *                  <li> d    Day in month    Number    10</li>
                 *                  <li> E    Day in week    Text    Tuesday; Tue</li>
                 *                  <li> a    Am/pm marker    Text    PM</li>
                 *                  <li> H    Hour in day (0-23)    Number    0</li>
                 *                  <li> k    Hour in day (1-24)    Number    24</li>
                 *                  <li> K    Hour in am/pm (0-11)    Number    0</li>
                 *                  <li> h    Hour in am/pm (1-12)    Number    12</li>
                 *                  <li> m    Minute in hour    Number    30</li>
                 *                  <li> s    Second in minute    Number    55</li>
                 *                  <li> S    Millisecond    Number    978</li>
                 *                  <li> z    Time zone    General time zone    Pacific Standard Time; PST; GMT-08:00</li>
                 *                  <li> Z    Time zone    RFC 822 time zone    -0800 </li>
                 * </ul>
                 */
                format: function(date, format, utc) {
                  utc = utc || false;
                  var fullYear,
                    month,
                    day,
                    d,
                    hour,
                    minute,
                    second,
                    millisecond;
                  if (utc) {
                    fullYear = date.getUTCFullYear();
                    month = date.getUTCMonth();
                    day = date.getUTCDay();
                    d = date.getUTCDate();
                    hour = date.getUTCHours();
                    minute = date.getUTCMinutes();
                    second = date.getUTCSeconds();
                    millisecond = date.getUTCMilliseconds();
                  } else {
                    fullYear = date.getFullYear();
                    month = date.getMonth();
                    d = date.getDate();
                    day = date.getDay();
                    hour = date.getHours();
                    minute = date.getMinutes();
                    second = date.getSeconds();
                    millisecond = date.getMilliseconds();
                  }
                  return format.replace(/([A-Za-z])\1*/g, function(match) {
                    var s,
                      pad,
                      c = match.charAt(0),
                      l = match.length;
                    if (c === 'd') {
                      s = '' + d;
                      pad = true;
                    } else if (c === 'H' && !s) {
                      s = '' + hour;
                      pad = true;
                    } else if (c === 'm' && !s) {
                      s = '' + minute;
                      pad = true;
                    } else if (c === 's') {
                      if (!s) {
                        s = '' + second;
                      }
                      pad = true;
                    } else if (c === 'G') {
                      s = (l < 4 ? eraAbbr : eraNames)[fullYear < 0 ? 0 : 1];
                    } else if (c === 'y') {
                      s = fullYear;
                      if (l > 1) {
                        if (l === 2) {
                          s = _truncate('' + s, 2, true);
                        } else {
                          pad = true;
                        }
                      }
                    } else if (c.toUpperCase() === 'Q') {
                      s = ceil((month + 1) / 3);
                      pad = true;
                    } else if (c === 'M') {
                      if (l < 3) {
                        s = month + 1;
                        pad = true;
                      } else {
                        s = (l === 3 ? monthAbbr : monthNames)[month];
                      }
                    } else if (c === 'w') {
                      s = getWeekOfYear(date, 0, utc);
                      pad = true;
                    } else if (c === 'D') {
                      s = getDayOfYear(date, utc);
                      pad = true;
                    } else if (c === 'E') {
                      if (l < 3) {
                        s = day + 1;
                        pad = true;
                      } else {
                        s = (l === -3 ? dayAbbr : dayNames)[day];
                      }
                    } else if (c === 'a') {
                      s = hour < 12 ? 'AM' : 'PM';
                    } else if (c === 'h') {
                      s = hour % 12 || 12;
                      pad = true;
                    } else if (c === 'K') {
                      s = hour % 12;
                      pad = true;
                    } else if (c === 'k') {
                      s = hour || 24;
                      pad = true;
                    } else if (c === 'S') {
                      s = round(millisecond * pow(10, l - 3));
                      pad = true;
                    } else if (c === 'z' || c === 'v' || c === 'Z') {
                      s = getTimezoneName(date);
                      if ((c === 'z' || c === 'v') && !s) {
                        l = 4;
                      }
                      if (!s || c === 'Z') {
                        var offset = date.getTimezoneOffset();
                        var tz = [
                          offset >= 0 ? '-' : '+',
                          _pad(floor(abs(offset) / 60), 2, '0'),
                          _pad(abs(offset) % 60, 2, '0'),
                        ];
                        if (l === 4) {
                          tz.splice(0, 0, 'GMT');
                          tz.splice(3, 0, ':');
                        }
                        s = tz.join('');
                      }
                    } else {
                      s = match;
                    }
                    if (pad) {
                      s = _pad(s, l, '0');
                    }
                    return s;
                  });
                },
              };

              var numberDate = {};

              function addInterval(interval) {
                numberDate[interval + 'sFromNow'] = function(val) {
                  return date.add(new Date(), interval, val);
                };
                numberDate[interval + 'sAgo'] = function(val) {
                  return date.add(new Date(), interval, -val);
                };
              }

              var intervals = [
                'year',
                'month',
                'day',
                'hour',
                'minute',
                'second',
              ];
              for (var i = 0, l = intervals.length; i < l; i++) {
                addInterval(intervals[i]);
              }

              var stringDate = {
                parseDate: function(dateStr, format) {
                  if (!format) {
                    throw new Error(
                      'format required when calling dateExtender.parse'
                    );
                  }
                  var tokens = [],
                    regexp = buildDateEXP(format, tokens),
                    re = new RegExp('^' + regexp + '$', 'i'),
                    match = re.exec(dateStr);
                  if (!match) {
                    return null;
                  } // null
                  var result = [1970, 0, 1, 0, 0, 0, 0], // will get converted to a Date at the end
                    amPm = '',
                    valid = every(match, function(v, i) {
                      if (i) {
                        var token = tokens[i - 1];
                        var l = token.length,
                          type = token.charAt(0);
                        if (type === 'y') {
                          if (v < 100) {
                            v = parseInt(v, 10);
                            //choose century to apply, according to a sliding window
                            //of 80 years before and 20 years after present year
                            var year = '' + new Date().getFullYear(),
                              century = year.substring(0, 2) * 100,
                              cutoff = min(year.substring(2, 4) + 20, 99);
                            result[0] =
                              v < cutoff ? century + v : century - 100 + v;
                          } else {
                            result[0] = v;
                          }
                        } else if (type === 'M') {
                          if (l > 2) {
                            var months = monthNames,
                              j,
                              k;
                            if (l === 3) {
                              months = monthAbbr;
                            }
                            //Tolerate abbreviating period in month part
                            //Case-insensitive comparison
                            v = v.replace('.', '').toLowerCase();
                            var contains = false;
                            for (
                              j = 0, k = months.length;
                              j < k && !contains;
                              j++
                            ) {
                              var s = months[j]
                                .replace('.', '')
                                .toLocaleLowerCase();
                              if (s === v) {
                                v = j;
                                contains = true;
                              }
                            }
                            if (!contains) {
                              return false;
                            }
                          } else {
                            v--;
                          }
                          result[1] = v;
                        } else if (type === 'E' || type === 'e') {
                          var days = dayNames;
                          if (l === 3) {
                            days = dayAbbr;
                          }
                          //Case-insensitive comparison
                          v = v.toLowerCase();
                          days = array.map(days, function(d) {
                            return d.toLowerCase();
                          });
                          var d = array.indexOf(days, v);
                          if (d === -1) {
                            v = parseInt(v, 10);
                            if (isNaN(v) || v > days.length) {
                              return false;
                            }
                          } else {
                            v = d;
                          }
                        } else if (type === 'D' || type === 'd') {
                          if (type === 'D') {
                            result[1] = 0;
                          }
                          result[2] = v;
                        } else if (type === 'a') {
                          var am = 'am';
                          var pm = 'pm';
                          var period = /\./g;
                          v = v.replace(period, '').toLowerCase();
                          // we might not have seen the hours field yet, so store the state and apply hour change later
                          amPm = v === pm ? 'p' : v === am ? 'a' : '';
                        } else if (
                          type === 'k' ||
                          type === 'h' ||
                          type === 'H' ||
                          type === 'K'
                        ) {
                          if (type === 'k' && +v === 24) {
                            v = 0;
                          }
                          result[3] = v;
                        } else if (type === 'm') {
                          result[4] = v;
                        } else if (type === 's') {
                          result[5] = v;
                        } else if (type === 'S') {
                          result[6] = v;
                        }
                      }
                      return true;
                    });
                  if (valid) {
                    var hours = +result[3];
                    //account for am/pm
                    if (amPm === 'p' && hours < 12) {
                      result[3] = hours + 12; //e.g., 3pm -> 15
                    } else if (amPm === 'a' && hours === 12) {
                      result[3] = 0; //12am -> 0
                    }
                    var dateObject = new Date(
                      result[0],
                      result[1],
                      result[2],
                      result[3],
                      result[4],
                      result[5],
                      result[6]
                    ); // Date
                    var dateToken = array.indexOf(tokens, 'd') !== -1,
                      monthToken = array.indexOf(tokens, 'M') !== -1,
                      month = result[1],
                      day = result[2],
                      dateMonth = dateObject.getMonth(),
                      dateDay = dateObject.getDate();
                    if (
                      (monthToken && dateMonth > month) ||
                      (dateToken && dateDay > day)
                    ) {
                      return null;
                    }
                    return dateObject; // Date
                  } else {
                    return null;
                  }
                },
              };

              var ret = extended
                .define(is.isDate, date)
                .define(is.isString, stringDate)
                .define(is.isNumber, numberDate);
              for (i in date) {
                if (date.hasOwnProperty(i)) {
                  ret[i] = date[i];
                }
              }

              for (i in stringDate) {
                if (stringDate.hasOwnProperty(i)) {
                  ret[i] = stringDate[i];
                }
              }
              for (i in numberDate) {
                if (numberDate.hasOwnProperty(i)) {
                  ret[i] = numberDate[i];
                }
              }
              return ret;
            }

            if ('undefined' !== typeof exports) {
              if ('undefined' !== typeof module && module.exports) {
                module.exports = defineDate(
                  require('extended'),
                  require('is-extended'),
                  require('array-extended')
                );
              }
            } else if ('function' === typeof define && define.amd) {
              define(['extended', 'is-extended', 'array-extended'], function(
                extended,
                is,
                arr
              ) {
                return defineDate(extended, is, arr);
              });
            } else {
              this.dateExtended = defineDate(
                this.extended,
                this.isExtended,
                this.arrayExtended
              );
            }
          }.call(this));
        },
        { 'array-extended': 102, extended: 113, 'is-extended': 129 },
      ],
      109: [
        function(require, module, exports) {
          (function() {
            /**
             * @projectName declare
             * @github http://github.com/doug-martin/declare.js
             * @header
             *
             * Declare is a library designed to allow writing object oriented code the same way in both the browser and node.js.
             *
             * ##Installation
             *
             * `npm install declare.js`
             *
             * Or [download the source](https://raw.github.com/doug-martin/declare.js/master/declare.js) ([minified](https://raw.github.com/doug-martin/declare.js/master/declare-min.js))
             *
             * ###Requirejs
             *
             * To use with requirejs place the `declare` source in the root scripts directory
             *
             * ```
             *
             * define(["declare"], function(declare){
             *      return declare({
             *          instance : {
             *              hello : function(){
             *                  return "world";
             *              }
             *          }
             *      });
             * });
             *
             * ```
             *
             *
             * ##Usage
             *
             * declare.js provides
             *
             * Class methods
             *
             * * `as(module | object, name)` : exports the object to module or the object with the name
             * * `mixin(mixin)` : mixes in an object but does not inherit directly from the object. **Note** this does not return a new class but changes the original class.
             * * `extend(proto)` : extend a class with the given properties. A shortcut to `declare(Super, {})`;
             *
             * Instance methods
             *
             * * `_super(arguments)`: calls the super of the current method, you can pass in either the argments object or an array with arguments you want passed to super
             * * `_getSuper()`: returns a this methods direct super.
             * * `_static` : use to reference class properties and methods.
             * * `get(prop)` : gets a property invoking the getter if it exists otherwise it just returns the named property on the object.
             * * `set(prop, val)` : sets a property invoking the setter if it exists otherwise it just sets the named property on the object.
             *
             *
             * ###Declaring a new Class
             *
             * Creating a new class with declare is easy!
             *
             * ```
             *
             * var Mammal = declare({
             *      //define your instance methods and properties
             *      instance : {
             *
             *          //will be called whenever a new instance is created
             *          constructor: function(options) {
             *              options = options || {};
             *              this._super(arguments);
             *              this._type = options.type || "mammal";
             *          },
             *
             *          speak : function() {
             *              return  "A mammal of type " + this._type + " sounds like";
             *          },
             *
             *          //Define your getters
             *          getters : {
             *
             *              //can be accessed by using the get method. (mammal.get("type"))
             *              type : function() {
             *                  return this._type;
             *              }
             *          },
             *
             *           //Define your setters
             *          setters : {
             *
             *                //can be accessed by using the set method. (mammal.set("type", "mammalType"))
             *              type : function(t) {
             *                  this._type = t;
             *              }
             *          }
             *      },
             *
             *      //Define your static methods
             *      static : {
             *
             *          //Mammal.soundOff(); //"Im a mammal!!"
             *          soundOff : function() {
             *              return "Im a mammal!!";
             *          }
             *      }
             * });
             *
             *
             * ```
             *
             * You can use Mammal just like you would any other class.
             *
             * ```
             * Mammal.soundOff("Im a mammal!!");
             *
             * var myMammal = new Mammal({type : "mymammal"});
             * myMammal.speak(); // "A mammal of type mymammal sounds like"
             * myMammal.get("type"); //"mymammal"
             * myMammal.set("type", "mammal");
             * myMammal.get("type"); //"mammal"
             *
             *
             * ```
             *
             * ###Extending a class
             *
             * If you want to just extend a single class use the .extend method.
             *
             * ```
             *
             * var Wolf = Mammal.extend({
             *
             *   //define your instance method
             *   instance: {
             *
             *        //You can override super constructors just be sure to call `_super`
             *       constructor: function(options) {
             *          options = options || {};
             *          this._super(arguments); //call our super constructor.
             *          this._sound = "growl";
             *          this._color = options.color || "grey";
             *      },
             *
             *      //override Mammals `speak` method by appending our own data to it.
             *      speak : function() {
             *          return this._super(arguments) + " a " + this._sound;
             *      },
             *
             *      //add new getters for sound and color
             *      getters : {
             *
             *           //new Wolf().get("type")
             *           //notice color is read only as we did not define a setter
             *          color : function() {
             *              return this._color;
             *          },
             *
             *          //new Wolf().get("sound")
             *          sound : function() {
             *              return this._sound;
             *          }
             *      },
             *
             *      setters : {
             *
             *          //new Wolf().set("sound", "howl")
             *          sound : function(s) {
             *              this._sound = s;
             *          }
             *      }
             *
             *  },
             *
             *  static : {
             *
             *      //You can override super static methods also! And you can still use _super
             *      soundOff : function() {
             *          //You can even call super in your statics!!!
             *          //should return "I'm a mammal!! that growls"
             *          return this._super(arguments) + " that growls";
             *      }
             *  }
             * });
             *
             * Wolf.soundOff(); //Im a mammal!! that growls
             *
             * var myWolf = new Wolf();
             * myWolf instanceof Mammal //true
             * myWolf instanceof Wolf //true
             *
             * ```
             *
             * You can also extend a class by using the declare method and just pass in the super class.
             *
             * ```
             * //Typical hierarchical inheritance
             * // Mammal->Wolf->Dog
             * var Dog = declare(Wolf, {
             *    instance: {
             *        constructor: function(options) {
             *            options = options || {};
             *            this._super(arguments);
             *            //override Wolfs initialization of sound to woof.
             *            this._sound = "woof";
             *
             *        },
             *
             *        speak : function() {
             *            //Should return "A mammal of type mammal sounds like a growl thats domesticated"
             *            return this._super(arguments) + " thats domesticated";
             *        }
             *    },
             *
             *    static : {
             *        soundOff : function() {
             *            //should return "I'm a mammal!! that growls but now barks"
             *            return this._super(arguments) + " but now barks";
             *        }
             *    }
             * });
             *
             * Dog.soundOff(); //Im a mammal!! that growls but now barks
             *
             * var myDog = new Dog();
             * myDog instanceof Mammal //true
             * myDog instanceof Wolf //true
             * myDog instanceof Dog //true
             *
             *
             * //Notice you still get the extend method.
             *
             * // Mammal->Wolf->Dog->Breed
             * var Breed = Dog.extend({
             *    instance: {
             *
             *        //initialize outside of constructor
             *        _pitch : "high",
             *
             *        constructor: function(options) {
             *            options = options || {};
             *            this._super(arguments);
             *            this.breed = options.breed || "lab";
             *        },
             *
             *        speak : function() {
             *            //Should return "A mammal of type mammal sounds like a
             *            //growl thats domesticated with a high pitch!"
             *            return this._super(arguments) + " with a " + this._pitch + " pitch!";
             *        },
             *
             *        getters : {
             *            pitch : function() {
             *                return this._pitch;
             *            }
             *        }
             *    },
             *
             *    static : {
             *        soundOff : function() {
             *            //should return "I'M A MAMMAL!! THAT GROWLS BUT NOW BARKS!"
             *            return this._super(arguments).toUpperCase() + "!";
             *        }
             *    }
             * });
             *
             *
             * Breed.soundOff()//"IM A MAMMAL!! THAT GROWLS BUT NOW BARKS!"
             *
             * var myBreed = new Breed({color : "gold", type : "lab"}),
             * myBreed instanceof Dog //true
             * myBreed instanceof Wolf //true
             * myBreed instanceof Mammal //true
             * myBreed.speak() //"A mammal of type lab sounds like a woof thats domesticated with a high pitch!"
             * myBreed.get("type") //"lab"
             * myBreed.get("color") //"gold"
             * myBreed.get("sound")" //"woof"
             * ```
             *
             * ###Multiple Inheritance / Mixins
             *
             * declare also allows the use of multiple super classes.
             * This is useful if you have generic classes that provide functionality but shouldnt be used on their own.
             *
             * Lets declare a mixin that allows us to watch for property changes.
             *
             * ```
             * //Notice that we set up the functions outside of declare because we can reuse them
             *
             * function _set(prop, val) {
             *     //get the old value
             *     var oldVal = this.get(prop);
             *     //call super to actually set the property
             *     var ret = this._super(arguments);
             *     //call our handlers
             *     this.__callHandlers(prop, oldVal, val);
             *     return ret;
             * }
             *
             * function _callHandlers(prop, oldVal, newVal) {
             *    //get our handlers for the property
             *     var handlers = this.__watchers[prop], l;
             *     //if the handlers exist and their length does not equal 0 then we call loop through them
             *     if (handlers && (l = handlers.length) !== 0) {
             *         for (var i = 0; i < l; i++) {
             *             //call the handler
             *             handlers[i].call(null, prop, oldVal, newVal);
             *         }
             *     }
             * }
             *
             *
             * //the watch function
             * function _watch(prop, handler) {
             *     if ("function" !== typeof handler) {
             *         //if its not a function then its an invalid handler
             *         throw new TypeError("Invalid handler.");
             *     }
             *     if (!this.__watchers[prop]) {
             *         //create the watchers if it doesnt exist
             *         this.__watchers[prop] = [handler];
             *     } else {
             *         //otherwise just add it to the handlers array
             *         this.__watchers[prop].push(handler);
             *     }
             * }
             *
             * function _unwatch(prop, handler) {
             *     if ("function" !== typeof handler) {
             *         throw new TypeError("Invalid handler.");
             *     }
             *     var handlers = this.__watchers[prop], index;
             *     if (handlers && (index = handlers.indexOf(handler)) !== -1) {
             *        //remove the handler if it is found
             *         handlers.splice(index, 1);
             *     }
             * }
             *
             * declare({
             *     instance:{
             *         constructor:function () {
             *             this._super(arguments);
             *             //set up our watchers
             *             this.__watchers = {};
             *         },
             *
             *         //override the default set function so we can watch values
             *         "set":_set,
             *         //set up our callhandlers function
             *         __callHandlers:_callHandlers,
             *         //add the watch function
             *         watch:_watch,
             *         //add the unwatch function
             *         unwatch:_unwatch
             *     },
             *
             *     "static":{
             *
             *         init:function () {
             *             this._super(arguments);
             *             this.__watchers = {};
             *         },
             *         //override the default set function so we can watch values
             *         "set":_set,
             *         //set our callHandlers function
             *         __callHandlers:_callHandlers,
             *         //add the watch
             *         watch:_watch,
             *         //add the unwatch function
             *         unwatch:_unwatch
             *     }
             * })
             *
             * ```
             *
             * Now lets use the mixin
             *
             * ```
             * var WatchDog = declare([Dog, WatchMixin]);
             *
             * var watchDog = new WatchDog();
             * //create our handler
             * function watch(id, oldVal, newVal) {
             *     console.log("watchdog's %s was %s, now %s", id, oldVal, newVal);
             * }
             *
             * //watch for property changes
             * watchDog.watch("type", watch);
             * watchDog.watch("color", watch);
             * watchDog.watch("sound", watch);
             *
             * //now set the properties each handler will be called
             * watchDog.set("type", "newDog");
             * watchDog.set("color", "newColor");
             * watchDog.set("sound", "newSound");
             *
             *
             * //unwatch the property changes
             * watchDog.unwatch("type", watch);
             * watchDog.unwatch("color", watch);
             * watchDog.unwatch("sound", watch);
             *
             * //no handlers will be called this time
             * watchDog.set("type", "newDog");
             * watchDog.set("color", "newColor");
             * watchDog.set("sound", "newSound");
             *
             *
             * ```
             *
             * ###Accessing static methods and properties witin an instance.
             *
             * To access static properties on an instance use the `_static` property which is a reference to your constructor.
             *
             * For example if your in your constructor and you want to have configurable default values.
             *
             * ```
             * consturctor : function constructor(opts){
             *     this.opts = opts || {};
             *     this._type = opts.type || this._static.DEFAULT_TYPE;
             * }
             * ```
             *
             *
             *
             * ###Creating a new instance of within an instance.
             *
             * Often times you want to create a new instance of an object within an instance. If your subclassed however you cannot return a new instance of the parent class as it will not be the right sub class. `declare` provides a way around this by setting the `_static` property on each isntance of the class.
             *
             * Lets add a reproduce method `Mammal`
             *
             * ```
             * reproduce : function(options){
             *     return new this._static(options);
             * }
             * ```
             *
             * Now in each subclass you can call reproduce and get the proper type.
             *
             * ```
             * var myDog = new Dog();
             * var myDogsChild = myDog.reproduce();
             *
             * myDogsChild instanceof Dog; //true
             * ```
             *
             * ###Using the `as`
             *
             * `declare` also provides an `as` method which allows you to add your class to an object or if your using node.js you can pass in `module` and the class will be exported as the module.
             *
             * ```
             * var animals = {};
             *
             * Mammal.as(animals, "Dog");
             * Wolf.as(animals, "Wolf");
             * Dog.as(animals, "Dog");
             * Breed.as(animals, "Breed");
             *
             * var myDog = new animals.Dog();
             *
             * ```
             *
             * Or in node
             *
             * ```
             * Mammal.as(exports, "Dog");
             * Wolf.as(exports, "Wolf");
             * Dog.as(exports, "Dog");
             * Breed.as(exports, "Breed");
             *
             * ```
             *
             * To export a class as the `module` in node
             *
             * ```
             * Mammal.as(module);
             * ```
             *
             *
             */
            function createDeclared() {
              var arraySlice = Array.prototype.slice,
                classCounter = 0,
                Base,
                forceNew = new Function();

              var SUPER_REGEXP = /(super)/g;

              function argsToArray(args, slice) {
                slice = slice || 0;
                return arraySlice.call(args, slice);
              }

              function isArray(obj) {
                return Object.prototype.toString.call(obj) === '[object Array]';
              }

              function isObject(obj) {
                var undef;
                return obj !== null && obj !== undef && typeof obj === 'object';
              }

              function isHash(obj) {
                var ret = isObject(obj);
                return ret && obj.constructor === Object;
              }

              var isArguments = function _isArguments(object) {
                return (
                  Object.prototype.toString.call(object) ===
                  '[object Arguments]'
                );
              };

              if (!isArguments(arguments)) {
                isArguments = function _isArguments(obj) {
                  return !!(obj && obj.hasOwnProperty('callee'));
                };
              }

              function indexOf(arr, item) {
                if (arr && arr.length) {
                  for (var i = 0, l = arr.length; i < l; i++) {
                    if (arr[i] === item) {
                      return i;
                    }
                  }
                }
                return -1;
              }

              function merge(target, source, exclude) {
                var name, s;
                for (name in source) {
                  if (
                    source.hasOwnProperty(name) &&
                    indexOf(exclude, name) === -1
                  ) {
                    s = source[name];
                    if (!(name in target) || target[name] !== s) {
                      target[name] = s;
                    }
                  }
                }
                return target;
              }

              function callSuper(args, a) {
                var meta = this.__meta,
                  supers = meta.supers,
                  l = supers.length,
                  superMeta = meta.superMeta,
                  pos = superMeta.pos;
                if (l > pos) {
                  args = !args
                    ? []
                    : !isArguments(args) && !isArray(args)
                    ? [args]
                    : args;
                  var name = superMeta.name,
                    f = superMeta.f,
                    m;
                  do {
                    m = supers[pos][name];
                    if ('function' === typeof m && (m = m._f || m) !== f) {
                      superMeta.pos = 1 + pos;
                      return m.apply(this, args);
                    }
                  } while (l > ++pos);
                }

                return null;
              }

              function getSuper() {
                var meta = this.__meta,
                  supers = meta.supers,
                  l = supers.length,
                  superMeta = meta.superMeta,
                  pos = superMeta.pos;
                if (l > pos) {
                  var name = superMeta.name,
                    f = superMeta.f,
                    m;
                  do {
                    m = supers[pos][name];
                    if ('function' === typeof m && (m = m._f || m) !== f) {
                      superMeta.pos = 1 + pos;
                      return m.bind(this);
                    }
                  } while (l > ++pos);
                }
                return null;
              }

              function getter(name) {
                var getters = this.__getters__;
                if (getters.hasOwnProperty(name)) {
                  return getters[name].apply(this);
                } else {
                  return this[name];
                }
              }

              function setter(name, val) {
                var setters = this.__setters__;
                if (isHash(name)) {
                  for (var i in name) {
                    var prop = name[i];
                    if (setters.hasOwnProperty(i)) {
                      setters[name].call(this, prop);
                    } else {
                      this[i] = prop;
                    }
                  }
                } else {
                  if (setters.hasOwnProperty(name)) {
                    return setters[name].apply(this, argsToArray(arguments, 1));
                  } else {
                    return (this[name] = val);
                  }
                }
              }

              function defaultFunction() {
                var meta = this.__meta || {},
                  supers = meta.supers,
                  l = supers.length,
                  superMeta = meta.superMeta,
                  pos = superMeta.pos;
                if (l > pos) {
                  var name = superMeta.name,
                    f = superMeta.f,
                    m;
                  do {
                    m = supers[pos][name];
                    if ('function' === typeof m && (m = m._f || m) !== f) {
                      superMeta.pos = 1 + pos;
                      return m.apply(this, arguments);
                    }
                  } while (l > ++pos);
                }
                return null;
              }

              function functionWrapper(f, name) {
                if (f.toString().match(SUPER_REGEXP)) {
                  var wrapper = function wrapper() {
                    var ret,
                      meta = this.__meta || {};
                    var orig = meta.superMeta;
                    meta.superMeta = { f: f, pos: 0, name: name };
                    switch (arguments.length) {
                      case 0:
                        ret = f.call(this);
                        break;
                      case 1:
                        ret = f.call(this, arguments[0]);
                        break;
                      case 2:
                        ret = f.call(this, arguments[0], arguments[1]);
                        break;

                      case 3:
                        ret = f.call(
                          this,
                          arguments[0],
                          arguments[1],
                          arguments[2]
                        );
                        break;
                      default:
                        ret = f.apply(this, arguments);
                    }
                    meta.superMeta = orig;
                    return ret;
                  };
                  wrapper._f = f;
                  return wrapper;
                } else {
                  f._f = f;
                  return f;
                }
              }

              function defineMixinProps(child, proto) {
                var operations = proto.setters || {},
                  __setters = child.__setters__,
                  __getters = child.__getters__;
                for (var i in operations) {
                  if (!__setters.hasOwnProperty(i)) {
                    //make sure that the setter isnt already there
                    __setters[i] = operations[i];
                  }
                }
                operations = proto.getters || {};
                for (i in operations) {
                  if (!__getters.hasOwnProperty(i)) {
                    //make sure that the setter isnt already there
                    __getters[i] = operations[i];
                  }
                }
                for (var j in proto) {
                  if (j !== 'getters' && j !== 'setters') {
                    var p = proto[j];
                    if ('function' === typeof p) {
                      if (!child.hasOwnProperty(j)) {
                        child[j] = functionWrapper(defaultFunction, j);
                      }
                    } else {
                      child[j] = p;
                    }
                  }
                }
              }

              function mixin() {
                var args = argsToArray(arguments),
                  l = args.length;
                var child = this.prototype;
                var childMeta = child.__meta,
                  thisMeta = this.__meta,
                  bases = child.__meta.bases,
                  staticBases = bases.slice(),
                  staticSupers = thisMeta.supers || [],
                  supers = childMeta.supers || [];
                for (var i = 0; i < l; i++) {
                  var m = args[i],
                    mProto = m.prototype;
                  var protoMeta = mProto.__meta,
                    meta = m.__meta;
                  !protoMeta &&
                    (protoMeta = mProto.__meta = { proto: mProto || {} });
                  !meta && (meta = m.__meta = { proto: m.__proto__ || {} });
                  defineMixinProps(child, protoMeta.proto || {});
                  defineMixinProps(this, meta.proto || {});
                  //copy the bases for static,

                  mixinSupers(m.prototype, supers, bases);
                  mixinSupers(m, staticSupers, staticBases);
                }
                return this;
              }

              function mixinSupers(sup, arr, bases) {
                var meta = sup.__meta;
                !meta && (meta = sup.__meta = {});
                var unique = sup.__meta.unique;
                !unique && (meta.unique = 'declare' + ++classCounter);
                //check it we already have this super mixed into our prototype chain
                //if true then we have already looped their supers!
                if (indexOf(bases, unique) === -1) {
                  //add their id to our bases
                  bases.push(unique);
                  var supers = sup.__meta.supers || [],
                    i = supers.length - 1 || 0;
                  while (i >= 0) {
                    mixinSupers(supers[i--], arr, bases);
                  }
                  arr.unshift(sup);
                }
              }

              function defineProps(child, proto) {
                var operations = proto.setters,
                  __setters = child.__setters__,
                  __getters = child.__getters__;
                if (operations) {
                  for (var i in operations) {
                    __setters[i] = operations[i];
                  }
                }
                operations = proto.getters || {};
                if (operations) {
                  for (i in operations) {
                    __getters[i] = operations[i];
                  }
                }
                for (i in proto) {
                  if (i != 'getters' && i != 'setters') {
                    var f = proto[i];
                    if ('function' === typeof f) {
                      var meta = f.__meta || {};
                      if (!meta.isConstructor) {
                        child[i] = functionWrapper(f, i);
                      } else {
                        child[i] = f;
                      }
                    } else {
                      child[i] = f;
                    }
                  }
                }
              }

              function _export(obj, name) {
                if (obj && name) {
                  obj[name] = this;
                } else {
                  obj.exports = obj = this;
                }
                return this;
              }

              function extend(proto) {
                return declare(this, proto);
              }

              function getNew(ctor) {
                // create object with correct prototype using a do-nothing
                // constructor
                forceNew.prototype = ctor.prototype;
                var t = new forceNew();
                forceNew.prototype = null; // clean up
                return t;
              }

              function __declare(child, sup, proto) {
                var childProto = {},
                  supers = [];
                var unique = 'declare' + ++classCounter,
                  bases = [],
                  staticBases = [];
                var instanceSupers = [],
                  staticSupers = [];
                var meta = {
                  supers: instanceSupers,
                  unique: unique,
                  bases: bases,
                  superMeta: {
                    f: null,
                    pos: 0,
                    name: null,
                  },
                };
                var childMeta = {
                  supers: staticSupers,
                  unique: unique,
                  bases: staticBases,
                  isConstructor: true,
                  superMeta: {
                    f: null,
                    pos: 0,
                    name: null,
                  },
                };

                if (isHash(sup) && !proto) {
                  proto = sup;
                  sup = Base;
                }

                if ('function' === typeof sup || isArray(sup)) {
                  supers = isArray(sup) ? sup : [sup];
                  sup = supers.shift();
                  child.__meta = childMeta;
                  childProto = getNew(sup);
                  childProto.__meta = meta;
                  childProto.__getters__ = merge(
                    {},
                    childProto.__getters__ || {}
                  );
                  childProto.__setters__ = merge(
                    {},
                    childProto.__setters__ || {}
                  );
                  child.__getters__ = merge({}, child.__getters__ || {});
                  child.__setters__ = merge({}, child.__setters__ || {});
                  mixinSupers(sup.prototype, instanceSupers, bases);
                  mixinSupers(sup, staticSupers, staticBases);
                } else {
                  child.__meta = childMeta;
                  childProto.__meta = meta;
                  childProto.__getters__ = childProto.__getters__ || {};
                  childProto.__setters__ = childProto.__setters__ || {};
                  child.__getters__ = child.__getters__ || {};
                  child.__setters__ = child.__setters__ || {};
                }
                child.prototype = childProto;
                if (proto) {
                  var instance = (meta.proto = proto.instance || {});
                  var stat = (childMeta.proto = proto.static || {});
                  stat.init = stat.init || defaultFunction;
                  defineProps(childProto, instance);
                  defineProps(child, stat);
                  if (!instance.hasOwnProperty('constructor')) {
                    childProto.constructor = instance.constructor = functionWrapper(
                      defaultFunction,
                      'constructor'
                    );
                  } else {
                    childProto.constructor = functionWrapper(
                      instance.constructor,
                      'constructor'
                    );
                  }
                } else {
                  meta.proto = {};
                  childMeta.proto = {};
                  child.init = functionWrapper(defaultFunction, 'init');
                  childProto.constructor = functionWrapper(
                    defaultFunction,
                    'constructor'
                  );
                }
                if (supers.length) {
                  mixin.apply(child, supers);
                }
                if (sup) {
                  //do this so we mixin our super methods directly but do not ov
                  merge(child, merge(merge({}, sup), child));
                }
                childProto._super = child._super = callSuper;
                childProto._getSuper = child._getSuper = getSuper;
                childProto._static = child;
              }

              function declare(sup, proto) {
                function declared() {
                  switch (arguments.length) {
                    case 0:
                      this.constructor.call(this);
                      break;
                    case 1:
                      this.constructor.call(this, arguments[0]);
                      break;
                    case 2:
                      this.constructor.call(this, arguments[0], arguments[1]);
                      break;
                    case 3:
                      this.constructor.call(
                        this,
                        arguments[0],
                        arguments[1],
                        arguments[2]
                      );
                      break;
                    default:
                      this.constructor.apply(this, arguments);
                  }
                }

                __declare(declared, sup, proto);
                return declared.init() || declared;
              }

              function singleton(sup, proto) {
                var retInstance;

                function declaredSingleton() {
                  if (!retInstance) {
                    this.constructor.apply(this, arguments);
                    retInstance = this;
                  }
                  return retInstance;
                }

                __declare(declaredSingleton, sup, proto);
                return declaredSingleton.init() || declaredSingleton;
              }

              Base = declare({
                instance: {
                  get: getter,
                  set: setter,
                },

                static: {
                  get: getter,
                  set: setter,
                  mixin: mixin,
                  extend: extend,
                  as: _export,
                },
              });

              declare.singleton = singleton;
              return declare;
            }

            if ('undefined' !== typeof exports) {
              if ('undefined' !== typeof module && module.exports) {
                module.exports = createDeclared();
              }
            } else if ('function' === typeof define && define.amd) {
              define(createDeclared);
            } else {
              this.declare = createDeclared();
            }
          })();
        },
        {},
      ],
      110: [
        function(require, module, exports) {
          module.exports = require('./declare.js');
        },
        { './declare.js': 109 },
      ],
      111: [
        function(require, module, exports) {
          (function(process, global) {
            /*!
             * @overview es6-promise - a tiny implementation of Promises/A+.
             * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
             * @license   Licensed under MIT license
             *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
             * @version   3.3.1
             */

            (function(global, factory) {
              typeof exports === 'object' && typeof module !== 'undefined'
                ? (module.exports = factory())
                : typeof define === 'function' && define.amd
                ? define(factory)
                : (global.ES6Promise = factory());
            })(this, function() {
              'use strict';

              function objectOrFunction(x) {
                return (
                  typeof x === 'function' ||
                  (typeof x === 'object' && x !== null)
                );
              }

              function isFunction(x) {
                return typeof x === 'function';
              }

              var _isArray = undefined;
              if (!Array.isArray) {
                _isArray = function(x) {
                  return Object.prototype.toString.call(x) === '[object Array]';
                };
              } else {
                _isArray = Array.isArray;
              }

              var isArray = _isArray;

              var len = 0;
              var vertxNext = undefined;
              var customSchedulerFn = undefined;

              var asap = function asap(callback, arg) {
                queue[len] = callback;
                queue[len + 1] = arg;
                len += 2;
                if (len === 2) {
                  // If len is 2, that means that we need to schedule an async flush.
                  // If additional callbacks are queued before the queue is flushed, they
                  // will be processed by this flush that we are scheduling.
                  if (customSchedulerFn) {
                    customSchedulerFn(flush);
                  } else {
                    scheduleFlush();
                  }
                }
              };

              function setScheduler(scheduleFn) {
                customSchedulerFn = scheduleFn;
              }

              function setAsap(asapFn) {
                asap = asapFn;
              }

              var browserWindow =
                typeof window !== 'undefined' ? window : undefined;
              var browserGlobal = browserWindow || {};
              var BrowserMutationObserver =
                browserGlobal.MutationObserver ||
                browserGlobal.WebKitMutationObserver;
              var isNode =
                typeof self === 'undefined' &&
                typeof process !== 'undefined' &&
                {}.toString.call(process) === '[object process]';

              // test for web worker but not in IE10
              var isWorker =
                typeof Uint8ClampedArray !== 'undefined' &&
                typeof importScripts !== 'undefined' &&
                typeof MessageChannel !== 'undefined';

              // node
              function useNextTick() {
                // node version 0.10.x displays a deprecation warning when nextTick is used recursively
                // see https://github.com/cujojs/when/issues/410 for details
                return function() {
                  return process.nextTick(flush);
                };
              }

              // vertx
              function useVertxTimer() {
                return function() {
                  vertxNext(flush);
                };
              }

              function useMutationObserver() {
                var iterations = 0;
                var observer = new BrowserMutationObserver(flush);
                var node = document.createTextNode('');
                observer.observe(node, { characterData: true });

                return function() {
                  node.data = iterations = ++iterations % 2;
                };
              }

              // web worker
              function useMessageChannel() {
                var channel = new MessageChannel();
                channel.port1.onmessage = flush;
                return function() {
                  return channel.port2.postMessage(0);
                };
              }

              function useSetTimeout() {
                // Store setTimeout reference so es6-promise will be unaffected by
                // other code modifying setTimeout (like sinon.useFakeTimers())
                var globalSetTimeout = setTimeout;
                return function() {
                  return globalSetTimeout(flush, 1);
                };
              }

              var queue = new Array(1000);
              function flush() {
                for (var i = 0; i < len; i += 2) {
                  var callback = queue[i];
                  var arg = queue[i + 1];

                  callback(arg);

                  queue[i] = undefined;
                  queue[i + 1] = undefined;
                }

                len = 0;
              }

              function attemptVertx() {
                try {
                  var r = require;
                  var vertx = r('vertx');
                  vertxNext = vertx.runOnLoop || vertx.runOnContext;
                  return useVertxTimer();
                } catch (e) {
                  return useSetTimeout();
                }
              }

              var scheduleFlush = undefined;
              // Decide what async method to use to triggering processing of queued callbacks:
              if (isNode) {
                scheduleFlush = useNextTick();
              } else if (BrowserMutationObserver) {
                scheduleFlush = useMutationObserver();
              } else if (isWorker) {
                scheduleFlush = useMessageChannel();
              } else if (
                browserWindow === undefined &&
                typeof require === 'function'
              ) {
                scheduleFlush = attemptVertx();
              } else {
                scheduleFlush = useSetTimeout();
              }

              function then(onFulfillment, onRejection) {
                var _arguments = arguments;

                var parent = this;

                var child = new this.constructor(noop);

                if (child[PROMISE_ID] === undefined) {
                  makePromise(child);
                }

                var _state = parent._state;

                if (_state) {
                  (function() {
                    var callback = _arguments[_state - 1];
                    asap(function() {
                      return invokeCallback(
                        _state,
                        child,
                        callback,
                        parent._result
                      );
                    });
                  })();
                } else {
                  subscribe(parent, child, onFulfillment, onRejection);
                }

                return child;
              }

              /**
  `Promise.resolve` returns a promise that will become resolved with the
  passed `value`. It is shorthand for the following:

  ```javascript
  let promise = new Promise(function(resolve, reject){
    resolve(1);
  });

  promise.then(function(value){
    // value === 1
  });
  ```

  Instead of writing the above, your code now simply becomes the following:

  ```javascript
  let promise = Promise.resolve(1);

  promise.then(function(value){
    // value === 1
  });
  ```

  @method resolve
  @static
  @param {Any} value value that the returned promise will be resolved with
  Useful for tooling.
  @return {Promise} a promise that will become fulfilled with the given
  `value`
*/
              function resolve(object) {
                /*jshint validthis:true */
                var Constructor = this;

                if (
                  object &&
                  typeof object === 'object' &&
                  object.constructor === Constructor
                ) {
                  return object;
                }

                var promise = new Constructor(noop);
                _resolve(promise, object);
                return promise;
              }

              var PROMISE_ID = Math.random()
                .toString(36)
                .substring(16);

              function noop() {}

              var PENDING = void 0;
              var FULFILLED = 1;
              var REJECTED = 2;

              var GET_THEN_ERROR = new ErrorObject();

              function selfFulfillment() {
                return new TypeError(
                  'You cannot resolve a promise with itself'
                );
              }

              function cannotReturnOwn() {
                return new TypeError(
                  'A promises callback cannot return that same promise.'
                );
              }

              function getThen(promise) {
                try {
                  return promise.then;
                } catch (error) {
                  GET_THEN_ERROR.error = error;
                  return GET_THEN_ERROR;
                }
              }

              function tryThen(
                then,
                value,
                fulfillmentHandler,
                rejectionHandler
              ) {
                try {
                  then.call(value, fulfillmentHandler, rejectionHandler);
                } catch (e) {
                  return e;
                }
              }

              function handleForeignThenable(promise, thenable, then) {
                asap(function(promise) {
                  var sealed = false;
                  var error = tryThen(
                    then,
                    thenable,
                    function(value) {
                      if (sealed) {
                        return;
                      }
                      sealed = true;
                      if (thenable !== value) {
                        _resolve(promise, value);
                      } else {
                        fulfill(promise, value);
                      }
                    },
                    function(reason) {
                      if (sealed) {
                        return;
                      }
                      sealed = true;

                      _reject(promise, reason);
                    },
                    'Settle: ' + (promise._label || ' unknown promise')
                  );

                  if (!sealed && error) {
                    sealed = true;
                    _reject(promise, error);
                  }
                }, promise);
              }

              function handleOwnThenable(promise, thenable) {
                if (thenable._state === FULFILLED) {
                  fulfill(promise, thenable._result);
                } else if (thenable._state === REJECTED) {
                  _reject(promise, thenable._result);
                } else {
                  subscribe(
                    thenable,
                    undefined,
                    function(value) {
                      return _resolve(promise, value);
                    },
                    function(reason) {
                      return _reject(promise, reason);
                    }
                  );
                }
              }

              function handleMaybeThenable(promise, maybeThenable, then$$) {
                if (
                  maybeThenable.constructor === promise.constructor &&
                  then$$ === then &&
                  maybeThenable.constructor.resolve === resolve
                ) {
                  handleOwnThenable(promise, maybeThenable);
                } else {
                  if (then$$ === GET_THEN_ERROR) {
                    _reject(promise, GET_THEN_ERROR.error);
                  } else if (then$$ === undefined) {
                    fulfill(promise, maybeThenable);
                  } else if (isFunction(then$$)) {
                    handleForeignThenable(promise, maybeThenable, then$$);
                  } else {
                    fulfill(promise, maybeThenable);
                  }
                }
              }

              function _resolve(promise, value) {
                if (promise === value) {
                  _reject(promise, selfFulfillment());
                } else if (objectOrFunction(value)) {
                  handleMaybeThenable(promise, value, getThen(value));
                } else {
                  fulfill(promise, value);
                }
              }

              function publishRejection(promise) {
                if (promise._onerror) {
                  promise._onerror(promise._result);
                }

                publish(promise);
              }

              function fulfill(promise, value) {
                if (promise._state !== PENDING) {
                  return;
                }

                promise._result = value;
                promise._state = FULFILLED;

                if (promise._subscribers.length !== 0) {
                  asap(publish, promise);
                }
              }

              function _reject(promise, reason) {
                if (promise._state !== PENDING) {
                  return;
                }
                promise._state = REJECTED;
                promise._result = reason;

                asap(publishRejection, promise);
              }

              function subscribe(parent, child, onFulfillment, onRejection) {
                var _subscribers = parent._subscribers;
                var length = _subscribers.length;

                parent._onerror = null;

                _subscribers[length] = child;
                _subscribers[length + FULFILLED] = onFulfillment;
                _subscribers[length + REJECTED] = onRejection;

                if (length === 0 && parent._state) {
                  asap(publish, parent);
                }
              }

              function publish(promise) {
                var subscribers = promise._subscribers;
                var settled = promise._state;

                if (subscribers.length === 0) {
                  return;
                }

                var child = undefined,
                  callback = undefined,
                  detail = promise._result;

                for (var i = 0; i < subscribers.length; i += 3) {
                  child = subscribers[i];
                  callback = subscribers[i + settled];

                  if (child) {
                    invokeCallback(settled, child, callback, detail);
                  } else {
                    callback(detail);
                  }
                }

                promise._subscribers.length = 0;
              }

              function ErrorObject() {
                this.error = null;
              }

              var TRY_CATCH_ERROR = new ErrorObject();

              function tryCatch(callback, detail) {
                try {
                  return callback(detail);
                } catch (e) {
                  TRY_CATCH_ERROR.error = e;
                  return TRY_CATCH_ERROR;
                }
              }

              function invokeCallback(settled, promise, callback, detail) {
                var hasCallback = isFunction(callback),
                  value = undefined,
                  error = undefined,
                  succeeded = undefined,
                  failed = undefined;

                if (hasCallback) {
                  value = tryCatch(callback, detail);

                  if (value === TRY_CATCH_ERROR) {
                    failed = true;
                    error = value.error;
                    value = null;
                  } else {
                    succeeded = true;
                  }

                  if (promise === value) {
                    _reject(promise, cannotReturnOwn());
                    return;
                  }
                } else {
                  value = detail;
                  succeeded = true;
                }

                if (promise._state !== PENDING) {
                  // noop
                } else if (hasCallback && succeeded) {
                  _resolve(promise, value);
                } else if (failed) {
                  _reject(promise, error);
                } else if (settled === FULFILLED) {
                  fulfill(promise, value);
                } else if (settled === REJECTED) {
                  _reject(promise, value);
                }
              }

              function initializePromise(promise, resolver) {
                try {
                  resolver(
                    function resolvePromise(value) {
                      _resolve(promise, value);
                    },
                    function rejectPromise(reason) {
                      _reject(promise, reason);
                    }
                  );
                } catch (e) {
                  _reject(promise, e);
                }
              }

              var id = 0;
              function nextId() {
                return id++;
              }

              function makePromise(promise) {
                promise[PROMISE_ID] = id++;
                promise._state = undefined;
                promise._result = undefined;
                promise._subscribers = [];
              }

              function Enumerator(Constructor, input) {
                this._instanceConstructor = Constructor;
                this.promise = new Constructor(noop);

                if (!this.promise[PROMISE_ID]) {
                  makePromise(this.promise);
                }

                if (isArray(input)) {
                  this._input = input;
                  this.length = input.length;
                  this._remaining = input.length;

                  this._result = new Array(this.length);

                  if (this.length === 0) {
                    fulfill(this.promise, this._result);
                  } else {
                    this.length = this.length || 0;
                    this._enumerate();
                    if (this._remaining === 0) {
                      fulfill(this.promise, this._result);
                    }
                  }
                } else {
                  _reject(this.promise, validationError());
                }
              }

              function validationError() {
                return new Error('Array Methods must be provided an Array');
              }

              Enumerator.prototype._enumerate = function() {
                var length = this.length;
                var _input = this._input;

                for (var i = 0; this._state === PENDING && i < length; i++) {
                  this._eachEntry(_input[i], i);
                }
              };

              Enumerator.prototype._eachEntry = function(entry, i) {
                var c = this._instanceConstructor;
                var resolve$$ = c.resolve;

                if (resolve$$ === resolve) {
                  var _then = getThen(entry);

                  if (_then === then && entry._state !== PENDING) {
                    this._settledAt(entry._state, i, entry._result);
                  } else if (typeof _then !== 'function') {
                    this._remaining--;
                    this._result[i] = entry;
                  } else if (c === Promise) {
                    var promise = new c(noop);
                    handleMaybeThenable(promise, entry, _then);
                    this._willSettleAt(promise, i);
                  } else {
                    this._willSettleAt(
                      new c(function(resolve$$) {
                        return resolve$$(entry);
                      }),
                      i
                    );
                  }
                } else {
                  this._willSettleAt(resolve$$(entry), i);
                }
              };

              Enumerator.prototype._settledAt = function(state, i, value) {
                var promise = this.promise;

                if (promise._state === PENDING) {
                  this._remaining--;

                  if (state === REJECTED) {
                    _reject(promise, value);
                  } else {
                    this._result[i] = value;
                  }
                }

                if (this._remaining === 0) {
                  fulfill(promise, this._result);
                }
              };

              Enumerator.prototype._willSettleAt = function(promise, i) {
                var enumerator = this;

                subscribe(
                  promise,
                  undefined,
                  function(value) {
                    return enumerator._settledAt(FULFILLED, i, value);
                  },
                  function(reason) {
                    return enumerator._settledAt(REJECTED, i, reason);
                  }
                );
              };

              /**
  `Promise.all` accepts an array of promises, and returns a new promise which
  is fulfilled with an array of fulfillment values for the passed promises, or
  rejected with the reason of the first passed promise to be rejected. It casts all
  elements of the passed iterable to promises as it runs this algorithm.

  Example:

  ```javascript
  let promise1 = resolve(1);
  let promise2 = resolve(2);
  let promise3 = resolve(3);
  let promises = [ promise1, promise2, promise3 ];

  Promise.all(promises).then(function(array){
    // The array here would be [ 1, 2, 3 ];
  });
  ```

  If any of the `promises` given to `all` are rejected, the first promise
  that is rejected will be given as an argument to the returned promises's
  rejection handler. For example:

  Example:

  ```javascript
  let promise1 = resolve(1);
  let promise2 = reject(new Error("2"));
  let promise3 = reject(new Error("3"));
  let promises = [ promise1, promise2, promise3 ];

  Promise.all(promises).then(function(array){
    // Code here never runs because there are rejected promises!
  }, function(error) {
    // error.message === "2"
  });
  ```

  @method all
  @static
  @param {Array} entries array of promises
  @param {String} label optional string for labeling the promise.
  Useful for tooling.
  @return {Promise} promise that is fulfilled when all `promises` have been
  fulfilled, or rejected if any of them become rejected.
  @static
*/
              function all(entries) {
                return new Enumerator(this, entries).promise;
              }

              /**
  `Promise.race` returns a new promise which is settled in the same way as the
  first passed promise to settle.

  Example:

  ```javascript
  let promise1 = new Promise(function(resolve, reject){
    setTimeout(function(){
      resolve('promise 1');
    }, 200);
  });

  let promise2 = new Promise(function(resolve, reject){
    setTimeout(function(){
      resolve('promise 2');
    }, 100);
  });

  Promise.race([promise1, promise2]).then(function(result){
    // result === 'promise 2' because it was resolved before promise1
    // was resolved.
  });
  ```

  `Promise.race` is deterministic in that only the state of the first
  settled promise matters. For example, even if other promises given to the
  `promises` array argument are resolved, but the first settled promise has
  become rejected before the other promises became fulfilled, the returned
  promise will become rejected:

  ```javascript
  let promise1 = new Promise(function(resolve, reject){
    setTimeout(function(){
      resolve('promise 1');
    }, 200);
  });

  let promise2 = new Promise(function(resolve, reject){
    setTimeout(function(){
      reject(new Error('promise 2'));
    }, 100);
  });

  Promise.race([promise1, promise2]).then(function(result){
    // Code here never runs
  }, function(reason){
    // reason.message === 'promise 2' because promise 2 became rejected before
    // promise 1 became fulfilled
  });
  ```

  An example real-world use case is implementing timeouts:

  ```javascript
  Promise.race([ajax('foo.json'), timeout(5000)])
  ```

  @method race
  @static
  @param {Array} promises array of promises to observe
  Useful for tooling.
  @return {Promise} a promise which settles in the same way as the first passed
  promise to settle.
*/
              function race(entries) {
                /*jshint validthis:true */
                var Constructor = this;

                if (!isArray(entries)) {
                  return new Constructor(function(_, reject) {
                    return reject(
                      new TypeError('You must pass an array to race.')
                    );
                  });
                } else {
                  return new Constructor(function(resolve, reject) {
                    var length = entries.length;
                    for (var i = 0; i < length; i++) {
                      Constructor.resolve(entries[i]).then(resolve, reject);
                    }
                  });
                }
              }

              /**
  `Promise.reject` returns a promise rejected with the passed `reason`.
  It is shorthand for the following:

  ```javascript
  let promise = new Promise(function(resolve, reject){
    reject(new Error('WHOOPS'));
  });

  promise.then(function(value){
    // Code here doesn't run because the promise is rejected!
  }, function(reason){
    // reason.message === 'WHOOPS'
  });
  ```

  Instead of writing the above, your code now simply becomes the following:

  ```javascript
  let promise = Promise.reject(new Error('WHOOPS'));

  promise.then(function(value){
    // Code here doesn't run because the promise is rejected!
  }, function(reason){
    // reason.message === 'WHOOPS'
  });
  ```

  @method reject
  @static
  @param {Any} reason value that the returned promise will be rejected with.
  Useful for tooling.
  @return {Promise} a promise rejected with the given `reason`.
*/
              function reject(reason) {
                /*jshint validthis:true */
                var Constructor = this;
                var promise = new Constructor(noop);
                _reject(promise, reason);
                return promise;
              }

              function needsResolver() {
                throw new TypeError(
                  'You must pass a resolver function as the first argument to the promise constructor'
                );
              }

              function needsNew() {
                throw new TypeError(
                  "Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function."
                );
              }

              /**
  Promise objects represent the eventual result of an asynchronous operation. The
  primary way of interacting with a promise is through its `then` method, which
  registers callbacks to receive either a promise's eventual value or the reason
  why the promise cannot be fulfilled.

  Terminology
  -----------

  - `promise` is an object or function with a `then` method whose behavior conforms to this specification.
  - `thenable` is an object or function that defines a `then` method.
  - `value` is any legal JavaScript value (including undefined, a thenable, or a promise).
  - `exception` is a value that is thrown using the throw statement.
  - `reason` is a value that indicates why a promise was rejected.
  - `settled` the final resting state of a promise, fulfilled or rejected.

  A promise can be in one of three states: pending, fulfilled, or rejected.

  Promises that are fulfilled have a fulfillment value and are in the fulfilled
  state.  Promises that are rejected have a rejection reason and are in the
  rejected state.  A fulfillment value is never a thenable.

  Promises can also be said to *resolve* a value.  If this value is also a
  promise, then the original promise's settled state will match the value's
  settled state.  So a promise that *resolves* a promise that rejects will
  itself reject, and a promise that *resolves* a promise that fulfills will
  itself fulfill.


  Basic Usage:
  ------------

  ```js
  let promise = new Promise(function(resolve, reject) {
    // on success
    resolve(value);

    // on failure
    reject(reason);
  });

  promise.then(function(value) {
    // on fulfillment
  }, function(reason) {
    // on rejection
  });
  ```

  Advanced Usage:
  ---------------

  Promises shine when abstracting away asynchronous interactions such as
  `XMLHttpRequest`s.

  ```js
  function getJSON(url) {
    return new Promise(function(resolve, reject){
      let xhr = new XMLHttpRequest();

      xhr.open('GET', url);
      xhr.onreadystatechange = handler;
      xhr.responseType = 'json';
      xhr.setRequestHeader('Accept', 'application/json');
      xhr.send();

      function handler() {
        if (this.readyState === this.DONE) {
          if (this.status === 200) {
            resolve(this.response);
          } else {
            reject(new Error('getJSON: `' + url + '` failed with status: [' + this.status + ']'));
          }
        }
      };
    });
  }

  getJSON('/posts.json').then(function(json) {
    // on fulfillment
  }, function(reason) {
    // on rejection
  });
  ```

  Unlike callbacks, promises are great composable primitives.

  ```js
  Promise.all([
    getJSON('/posts'),
    getJSON('/comments')
  ]).then(function(values){
    values[0] // => postsJSON
    values[1] // => commentsJSON

    return values;
  });
  ```

  @class Promise
  @param {function} resolver
  Useful for tooling.
  @constructor
*/
              function Promise(resolver) {
                this[PROMISE_ID] = nextId();
                this._result = this._state = undefined;
                this._subscribers = [];

                if (noop !== resolver) {
                  typeof resolver !== 'function' && needsResolver();
                  this instanceof Promise
                    ? initializePromise(this, resolver)
                    : needsNew();
                }
              }

              Promise.all = all;
              Promise.race = race;
              Promise.resolve = resolve;
              Promise.reject = reject;
              Promise._setScheduler = setScheduler;
              Promise._setAsap = setAsap;
              Promise._asap = asap;

              Promise.prototype = {
                constructor: Promise,

                /**
    The primary way of interacting with a promise is through its `then` method,
    which registers callbacks to receive either a promise's eventual value or the
    reason why the promise cannot be fulfilled.
  
    ```js
    findUser().then(function(user){
      // user is available
    }, function(reason){
      // user is unavailable, and you are given the reason why
    });
    ```
  
    Chaining
    --------
  
    The return value of `then` is itself a promise.  This second, 'downstream'
    promise is resolved with the return value of the first promise's fulfillment
    or rejection handler, or rejected if the handler throws an exception.
  
    ```js
    findUser().then(function (user) {
      return user.name;
    }, function (reason) {
      return 'default name';
    }).then(function (userName) {
      // If `findUser` fulfilled, `userName` will be the user's name, otherwise it
      // will be `'default name'`
    });
  
    findUser().then(function (user) {
      throw new Error('Found user, but still unhappy');
    }, function (reason) {
      throw new Error('`findUser` rejected and we're unhappy');
    }).then(function (value) {
      // never reached
    }, function (reason) {
      // if `findUser` fulfilled, `reason` will be 'Found user, but still unhappy'.
      // If `findUser` rejected, `reason` will be '`findUser` rejected and we're unhappy'.
    });
    ```
    If the downstream promise does not specify a rejection handler, rejection reasons will be propagated further downstream.
  
    ```js
    findUser().then(function (user) {
      throw new PedagogicalException('Upstream error');
    }).then(function (value) {
      // never reached
    }).then(function (value) {
      // never reached
    }, function (reason) {
      // The `PedgagocialException` is propagated all the way down to here
    });
    ```
  
    Assimilation
    ------------
  
    Sometimes the value you want to propagate to a downstream promise can only be
    retrieved asynchronously. This can be achieved by returning a promise in the
    fulfillment or rejection handler. The downstream promise will then be pending
    until the returned promise is settled. This is called *assimilation*.
  
    ```js
    findUser().then(function (user) {
      return findCommentsByAuthor(user);
    }).then(function (comments) {
      // The user's comments are now available
    });
    ```
  
    If the assimliated promise rejects, then the downstream promise will also reject.
  
    ```js
    findUser().then(function (user) {
      return findCommentsByAuthor(user);
    }).then(function (comments) {
      // If `findCommentsByAuthor` fulfills, we'll have the value here
    }, function (reason) {
      // If `findCommentsByAuthor` rejects, we'll have the reason here
    });
    ```
  
    Simple Example
    --------------
  
    Synchronous Example
  
    ```javascript
    let result;
  
    try {
      result = findResult();
      // success
    } catch(reason) {
      // failure
    }
    ```
  
    Errback Example
  
    ```js
    findResult(function(result, err){
      if (err) {
        // failure
      } else {
        // success
      }
    });
    ```
  
    Promise Example;
  
    ```javascript
    findResult().then(function(result){
      // success
    }, function(reason){
      // failure
    });
    ```
  
    Advanced Example
    --------------
  
    Synchronous Example
  
    ```javascript
    let author, books;
  
    try {
      author = findAuthor();
      books  = findBooksByAuthor(author);
      // success
    } catch(reason) {
      // failure
    }
    ```
  
    Errback Example
  
    ```js
  
    function foundBooks(books) {
  
    }
  
    function failure(reason) {
  
    }
  
    findAuthor(function(author, err){
      if (err) {
        failure(err);
        // failure
      } else {
        try {
          findBoooksByAuthor(author, function(books, err) {
            if (err) {
              failure(err);
            } else {
              try {
                foundBooks(books);
              } catch(reason) {
                failure(reason);
              }
            }
          });
        } catch(error) {
          failure(err);
        }
        // success
      }
    });
    ```
  
    Promise Example;
  
    ```javascript
    findAuthor().
      then(findBooksByAuthor).
      then(function(books){
        // found books
    }).catch(function(reason){
      // something went wrong
    });
    ```
  
    @method then
    @param {Function} onFulfilled
    @param {Function} onRejected
    Useful for tooling.
    @return {Promise}
  */
                then: then,

                /**
    `catch` is simply sugar for `then(undefined, onRejection)` which makes it the same
    as the catch block of a try/catch statement.
  
    ```js
    function findAuthor(){
      throw new Error('couldn't find that author');
    }
  
    // synchronous
    try {
      findAuthor();
    } catch(reason) {
      // something went wrong
    }
  
    // async with promises
    findAuthor().catch(function(reason){
      // something went wrong
    });
    ```
  
    @method catch
    @param {Function} onRejection
    Useful for tooling.
    @return {Promise}
  */
                catch: function _catch(onRejection) {
                  return this.then(null, onRejection);
                },
              };

              function polyfill() {
                var local = undefined;

                if (typeof global !== 'undefined') {
                  local = global;
                } else if (typeof self !== 'undefined') {
                  local = self;
                } else {
                  try {
                    local = Function('return this')();
                  } catch (e) {
                    throw new Error(
                      'polyfill failed because global object is unavailable in this environment'
                    );
                  }
                }

                var P = local.Promise;

                if (P) {
                  var promiseToString = null;
                  try {
                    promiseToString = Object.prototype.toString.call(
                      P.resolve()
                    );
                  } catch (e) {
                    // silently ignored
                  }

                  if (promiseToString === '[object Promise]' && !P.cast) {
                    return;
                  }
                }

                local.Promise = Promise;
              }

              polyfill();
              // Strange compat..
              Promise.polyfill = polyfill;
              Promise.Promise = Promise;

              return Promise;
            });
          }.call(
            this,
            require('_process'),
            typeof global !== 'undefined'
              ? global
              : typeof self !== 'undefined'
              ? self
              : typeof window !== 'undefined'
              ? window
              : {}
          ));
        },
        { _process: 187 },
      ],
      112: [
        function(require, module, exports) {
          // Copyright Joyent, Inc. and other Node contributors.
          //
          // Permission is hereby granted, free of charge, to any person obtaining a
          // copy of this software and associated documentation files (the
          // "Software"), to deal in the Software without restriction, including
          // without limitation the rights to use, copy, modify, merge, publish,
          // distribute, sublicense, and/or sell copies of the Software, and to permit
          // persons to whom the Software is furnished to do so, subject to the
          // following conditions:
          //
          // The above copyright notice and this permission notice shall be included
          // in all copies or substantial portions of the Software.
          //
          // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
          // OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
          // MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
          // NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
          // DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
          // OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
          // USE OR OTHER DEALINGS IN THE SOFTWARE.

          var objectCreate = Object.create || objectCreatePolyfill;
          var objectKeys = Object.keys || objectKeysPolyfill;
          var bind = Function.prototype.bind || functionBindPolyfill;

          function EventEmitter() {
            if (
              !this._events ||
              !Object.prototype.hasOwnProperty.call(this, '_events')
            ) {
              this._events = objectCreate(null);
              this._eventsCount = 0;
            }

            this._maxListeners = this._maxListeners || undefined;
          }
          module.exports = EventEmitter;

          // Backwards-compat with node 0.10.x
          EventEmitter.EventEmitter = EventEmitter;

          EventEmitter.prototype._events = undefined;
          EventEmitter.prototype._maxListeners = undefined;

          // By default EventEmitters will print a warning if more than 10 listeners are
          // added to it. This is a useful default which helps finding memory leaks.
          var defaultMaxListeners = 10;

          var hasDefineProperty;
          try {
            var o = {};
            if (Object.defineProperty)
              Object.defineProperty(o, 'x', { value: 0 });
            hasDefineProperty = o.x === 0;
          } catch (err) {
            hasDefineProperty = false;
          }
          if (hasDefineProperty) {
            Object.defineProperty(EventEmitter, 'defaultMaxListeners', {
              enumerable: true,
              get: function() {
                return defaultMaxListeners;
              },
              set: function(arg) {
                // check whether the input is a positive number (whose value is zero or
                // greater and not a NaN).
                if (typeof arg !== 'number' || arg < 0 || arg !== arg)
                  throw new TypeError(
                    '"defaultMaxListeners" must be a positive number'
                  );
                defaultMaxListeners = arg;
              },
            });
          } else {
            EventEmitter.defaultMaxListeners = defaultMaxListeners;
          }

          // Obviously not all Emitters should be limited to 10. This function allows
          // that to be increased. Set to zero for unlimited.
          EventEmitter.prototype.setMaxListeners = function setMaxListeners(n) {
            if (typeof n !== 'number' || n < 0 || isNaN(n))
              throw new TypeError('"n" argument must be a positive number');
            this._maxListeners = n;
            return this;
          };

          function $getMaxListeners(that) {
            if (that._maxListeners === undefined)
              return EventEmitter.defaultMaxListeners;
            return that._maxListeners;
          }

          EventEmitter.prototype.getMaxListeners = function getMaxListeners() {
            return $getMaxListeners(this);
          };

          // These standalone emit* functions are used to optimize calling of event
          // handlers for fast cases because emit() itself often has a variable number of
          // arguments and can be deoptimized because of that. These functions always have
          // the same number of arguments and thus do not get deoptimized, so the code
          // inside them can execute faster.
          function emitNone(handler, isFn, self) {
            if (isFn) handler.call(self);
            else {
              var len = handler.length;
              var listeners = arrayClone(handler, len);
              for (var i = 0; i < len; ++i) listeners[i].call(self);
            }
          }
          function emitOne(handler, isFn, self, arg1) {
            if (isFn) handler.call(self, arg1);
            else {
              var len = handler.length;
              var listeners = arrayClone(handler, len);
              for (var i = 0; i < len; ++i) listeners[i].call(self, arg1);
            }
          }
          function emitTwo(handler, isFn, self, arg1, arg2) {
            if (isFn) handler.call(self, arg1, arg2);
            else {
              var len = handler.length;
              var listeners = arrayClone(handler, len);
              for (var i = 0; i < len; ++i) listeners[i].call(self, arg1, arg2);
            }
          }
          function emitThree(handler, isFn, self, arg1, arg2, arg3) {
            if (isFn) handler.call(self, arg1, arg2, arg3);
            else {
              var len = handler.length;
              var listeners = arrayClone(handler, len);
              for (var i = 0; i < len; ++i)
                listeners[i].call(self, arg1, arg2, arg3);
            }
          }

          function emitMany(handler, isFn, self, args) {
            if (isFn) handler.apply(self, args);
            else {
              var len = handler.length;
              var listeners = arrayClone(handler, len);
              for (var i = 0; i < len; ++i) listeners[i].apply(self, args);
            }
          }

          EventEmitter.prototype.emit = function emit(type) {
            var er, handler, len, args, i, events;
            var doError = type === 'error';

            events = this._events;
            if (events) doError = doError && events.error == null;
            else if (!doError) return false;

            // If there is no 'error' event listener then throw.
            if (doError) {
              if (arguments.length > 1) er = arguments[1];
              if (er instanceof Error) {
                throw er; // Unhandled 'error' event
              } else {
                // At least give some kind of context to the user
                var err = new Error('Unhandled "error" event. (' + er + ')');
                err.context = er;
                throw err;
              }
              return false;
            }

            handler = events[type];

            if (!handler) return false;

            var isFn = typeof handler === 'function';
            len = arguments.length;
            switch (len) {
              // fast cases
              case 1:
                emitNone(handler, isFn, this);
                break;
              case 2:
                emitOne(handler, isFn, this, arguments[1]);
                break;
              case 3:
                emitTwo(handler, isFn, this, arguments[1], arguments[2]);
                break;
              case 4:
                emitThree(
                  handler,
                  isFn,
                  this,
                  arguments[1],
                  arguments[2],
                  arguments[3]
                );
                break;
              // slower
              default:
                args = new Array(len - 1);
                for (i = 1; i < len; i++) args[i - 1] = arguments[i];
                emitMany(handler, isFn, this, args);
            }

            return true;
          };

          function _addListener(target, type, listener, prepend) {
            var m;
            var events;
            var existing;

            if (typeof listener !== 'function')
              throw new TypeError('"listener" argument must be a function');

            events = target._events;
            if (!events) {
              events = target._events = objectCreate(null);
              target._eventsCount = 0;
            } else {
              // To avoid recursion in the case that type === "newListener"! Before
              // adding it to the listeners, first emit "newListener".
              if (events.newListener) {
                target.emit(
                  'newListener',
                  type,
                  listener.listener ? listener.listener : listener
                );

                // Re-assign `events` because a newListener handler could have caused the
                // this._events to be assigned to a new object
                events = target._events;
              }
              existing = events[type];
            }

            if (!existing) {
              // Optimize the case of one listener. Don't need the extra array object.
              existing = events[type] = listener;
              ++target._eventsCount;
            } else {
              if (typeof existing === 'function') {
                // Adding the second element, need to change to array.
                existing = events[type] = prepend
                  ? [listener, existing]
                  : [existing, listener];
              } else {
                // If we've already got an array, just append.
                if (prepend) {
                  existing.unshift(listener);
                } else {
                  existing.push(listener);
                }
              }

              // Check for listener leak
              if (!existing.warned) {
                m = $getMaxListeners(target);
                if (m && m > 0 && existing.length > m) {
                  existing.warned = true;
                  var w = new Error(
                    'Possible EventEmitter memory leak detected. ' +
                      existing.length +
                      ' "' +
                      String(type) +
                      '" listeners ' +
                      'added. Use emitter.setMaxListeners() to ' +
                      'increase limit.'
                  );
                  w.name = 'MaxListenersExceededWarning';
                  w.emitter = target;
                  w.type = type;
                  w.count = existing.length;
                  if (typeof console === 'object' && console.warn) {
                    console.warn('%s: %s', w.name, w.message);
                  }
                }
              }
            }

            return target;
          }

          EventEmitter.prototype.addListener = function addListener(
            type,
            listener
          ) {
            return _addListener(this, type, listener, false);
          };

          EventEmitter.prototype.on = EventEmitter.prototype.addListener;

          EventEmitter.prototype.prependListener = function prependListener(
            type,
            listener
          ) {
            return _addListener(this, type, listener, true);
          };

          function onceWrapper() {
            if (!this.fired) {
              this.target.removeListener(this.type, this.wrapFn);
              this.fired = true;
              switch (arguments.length) {
                case 0:
                  return this.listener.call(this.target);
                case 1:
                  return this.listener.call(this.target, arguments[0]);
                case 2:
                  return this.listener.call(
                    this.target,
                    arguments[0],
                    arguments[1]
                  );
                case 3:
                  return this.listener.call(
                    this.target,
                    arguments[0],
                    arguments[1],
                    arguments[2]
                  );
                default:
                  var args = new Array(arguments.length);
                  for (var i = 0; i < args.length; ++i) args[i] = arguments[i];
                  this.listener.apply(this.target, args);
              }
            }
          }

          function _onceWrap(target, type, listener) {
            var state = {
              fired: false,
              wrapFn: undefined,
              target: target,
              type: type,
              listener: listener,
            };
            var wrapped = bind.call(onceWrapper, state);
            wrapped.listener = listener;
            state.wrapFn = wrapped;
            return wrapped;
          }

          EventEmitter.prototype.once = function once(type, listener) {
            if (typeof listener !== 'function')
              throw new TypeError('"listener" argument must be a function');
            this.on(type, _onceWrap(this, type, listener));
            return this;
          };

          EventEmitter.prototype.prependOnceListener = function prependOnceListener(
            type,
            listener
          ) {
            if (typeof listener !== 'function')
              throw new TypeError('"listener" argument must be a function');
            this.prependListener(type, _onceWrap(this, type, listener));
            return this;
          };

          // Emits a 'removeListener' event if and only if the listener was removed.
          EventEmitter.prototype.removeListener = function removeListener(
            type,
            listener
          ) {
            var list, events, position, i, originalListener;

            if (typeof listener !== 'function')
              throw new TypeError('"listener" argument must be a function');

            events = this._events;
            if (!events) return this;

            list = events[type];
            if (!list) return this;

            if (list === listener || list.listener === listener) {
              if (--this._eventsCount === 0) this._events = objectCreate(null);
              else {
                delete events[type];
                if (events.removeListener)
                  this.emit('removeListener', type, list.listener || listener);
              }
            } else if (typeof list !== 'function') {
              position = -1;

              for (i = list.length - 1; i >= 0; i--) {
                if (list[i] === listener || list[i].listener === listener) {
                  originalListener = list[i].listener;
                  position = i;
                  break;
                }
              }

              if (position < 0) return this;

              if (position === 0) list.shift();
              else spliceOne(list, position);

              if (list.length === 1) events[type] = list[0];

              if (events.removeListener)
                this.emit('removeListener', type, originalListener || listener);
            }

            return this;
          };

          EventEmitter.prototype.removeAllListeners = function removeAllListeners(
            type
          ) {
            var listeners, events, i;

            events = this._events;
            if (!events) return this;

            // not listening for removeListener, no need to emit
            if (!events.removeListener) {
              if (arguments.length === 0) {
                this._events = objectCreate(null);
                this._eventsCount = 0;
              } else if (events[type]) {
                if (--this._eventsCount === 0)
                  this._events = objectCreate(null);
                else delete events[type];
              }
              return this;
            }

            // emit removeListener for all listeners on all events
            if (arguments.length === 0) {
              var keys = objectKeys(events);
              var key;
              for (i = 0; i < keys.length; ++i) {
                key = keys[i];
                if (key === 'removeListener') continue;
                this.removeAllListeners(key);
              }
              this.removeAllListeners('removeListener');
              this._events = objectCreate(null);
              this._eventsCount = 0;
              return this;
            }

            listeners = events[type];

            if (typeof listeners === 'function') {
              this.removeListener(type, listeners);
            } else if (listeners) {
              // LIFO order
              for (i = listeners.length - 1; i >= 0; i--) {
                this.removeListener(type, listeners[i]);
              }
            }

            return this;
          };

          function _listeners(target, type, unwrap) {
            var events = target._events;

            if (!events) return [];

            var evlistener = events[type];
            if (!evlistener) return [];

            if (typeof evlistener === 'function')
              return unwrap
                ? [evlistener.listener || evlistener]
                : [evlistener];

            return unwrap
              ? unwrapListeners(evlistener)
              : arrayClone(evlistener, evlistener.length);
          }

          EventEmitter.prototype.listeners = function listeners(type) {
            return _listeners(this, type, true);
          };

          EventEmitter.prototype.rawListeners = function rawListeners(type) {
            return _listeners(this, type, false);
          };

          EventEmitter.listenerCount = function(emitter, type) {
            if (typeof emitter.listenerCount === 'function') {
              return emitter.listenerCount(type);
            } else {
              return listenerCount.call(emitter, type);
            }
          };

          EventEmitter.prototype.listenerCount = listenerCount;
          function listenerCount(type) {
            var events = this._events;

            if (events) {
              var evlistener = events[type];

              if (typeof evlistener === 'function') {
                return 1;
              } else if (evlistener) {
                return evlistener.length;
              }
            }

            return 0;
          }

          EventEmitter.prototype.eventNames = function eventNames() {
            return this._eventsCount > 0 ? Reflect.ownKeys(this._events) : [];
          };

          // About 1.5x faster than the two-arg version of Array#splice().
          function spliceOne(list, index) {
            for (
              var i = index, k = i + 1, n = list.length;
              k < n;
              i += 1, k += 1
            )
              list[i] = list[k];
            list.pop();
          }

          function arrayClone(arr, n) {
            var copy = new Array(n);
            for (var i = 0; i < n; ++i) copy[i] = arr[i];
            return copy;
          }

          function unwrapListeners(arr) {
            var ret = new Array(arr.length);
            for (var i = 0; i < ret.length; ++i) {
              ret[i] = arr[i].listener || arr[i];
            }
            return ret;
          }

          function objectCreatePolyfill(proto) {
            var F = function() {};
            F.prototype = proto;
            return new F();
          }
          function objectKeysPolyfill(obj) {
            var keys = [];
            for (var k in obj)
              if (Object.prototype.hasOwnProperty.call(obj, k)) {
                keys.push(k);
              }
            return k;
          }
          function functionBindPolyfill(context) {
            var fn = this;
            return function() {
              return fn.apply(context, arguments);
            };
          }
        },
        {},
      ],
      113: [
        function(require, module, exports) {
          (function() {
            'use strict';
            /*global extender is, dateExtended*/

            function defineExtended(extender) {
              var merge = (function merger() {
                function _merge(target, source) {
                  var name, s;
                  for (name in source) {
                    if (source.hasOwnProperty(name)) {
                      s = source[name];
                      if (!(name in target) || target[name] !== s) {
                        target[name] = s;
                      }
                    }
                  }
                  return target;
                }

                return function merge(obj) {
                  if (!obj) {
                    obj = {};
                  }
                  for (var i = 1, l = arguments.length; i < l; i++) {
                    _merge(obj, arguments[i]);
                  }
                  return obj; // Object
                };
              })();

              function getExtended() {
                var loaded = {};

                //getInitial instance;
                var extended = extender.define();
                extended.expose({
                  register: function register(alias, extendWith) {
                    if (!extendWith) {
                      extendWith = alias;
                      alias = null;
                    }
                    var type = typeof extendWith;
                    if (alias) {
                      extended[alias] = extendWith;
                    } else if (extendWith && type === 'function') {
                      extended.extend(extendWith);
                    } else if (type === 'object') {
                      extended.expose(extendWith);
                    } else {
                      throw new TypeError(
                        'extended.register must be called with an extender function'
                      );
                    }
                    return extended;
                  },

                  define: function() {
                    return extender.define.apply(extender, arguments);
                  },
                });

                return extended;
              }

              function extended() {
                return getExtended();
              }

              extended.define = function define() {
                return extender.define.apply(extender, arguments);
              };

              return extended;
            }

            if ('undefined' !== typeof exports) {
              if ('undefined' !== typeof module && module.exports) {
                module.exports = defineExtended(require('extender'));
              }
            } else if ('function' === typeof define && define.amd) {
              define(['extender'], function(extender) {
                return defineExtended(extender);
              });
            } else {
              this.extended = defineExtended(this.extender);
            }
          }.call(this));
        },
        { extender: 115 },
      ],
      114: [
        function(require, module, exports) {
          (function() {
            /*jshint strict:false*/

            /**
             *
             * @projectName extender
             * @github http://github.com/doug-martin/extender
             * @header
             * [![build status](https://secure.travis-ci.org/doug-martin/extender.png)](http://travis-ci.org/doug-martin/extender)
             * # Extender
             *
             * `extender` is a library that helps in making chainable APIs, by creating a function that accepts different values and returns an object decorated with functions based on the type.
             *
             * ## Why Is Extender Different?
             *
             * Extender is different than normal chaining because is does more than return `this`. It decorates your values in a type safe manner.
             *
             * For example if you return an array from a string based method then the returned value will be decorated with array methods and not the string methods. This allow you as the developer to focus on your API and not worrying about how to properly build and connect your API.
             *
             *
             * ## Installation
             *
             * ```
             * npm install extender
             * ```
             *
             * Or [download the source](https://raw.github.com/doug-martin/extender/master/extender.js) ([minified](https://raw.github.com/doug-martin/extender/master/extender-min.js))
             *
             * **Note** `extender` depends on [`declare.js`](http://doug-martin.github.com/declare.js/).
             *
             * ### Requirejs
             *
             * To use with requirejs place the `extend` source in the root scripts directory
             *
             * ```javascript
             *
             * define(["extender"], function(extender){
             * });
             *
             * ```
             *
             *
             * ## Usage
             *
             * **`extender.define(tester, decorations)`**
             *
             * To create your own extender call the `extender.define` function.
             *
             * This function accepts an optional tester which is used to determine a value should be decorated with the specified `decorations`
             *
             * ```javascript
             * function isString(obj) {
             *     return !isUndefinedOrNull(obj) && (typeof obj === "string" || obj instanceof String);
             * }
             *
             *
             * var myExtender = extender.define(isString, {
             *		multiply: function (str, times) {
             *			var ret = str;
             *			for (var i = 1; i < times; i++) {
             *				ret += str;
             *			}
             *			return ret;
             *		},
             *		toArray: function (str, delim) {
             *			delim = delim || "";
             *			return str.split(delim);
             *		}
             *	});
             *
             * myExtender("hello").multiply(2).value(); //hellohello
             *
             * ```
             *
             * If you do not specify a tester function and just pass in an object of `functions` then all values passed in will be decorated with methods.
             *
             * ```javascript
             *
             * function isUndefined(obj) {
             *     var undef;
             *     return obj === undef;
             * }
             *
             * function isUndefinedOrNull(obj) {
             *	var undef;
             *     return obj === undef || obj === null;
             * }
             *
             * function isArray(obj) {
             *     return Object.prototype.toString.call(obj) === "[object Array]";
             * }
             *
             * function isBoolean(obj) {
             *     var undef, type = typeof obj;
             *     return !isUndefinedOrNull(obj) && type === "boolean" || type === "Boolean";
             * }
             *
             * function isString(obj) {
             *     return !isUndefinedOrNull(obj) && (typeof obj === "string" || obj instanceof String);
             * }
             *
             * var myExtender = extender.define({
             *	isUndefined : isUndefined,
             *	isUndefinedOrNull : isUndefinedOrNull,
             *	isArray : isArray,
             *	isBoolean : isBoolean,
             *	isString : isString
             * });
             *
             * ```
             *
             * To use
             *
             * ```
             * var undef;
             * myExtender("hello").isUndefined().value(); //false
             * myExtender(undef).isUndefined().value(); //true
             * ```
             *
             * You can also chain extenders so that they accept multiple types and decorates accordingly.
             *
             * ```javascript
             * myExtender
             *     .define(isArray, {
             *		pluck: function (arr, m) {
             *			var ret = [];
             *			for (var i = 0, l = arr.length; i < l; i++) {
             *				ret.push(arr[i][m]);
             *			}
             *			return ret;
             *		}
             *	})
             *     .define(isBoolean, {
             *		invert: function (val) {
             *			return !val;
             *		}
             *	});
             *
             * myExtender([{a: "a"},{a: "b"},{a: "c"}]).pluck("a").value(); //["a", "b", "c"]
             * myExtender("I love javascript!").toArray(/\s+/).pluck("0"); //["I", "l", "j"]
             *
             * ```
             *
             * Notice that we reuse the same extender as defined above.
             *
             * **Return Values**
             *
             * When creating an extender if you return a value from one of the decoration functions then that value will also be decorated. If you do not return any values then the extender will be returned.
             *
             * **Default decoration methods**
             *
             * By default every value passed into an extender is decorated with the following methods.
             *
             * * `value` : The value this extender represents.
             * * `eq(otherValue)` : Tests strict equality of the currently represented value to the `otherValue`
             * * `neq(oterValue)` : Tests strict inequality of the currently represented value.
             * * `print` : logs the current value to the console.
             *
             * **Extender initialization**
             *
             * When creating an extender you can also specify a constructor which will be invoked with the current value.
             *
             * ```javascript
             * myExtender.define(isString, {
             *	constructor : function(val){
             *     //set our value to the string trimmed
             *		this._value = val.trimRight().trimLeft();
             *	}
             * });
             * ```
             *
             * **`noWrap`**
             *
             * `extender` also allows you to specify methods that should not have the value wrapped providing a cleaner exit function other than `value()`.
             *
             * For example suppose you have an API that allows you to build a validator, rather than forcing the user to invoke the `value` method you could add a method called `validator` which makes more syntactic sense.
             *
             * ```
             *
             * var myValidator = extender.define({
             *     //chainable validation methods
             *     //...
             *     //end chainable validation methods
             *
             *     noWrap : {
             *         validator : function(){
             *             //return your validator
             *         }
             *     }
             * });
             *
             * myValidator().isNotNull().isEmailAddress().validator(); //now you dont need to call .value()
             *
             *
             * ```
             * **`extender.extend(extendr)`**
             *
             * You may also compose extenders through the use of `extender.extend(extender)`, which will return an entirely new extender that is the composition of extenders.
             *
             * Suppose you have the following two extenders.
             *
             * ```javascript
             * var myExtender = extender
             *        .define({
             *            isFunction: is.function,
             *            isNumber: is.number,
             *            isString: is.string,
             *            isDate: is.date,
             *            isArray: is.array,
             *            isBoolean: is.boolean,
             *            isUndefined: is.undefined,
             *            isDefined: is.defined,
             *            isUndefinedOrNull: is.undefinedOrNull,
             *            isNull: is.null,
             *            isArguments: is.arguments,
             *            isInstanceOf: is.instanceOf,
             *            isRegExp: is.regExp
             *        });
             * var myExtender2 = extender.define(is.array, {
             *     pluck: function (arr, m) {
             *         var ret = [];
             *         for (var i = 0, l = arr.length; i < l; i++) {
             *             ret.push(arr[i][m]);
             *         }
             *         return ret;
             *     },
             *
             *     noWrap: {
             *         pluckPlain: function (arr, m) {
             *             var ret = [];
             *             for (var i = 0, l = arr.length; i < l; i++) {
             *                 ret.push(arr[i][m]);
             *             }
             *             return ret;
             *         }
             *     }
             * });
             *
             *
             * ```
             *
             * And you do not want to alter either of them but instead what to create a third that is the union of the two.
             *
             *
             * ```javascript
             * var composed = extender.extend(myExtender).extend(myExtender2);
             * ```
             * So now you can use the new extender with the joined functionality if `myExtender` and `myExtender2`.
             *
             * ```javascript
             * var extended = composed([
             *      {a: "a"},
             *      {a: "b"},
             *      {a: "c"}
             * ]);
             * extended.isArray().value(); //true
             * extended.pluck("a").value(); // ["a", "b", "c"]);
             *
             * ```
             *
             * **Note** `myExtender` and `myExtender2` will **NOT** be altered.
             *
             * **`extender.expose(methods)`**
             *
             * The `expose` method allows you to add methods to your extender that are not wrapped or automatically chained by exposing them on the extender directly.
             *
             * ```
             * var isMethods = {
             *      isFunction: is.function,
             *      isNumber: is.number,
             *      isString: is.string,
             *      isDate: is.date,
             *      isArray: is.array,
             *      isBoolean: is.boolean,
             *      isUndefined: is.undefined,
             *      isDefined: is.defined,
             *      isUndefinedOrNull: is.undefinedOrNull,
             *      isNull: is.null,
             *      isArguments: is.arguments,
             *      isInstanceOf: is.instanceOf,
             *      isRegExp: is.regExp
             * };
             *
             * var myExtender = extender.define(isMethods).expose(isMethods);
             *
             * myExtender.isArray([]); //true
             * myExtender([]).isArray([]).value(); //true
             *
             * ```
             *
             *
             * **Using `instanceof`**
             *
             * When using extenders you can test if a value is an `instanceof` of an extender by using the instanceof operator.
             *
             * ```javascript
             * var str = myExtender("hello");
             *
             * str instanceof myExtender; //true
             * ```
             *
             * ## Examples
             *
             * To see more examples click [here](https://github.com/doug-martin/extender/tree/master/examples)
             */
            function defineExtender(declare) {
              var slice = Array.prototype.slice,
                undef;

              function indexOf(arr, item) {
                if (arr && arr.length) {
                  for (var i = 0, l = arr.length; i < l; i++) {
                    if (arr[i] === item) {
                      return i;
                    }
                  }
                }
                return -1;
              }

              function isArray(obj) {
                return Object.prototype.toString.call(obj) === '[object Array]';
              }

              var merge = (function merger() {
                function _merge(target, source, exclude) {
                  var name, s;
                  for (name in source) {
                    if (
                      source.hasOwnProperty(name) &&
                      indexOf(exclude, name) === -1
                    ) {
                      s = source[name];
                      if (!(name in target) || target[name] !== s) {
                        target[name] = s;
                      }
                    }
                  }
                  return target;
                }

                return function merge(obj) {
                  if (!obj) {
                    obj = {};
                  }
                  var l = arguments.length;
                  var exclude = arguments[arguments.length - 1];
                  if (isArray(exclude)) {
                    l--;
                  } else {
                    exclude = [];
                  }
                  for (var i = 1; i < l; i++) {
                    _merge(obj, arguments[i], exclude);
                  }
                  return obj; // Object
                };
              })();

              function extender(supers) {
                supers = supers || [];
                var Base = declare({
                    instance: {
                      constructor: function(value) {
                        this._value = value;
                      },

                      value: function() {
                        return this._value;
                      },

                      eq: function eq(val) {
                        return this['__extender__'](this._value === val);
                      },

                      neq: function neq(other) {
                        return this['__extender__'](this._value !== other);
                      },
                      print: function() {
                        console.log(this._value);
                        return this;
                      },
                    },
                  }),
                  defined = [];

                function addMethod(proto, name, func) {
                  if ('function' !== typeof func) {
                    throw new TypeError(
                      'when extending type you must provide a function'
                    );
                  }
                  var extendedMethod;
                  if (name === 'constructor') {
                    extendedMethod = function() {
                      this._super(arguments);
                      func.apply(this, arguments);
                    };
                  } else {
                    extendedMethod = function extendedMethod() {
                      var args = slice.call(arguments);
                      args.unshift(this._value);
                      var ret = func.apply(this, args);
                      return ret !== undef ? this['__extender__'](ret) : this;
                    };
                  }
                  proto[name] = extendedMethod;
                }

                function addNoWrapMethod(proto, name, func) {
                  if ('function' !== typeof func) {
                    throw new TypeError(
                      'when extending type you must provide a function'
                    );
                  }
                  var extendedMethod;
                  if (name === 'constructor') {
                    extendedMethod = function() {
                      this._super(arguments);
                      func.apply(this, arguments);
                    };
                  } else {
                    extendedMethod = function extendedMethod() {
                      var args = slice.call(arguments);
                      args.unshift(this._value);
                      return func.apply(this, args);
                    };
                  }
                  proto[name] = extendedMethod;
                }

                function decorateProto(proto, decoration, nowrap) {
                  for (var i in decoration) {
                    if (decoration.hasOwnProperty(i)) {
                      if (i !== 'getters' && i !== 'setters') {
                        if (i === 'noWrap') {
                          decorateProto(proto, decoration[i], true);
                        } else if (nowrap) {
                          addNoWrapMethod(proto, i, decoration[i]);
                        } else {
                          addMethod(proto, i, decoration[i]);
                        }
                      } else {
                        proto[i] = decoration[i];
                      }
                    }
                  }
                }

                function _extender(obj) {
                  var ret = obj,
                    i,
                    l;
                  if (!(obj instanceof Base)) {
                    var OurBase = Base;
                    for (i = 0, l = defined.length; i < l; i++) {
                      var definer = defined[i];
                      if (definer[0](obj)) {
                        OurBase = OurBase.extend({ instance: definer[1] });
                      }
                    }
                    ret = new OurBase(obj);
                    ret['__extender__'] = _extender;
                  }
                  return ret;
                }

                function always() {
                  return true;
                }

                function define(tester, decorate) {
                  if (arguments.length) {
                    if (typeof tester === 'object') {
                      decorate = tester;
                      tester = always;
                    }
                    decorate = decorate || {};
                    var proto = {};
                    decorateProto(proto, decorate);
                    //handle browsers like which skip over the constructor while looping
                    if (!proto.hasOwnProperty('constructor')) {
                      if (decorate.hasOwnProperty('constructor')) {
                        addMethod(proto, 'constructor', decorate.constructor);
                      } else {
                        proto.constructor = function() {
                          this._super(arguments);
                        };
                      }
                    }
                    defined.push([tester, proto]);
                  }
                  return _extender;
                }

                function extend(supr) {
                  if (supr && supr.hasOwnProperty('__defined__')) {
                    _extender['__defined__'] = defined = defined.concat(
                      supr['__defined__']
                    );
                  }
                  merge(_extender, supr, [
                    'define',
                    'extend',
                    'expose',
                    '__defined__',
                  ]);
                  return _extender;
                }

                _extender.define = define;
                _extender.extend = extend;
                _extender.expose = function expose() {
                  var methods;
                  for (var i = 0, l = arguments.length; i < l; i++) {
                    methods = arguments[i];
                    if (typeof methods === 'object') {
                      merge(_extender, methods, [
                        'define',
                        'extend',
                        'expose',
                        '__defined__',
                      ]);
                    }
                  }
                  return _extender;
                };
                _extender['__defined__'] = defined;

                return _extender;
              }

              return {
                define: function() {
                  return extender().define.apply(extender, arguments);
                },

                extend: function(supr) {
                  return extender()
                    .define()
                    .extend(supr);
                },
              };
            }

            if ('undefined' !== typeof exports) {
              if ('undefined' !== typeof module && module.exports) {
                module.exports = defineExtender(require('declare.js'));
              }
            } else if ('function' === typeof define && define.amd) {
              define(['declare'], function(declare) {
                return defineExtender(declare);
              });
            } else {
              this.extender = defineExtender(this.declare);
            }
          }.call(this));
        },
        { 'declare.js': 110 },
      ],
      115: [
        function(require, module, exports) {
          module.exports = require('./extender.js');
        },
        { './extender.js': 114 },
      ],
      116: [
        function(require, module, exports) {
          module.exports = require('./lib');
        },
        { './lib': 121 },
      ],
      117: [
        function(require, module, exports) {
          (function(setImmediate) {
            var is = require('is-extended'),
              hasOwn = Object.prototype.hasOwnProperty;
            module.exports = require('extended')()
              .register(is)
              .register(require('object-extended'))
              .register(require('string-extended'))
              .register('LINE_BREAK', require('os').EOL)
              .register('asyncEach', function(arr, iter, cb) {
                (function asyncIterator(i, l, rows, cb) {
                  if (++i < l) {
                    iter(rows[i], function(err) {
                      if (err) {
                        cb(err);
                      } else {
                        if (i % 100 === 0) {
                          //dont overflow the stack
                          setImmediate(function() {
                            asyncIterator(i, l, rows, cb);
                          });
                        } else {
                          asyncIterator(i, l, rows, cb);
                        }
                      }
                    });
                  } else {
                    //get out of stack
                    cb(null, arr);
                  }
                })(-1, arr.length, arr, cb);
              })
              .register('spreadArgs', function spreadArgs(f, args, scope) {
                var ret;
                switch ((args || []).length) {
                  case 0:
                    ret = f.call(scope);
                    break;
                  case 1:
                    ret = f.call(scope, args[0]);
                    break;
                  case 2:
                    ret = f.call(scope, args[0], args[1]);
                    break;
                  case 3:
                    ret = f.call(scope, args[0], args[1], args[2]);
                    break;
                  default:
                    ret = f.apply(scope, args);
                }
                return ret;
              })
              .register('keys', function(obj) {
                var ret = [];
                for (var i in obj) {
                  if (hasOwn.call(obj, i)) {
                    ret.push(i);
                  }
                }
                return ret;
              });
          }.call(this, require('timers').setImmediate));
        },
        {
          extended: 113,
          'is-extended': 129,
          'object-extended': 168,
          os: 169,
          'string-extended': 208,
          timers: 210,
        },
      ],
      118: [
        function(require, module, exports) {
          var fs = require('fs'),
            extended = require('../extended'),
            Buffer = require('safer-buffer').Buffer,
            has = extended.has,
            isBoolean = extended.isBoolean,
            isUndefinedOrNull = extended.isUndefinedOrNull,
            escape = extended.escape,
            isArray = extended.isArray,
            keys = extended.keys,
            stream = require('stream'),
            LINE_BREAK = extended.LINE_BREAK;

          function createQuoteChecker(stream, quoteColumns, quoteHeaders) {
            var shouldQuote;
            if (isBoolean(quoteColumns)) {
              if (isBoolean(quoteHeaders)) {
                shouldQuote = function shouldQuote(index, isHeader) {
                  return isHeader ? quoteHeaders : quoteColumns;
                };
              } else if (isArray(quoteHeaders)) {
                shouldQuote = function shouldQuote(index, isHeader) {
                  return isHeader ? quoteHeaders[index] : quoteColumns;
                };
              } else {
                shouldQuote = function shouldQuote(index, isHeader) {
                  return isHeader
                    ? quoteHeaders[stream.headers[index]]
                    : quoteColumns;
                };
              }
            } else if (isArray(quoteColumns)) {
              if (isBoolean(quoteHeaders)) {
                shouldQuote = function shouldQuote(index, isHeader) {
                  return isHeader ? quoteHeaders : quoteColumns[index];
                };
              } else {
                shouldQuote = function shouldQuote(index, isHeader) {
                  return isHeader ? quoteHeaders[index] : quoteColumns[index];
                };
              }
            } else {
              if (isBoolean(quoteHeaders)) {
                shouldQuote = function shouldQuote(index, isHeader) {
                  return isHeader
                    ? quoteHeaders
                    : quoteColumns[stream.headers[index]];
                };
              } else {
                shouldQuote = function shouldQuote(index, isHeader) {
                  return isHeader
                    ? quoteHeaders[stream.headers[index]]
                    : quoteColumns[stream.headers[index]];
                };
              }
            }
            return shouldQuote;
          }

          function createFormatter(options, stream) {
            options = options || {};
            var delimiter = options.delimiter || ',',
              ESCAPE_REGEXP = new RegExp(
                '[' +
                  delimiter +
                  escape(options.rowDelimiter || LINE_BREAK) +
                  "']"
              ),
              QUOTE = options.quote || '"',
              ESCAPE = options.escape || '"',
              REPLACE_REGEXP = new RegExp(QUOTE, 'g'),
              quoteColumns = has(options, 'quoteColumns')
                ? options.quoteColumns
                : false,
              quoteHeaders = has(options, 'quoteHeaders')
                ? options.quoteHeaders
                : quoteColumns,
              shouldQuote = createQuoteChecker(
                stream,
                quoteColumns,
                quoteHeaders
              );

            function escapeField(field, index, isHeader) {
              var escape;
              field = field.replace(/\0/g, '');
              if ((escape = field.indexOf(QUOTE) !== -1)) {
                field = field.replace(REPLACE_REGEXP, ESCAPE + QUOTE);
                escape = true;
              } else {
                escape = field.search(ESCAPE_REGEXP) !== -1;
              }
              escape = escape || shouldQuote(index, isHeader);
              if (escape) {
                field = [QUOTE + field + QUOTE];
              } else {
                field = [field];
              }
              return field.join('');
            }

            return function escapeFields(fields, isHeader) {
              var i = -1,
                l = fields.length,
                ret = [],
                field;
              while (++i < l) {
                field = fields[i];
                field = (isUndefinedOrNull(field) ? '' : field) + '';
                ret.push(escapeField(field, i, isHeader));
              }
              return ret.join(delimiter);
            };
          }

          function defaultTransform(row, cb) {
            return cb(null, row);
          }

          function isHashArray(arr) {
            return isArray(arr) && isArray(arr[0]) && arr[0].length === 2;
          }

          //get headers from a row item
          function gatherHeaders(item) {
            var ret, i, l;
            if (isHashArray(item)) {
              //lets assume a multidimesional array with item 0 bing the title
              i = -1;
              l = item.length;
              ret = [];
              while (++i < l) {
                ret[i] = item[i][0];
              }
            } else if (isArray(item)) {
              ret = item;
            } else {
              ret = keys(item);
            }
            return ret;
          }

          //check if we need to write header return true if we should also write a row
          //could be false if headers is true and the header row(first item) is passed in
          function checkHeaders(stream, item) {
            var headers,
              ret = true;
            if (!stream.parsedHeaders) {
              stream.parsedHeaders = true;
              headers = stream.headers = gatherHeaders(item);
              stream.headersLength = headers.length;
            }
            if (!stream.hasWrittenHeaders) {
              stream.totalCount++;
              stream.push(
                Buffer.from(stream.formatter(stream.headers, true), 'utf8')
              );
              stream.hasWrittenHeaders = true;
              ret = isHashArray(item) || !isArray(item);
            }
            return ret;
          }

          //transform an object into a CSV row
          function transformHashData(stream, item) {
            var vals = [],
              row = [],
              headers = stream.headers,
              i = -1,
              headersLength = stream.headersLength;
            if (stream.totalCount++) {
              row.push(stream.rowDelimiter);
            }
            while (++i < headersLength) {
              vals[i] = item[headers[i]];
            }
            row.push(stream.formatter(vals));
            return row.join('');
          }

          //transform an array into a CSV row
          function transformArrayData(stream, item, cb) {
            var row = [];
            if (stream.totalCount++) {
              row.push(stream.rowDelimiter);
            }
            row.push(stream.formatter(item));
            return row.join('');
          }

          //transform an array of two item arrays into a CSV row
          function transformHashArrayData(stream, item) {
            var vals = [],
              row = [],
              i = -1,
              headersLength = stream.headersLength;
            if (stream.totalCount++) {
              row.push(stream.rowDelimiter);
            }
            while (++i < headersLength) {
              vals[i] = item[i][1];
            }
            row.push(stream.formatter(vals));
            return row.join('');
          }

          //wrapper to determin what transform to run
          function transformItem(stream, item) {
            var ret;
            if (isArray(item)) {
              if (isHashArray(item)) {
                ret = transformHashArrayData(stream, item);
              } else {
                ret = transformArrayData(stream, item);
              }
            } else {
              ret = transformHashData(stream, item);
            }
            return ret;
          }

          exports.createFormatter = createFormatter;
          exports.transformItem = transformItem;
          exports.checkHeaders = checkHeaders;
          exports.defaultTransform = defaultTransform;
        },
        { '../extended': 117, fs: 105, 'safer-buffer': 204, stream: 207 },
      ],
      119: [
        function(require, module, exports) {
          var fs = require('fs'),
            util = require('util'),
            extended = require('../extended'),
            Buffer = require('safer-buffer').Buffer,
            escape = extended.escape,
            isArray = extended.isArray,
            has = extended.has,
            stream = require('stream'),
            Transform = stream.Transform,
            LINE_BREAK = extended.LINE_BREAK,
            formatter = require('./formatter'),
            createFormatter = formatter.createFormatter,
            checkHeaders = formatter.checkHeaders,
            transformItem = formatter.transformItem,
            defaultTransform = formatter.defaultTransform;

          function CsvTransformStream(options) {
            options = options || {};
            options.objectMode = true;

            if (has(options, 'transform')) {
              // remove so its not set to _transform in Transform constructor
              options.consumerTransform = options.transform;
              delete options.transform;
            }

            Transform.call(this, options);
            this.formatter = createFormatter(options, this);
            this.rowDelimiter = options.rowDelimiter || '\n';
            var hasHeaders = has(options, 'headers') ? !!options.headers : null,
              headers =
                hasHeaders && isArray(options.headers) ? options.headers : null;
            this.hasHeaders = hasHeaders;
            this.headers = headers;
            if (hasHeaders) {
              if (headers) {
                this.parsedHeaders = true;
                this.headersLength = headers.length;
              } else {
                this.parsedHeaders = false;
              }
            }
            this.hasWrittenHeaders = hasHeaders ? false : true;
            (this.includeEndRowDelimiter = !!options.includeEndRowDelimiter),
              has(options, 'consumerTransform') &&
                this.transform(options.consumerTransform);
          }
          util.inherits(CsvTransformStream, Transform);

          extended(CsvTransformStream).extend({
            headers: null,

            headersLength: 0,

            totalCount: 0,

            _transform: function(item, encoding, cb) {
              var self = this;
              this.__transform(item, function(err, item) {
                if (err) {
                  cb(err);
                } else {
                  if (checkHeaders(self, item)) {
                    self.push(Buffer.from(transformItem(self, item), 'utf8'));
                  }
                  cb();
                }
              });
            },

            __transform: defaultTransform,

            transform: function(cb) {
              if (!extended.isFunction(cb)) {
                this.emit(
                  'error',
                  new TypeError(
                    'fast-csv.FormatterStream#transform requires a function'
                  )
                );
              }
              if (cb.length === 2) {
                this.__transform = cb;
              } else {
                this.__transform = function(data, next) {
                  next(null, cb(data));
                };
              }
              return this;
            },

            _flush: function(cb) {
              if (this.includeEndRowDelimiter) {
                this.push(this.rowDelimiter);
              }
              cb();
            },
          });

          module.exports = CsvTransformStream;
        },
        {
          '../extended': 117,
          './formatter': 118,
          fs: 105,
          'safer-buffer': 204,
          stream: 207,
          util: 213,
        },
      ],
      120: [
        function(require, module, exports) {
          (function(Buffer) {
            var fs = require('fs'),
              extended = require('../extended'),
              escape = extended.escape,
              stream = require('stream'),
              LINE_BREAK = extended.LINE_BREAK,
              CsvTransformStream = require('./formatter_stream');

            function createWriteStream(options) {
              return new CsvTransformStream(options);
            }

            function write(arr, options, ws) {
              var csvStream = createWriteStream(options),
                i = -1,
                l = arr.length;
              extended.asyncEach(
                arr,
                function(item, cb) {
                  csvStream.write(item, null, cb);
                },
                function(err) {
                  if (err) {
                    csvStream.emit('error', err);
                  } else {
                    csvStream.end();
                  }
                }
              );
              return csvStream;
            }

            function writeToStream(ws, arr, options) {
              return write(arr, options).pipe(ws);
            }

            function writeToString(arr, options, cb) {
              if (extended.isFunction(options)) {
                cb = options;
                options = {};
              }
              var ws = new stream.Writable(),
                written = [];
              ws._write = function(data, enc, cb) {
                written.push(data + '');
                cb();
              };
              ws.on('error', cb).on('finish', function() {
                cb(null, written.join(''));
              });
              write(arr, options).pipe(ws);
            }

            function writeToBuffer(arr, options, cb) {
              if (extended.isFunction(options)) {
                cb = options;
                options = {};
              }
              var ws = new stream.Writable(),
                buffers = [],
                l = 0;
              ws._write = function(data, enc, cb) {
                buffers.push(data);
                l++;
                cb();
              };
              ws.on('error', cb).on('finish', function() {
                cb(null, Buffer.concat(buffers));
              });
              write(arr, options).pipe(ws);
            }

            function writeToPath(path, arr, options) {
              var stream = fs.createWriteStream(path, { encoding: 'utf8' });
              return write(arr, options).pipe(stream);
            }

            createWriteStream.writeToBuffer = writeToBuffer;
            createWriteStream.write = write;
            createWriteStream.createWriteStream = createWriteStream;
            createWriteStream.writeToString = writeToString;
            createWriteStream.writeToPath = writeToPath;
            createWriteStream.writeToStream = writeToStream;
            module.exports = createWriteStream;
          }.call(this, require('buffer').Buffer));
        },
        {
          '../extended': 117,
          './formatter_stream': 119,
          buffer: 106,
          fs: 105,
          stream: 207,
        },
      ],
      121: [
        function(require, module, exports) {
          /**
           * @projectName fast-csv
           * @github https://github.com/C2FO/fast-csv
           * @includeDoc [Change Log] ../History.md
           * @header [../README.md]
           */

          var fs = require('fs'),
            parser = require('./parser'),
            formatter = require('./formatter');

          function csv() {
            return parser.apply(void 0, arguments);
          }

          csv.parse = csv;
          csv.fromString = parser.fromString;
          csv.fromPath = parser.fromPath;
          csv.fromStream = parser.fromStream;
          csv.format = formatter;
          csv.write = formatter.write;
          csv.writeToStream = formatter.writeToStream;
          csv.writeToString = formatter.writeToString;
          csv.writeToBuffer = formatter.writeToBuffer;
          csv.writeToPath = formatter.writeToPath;
          csv.createWriteStream = formatter.createWriteStream;
          csv.createReadStream = formatter.createWriteStream;

          module.exports = csv;
        },
        { './formatter': 120, './parser': 122, fs: 105 },
      ],
      122: [
        function(require, module, exports) {
          (function(process) {
            var extended = require('../extended'),
              out = process.stdout,
              stream = require('stream'),
              fs = require('fs'),
              ParserStream = require('./parser_stream');

            function parse(options) {
              return new ParserStream(options);
            }

            function fromStream(stream, options) {
              return stream.pipe(new ParserStream(options));
            }

            function fromPath(location, options) {
              return fs
                .createReadStream(location)
                .pipe(new ParserStream(options));
            }

            function fromString(string, options) {
              var rs = new stream.Readable();
              rs.push(string);
              rs.push(null);
              return rs.pipe(new ParserStream(options));
            }

            parse.fromStream = fromStream;
            parse.fromPath = fromPath;
            parse.fromString = fromString;
            module.exports = parse;
          }.call(this, require('_process')));
        },
        {
          '../extended': 117,
          './parser_stream': 124,
          _process: 187,
          fs: 105,
          stream: 207,
        },
      ],
      123: [
        function(require, module, exports) {
          var extended = require('./../extended'),
            has = extended.has,
            isUndefinedOrNull = extended.isUndefinedOrNull,
            trim = extended.trim,
            trimLeft = extended.trimLeft,
            trimRight = extended.trimRight;

          function createParser(options) {
            options = options || {};
            var delimiter = options.delimiter || ',',
              doLtrim = options.ltrim || false,
              doRtrim = options.rtrim || false,
              doTrim = options.trim || false,
              ESCAPE = has(options, 'quote') ? options.quote : '"',
              VALUE_REGEXP = new RegExp(
                '([^' +
                  delimiter +
                  '\'"\\s\\\\]*(?:\\s+[^' +
                  delimiter +
                  '\'"\\s\\\\]+)*)'
              ),
              SEARCH_REGEXP = new RegExp('(?:\\n|\\r|' + delimiter + ')'),
              ESCAPE_CHAR = options.escape || '"',
              NEXT_TOKEN_REGEXP = new RegExp(
                '([^\\s]|\\r\\n|\\n|\\r|' + delimiter + ')'
              ),
              ROW_DELIMITER = /(\r\n|\n|\r)/,
              SPACE_CHAR_REGEX = new RegExp('(?!' + delimiter + ') '),
              COMMENT,
              hasComments;
            if (has(options, 'comment')) {
              COMMENT = options.comment;
              hasComments = true;
            }

            function formatItem(item) {
              if (doTrim) {
                item = trim(item);
              } else if (doLtrim) {
                item = trimLeft(item);
              } else if (doRtrim) {
                item = trimRight(item);
              }
              return item;
            }

            function parseEscapedItem(str, items, cursor, hasMoreData) {
              var depth = 0,
                ret = [];
              var startPushing = false,
                token,
                i = 0,
                l = str.length,
                escapeIsEscape = ESCAPE_CHAR === ESCAPE;
              if (l) {
                while (cursor < l && (token = str.charAt(cursor))) {
                  if (token === ESCAPE) {
                    if (!startPushing) {
                      depth++;
                      startPushing = true;
                    } else if (
                      escapeIsEscape &&
                      str.charAt(cursor + 1) === ESCAPE
                    ) {
                      cursor++;
                      ret[i++] = token;
                    } else if (!escapeIsEscape && ret[i - 1] === ESCAPE_CHAR) {
                      ret[i - 1] = token;
                    } else {
                      if (!--depth) {
                        ++cursor;
                        break;
                      }
                    }
                  } else {
                    ret[i++] = token;
                  }
                  ++cursor;
                }
              }
              ret = ret.join('');
              var next = getNextToken(str, cursor),
                nextToken = next.token;
              if (nextToken && nextToken.search(delimiter) === 0) {
                if (hasMoreData && next.cursor + 1 >= l) {
                  cursor = null;
                } else {
                  cursor++;
                }
              } else if (depth && !nextToken) {
                if (hasMoreData) {
                  cursor = null;
                } else {
                  throw new Error(
                    "Parse Error: expected: '" +
                      ESCAPE +
                      "' got: '" +
                      nextToken +
                      "'. at '" +
                      str.substr(cursor).replace(/[r\n]/g, '\\n' + "'")
                  );
                }
              } else if (
                !depth &&
                nextToken &&
                nextToken.search(SEARCH_REGEXP) === -1
              ) {
                throw new Error(
                  "Parse Error: expected: '" +
                    ESCAPE +
                    "' got: '" +
                    nextToken +
                    "'. at '" +
                    str.substr(cursor, 10).replace(/[\r\n]/g, '\\n' + "'")
                );
              } else if (
                hasMoreData &&
                (!nextToken || !ROW_DELIMITER.test(nextToken))
              ) {
                cursor = null;
              }
              if (cursor !== null) {
                items.push(formatItem(ret));
              }
              return cursor;
            }

            function parseCommentLine(line, cursor, hasMoreData) {
              var nextIndex = line.substr(cursor).search(ROW_DELIMITER);
              if (nextIndex === -1) {
                if (hasMoreData) {
                  nextIndex = null;
                } else {
                  nextIndex = line.length + 1;
                }
              } else {
                nextIndex = cursor + nextIndex + 1; //go past the next line break
              }
              return nextIndex;
            }

            function parseItem(line, items, cursor, hasMoreData) {
              var searchStr = line.substr(cursor),
                nextIndex = searchStr.search(SEARCH_REGEXP);
              if (nextIndex === -1) {
                if (!VALUE_REGEXP.test(searchStr)) {
                  throw new Error(
                    "Parse Error: delimiter '" +
                      delimiter +
                      "' not found at '" +
                      searchStr.replace(/\n/g, '\\n' + "'")
                  );
                } else {
                  nextIndex = searchStr.length;
                }
              }
              var nextChar = searchStr.charAt(nextIndex);
              if (nextChar.search(delimiter) !== -1) {
                if (hasMoreData && cursor + (nextIndex + 1) >= line.length) {
                  cursor = null;
                } else {
                  items.push(formatItem(searchStr.substr(0, nextIndex)));
                  cursor += nextIndex + 1;

                  var cursorChar = line.charAt(cursor);
                  // if ends with a delimiter, append an empty element, unless strict column handling
                  if (
                    !options.strictColumnHandling &&
                    (ROW_DELIMITER.test(cursorChar) || cursor >= line.length)
                  ) {
                    items.push('');
                  }
                  // if ends with empty space that is not a delimiter, append an empty space, unless strict column handling
                  if (
                    !options.strictColumnHandling &&
                    SPACE_CHAR_REGEX.test(cursorChar) &&
                    !hasMoreData
                  ) {
                    items.push(cursorChar);
                  }
                }
              } else if (ROW_DELIMITER.test(nextChar)) {
                items.push(formatItem(searchStr.substr(0, nextIndex)));
                cursor += nextIndex;
              } else if (!hasMoreData) {
                items.push(formatItem(searchStr.substr(0, nextIndex)));
                cursor += nextIndex + 1;
              } else {
                cursor = null;
              }

              return cursor;
            }

            function getNextToken(line, cursor) {
              var token,
                tokenLen,
                nextIndex,
                subStr = line.substr(cursor);
              if ((nextIndex = subStr.search(NEXT_TOKEN_REGEXP)) !== -1) {
                tokenLen = subStr.match(NEXT_TOKEN_REGEXP)[1].length;
                token = line.substr(cursor + nextIndex, tokenLen);
                cursor += nextIndex + tokenLen - 1;
              }
              return { token: token, cursor: cursor };
            }

            return function parseLine(line, hasMoreData) {
              var i = 0,
                l = line.length,
                rows = [],
                items = [],
                token,
                nextToken,
                cursor,
                lastLineI = 0;
              while (i < l) {
                nextToken = getNextToken(line, i);
                token = nextToken.token;
                if (isUndefinedOrNull(token)) {
                  i = lastLineI;
                  cursor = null;
                  break;
                } else if (ROW_DELIMITER.test(token)) {
                  i = nextToken.cursor + 1;
                  if (i < l) {
                    rows.push(items);
                    items = [];
                    lastLineI = i;
                  } else {
                    // if ends with CR and there is more data, keep unparsed due to possible coming LF in CRLF
                    if (token === '\r' && hasMoreData) {
                      i = lastLineI;
                      cursor = null;
                    }
                    break;
                  }
                } else if (hasComments && token === COMMENT) {
                  cursor = parseCommentLine(line, i, hasMoreData);
                  if (cursor === null) {
                    i = lastLineI;
                    break;
                  } else if (cursor < l) {
                    lastLineI = i = cursor;
                  } else {
                    i = cursor;
                    cursor = null;
                    break;
                  }
                } else {
                  if (token === ESCAPE) {
                    cursor = parseEscapedItem(
                      line,
                      items,
                      nextToken.cursor,
                      hasMoreData
                    );
                  } else {
                    cursor = parseItem(line, items, i, hasMoreData);
                  }
                  if (cursor === null) {
                    i = lastLineI;
                    break;
                  } else {
                    i = cursor;
                  }
                }
              }
              cursor !== null && rows.push(items);
              return { line: line.substr(i), rows: rows };
            };
          }
          module.exports = createParser;
        },
        { './../extended': 117 },
      ],
      124: [
        function(require, module, exports) {
          (function(process) {
            var extended = require('../extended'),
              isUndefined = extended.isUndefined,
              spreadArgs = extended.spreadArgs,
              util = require('util'),
              out = process.stdout,
              stream = require('stream'),
              EMPTY = /^\s*(?:''|"")?\s*(?:,\s*(?:''|"")?\s*)*$/,
              DEFAULT_DELIMITER = ',',
              createParser = require('./parser'),
              fs = require('fs'),
              StringDecoder = require('string_decoder').StringDecoder,
              hasIsPaused = !!stream.Transform.prototype.isPaused;

            function ParserStream(options) {
              options = options || {};
              options.objectMode = extended.has(options, 'objectMode')
                ? options.objectMode
                : true;
              stream.Transform.call(this, options);
              this.lines = '';
              this.decoder = new StringDecoder();
              this._parsedHeaders = false;
              this._rowCount = -1;
              this._emitData = false;
              var delimiter;
              if (extended.has(options, 'delimiter')) {
                delimiter = options.delimiter;
                if (delimiter.length > 1) {
                  throw new Error(
                    'delimiter option must be one character long'
                  );
                }
                delimiter = extended.escape(delimiter);
              } else {
                delimiter = DEFAULT_DELIMITER;
              }
              options.delimiter = delimiter;
              this.parser = createParser(options);
              this._headers = options.headers;
              this._renameHeaders = options.renameHeaders;
              this._ignoreEmpty = options.ignoreEmpty;
              this._discardUnmappedColumns = options.discardUnmappedColumns;
              this._strictColumnHandling = options.strictColumnHandling;
              this.__objectMode = options.objectMode;
              this.__buffered = [];
              return this;
            }

            util.inherits(ParserStream, stream.Transform);

            var origOn = ParserStream.prototype.on,
              origEmit = ParserStream.prototype.emit;

            extended(ParserStream).extend({
              __pausedDone: null,

              __endEmitted: false,

              __emittedData: false,

              __handleLine: function __parseLineData(
                line,
                index,
                ignore,
                next
              ) {
                var ignoreEmpty = this._ignoreEmpty,
                  self = this;
                if (
                  extended.isBoolean(ignoreEmpty) &&
                  ignoreEmpty &&
                  (!line || EMPTY.test(line.join('')))
                ) {
                  return next(null, null);
                }
                if (!ignore) {
                  this.__transform(line, function(err, line) {
                    if (err) {
                      next(err);
                    } else {
                      self.__validate(line, function(err, isValid, reason) {
                        if (err) {
                          next(err);
                        } else if (isValid) {
                          next(null, line);
                        } else {
                          self.emit('data-invalid', line, index, reason);
                          next(null, null);
                        }
                      });
                    }
                  });
                } else {
                  return next(null, line);
                }
              },

              __processRows: function(rows, data, cb) {
                var self = this,
                  count;
                extended.asyncEach(
                  rows,
                  function(row, cb) {
                    if (row) {
                      self.__handleLine(
                        row,
                        (count = ++self._rowCount),
                        false,
                        function(err, dataRow) {
                          if (err) {
                            cb(err);
                          } else {
                            if (dataRow) {
                              if (!self.isStreamPaused()) {
                                self.__emitRecord(dataRow, count);
                              } else {
                                self.__buffered.push([dataRow, count]);
                              }
                            } else {
                              count = --self._rowCount;
                            }
                            cb();
                          }
                        }
                      );
                    }
                  },
                  function(err) {
                    if (err) {
                      cb(err);
                    } else {
                      cb(null, data.line);
                    }
                  }
                );
              },

              __processHeaders: function(rows, cb) {
                var headers = this._headers,
                  renameHeaders = this._renameHeaders,
                  discardUnmappedColumns = this._discardUnmappedColumns,
                  strictColumnHandling = this._strictColumnHandling,
                  self = this;

                function headerHandler(err, headers) {
                  if (err) {
                    cb(err);
                  } else if (extended.isArray(headers)) {
                    var headersLength = headers.length,
                      orig = self.__transform;
                    self.__transform = function(data, cb) {
                      var ret = {},
                        i = -1,
                        val;
                      if (data.length > headersLength) {
                        if (discardUnmappedColumns) {
                          data.splice(headersLength);
                        } else if (strictColumnHandling) {
                          self.emit('data-invalid', data);
                          return orig(null, cb);
                        } else {
                          self.emit(
                            'error',
                            new Error(
                              'Unexpected Error: column header mismatch expected: ' +
                                headersLength +
                                ' columns got: ' +
                                data.length
                            )
                          );
                          return orig(null, cb);
                        }
                      } else if (
                        strictColumnHandling &&
                        data.length < headersLength
                      ) {
                        self.emit('data-invalid', data);
                        return orig(null, cb);
                      }
                      while (++i < headersLength) {
                        if (isUndefined(headers[i])) {
                          continue;
                        }
                        val = data[i];
                        ret[headers[i]] = isUndefined(val) ? '' : val;
                      }

                      return orig(ret, cb);
                    };
                  }
                  self._parsedHeaders = true;
                  cb(null);
                }

                if (renameHeaders) {
                  if (Array.isArray(headers)) {
                    rows.shift();
                    headerHandler(null, headers);
                  } else {
                    self.emit(
                      'error',
                      new Error(
                        'Error renaming headers: new headers must be provided in an array'
                      )
                    );
                  }
                } else if (extended.isBoolean(headers) && headers) {
                  this.__handleLine(rows.shift(), 0, true, headerHandler);
                } else {
                  headerHandler(null, headers);
                }
              },

              _parse: function _parseLine(data, hasMoreData, cb) {
                var rows,
                  self = this;
                try {
                  data = this.parser(data, hasMoreData);
                  rows = data.rows;
                  if (rows.length) {
                    if (!this._parsedHeaders) {
                      this.__processHeaders(rows, function(err) {
                        if (err) {
                          cb(err);
                        } else {
                          self.__processRows(rows, data, cb);
                        }
                      });
                    } else {
                      this.__processRows(rows, data, cb);
                    }
                  } else {
                    cb(null, data.line);
                  }
                } catch (e) {
                  cb(e);
                }
              },

              __emitRecord: function(dataRow, count) {
                if (this._emitData) {
                  this.push(
                    this.__objectMode ? dataRow : JSON.stringify(dataRow)
                  );
                }
              },

              __removeBOM: function(data) {
                // Catches EFBBBF (UTF-8 BOM) because the buffer-to-string
                // conversion translates it to FEFF (UTF-16 BOM)
                if (
                  data &&
                  typeof data == 'string' &&
                  data.charCodeAt(0) == '0xFEFF'
                ) {
                  return data.slice(1);
                }
                return data;
              },

              _transform: function(data, encoding, done) {
                var lines = this.lines,
                  lineData = lines + this.decoder.write(data),
                  self = this;
                if (lineData.length > 1) {
                  lineData = this.__removeBOM(lineData);
                  this._parse(lineData, true, function(err, lineData) {
                    if (err) {
                      done(err);
                    } else {
                      self.lines = lineData;
                      if (!self.isStreamPaused()) {
                        done();
                      } else {
                        self.__pausedDone = done;
                      }
                    }
                  });
                } else {
                  this.lines = lineData;
                  if (!this.isStreamPaused()) {
                    done();
                  } else {
                    this.__pausedDone = done;
                  }
                }
              },

              __doFlush: function(callback) {
                try {
                  callback();
                } catch (e) {
                  callback(e);
                }
              },

              _flush: function(callback) {
                var self = this;
                if (this.lines) {
                  this._parse(this.lines, false, function(err) {
                    if (err) {
                      callback(err);
                    } else if (!self.isStreamPaused()) {
                      self.__doFlush(callback);
                    } else {
                      self.__pausedDone = function() {
                        self.__doFlush(callback);
                      };
                    }
                  });
                } else {
                  if (!this.isStreamPaused()) {
                    this.__doFlush(callback);
                  } else {
                    this.__pausedDone = function() {
                      self.__doFlush(callback);
                    };
                  }
                }
              },

              __validate: function(data, next) {
                return next(null, true);
              },

              __transform: function(data, next) {
                return next(null, data);
              },

              __flushPausedBuffer: function() {
                var buffered = this.__buffered,
                  l = buffered.length;
                if (l) {
                  var entry;
                  while (buffered.length) {
                    entry = buffered.shift();
                    this.__emitRecord(entry[0], entry[1]);
                    //handle case where paused is called while emitting data
                    if (this.isStreamPaused()) {
                      return;
                    }
                  }
                  buffered.length = 0;
                }
                if (this.__pausedDone) {
                  var done = this.__pausedDone;
                  this.__pausedDone = null;
                  done();
                }
              },

              isStreamPaused: function() {
                return this.__paused;
              },

              emit: function(event) {
                if (event === 'end') {
                  if (!this.__endEmitted) {
                    this.__endEmitted = true;
                    spreadArgs(origEmit, ['end', ++this._rowCount], this);
                  }
                } else {
                  if (!hasIsPaused) {
                    if (event === 'pause') {
                      this.__paused = true;
                    } else if (event === 'resume') {
                      this.__paused = false;
                      this.__flushPausedBuffer();
                    }
                  }
                  spreadArgs(origEmit, arguments, this);
                }
              },

              on: function(evt) {
                if (evt === 'data' || evt === 'readable') {
                  this._emitData = true;
                }
                spreadArgs(origOn, arguments, this);
                return this;
              },

              validate: function(cb) {
                if (!extended.isFunction(cb)) {
                  this.emit(
                    'error',
                    new TypeError(
                      'fast-csv.Parser#validate requires a function'
                    )
                  );
                }
                if (cb.length === 2) {
                  this.__validate = cb;
                } else {
                  this.__validate = function(data, next) {
                    return next(null, cb(data));
                  };
                }
                return this;
              },
              transform: function(cb) {
                if (!extended.isFunction(cb)) {
                  this.emit(
                    'error',
                    new TypeError(
                      'fast-csv.Parser#transform requires a function'
                    )
                  );
                }
                if (cb.length === 2) {
                  this.__transform = cb;
                } else {
                  this.__transform = function(data, next) {
                    return next(null, cb(data));
                  };
                }
                return this;
              },
            });

            module.exports = ParserStream;
          }.call(this, require('_process')));
        },
        {
          '../extended': 117,
          './parser': 123,
          _process: 187,
          fs: 105,
          stream: 207,
          string_decoder: 209,
          util: 213,
        },
      ],
      125: [
        function(require, module, exports) {
          exports.read = function(buffer, offset, isLE, mLen, nBytes) {
            var e, m;
            var eLen = nBytes * 8 - mLen - 1;
            var eMax = (1 << eLen) - 1;
            var eBias = eMax >> 1;
            var nBits = -7;
            var i = isLE ? nBytes - 1 : 0;
            var d = isLE ? -1 : 1;
            var s = buffer[offset + i];

            i += d;

            e = s & ((1 << -nBits) - 1);
            s >>= -nBits;
            nBits += eLen;
            for (
              ;
              nBits > 0;
              e = e * 256 + buffer[offset + i], i += d, nBits -= 8
            ) {}

            m = e & ((1 << -nBits) - 1);
            e >>= -nBits;
            nBits += mLen;
            for (
              ;
              nBits > 0;
              m = m * 256 + buffer[offset + i], i += d, nBits -= 8
            ) {}

            if (e === 0) {
              e = 1 - eBias;
            } else if (e === eMax) {
              return m ? NaN : (s ? -1 : 1) * Infinity;
            } else {
              m = m + Math.pow(2, mLen);
              e = e - eBias;
            }
            return (s ? -1 : 1) * m * Math.pow(2, e - mLen);
          };

          exports.write = function(buffer, value, offset, isLE, mLen, nBytes) {
            var e, m, c;
            var eLen = nBytes * 8 - mLen - 1;
            var eMax = (1 << eLen) - 1;
            var eBias = eMax >> 1;
            var rt = mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0;
            var i = isLE ? 0 : nBytes - 1;
            var d = isLE ? 1 : -1;
            var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0;

            value = Math.abs(value);

            if (isNaN(value) || value === Infinity) {
              m = isNaN(value) ? 1 : 0;
              e = eMax;
            } else {
              e = Math.floor(Math.log(value) / Math.LN2);
              if (value * (c = Math.pow(2, -e)) < 1) {
                e--;
                c *= 2;
              }
              if (e + eBias >= 1) {
                value += rt / c;
              } else {
                value += rt * Math.pow(2, 1 - eBias);
              }
              if (value * c >= 2) {
                e++;
                c /= 2;
              }

              if (e + eBias >= eMax) {
                m = 0;
                e = eMax;
              } else if (e + eBias >= 1) {
                m = (value * c - 1) * Math.pow(2, mLen);
                e = e + eBias;
              } else {
                m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
                e = 0;
              }
            }

            for (
              ;
              mLen >= 8;
              buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8
            ) {}

            e = (e << mLen) | m;
            eLen += mLen;
            for (
              ;
              eLen > 0;
              buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8
            ) {}

            buffer[offset + i - d] |= s * 128;
          };
        },
        {},
      ],
      126: [
        function(require, module, exports) {
          (function(global) {
            'use strict';
            var Mutation =
              global.MutationObserver || global.WebKitMutationObserver;

            var scheduleDrain;

            {
              if (Mutation) {
                var called = 0;
                var observer = new Mutation(nextTick);
                var element = global.document.createTextNode('');
                observer.observe(element, {
                  characterData: true,
                });
                scheduleDrain = function() {
                  element.data = called = ++called % 2;
                };
              } else if (
                !global.setImmediate &&
                typeof global.MessageChannel !== 'undefined'
              ) {
                var channel = new global.MessageChannel();
                channel.port1.onmessage = nextTick;
                scheduleDrain = function() {
                  channel.port2.postMessage(0);
                };
              } else if (
                'document' in global &&
                'onreadystatechange' in global.document.createElement('script')
              ) {
                scheduleDrain = function() {
                  // Create a <script> element; its readystatechange event will be fired asynchronously once it is inserted
                  // into the document. Do so, thus queuing up the task. Remember to clean up once it's been called.
                  var scriptEl = global.document.createElement('script');
                  scriptEl.onreadystatechange = function() {
                    nextTick();

                    scriptEl.onreadystatechange = null;
                    scriptEl.parentNode.removeChild(scriptEl);
                    scriptEl = null;
                  };
                  global.document.documentElement.appendChild(scriptEl);
                };
              } else {
                scheduleDrain = function() {
                  setTimeout(nextTick, 0);
                };
              }
            }

            var draining;
            var queue = [];
            //named nextTick for less confusing stack traces
            function nextTick() {
              draining = true;
              var i, oldQueue;
              var len = queue.length;
              while (len) {
                oldQueue = queue;
                queue = [];
                i = -1;
                while (++i < len) {
                  oldQueue[i]();
                }
                len = queue.length;
              }
              draining = false;
            }

            module.exports = immediate;
            function immediate(task) {
              if (queue.push(task) === 1 && !draining) {
                scheduleDrain();
              }
            }
          }.call(
            this,
            typeof global !== 'undefined'
              ? global
              : typeof self !== 'undefined'
              ? self
              : typeof window !== 'undefined'
              ? window
              : {}
          ));
        },
        {},
      ],
      127: [
        function(require, module, exports) {
          if (typeof Object.create === 'function') {
            // implementation from standard node.js 'util' module
            module.exports = function inherits(ctor, superCtor) {
              ctor.super_ = superCtor;
              ctor.prototype = Object.create(superCtor.prototype, {
                constructor: {
                  value: ctor,
                  enumerable: false,
                  writable: true,
                  configurable: true,
                },
              });
            };
          } else {
            // old school shim for old browsers
            module.exports = function inherits(ctor, superCtor) {
              ctor.super_ = superCtor;
              var TempCtor = function() {};
              TempCtor.prototype = superCtor.prototype;
              ctor.prototype = new TempCtor();
              ctor.prototype.constructor = ctor;
            };
          }
        },
        {},
      ],
      128: [
        function(require, module, exports) {
          /*!
           * Determine if an object is a Buffer
           *
           * @author   Feross Aboukhadijeh <https://feross.org>
           * @license  MIT
           */

          // The _isBuffer check is for Safari 5-7 support, because it's missing
          // Object.prototype.constructor. Remove this eventually
          module.exports = function(obj) {
            return (
              obj != null &&
              (isBuffer(obj) || isSlowBuffer(obj) || !!obj._isBuffer)
            );
          };

          function isBuffer(obj) {
            return (
              !!obj.constructor &&
              typeof obj.constructor.isBuffer === 'function' &&
              obj.constructor.isBuffer(obj)
            );
          }

          // For Node v0.10 support. Remove this eventually.
          function isSlowBuffer(obj) {
            return (
              typeof obj.readFloatLE === 'function' &&
              typeof obj.slice === 'function' &&
              isBuffer(obj.slice(0, 0))
            );
          }
        },
        {},
      ],
      129: [
        function(require, module, exports) {
          (function(Buffer) {
            (function() {
              'use strict';

              function defineIsa(extended) {
                var pSlice = Array.prototype.slice;

                var hasOwn = Object.prototype.hasOwnProperty;
                var toStr = Object.prototype.toString;

                function argsToArray(args, slice) {
                  var i = -1,
                    j = 0,
                    l = args.length,
                    ret = [];
                  slice = slice || 0;
                  i += slice;
                  while (++i < l) {
                    ret[j++] = args[i];
                  }
                  return ret;
                }

                function keys(obj) {
                  var ret = [];
                  for (var i in obj) {
                    if (hasOwn.call(obj, i)) {
                      ret.push(i);
                    }
                  }
                  return ret;
                }

                //taken from node js assert.js
                //https://github.com/joyent/node/blob/master/lib/assert.js
                function deepEqual(actual, expected) {
                  // 7.1. All identical values are equivalent, as determined by ===.
                  if (actual === expected) {
                    return true;
                  } else if (
                    typeof Buffer !== 'undefined' &&
                    Buffer.isBuffer(actual) &&
                    Buffer.isBuffer(expected)
                  ) {
                    if (actual.length !== expected.length) {
                      return false;
                    }
                    for (var i = 0; i < actual.length; i++) {
                      if (actual[i] !== expected[i]) {
                        return false;
                      }
                    }
                    return true;

                    // 7.2. If the expected value is a Date object, the actual value is
                    // equivalent if it is also a Date object that refers to the same time.
                  } else if (isDate(actual) && isDate(expected)) {
                    return actual.getTime() === expected.getTime();

                    // 7.3 If the expected value is a RegExp object, the actual value is
                    // equivalent if it is also a RegExp object with the same source and
                    // properties (`global`, `multiline`, `lastIndex`, `ignoreCase`).
                  } else if (isRegExp(actual) && isRegExp(expected)) {
                    return (
                      actual.source === expected.source &&
                      actual.global === expected.global &&
                      actual.multiline === expected.multiline &&
                      actual.lastIndex === expected.lastIndex &&
                      actual.ignoreCase === expected.ignoreCase
                    );

                    // 7.4. Other pairs that do not both pass typeof value == 'object',
                    // equivalence is determined by ==.
                  } else if (
                    isString(actual) &&
                    isString(expected) &&
                    actual !== expected
                  ) {
                    return false;
                  } else if (
                    typeof actual !== 'object' &&
                    typeof expected !== 'object'
                  ) {
                    return actual === expected;

                    // 7.5 For all other Object pairs, including Array objects, equivalence is
                    // determined by having the same number of owned properties (as verified
                    // with Object.prototype.hasOwnProperty.call), the same set of keys
                    // (although not necessarily the same order), equivalent values for every
                    // corresponding key, and an identical 'prototype' property. Note: this
                    // accounts for both named and indexed properties on Arrays.
                  } else {
                    return objEquiv(actual, expected);
                  }
                }

                function objEquiv(a, b) {
                  var key;
                  if (isUndefinedOrNull(a) || isUndefinedOrNull(b)) {
                    return false;
                  }
                  // an identical 'prototype' property.
                  if (a.prototype !== b.prototype) {
                    return false;
                  }
                  //~~~I've managed to break Object.keys through screwy arguments passing.
                  //   Converting to array solves the problem.
                  if (isArguments(a)) {
                    if (!isArguments(b)) {
                      return false;
                    }
                    a = pSlice.call(a);
                    b = pSlice.call(b);
                    return deepEqual(a, b);
                  }
                  try {
                    var ka = keys(a),
                      kb = keys(b),
                      i;
                    // having the same number of owned properties (keys incorporates
                    // hasOwnProperty)
                    if (ka.length !== kb.length) {
                      return false;
                    }
                    //the same set of keys (although not necessarily the same order),
                    ka.sort();
                    kb.sort();
                    //~~~cheap key test
                    for (i = ka.length - 1; i >= 0; i--) {
                      if (ka[i] !== kb[i]) {
                        return false;
                      }
                    }
                    //equivalent values for every corresponding key, and
                    //~~~possibly expensive deep test
                    for (i = ka.length - 1; i >= 0; i--) {
                      key = ka[i];
                      if (!deepEqual(a[key], b[key])) {
                        return false;
                      }
                    }
                  } catch (e) {
                    //happens when one is a string literal and the other isn't
                    return false;
                  }
                  return true;
                }

                var isFunction = function(obj) {
                  return toStr.call(obj) === '[object Function]';
                };

                //ie hack
                if (
                  'undefined' !== typeof window &&
                  !isFunction(window.alert)
                ) {
                  (function(alert) {
                    isFunction = function(obj) {
                      return (
                        toStr.call(obj) === '[object Function]' || obj === alert
                      );
                    };
                  })(window.alert);
                }

                function isObject(obj) {
                  var undef;
                  return obj !== null && typeof obj === 'object';
                }

                function isHash(obj) {
                  var ret = isObject(obj);
                  return (
                    ret &&
                    obj.constructor === Object &&
                    !obj.nodeType &&
                    !obj.setInterval
                  );
                }

                function isEmpty(object) {
                  if (isArguments(object)) {
                    return object.length === 0;
                  } else if (isObject(object)) {
                    return keys(object).length === 0;
                  } else if (isString(object) || isArray(object)) {
                    return object.length === 0;
                  }
                  return true;
                }

                function isBoolean(obj) {
                  return (
                    obj === true ||
                    obj === false ||
                    toStr.call(obj) === '[object Boolean]'
                  );
                }

                function isUndefined(obj) {
                  return typeof obj === 'undefined';
                }

                function isDefined(obj) {
                  return !isUndefined(obj);
                }

                function isUndefinedOrNull(obj) {
                  return isUndefined(obj) || isNull(obj);
                }

                function isNull(obj) {
                  return obj === null;
                }

                var isArguments = function _isArguments(object) {
                  return toStr.call(object) === '[object Arguments]';
                };

                if (!isArguments(arguments)) {
                  isArguments = function _isArguments(obj) {
                    return !!(obj && hasOwn.call(obj, 'callee'));
                  };
                }

                function isInstanceOf(obj, clazz) {
                  if (isFunction(clazz)) {
                    return obj instanceof clazz;
                  } else {
                    return false;
                  }
                }

                function isRegExp(obj) {
                  return toStr.call(obj) === '[object RegExp]';
                }

                var isArray =
                  Array.isArray ||
                  function isArray(obj) {
                    return toStr.call(obj) === '[object Array]';
                  };

                function isDate(obj) {
                  return toStr.call(obj) === '[object Date]';
                }

                function isString(obj) {
                  return toStr.call(obj) === '[object String]';
                }

                function isNumber(obj) {
                  return toStr.call(obj) === '[object Number]';
                }

                function isTrue(obj) {
                  return obj === true;
                }

                function isFalse(obj) {
                  return obj === false;
                }

                function isNotNull(obj) {
                  return !isNull(obj);
                }

                function isEq(obj, obj2) {
                  /*jshint eqeqeq:false*/
                  return obj == obj2;
                }

                function isNeq(obj, obj2) {
                  /*jshint eqeqeq:false*/
                  return obj != obj2;
                }

                function isSeq(obj, obj2) {
                  return obj === obj2;
                }

                function isSneq(obj, obj2) {
                  return obj !== obj2;
                }

                function isIn(obj, arr) {
                  if (
                    (isArray(arr) && Array.prototype.indexOf) ||
                    isString(arr)
                  ) {
                    return arr.indexOf(obj) > -1;
                  } else if (isArray(arr)) {
                    for (var i = 0, l = arr.length; i < l; i++) {
                      if (isEq(obj, arr[i])) {
                        return true;
                      }
                    }
                  }
                  return false;
                }

                function isNotIn(obj, arr) {
                  return !isIn(obj, arr);
                }

                function isLt(obj, obj2) {
                  return obj < obj2;
                }

                function isLte(obj, obj2) {
                  return obj <= obj2;
                }

                function isGt(obj, obj2) {
                  return obj > obj2;
                }

                function isGte(obj, obj2) {
                  return obj >= obj2;
                }

                function isLike(obj, reg) {
                  if (isString(reg)) {
                    return ('' + obj).match(reg) !== null;
                  } else if (isRegExp(reg)) {
                    return reg.test(obj);
                  }
                  return false;
                }

                function isNotLike(obj, reg) {
                  return !isLike(obj, reg);
                }

                function contains(arr, obj) {
                  return isIn(obj, arr);
                }

                function notContains(arr, obj) {
                  return !isIn(obj, arr);
                }

                function containsAt(arr, obj, index) {
                  if (isArray(arr) && arr.length > index) {
                    return isEq(arr[index], obj);
                  }
                  return false;
                }

                function notContainsAt(arr, obj, index) {
                  if (isArray(arr)) {
                    return !isEq(arr[index], obj);
                  }
                  return false;
                }

                function has(obj, prop) {
                  return hasOwn.call(obj, prop);
                }

                function notHas(obj, prop) {
                  return !has(obj, prop);
                }

                function length(obj, l) {
                  if (has(obj, 'length')) {
                    return obj.length === l;
                  }
                  return false;
                }

                function notLength(obj, l) {
                  if (has(obj, 'length')) {
                    return obj.length !== l;
                  }
                  return false;
                }

                var isa = {
                  isFunction: isFunction,
                  isObject: isObject,
                  isEmpty: isEmpty,
                  isHash: isHash,
                  isNumber: isNumber,
                  isString: isString,
                  isDate: isDate,
                  isArray: isArray,
                  isBoolean: isBoolean,
                  isUndefined: isUndefined,
                  isDefined: isDefined,
                  isUndefinedOrNull: isUndefinedOrNull,
                  isNull: isNull,
                  isArguments: isArguments,
                  instanceOf: isInstanceOf,
                  isRegExp: isRegExp,
                  deepEqual: deepEqual,
                  isTrue: isTrue,
                  isFalse: isFalse,
                  isNotNull: isNotNull,
                  isEq: isEq,
                  isNeq: isNeq,
                  isSeq: isSeq,
                  isSneq: isSneq,
                  isIn: isIn,
                  isNotIn: isNotIn,
                  isLt: isLt,
                  isLte: isLte,
                  isGt: isGt,
                  isGte: isGte,
                  isLike: isLike,
                  isNotLike: isNotLike,
                  contains: contains,
                  notContains: notContains,
                  has: has,
                  notHas: notHas,
                  isLength: length,
                  isNotLength: notLength,
                  containsAt: containsAt,
                  notContainsAt: notContainsAt,
                };

                var tester = {
                  constructor: function() {
                    this._testers = [];
                  },

                  noWrap: {
                    tester: function() {
                      var testers = this._testers;
                      return function tester(value) {
                        var isa = false;
                        for (
                          var i = 0, l = testers.length;
                          i < l && !isa;
                          i++
                        ) {
                          isa = testers[i](value);
                        }
                        return isa;
                      };
                    },
                  },
                };

                var switcher = {
                  constructor: function() {
                    this._cases = [];
                    this.__default = null;
                  },

                  def: function(val, fn) {
                    this.__default = fn;
                  },

                  noWrap: {
                    switcher: function() {
                      var testers = this._cases,
                        __default = this.__default;
                      return function tester() {
                        var handled = false,
                          args = argsToArray(arguments),
                          caseRet;
                        for (
                          var i = 0, l = testers.length;
                          i < l && !handled;
                          i++
                        ) {
                          caseRet = testers[i](args);
                          if (caseRet.length > 1) {
                            if (caseRet[1] || caseRet[0]) {
                              return caseRet[1];
                            }
                          }
                        }
                        if (!handled && __default) {
                          return __default.apply(this, args);
                        }
                      };
                    },
                  },
                };

                function addToTester(func) {
                  tester[func] = function isaTester() {
                    this._testers.push(isa[func]);
                  };
                }

                function addToSwitcher(func) {
                  switcher[func] = function isaTester() {
                    var args = argsToArray(arguments, 1),
                      isFunc = isa[func],
                      handler,
                      doBreak = true;
                    if (args.length <= isFunc.length - 1) {
                      throw new TypeError(
                        'A handler must be defined when calling using switch'
                      );
                    } else {
                      handler = args.pop();
                      if (isBoolean(handler)) {
                        doBreak = handler;
                        handler = args.pop();
                      }
                    }
                    if (!isFunction(handler)) {
                      throw new TypeError('handler must be defined');
                    }
                    this._cases.push(function(testArgs) {
                      if (isFunc.apply(isa, testArgs.concat(args))) {
                        return [doBreak, handler.apply(this, testArgs)];
                      }
                      return [false];
                    });
                  };
                }

                for (var i in isa) {
                  if (hasOwn.call(isa, i)) {
                    addToSwitcher(i);
                    addToTester(i);
                  }
                }

                var is = extended.define(isa).expose(isa);
                is.tester = extended.define(tester);
                is.switcher = extended.define(switcher);
                return is;
              }

              if ('undefined' !== typeof exports) {
                if ('undefined' !== typeof module && module.exports) {
                  module.exports = defineIsa(require('extended'));
                }
              } else if ('function' === typeof define && define.amd) {
                define(['extended'], function(extended) {
                  return defineIsa(extended);
                });
              } else {
                this.isExtended = defineIsa(this.extended);
              }
            }.call(this));
          }.call(this, require('buffer').Buffer));
        },
        { buffer: 106, extended: 113 },
      ],
      130: [
        function(require, module, exports) {
          var toString = {}.toString;

          module.exports =
            Array.isArray ||
            function(arr) {
              return toString.call(arr) == '[object Array]';
            };
        },
        {},
      ],
      131: [
        function(require, module, exports) {
          'use strict';
          var utils = require('./utils');
          var support = require('./support');
          // private property
          var _keyStr =
            'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';

          // public method for encoding
          exports.encode = function(input) {
            var output = [];
            var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
            var i = 0,
              len = input.length,
              remainingBytes = len;

            var isArray = utils.getTypeOf(input) !== 'string';
            while (i < input.length) {
              remainingBytes = len - i;

              if (!isArray) {
                chr1 = input.charCodeAt(i++);
                chr2 = i < len ? input.charCodeAt(i++) : 0;
                chr3 = i < len ? input.charCodeAt(i++) : 0;
              } else {
                chr1 = input[i++];
                chr2 = i < len ? input[i++] : 0;
                chr3 = i < len ? input[i++] : 0;
              }

              enc1 = chr1 >> 2;
              enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
              enc3 = remainingBytes > 1 ? ((chr2 & 15) << 2) | (chr3 >> 6) : 64;
              enc4 = remainingBytes > 2 ? chr3 & 63 : 64;

              output.push(
                _keyStr.charAt(enc1) +
                  _keyStr.charAt(enc2) +
                  _keyStr.charAt(enc3) +
                  _keyStr.charAt(enc4)
              );
            }

            return output.join('');
          };

          // public method for decoding
          exports.decode = function(input) {
            var chr1, chr2, chr3;
            var enc1, enc2, enc3, enc4;
            var i = 0,
              resultIndex = 0;

            var dataUrlPrefix = 'data:';

            if (input.substr(0, dataUrlPrefix.length) === dataUrlPrefix) {
              // This is a common error: people give a data url
              // (data:image/png;base64,iVBOR...) with a {base64: true} and
              // wonders why things don't work.
              // We can detect that the string input looks like a data url but we
              // *can't* be sure it is one: removing everything up to the comma would
              // be too dangerous.
              throw new Error(
                'Invalid base64 input, it looks like a data url.'
              );
            }

            input = input.replace(/[^A-Za-z0-9\+\/\=]/g, '');

            var totalLength = (input.length * 3) / 4;
            if (input.charAt(input.length - 1) === _keyStr.charAt(64)) {
              totalLength--;
            }
            if (input.charAt(input.length - 2) === _keyStr.charAt(64)) {
              totalLength--;
            }
            if (totalLength % 1 !== 0) {
              // totalLength is not an integer, the length does not match a valid
              // base64 content. That can happen if:
              // - the input is not a base64 content
              // - the input is *almost* a base64 content, with a extra chars at the
              //   beginning or at the end
              // - the input uses a base64 variant (base64url for example)
              throw new Error('Invalid base64 input, bad content length.');
            }
            var output;
            if (support.uint8array) {
              output = new Uint8Array(totalLength | 0);
            } else {
              output = new Array(totalLength | 0);
            }

            while (i < input.length) {
              enc1 = _keyStr.indexOf(input.charAt(i++));
              enc2 = _keyStr.indexOf(input.charAt(i++));
              enc3 = _keyStr.indexOf(input.charAt(i++));
              enc4 = _keyStr.indexOf(input.charAt(i++));

              chr1 = (enc1 << 2) | (enc2 >> 4);
              chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
              chr3 = ((enc3 & 3) << 6) | enc4;

              output[resultIndex++] = chr1;

              if (enc3 !== 64) {
                output[resultIndex++] = chr2;
              }
              if (enc4 !== 64) {
                output[resultIndex++] = chr3;
              }
            }

            return output;
          };
        },
        { './support': 160, './utils': 162 },
      ],
      132: [
        function(require, module, exports) {
          'use strict';

          var external = require('./external');
          var DataWorker = require('./stream/DataWorker');
          var DataLengthProbe = require('./stream/DataLengthProbe');
          var Crc32Probe = require('./stream/Crc32Probe');
          var DataLengthProbe = require('./stream/DataLengthProbe');

          /**
           * Represent a compressed object, with everything needed to decompress it.
           * @constructor
           * @param {number} compressedSize the size of the data compressed.
           * @param {number} uncompressedSize the size of the data after decompression.
           * @param {number} crc32 the crc32 of the decompressed file.
           * @param {object} compression the type of compression, see lib/compressions.js.
           * @param {String|ArrayBuffer|Uint8Array|Buffer} data the compressed data.
           */
          function CompressedObject(
            compressedSize,
            uncompressedSize,
            crc32,
            compression,
            data
          ) {
            this.compressedSize = compressedSize;
            this.uncompressedSize = uncompressedSize;
            this.crc32 = crc32;
            this.compression = compression;
            this.compressedContent = data;
          }

          CompressedObject.prototype = {
            /**
             * Create a worker to get the uncompressed content.
             * @return {GenericWorker} the worker.
             */
            getContentWorker: function() {
              var worker = new DataWorker(
                external.Promise.resolve(this.compressedContent)
              )
                .pipe(this.compression.uncompressWorker())
                .pipe(new DataLengthProbe('data_length'));

              var that = this;
              worker.on('end', function() {
                if (this.streamInfo['data_length'] !== that.uncompressedSize) {
                  throw new Error('Bug : uncompressed data size mismatch');
                }
              });
              return worker;
            },
            /**
             * Create a worker to get the compressed content.
             * @return {GenericWorker} the worker.
             */
            getCompressedWorker: function() {
              return new DataWorker(
                external.Promise.resolve(this.compressedContent)
              )
                .withStreamInfo('compressedSize', this.compressedSize)
                .withStreamInfo('uncompressedSize', this.uncompressedSize)
                .withStreamInfo('crc32', this.crc32)
                .withStreamInfo('compression', this.compression);
            },
          };

          /**
           * Chain the given worker with other workers to compress the content with the
           * given compresion.
           * @param {GenericWorker} uncompressedWorker the worker to pipe.
           * @param {Object} compression the compression object.
           * @param {Object} compressionOptions the options to use when compressing.
           * @return {GenericWorker} the new worker compressing the content.
           */
          CompressedObject.createWorkerFrom = function(
            uncompressedWorker,
            compression,
            compressionOptions
          ) {
            return uncompressedWorker
              .pipe(new Crc32Probe())
              .pipe(new DataLengthProbe('uncompressedSize'))
              .pipe(compression.compressWorker(compressionOptions))
              .pipe(new DataLengthProbe('compressedSize'))
              .withStreamInfo('compression', compression);
          };

          module.exports = CompressedObject;
        },
        {
          './external': 136,
          './stream/Crc32Probe': 155,
          './stream/DataLengthProbe': 156,
          './stream/DataWorker': 157,
        },
      ],
      133: [
        function(require, module, exports) {
          'use strict';

          var GenericWorker = require('./stream/GenericWorker');

          exports.STORE = {
            magic: '\x00\x00',
            compressWorker: function(compressionOptions) {
              return new GenericWorker('STORE compression');
            },
            uncompressWorker: function() {
              return new GenericWorker('STORE decompression');
            },
          };
          exports.DEFLATE = require('./flate');
        },
        { './flate': 137, './stream/GenericWorker': 158 },
      ],
      134: [
        function(require, module, exports) {
          'use strict';

          var utils = require('./utils');

          /**
           * The following functions come from pako, from pako/lib/zlib/crc32.js
           * released under the MIT license, see pako https://github.com/nodeca/pako/
           */

          // Use ordinary array, since untyped makes no boost here
          function makeTable() {
            var c,
              table = [];

            for (var n = 0; n < 256; n++) {
              c = n;
              for (var k = 0; k < 8; k++) {
                c = c & 1 ? 0xedb88320 ^ (c >>> 1) : c >>> 1;
              }
              table[n] = c;
            }

            return table;
          }

          // Create table on load. Just 255 signed longs. Not a problem.
          var crcTable = makeTable();

          function crc32(crc, buf, len, pos) {
            var t = crcTable,
              end = pos + len;

            crc = crc ^ -1;

            for (var i = pos; i < end; i++) {
              crc = (crc >>> 8) ^ t[(crc ^ buf[i]) & 0xff];
            }

            return crc ^ -1; // >>> 0;
          }

          // That's all for the pako functions.

          /**
           * Compute the crc32 of a string.
           * This is almost the same as the function crc32, but for strings. Using the
           * same function for the two use cases leads to horrible performances.
           * @param {Number} crc the starting value of the crc.
           * @param {String} str the string to use.
           * @param {Number} len the length of the string.
           * @param {Number} pos the starting position for the crc32 computation.
           * @return {Number} the computed crc32.
           */
          function crc32str(crc, str, len, pos) {
            var t = crcTable,
              end = pos + len;

            crc = crc ^ -1;

            for (var i = pos; i < end; i++) {
              crc = (crc >>> 8) ^ t[(crc ^ str.charCodeAt(i)) & 0xff];
            }

            return crc ^ -1; // >>> 0;
          }

          module.exports = function crc32wrapper(input, crc) {
            if (typeof input === 'undefined' || !input.length) {
              return 0;
            }

            var isArray = utils.getTypeOf(input) !== 'string';

            if (isArray) {
              return crc32(crc | 0, input, input.length, 0);
            } else {
              return crc32str(crc | 0, input, input.length, 0);
            }
          };
        },
        { './utils': 162 },
      ],
      135: [
        function(require, module, exports) {
          'use strict';
          exports.base64 = false;
          exports.binary = false;
          exports.dir = false;
          exports.createFolders = true;
          exports.date = null;
          exports.compression = null;
          exports.compressionOptions = null;
          exports.comment = null;
          exports.unixPermissions = null;
          exports.dosPermissions = null;
        },
        {},
      ],
      136: [
        function(require, module, exports) {
          /* global Promise */
          'use strict';

          // load the global object first:
          // - it should be better integrated in the system (unhandledRejection in node)
          // - the environment may have a custom Promise implementation (see zone.js)
          var ES6Promise = null;
          if (typeof Promise !== 'undefined') {
            ES6Promise = Promise;
          } else {
            ES6Promise = require('lie');
          }

          /**
           * Let the user use/change some implementations.
           */
          module.exports = {
            Promise: ES6Promise,
          };
        },
        { lie: 166 },
      ],
      137: [
        function(require, module, exports) {
          'use strict';
          var USE_TYPEDARRAY =
            typeof Uint8Array !== 'undefined' &&
            typeof Uint16Array !== 'undefined' &&
            typeof Uint32Array !== 'undefined';

          var pako = require('pako');
          var utils = require('./utils');
          var GenericWorker = require('./stream/GenericWorker');

          var ARRAY_TYPE = USE_TYPEDARRAY ? 'uint8array' : 'array';

          exports.magic = '\x08\x00';

          /**
           * Create a worker that uses pako to inflate/deflate.
           * @constructor
           * @param {String} action the name of the pako function to call : either "Deflate" or "Inflate".
           * @param {Object} options the options to use when (de)compressing.
           */
          function FlateWorker(action, options) {
            GenericWorker.call(this, 'FlateWorker/' + action);

            this._pako = null;
            this._pakoAction = action;
            this._pakoOptions = options;
            // the `meta` object from the last chunk received
            // this allow this worker to pass around metadata
            this.meta = {};
          }

          utils.inherits(FlateWorker, GenericWorker);

          /**
           * @see GenericWorker.processChunk
           */
          FlateWorker.prototype.processChunk = function(chunk) {
            this.meta = chunk.meta;
            if (this._pako === null) {
              this._createPako();
            }
            this._pako.push(utils.transformTo(ARRAY_TYPE, chunk.data), false);
          };

          /**
           * @see GenericWorker.flush
           */
          FlateWorker.prototype.flush = function() {
            GenericWorker.prototype.flush.call(this);
            if (this._pako === null) {
              this._createPako();
            }
            this._pako.push([], true);
          };
          /**
           * @see GenericWorker.cleanUp
           */
          FlateWorker.prototype.cleanUp = function() {
            GenericWorker.prototype.cleanUp.call(this);
            this._pako = null;
          };

          /**
           * Create the _pako object.
           * TODO: lazy-loading this object isn't the best solution but it's the
           * quickest. The best solution is to lazy-load the worker list. See also the
           * issue #446.
           */
          FlateWorker.prototype._createPako = function() {
            this._pako = new pako[this._pakoAction]({
              raw: true,
              level: this._pakoOptions.level || -1, // default compression
            });
            var self = this;
            this._pako.onData = function(data) {
              self.push({
                data: data,
                meta: self.meta,
              });
            };
          };

          exports.compressWorker = function(compressionOptions) {
            return new FlateWorker('Deflate', compressionOptions);
          };
          exports.uncompressWorker = function() {
            return new FlateWorker('Inflate', {});
          };
        },
        { './stream/GenericWorker': 158, './utils': 162, pako: 170 },
      ],
      138: [
        function(require, module, exports) {
          'use strict';

          var utils = require('../utils');
          var GenericWorker = require('../stream/GenericWorker');
          var utf8 = require('../utf8');
          var crc32 = require('../crc32');
          var signature = require('../signature');

          /**
           * Transform an integer into a string in hexadecimal.
           * @private
           * @param {number} dec the number to convert.
           * @param {number} bytes the number of bytes to generate.
           * @returns {string} the result.
           */
          var decToHex = function(dec, bytes) {
            var hex = '',
              i;
            for (i = 0; i < bytes; i++) {
              hex += String.fromCharCode(dec & 0xff);
              dec = dec >>> 8;
            }
            return hex;
          };

          /**
           * Generate the UNIX part of the external file attributes.
           * @param {Object} unixPermissions the unix permissions or null.
           * @param {Boolean} isDir true if the entry is a directory, false otherwise.
           * @return {Number} a 32 bit integer.
           *
           * adapted from http://unix.stackexchange.com/questions/14705/the-zip-formats-external-file-attribute :
           *
           * TTTTsstrwxrwxrwx0000000000ADVSHR
           * ^^^^____________________________ file type, see zipinfo.c (UNX_*)
           *     ^^^_________________________ setuid, setgid, sticky
           *        ^^^^^^^^^________________ permissions
           *                 ^^^^^^^^^^______ not used ?
           *                           ^^^^^^ DOS attribute bits : Archive, Directory, Volume label, System file, Hidden, Read only
           */
          var generateUnixExternalFileAttr = function(unixPermissions, isDir) {
            var result = unixPermissions;
            if (!unixPermissions) {
              // I can't use octal values in strict mode, hence the hexa.
              //  040775 => 0x41fd
              // 0100664 => 0x81b4
              result = isDir ? 0x41fd : 0x81b4;
            }
            return (result & 0xffff) << 16;
          };

          /**
           * Generate the DOS part of the external file attributes.
           * @param {Object} dosPermissions the dos permissions or null.
           * @param {Boolean} isDir true if the entry is a directory, false otherwise.
           * @return {Number} a 32 bit integer.
           *
           * Bit 0     Read-Only
           * Bit 1     Hidden
           * Bit 2     System
           * Bit 3     Volume Label
           * Bit 4     Directory
           * Bit 5     Archive
           */
          var generateDosExternalFileAttr = function(dosPermissions, isDir) {
            // the dir flag is already set for compatibility
            return (dosPermissions || 0) & 0x3f;
          };

          /**
           * Generate the various parts used in the construction of the final zip file.
           * @param {Object} streamInfo the hash with informations about the compressed file.
           * @param {Boolean} streamedContent is the content streamed ?
           * @param {Boolean} streamingEnded is the stream finished ?
           * @param {number} offset the current offset from the start of the zip file.
           * @param {String} platform let's pretend we are this platform (change platform dependents fields)
           * @param {Function} encodeFileName the function to encode the file name / comment.
           * @return {Object} the zip parts.
           */
          var generateZipParts = function(
            streamInfo,
            streamedContent,
            streamingEnded,
            offset,
            platform,
            encodeFileName
          ) {
            var file = streamInfo['file'],
              compression = streamInfo['compression'],
              useCustomEncoding = encodeFileName !== utf8.utf8encode,
              encodedFileName = utils.transformTo(
                'string',
                encodeFileName(file.name)
              ),
              utfEncodedFileName = utils.transformTo(
                'string',
                utf8.utf8encode(file.name)
              ),
              comment = file.comment,
              encodedComment = utils.transformTo(
                'string',
                encodeFileName(comment)
              ),
              utfEncodedComment = utils.transformTo(
                'string',
                utf8.utf8encode(comment)
              ),
              useUTF8ForFileName =
                utfEncodedFileName.length !== file.name.length,
              useUTF8ForComment = utfEncodedComment.length !== comment.length,
              dosTime,
              dosDate,
              extraFields = '',
              unicodePathExtraField = '',
              unicodeCommentExtraField = '',
              dir = file.dir,
              date = file.date;

            var dataInfo = {
              crc32: 0,
              compressedSize: 0,
              uncompressedSize: 0,
            };

            // if the content is streamed, the sizes/crc32 are only available AFTER
            // the end of the stream.
            if (!streamedContent || streamingEnded) {
              dataInfo.crc32 = streamInfo['crc32'];
              dataInfo.compressedSize = streamInfo['compressedSize'];
              dataInfo.uncompressedSize = streamInfo['uncompressedSize'];
            }

            var bitflag = 0;
            if (streamedContent) {
              // Bit 3: the sizes/crc32 are set to zero in the local header.
              // The correct values are put in the data descriptor immediately
              // following the compressed data.
              bitflag |= 0x0008;
            }
            if (
              !useCustomEncoding &&
              (useUTF8ForFileName || useUTF8ForComment)
            ) {
              // Bit 11: Language encoding flag (EFS).
              bitflag |= 0x0800;
            }

            var extFileAttr = 0;
            var versionMadeBy = 0;
            if (dir) {
              // dos or unix, we set the dos dir flag
              extFileAttr |= 0x00010;
            }
            if (platform === 'UNIX') {
              versionMadeBy = 0x031e; // UNIX, version 3.0
              extFileAttr |= generateUnixExternalFileAttr(
                file.unixPermissions,
                dir
              );
            } else {
              // DOS or other, fallback to DOS
              versionMadeBy = 0x0014; // DOS, version 2.0
              extFileAttr |= generateDosExternalFileAttr(
                file.dosPermissions,
                dir
              );
            }

            // date
            // @see http://www.delorie.com/djgpp/doc/rbinter/it/52/13.html
            // @see http://www.delorie.com/djgpp/doc/rbinter/it/65/16.html
            // @see http://www.delorie.com/djgpp/doc/rbinter/it/66/16.html

            dosTime = date.getUTCHours();
            dosTime = dosTime << 6;
            dosTime = dosTime | date.getUTCMinutes();
            dosTime = dosTime << 5;
            dosTime = dosTime | (date.getUTCSeconds() / 2);

            dosDate = date.getUTCFullYear() - 1980;
            dosDate = dosDate << 4;
            dosDate = dosDate | (date.getUTCMonth() + 1);
            dosDate = dosDate << 5;
            dosDate = dosDate | date.getUTCDate();

            if (useUTF8ForFileName) {
              // set the unicode path extra field. unzip needs at least one extra
              // field to correctly handle unicode path, so using the path is as good
              // as any other information. This could improve the situation with
              // other archive managers too.
              // This field is usually used without the utf8 flag, with a non
              // unicode path in the header (winrar, winzip). This helps (a bit)
              // with the messy Windows' default compressed folders feature but
              // breaks on p7zip which doesn't seek the unicode path extra field.
              // So for now, UTF-8 everywhere !
              unicodePathExtraField =
                // Version
                decToHex(1, 1) +
                // NameCRC32
                decToHex(crc32(encodedFileName), 4) +
                // UnicodeName
                utfEncodedFileName;

              extraFields +=
                // Info-ZIP Unicode Path Extra Field
                '\x75\x70' +
                // size
                decToHex(unicodePathExtraField.length, 2) +
                // content
                unicodePathExtraField;
            }

            if (useUTF8ForComment) {
              unicodeCommentExtraField =
                // Version
                decToHex(1, 1) +
                // CommentCRC32
                decToHex(crc32(encodedComment), 4) +
                // UnicodeName
                utfEncodedComment;

              extraFields +=
                // Info-ZIP Unicode Path Extra Field
                '\x75\x63' +
                // size
                decToHex(unicodeCommentExtraField.length, 2) +
                // content
                unicodeCommentExtraField;
            }

            var header = '';

            // version needed to extract
            header += '\x0A\x00';
            // general purpose bit flag
            header += decToHex(bitflag, 2);
            // compression method
            header += compression.magic;
            // last mod file time
            header += decToHex(dosTime, 2);
            // last mod file date
            header += decToHex(dosDate, 2);
            // crc-32
            header += decToHex(dataInfo.crc32, 4);
            // compressed size
            header += decToHex(dataInfo.compressedSize, 4);
            // uncompressed size
            header += decToHex(dataInfo.uncompressedSize, 4);
            // file name length
            header += decToHex(encodedFileName.length, 2);
            // extra field length
            header += decToHex(extraFields.length, 2);

            var fileRecord =
              signature.LOCAL_FILE_HEADER +
              header +
              encodedFileName +
              extraFields;

            var dirRecord =
              signature.CENTRAL_FILE_HEADER +
              // version made by (00: DOS)
              decToHex(versionMadeBy, 2) +
              // file header (common to file and central directory)
              header +
              // file comment length
              decToHex(encodedComment.length, 2) +
              // disk number start
              '\x00\x00' +
              // internal file attributes TODO
              '\x00\x00' +
              // external file attributes
              decToHex(extFileAttr, 4) +
              // relative offset of local header
              decToHex(offset, 4) +
              // file name
              encodedFileName +
              // extra field
              extraFields +
              // file comment
              encodedComment;

            return {
              fileRecord: fileRecord,
              dirRecord: dirRecord,
            };
          };

          /**
           * Generate the EOCD record.
           * @param {Number} entriesCount the number of entries in the zip file.
           * @param {Number} centralDirLength the length (in bytes) of the central dir.
           * @param {Number} localDirLength the length (in bytes) of the local dir.
           * @param {String} comment the zip file comment as a binary string.
           * @param {Function} encodeFileName the function to encode the comment.
           * @return {String} the EOCD record.
           */
          var generateCentralDirectoryEnd = function(
            entriesCount,
            centralDirLength,
            localDirLength,
            comment,
            encodeFileName
          ) {
            var dirEnd = '';
            var encodedComment = utils.transformTo(
              'string',
              encodeFileName(comment)
            );

            // end of central dir signature
            dirEnd =
              signature.CENTRAL_DIRECTORY_END +
              // number of this disk
              '\x00\x00' +
              // number of the disk with the start of the central directory
              '\x00\x00' +
              // total number of entries in the central directory on this disk
              decToHex(entriesCount, 2) +
              // total number of entries in the central directory
              decToHex(entriesCount, 2) +
              // size of the central directory   4 bytes
              decToHex(centralDirLength, 4) +
              // offset of start of central directory with respect to the starting disk number
              decToHex(localDirLength, 4) +
              // .ZIP file comment length
              decToHex(encodedComment.length, 2) +
              // .ZIP file comment
              encodedComment;

            return dirEnd;
          };

          /**
           * Generate data descriptors for a file entry.
           * @param {Object} streamInfo the hash generated by a worker, containing informations
           * on the file entry.
           * @return {String} the data descriptors.
           */
          var generateDataDescriptors = function(streamInfo) {
            var descriptor = '';
            descriptor =
              signature.DATA_DESCRIPTOR +
              // crc-32                          4 bytes
              decToHex(streamInfo['crc32'], 4) +
              // compressed size                 4 bytes
              decToHex(streamInfo['compressedSize'], 4) +
              // uncompressed size               4 bytes
              decToHex(streamInfo['uncompressedSize'], 4);

            return descriptor;
          };

          /**
           * A worker to concatenate other workers to create a zip file.
           * @param {Boolean} streamFiles `true` to stream the content of the files,
           * `false` to accumulate it.
           * @param {String} comment the comment to use.
           * @param {String} platform the platform to use, "UNIX" or "DOS".
           * @param {Function} encodeFileName the function to encode file names and comments.
           */
          function ZipFileWorker(
            streamFiles,
            comment,
            platform,
            encodeFileName
          ) {
            GenericWorker.call(this, 'ZipFileWorker');
            // The number of bytes written so far. This doesn't count accumulated chunks.
            this.bytesWritten = 0;
            // The comment of the zip file
            this.zipComment = comment;
            // The platform "generating" the zip file.
            this.zipPlatform = platform;
            // the function to encode file names and comments.
            this.encodeFileName = encodeFileName;
            // Should we stream the content of the files ?
            this.streamFiles = streamFiles;
            // If `streamFiles` is false, we will need to accumulate the content of the
            // files to calculate sizes / crc32 (and write them *before* the content).
            // This boolean indicates if we are accumulating chunks (it will change a lot
            // during the lifetime of this worker).
            this.accumulate = false;
            // The buffer receiving chunks when accumulating content.
            this.contentBuffer = [];
            // The list of generated directory records.
            this.dirRecords = [];
            // The offset (in bytes) from the beginning of the zip file for the current source.
            this.currentSourceOffset = 0;
            // The total number of entries in this zip file.
            this.entriesCount = 0;
            // the name of the file currently being added, null when handling the end of the zip file.
            // Used for the emited metadata.
            this.currentFile = null;

            this._sources = [];
          }
          utils.inherits(ZipFileWorker, GenericWorker);

          /**
           * @see GenericWorker.push
           */
          ZipFileWorker.prototype.push = function(chunk) {
            var currentFilePercent = chunk.meta.percent || 0;
            var entriesCount = this.entriesCount;
            var remainingFiles = this._sources.length;

            if (this.accumulate) {
              this.contentBuffer.push(chunk);
            } else {
              this.bytesWritten += chunk.data.length;

              GenericWorker.prototype.push.call(this, {
                data: chunk.data,
                meta: {
                  currentFile: this.currentFile,
                  percent: entriesCount
                    ? (currentFilePercent +
                        100 * (entriesCount - remainingFiles - 1)) /
                      entriesCount
                    : 100,
                },
              });
            }
          };

          /**
           * The worker started a new source (an other worker).
           * @param {Object} streamInfo the streamInfo object from the new source.
           */
          ZipFileWorker.prototype.openedSource = function(streamInfo) {
            this.currentSourceOffset = this.bytesWritten;
            this.currentFile = streamInfo['file'].name;

            var streamedContent = this.streamFiles && !streamInfo['file'].dir;

            // don't stream folders (because they don't have any content)
            if (streamedContent) {
              var record = generateZipParts(
                streamInfo,
                streamedContent,
                false,
                this.currentSourceOffset,
                this.zipPlatform,
                this.encodeFileName
              );
              this.push({
                data: record.fileRecord,
                meta: { percent: 0 },
              });
            } else {
              // we need to wait for the whole file before pushing anything
              this.accumulate = true;
            }
          };

          /**
           * The worker finished a source (an other worker).
           * @param {Object} streamInfo the streamInfo object from the finished source.
           */
          ZipFileWorker.prototype.closedSource = function(streamInfo) {
            this.accumulate = false;
            var streamedContent = this.streamFiles && !streamInfo['file'].dir;
            var record = generateZipParts(
              streamInfo,
              streamedContent,
              true,
              this.currentSourceOffset,
              this.zipPlatform,
              this.encodeFileName
            );

            this.dirRecords.push(record.dirRecord);
            if (streamedContent) {
              // after the streamed file, we put data descriptors
              this.push({
                data: generateDataDescriptors(streamInfo),
                meta: { percent: 100 },
              });
            } else {
              // the content wasn't streamed, we need to push everything now
              // first the file record, then the content
              this.push({
                data: record.fileRecord,
                meta: { percent: 0 },
              });
              while (this.contentBuffer.length) {
                this.push(this.contentBuffer.shift());
              }
            }
            this.currentFile = null;
          };

          /**
           * @see GenericWorker.flush
           */
          ZipFileWorker.prototype.flush = function() {
            var localDirLength = this.bytesWritten;
            for (var i = 0; i < this.dirRecords.length; i++) {
              this.push({
                data: this.dirRecords[i],
                meta: { percent: 100 },
              });
            }
            var centralDirLength = this.bytesWritten - localDirLength;

            var dirEnd = generateCentralDirectoryEnd(
              this.dirRecords.length,
              centralDirLength,
              localDirLength,
              this.zipComment,
              this.encodeFileName
            );

            this.push({
              data: dirEnd,
              meta: { percent: 100 },
            });
          };

          /**
           * Prepare the next source to be read.
           */
          ZipFileWorker.prototype.prepareNextSource = function() {
            this.previous = this._sources.shift();
            this.openedSource(this.previous.streamInfo);
            if (this.isPaused) {
              this.previous.pause();
            } else {
              this.previous.resume();
            }
          };

          /**
           * @see GenericWorker.registerPrevious
           */
          ZipFileWorker.prototype.registerPrevious = function(previous) {
            this._sources.push(previous);
            var self = this;

            previous.on('data', function(chunk) {
              self.processChunk(chunk);
            });
            previous.on('end', function() {
              self.closedSource(self.previous.streamInfo);
              if (self._sources.length) {
                self.prepareNextSource();
              } else {
                self.end();
              }
            });
            previous.on('error', function(e) {
              self.error(e);
            });
            return this;
          };

          /**
           * @see GenericWorker.resume
           */
          ZipFileWorker.prototype.resume = function() {
            if (!GenericWorker.prototype.resume.call(this)) {
              return false;
            }

            if (!this.previous && this._sources.length) {
              this.prepareNextSource();
              return true;
            }
            if (
              !this.previous &&
              !this._sources.length &&
              !this.generatedError
            ) {
              this.end();
              return true;
            }
          };

          /**
           * @see GenericWorker.error
           */
          ZipFileWorker.prototype.error = function(e) {
            var sources = this._sources;
            if (!GenericWorker.prototype.error.call(this, e)) {
              return false;
            }
            for (var i = 0; i < sources.length; i++) {
              try {
                sources[i].error(e);
              } catch (e) {
                // the `error` exploded, nothing to do
              }
            }
            return true;
          };

          /**
           * @see GenericWorker.lock
           */
          ZipFileWorker.prototype.lock = function() {
            GenericWorker.prototype.lock.call(this);
            var sources = this._sources;
            for (var i = 0; i < sources.length; i++) {
              sources[i].lock();
            }
          };

          module.exports = ZipFileWorker;
        },
        {
          '../crc32': 134,
          '../signature': 153,
          '../stream/GenericWorker': 158,
          '../utf8': 161,
          '../utils': 162,
        },
      ],
      139: [
        function(require, module, exports) {
          'use strict';

          var compressions = require('../compressions');
          var ZipFileWorker = require('./ZipFileWorker');

          /**
           * Find the compression to use.
           * @param {String} fileCompression the compression defined at the file level, if any.
           * @param {String} zipCompression the compression defined at the load() level.
           * @return {Object} the compression object to use.
           */
          var getCompression = function(fileCompression, zipCompression) {
            var compressionName = fileCompression || zipCompression;
            var compression = compressions[compressionName];
            if (!compression) {
              throw new Error(
                compressionName + ' is not a valid compression method !'
              );
            }
            return compression;
          };

          /**
           * Create a worker to generate a zip file.
           * @param {JSZip} zip the JSZip instance at the right root level.
           * @param {Object} options to generate the zip file.
           * @param {String} comment the comment to use.
           */
          exports.generateWorker = function(zip, options, comment) {
            var zipFileWorker = new ZipFileWorker(
              options.streamFiles,
              comment,
              options.platform,
              options.encodeFileName
            );
            var entriesCount = 0;
            try {
              zip.forEach(function(relativePath, file) {
                entriesCount++;
                var compression = getCompression(
                  file.options.compression,
                  options.compression
                );
                var compressionOptions =
                  file.options.compressionOptions ||
                  options.compressionOptions ||
                  {};
                var dir = file.dir,
                  date = file.date;

                file
                  ._compressWorker(compression, compressionOptions)
                  .withStreamInfo('file', {
                    name: relativePath,
                    dir: dir,
                    date: date,
                    comment: file.comment || '',
                    unixPermissions: file.unixPermissions,
                    dosPermissions: file.dosPermissions,
                  })
                  .pipe(zipFileWorker);
              });
              zipFileWorker.entriesCount = entriesCount;
            } catch (e) {
              zipFileWorker.error(e);
         